#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SansEPD76
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SansEPD76;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 76;
my $line_spacing = 0;
my $name = 'Sans 76';
my $space_width = 20;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 6, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 17, 
        'xoffset'  => 6, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0xFC, 0x1F, 0x80, ##  000000     000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 44, 
        'xoffset'  => 5, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, ##                    00000         00000       
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, ##                    00000         00000       
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, ##                    00000         00000       
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0x7C, 0x01, 0xF0, 0x00, ##                   00000         00000        
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x00, 0xF8, 0x03, 0xE0, 0x00, ##                  00000         00000         
            0x00, 0x01, 0xF0, 0x07, 0xC0, 0x00, ##                 00000         00000          
            0x00, 0x01, 0xF0, 0x07, 0xC0, 0x00, ##                 00000         00000          
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##      0000000000000000000000000000000000000000
            0x00, 0x03, 0xE0, 0x0F, 0x80, 0x00, ##                00000         00000           
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x07, 0xC0, 0x1F, 0x00, 0x00, ##               00000         00000            
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000             
            0x00, 0x1F, 0x00, 0x7C, 0x00, 0x00, ##             00000         00000              
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  0000000000000000000000000000000000000000    
            0x00, 0x3E, 0x00, 0xF8, 0x00, 0x00, ##            00000         00000               
            0x00, 0x3E, 0x00, 0xF8, 0x00, 0x00, ##            00000         00000               
            0x00, 0x3C, 0x01, 0xF0, 0x00, 0x00, ##            0000         00000                
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##           00000         00000                
            0x00, 0x7C, 0x03, 0xE0, 0x00, 0x00, ##           00000        00000                 
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x00, 0xF8, 0x03, 0xE0, 0x00, 0x00, ##          00000         00000                 
            0x00, 0xF8, 0x03, 0xC0, 0x00, 0x00, ##          00000         0000                  
            0x01, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##         00000         00000                  
            0x01, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##         00000         00000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000         
            0x03, 0xFF, 0xFF, 0x80, ##        0000000000000000000     
            0x0F, 0xFF, 0xFF, 0xE0, ##      00000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x7F, 0xC7, 0x07, 0xE0, ##   000000000   000     000000   
            0x7F, 0x07, 0x00, 0xE0, ##   0000000     000        000   
            0x7E, 0x07, 0x00, 0x20, ##   000000      000          0   
            0xFE, 0x07, 0x00, 0x00, ##  0000000      000              
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFC, 0x07, 0x00, 0x00, ##  000000       000              
            0xFE, 0x07, 0x00, 0x00, ##  0000000      000              
            0x7F, 0x07, 0x00, 0x00, ##   0000000     000              
            0x7F, 0x87, 0x00, 0x00, ##   00000000    000              
            0x3F, 0xFF, 0x00, 0x00, ##    00000000000000              
            0x1F, 0xFF, 0xC0, 0x00, ##     000000000000000            
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000        
            0x07, 0xFF, 0xFF, 0x00, ##       0000000000000000000      
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000    
            0x00, 0x1F, 0xFF, 0xE0, ##             0000000000000000   
            0x00, 0x07, 0xFF, 0xF0, ##               000000000000000  
            0x00, 0x07, 0x0F, 0xF8, ##               000    000000000 
            0x00, 0x07, 0x03, 0xF8, ##               000      0000000 
            0x00, 0x07, 0x01, 0xF8, ##               000       000000 
            0x00, 0x07, 0x01, 0xFC, ##               000       0000000
            0x00, 0x07, 0x00, 0xFC, ##               000        000000
            0x00, 0x07, 0x00, 0xFC, ##               000        000000
            0x00, 0x07, 0x00, 0xFC, ##               000        000000
            0x00, 0x07, 0x00, 0xFC, ##               000        000000
            0x00, 0x07, 0x00, 0xFC, ##               000        000000
            0x80, 0x07, 0x01, 0xFC, ##  0            000       0000000
            0xE0, 0x07, 0x03, 0xF8, ##  000          000      0000000 
            0xF8, 0x07, 0x07, 0xF8, ##  00000        000     00000000 
            0xFF, 0x07, 0x3F, 0xF0, ##  00000000     000  0000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000     
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000       
            0x00, 0xFF, 0xE0, 0x00, ##          00000000000           
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x07, 0x00, 0x00, ##               000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 54, 
        'xoffset'  => 4, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, ##          000000                         00000          
            0x07, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##       000000000000                     00000           
            0x0F, 0xFF, 0xC0, 0x00, 0x07, 0xE0, 0x00, ##      00000000000000                   000000           
            0x1F, 0xFF, 0xE0, 0x00, 0x07, 0xC0, 0x00, ##     0000000000000000                  00000            
            0x3F, 0x87, 0xF0, 0x00, 0x0F, 0x80, 0x00, ##    0000000    0000000                00000             
            0x3E, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x00, ##    00000        00000                00000             
            0x7E, 0x01, 0xF8, 0x00, 0x1F, 0x00, 0x00, ##   000000        000000              00000              
            0x7C, 0x00, 0xF8, 0x00, 0x3F, 0x00, 0x00, ##   00000          00000             000000              
            0xFC, 0x00, 0xF8, 0x00, 0x3E, 0x00, 0x00, ##  000000          00000             00000               
            0xF8, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, ##  00000            00000           00000                
            0xF8, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, ##  00000            00000           00000                
            0xF8, 0x00, 0x7C, 0x00, 0xF8, 0x00, 0x00, ##  00000            00000          00000                 
            0xF8, 0x00, 0x7C, 0x01, 0xF8, 0x00, 0x00, ##  00000            00000         000000                 
            0xF8, 0x00, 0x7C, 0x01, 0xF0, 0x00, 0x00, ##  00000            00000         00000                  
            0xF8, 0x00, 0x7C, 0x03, 0xE0, 0x00, 0x00, ##  00000            00000        00000                   
            0xF8, 0x00, 0x7C, 0x03, 0xE0, 0x00, 0x00, ##  00000            00000        00000                   
            0xF8, 0x00, 0x7C, 0x07, 0xC0, 0x00, 0x00, ##  00000            00000       00000                    
            0xFC, 0x00, 0xF8, 0x07, 0xC0, 0x00, 0x00, ##  000000          00000        00000                    
            0x7C, 0x00, 0xF8, 0x0F, 0x80, 0x00, 0x00, ##   00000          00000       00000                     
            0x7E, 0x01, 0xF8, 0x1F, 0x80, 0x00, 0x00, ##   000000        000000      000000                     
            0x3E, 0x01, 0xF0, 0x1F, 0x00, 0x00, 0x00, ##    00000        00000       00000                      
            0x3F, 0x87, 0xF0, 0x3E, 0x00, 0x00, 0x00, ##    0000000    0000000      00000                       
            0x1F, 0xFF, 0xE0, 0x3E, 0x00, 0x00, 0x00, ##     0000000000000000       00000                       
            0x0F, 0xFF, 0xC0, 0x7C, 0x00, 0xFC, 0x00, ##      00000000000000       00000          000000        
            0x07, 0xFF, 0x80, 0xFC, 0x07, 0xFF, 0x80, ##       000000000000       000000       000000000000     
            0x01, 0xFE, 0x00, 0xF8, 0x0F, 0xFF, 0xC0, ##         00000000         00000       00000000000000    
            0x00, 0x00, 0x01, 0xF0, 0x1F, 0xFF, 0xE0, ##                         00000       0000000000000000   
            0x00, 0x00, 0x01, 0xF0, 0x3F, 0x87, 0xF0, ##                         00000      0000000    0000000  
            0x00, 0x00, 0x03, 0xE0, 0x3E, 0x01, 0xF0, ##                        00000       00000        00000  
            0x00, 0x00, 0x07, 0xE0, 0x7E, 0x01, 0xF8, ##                       000000      000000        000000 
            0x00, 0x00, 0x07, 0xC0, 0x7C, 0x00, 0xF8, ##                       00000       00000          00000 
            0x00, 0x00, 0x0F, 0x80, 0xFC, 0x00, 0xF8, ##                      00000       000000          00000 
            0x00, 0x00, 0x0F, 0x80, 0xF8, 0x00, 0x7C, ##                      00000       00000            00000
            0x00, 0x00, 0x1F, 0x00, 0xF8, 0x00, 0x7C, ##                     00000        00000            00000
            0x00, 0x00, 0x1F, 0x00, 0xF8, 0x00, 0x7C, ##                     00000        00000            00000
            0x00, 0x00, 0x3E, 0x00, 0xF8, 0x00, 0x7C, ##                    00000         00000            00000
            0x00, 0x00, 0x7E, 0x00, 0xF8, 0x00, 0x7C, ##                   000000         00000            00000
            0x00, 0x00, 0x7C, 0x00, 0xF8, 0x00, 0x7C, ##                   00000          00000            00000
            0x00, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x7C, ##                  00000           00000            00000
            0x00, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0x7C, ##                  00000           00000            00000
            0x00, 0x01, 0xF0, 0x00, 0xFC, 0x00, 0xF8, ##                 00000            000000          00000 
            0x00, 0x03, 0xF0, 0x00, 0x7C, 0x00, 0xF8, ##                000000             00000          00000 
            0x00, 0x03, 0xE0, 0x00, 0x7E, 0x01, 0xF8, ##                00000              000000        000000 
            0x00, 0x07, 0xC0, 0x00, 0x3E, 0x01, 0xF0, ##               00000                00000        00000  
            0x00, 0x07, 0xC0, 0x00, 0x3F, 0x87, 0xF0, ##               00000                0000000    0000000  
            0x00, 0x0F, 0x80, 0x00, 0x1F, 0xFF, 0xE0, ##              00000                  0000000000000000   
            0x00, 0x1F, 0x80, 0x00, 0x0F, 0xFF, 0xC0, ##             000000                   00000000000000    
            0x00, 0x1F, 0x00, 0x00, 0x07, 0xFF, 0x80, ##             00000                     000000000000     
            0x00, 0x3E, 0x00, 0x00, 0x01, 0xFC, 0x00, ##            00000                        0000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, ##                000000000                     
            0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, ##             000000000000000                  
            0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, ##           00000000000000000000               
            0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##          000000000000000000000               
            0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##         0000000000000000000000               
            0x01, 0xFE, 0x03, 0xF8, 0x00, 0x00, ##         00000000       0000000               
            0x03, 0xF8, 0x00, 0x78, 0x00, 0x00, ##        0000000            0000               
            0x03, 0xF0, 0x00, 0x18, 0x00, 0x00, ##        000000               00               
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, ##       0000000                                
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##       000000                                 
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##       000000                                 
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##       000000                                 
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##       000000                                 
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##       000000                                 
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, ##       0000000                                
            0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, ##        0000000                               
            0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, ##        0000000                               
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, ##         0000000                              
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, ##          0000000                             
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                            
            0x01, 0xFF, 0x80, 0x00, 0x00, 0x00, ##         0000000000                           
            0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        000000000000                          
            0x07, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##       00000000000000                         
            0x0F, 0xEF, 0xF0, 0x00, 0x0F, 0xC0, ##      0000000 00000000                000000  
            0x1F, 0xC7, 0xF8, 0x00, 0x0F, 0xC0, ##     0000000   00000000               000000  
            0x3F, 0x83, 0xFC, 0x00, 0x0F, 0xC0, ##    0000000     00000000              000000  
            0x3F, 0x01, 0xFE, 0x00, 0x0F, 0x80, ##    000000       00000000             00000   
            0x7F, 0x00, 0xFF, 0x00, 0x1F, 0x80, ##   0000000        00000000           000000   
            0x7E, 0x00, 0x7F, 0x80, 0x1F, 0x80, ##   000000          00000000          000000   
            0x7E, 0x00, 0x3F, 0xC0, 0x1F, 0x80, ##   000000           00000000         000000   
            0xFC, 0x00, 0x1F, 0xE0, 0x1F, 0x00, ##  000000             00000000        00000    
            0xFC, 0x00, 0x0F, 0xF0, 0x3F, 0x00, ##  000000              00000000      000000    
            0xFC, 0x00, 0x07, 0xF8, 0x3E, 0x00, ##  000000               00000000     00000     
            0xFC, 0x00, 0x03, 0xFC, 0x7E, 0x00, ##  000000                00000000   000000     
            0xFC, 0x00, 0x01, 0xFE, 0x7C, 0x00, ##  000000                 00000000  00000      
            0xFC, 0x00, 0x00, 0xFF, 0xFC, 0x00, ##  000000                  00000000000000      
            0xFC, 0x00, 0x00, 0x7F, 0xF8, 0x00, ##  000000                   000000000000       
            0xFE, 0x00, 0x00, 0x3F, 0xF8, 0x00, ##  0000000                   00000000000       
            0x7E, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##   000000                    000000000        
            0x7F, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##   0000000                    00000000        
            0x3F, 0x80, 0x00, 0x0F, 0xF8, 0x00, ##    0000000                   000000000       
            0x3F, 0xC0, 0x00, 0x3F, 0xFC, 0x00, ##    00000000                000000000000      
            0x1F, 0xE0, 0x00, 0xFF, 0xFE, 0x00, ##     00000000             000000000000000     
            0x0F, 0xFC, 0x03, 0xFF, 0xFF, 0x00, ##      0000000000        000000000000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x7F, 0x80, ##       00000000000000000000000000  00000000   
            0x03, 0xFF, 0xFF, 0xF8, 0x3F, 0xC0, ##        00000000000000000000000     00000000  
            0x01, 0xFF, 0xFF, 0xE0, 0x1F, 0xE0, ##         00000000000000000000        00000000 
            0x00, 0x7F, 0xFF, 0x80, 0x0F, 0xF0, ##           0000000000000000           00000000
            0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, ##              0000000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 14, 
        'xoffset'  => 5, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x7C, ##           00000
            0x00, 0xF8, ##          00000 
            0x00, 0xF8, ##          00000 
            0x01, 0xF0, ##         00000  
            0x01, 0xF0, ##         00000  
            0x03, 0xE0, ##        00000   
            0x03, 0xE0, ##        00000   
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x0F, 0xC0, ##      000000    
            0x0F, 0x80, ##      00000     
            0x1F, 0x80, ##     000000     
            0x1F, 0x80, ##     000000     
            0x1F, 0x00, ##     00000      
            0x3F, 0x00, ##    000000      
            0x3F, 0x00, ##    000000      
            0x3E, 0x00, ##    00000       
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x7C, 0x00, ##   00000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0x7C, 0x00, ##   00000        
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x7E, 0x00, ##   000000       
            0x3E, 0x00, ##    00000       
            0x3F, 0x00, ##    000000      
            0x3F, 0x00, ##    000000      
            0x1F, 0x00, ##     00000      
            0x1F, 0x80, ##     000000     
            0x1F, 0x80, ##     000000     
            0x0F, 0x80, ##      00000     
            0x0F, 0xC0, ##      000000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x03, 0xE0, ##        00000   
            0x03, 0xE0, ##        00000   
            0x01, 0xF0, ##         00000  
            0x01, 0xF0, ##         00000  
            0x00, 0xF8, ##          00000 
            0x00, 0xF8, ##          00000 
            0x00, 0x7C, ##           00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 14, 
        'xoffset'  => 5, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF8, 0x00, ##  00000         
            0x7C, 0x00, ##   00000        
            0x7C, 0x00, ##   00000        
            0x3E, 0x00, ##    00000       
            0x3E, 0x00, ##    00000       
            0x1F, 0x00, ##     00000      
            0x1F, 0x00, ##     00000      
            0x0F, 0x80, ##      00000     
            0x0F, 0x80, ##      00000     
            0x0F, 0xC0, ##      000000    
            0x07, 0xC0, ##       00000    
            0x07, 0xE0, ##       000000   
            0x07, 0xE0, ##       000000   
            0x03, 0xE0, ##        00000   
            0x03, 0xF0, ##        000000  
            0x03, 0xF0, ##        000000  
            0x01, 0xF0, ##         00000  
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x00, 0xF8, ##          00000 
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x00, 0xFC, ##          000000
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF8, ##         000000 
            0x01, 0xF0, ##         00000  
            0x03, 0xF0, ##        000000  
            0x03, 0xF0, ##        000000  
            0x03, 0xE0, ##        00000   
            0x07, 0xE0, ##       000000   
            0x07, 0xE0, ##       000000   
            0x07, 0xC0, ##       00000    
            0x0F, 0xC0, ##      000000    
            0x0F, 0x80, ##      00000     
            0x0F, 0x80, ##      00000     
            0x1F, 0x00, ##     00000      
            0x1F, 0x00, ##     00000      
            0x3E, 0x00, ##    00000       
            0x3E, 0x00, ##    00000       
            0x7C, 0x00, ##   00000        
            0x7C, 0x00, ##   00000        
            0xF8, 0x00, ##  00000         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 28, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x40, 0x0F, 0x00, 0x20, ##   0          0000          0 
            0x60, 0x0F, 0x00, 0x60, ##   00         0000         00 
            0xF8, 0x0F, 0x01, 0xF0, ##  00000       0000       00000
            0xFE, 0x0F, 0x07, 0xF0, ##  0000000     0000     0000000
            0x3F, 0x0F, 0x0F, 0xC0, ##    000000    0000    000000  
            0x1F, 0xCF, 0x3F, 0x80, ##     0000000  0000  0000000   
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000     
            0x01, 0xFF, 0xF8, 0x00, ##         00000000000000       
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000         
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000         
            0x01, 0xFF, 0xF8, 0x00, ##         00000000000000       
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000     
            0x1F, 0xCF, 0x3F, 0x80, ##     0000000  0000  0000000   
            0x3F, 0x0F, 0x0F, 0xC0, ##    000000    0000    000000  
            0xFE, 0x0F, 0x07, 0xF0, ##  0000000     0000     0000000
            0xF8, 0x0F, 0x01, 0xF0, ##  00000       0000       00000
            0x60, 0x0F, 0x00, 0x60, ##   00         0000         00 
            0x40, 0x0F, 0x00, 0x20, ##   0          0000          0 
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 9, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x00, ##     00000 
            0x3F, 0x00, ##    000000 
            0x3E, 0x00, ##    00000  
            0x3E, 0x00, ##    00000  
            0x3E, 0x00, ##    00000  
            0x7C, 0x00, ##   00000   
            0x7C, 0x00, ##   00000   
            0x78, 0x00, ##   0000    
            0x78, 0x00, ##   0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 6, 
        'xoffset'  => 7, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x01, 0xF8, ##                 000000 
            0x00, 0x01, 0xF8, ##                 000000 
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x03, 0xF0, ##                000000  
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x07, 0xE0, ##               000000   
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x0F, 0xC0, ##              000000    
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x3F, 0x00, ##            000000      
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x7E, 0x00, ##           000000       
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x01, 0xF8, 0x00, ##         000000         
            0x01, 0xF8, 0x00, ##         000000         
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x03, 0xF0, 0x00, ##        000000          
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x07, 0xE0, 0x00, ##       000000           
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x1F, 0x80, 0x00, ##     000000             
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x3F, 0x00, 0x00, ##    000000              
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x7E, 0x00, 0x00, ##   000000               
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0xFC, 0x00, 0x00, ##  000000                
            0xF8, 0x00, 0x00, ##  00000                 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xC0, ##       000000000000000000000      
            0x07, 0xF8, 0x1F, 0xE0, ##       00000000      00000000     
            0x0F, 0xE0, 0x07, 0xF0, ##      0000000          0000000    
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x0F, 0xE0, 0x07, 0xF0, ##      0000000          0000000    
            0x07, 0xF8, 0x1F, 0xE0, ##       00000000      00000000     
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 28, 
        'xoffset'  => 7, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0x80, 0x00, ##           00000000           
            0x0F, 0xFF, 0x80, 0x00, ##      0000000000000           
            0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000           
            0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000           
            0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000           
            0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000           
            0xFF, 0x1F, 0x80, 0x00, ##  00000000   000000           
            0xE0, 0x1F, 0x80, 0x00, ##  000        000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xC0, 0x00, ##           000000000            
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000         
            0x7F, 0xFF, 0xFE, 0x00, ##   0000000000000000000000       
            0xFF, 0xFF, 0xFF, 0x00, ##  000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0x80, 0x7F, 0xC0, ##  000000000        000000000    
            0xFC, 0x00, 0x1F, 0xE0, ##  000000             00000000   
            0xF0, 0x00, 0x0F, 0xF0, ##  0000                00000000  
            0xC0, 0x00, 0x07, 0xF0, ##  00                   0000000  
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x07, 0xE0, ##                       000000   
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000   
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000    
            0x00, 0x00, 0x3F, 0x80, ##                    0000000     
            0x00, 0x00, 0x7F, 0x80, ##                   00000000     
            0x00, 0x00, 0x7F, 0x00, ##                   0000000      
            0x00, 0x00, 0xFE, 0x00, ##                  0000000       
            0x00, 0x01, 0xFC, 0x00, ##                 0000000        
            0x00, 0x03, 0xF8, 0x00, ##                0000000         
            0x00, 0x07, 0xF0, 0x00, ##               0000000          
            0x00, 0x0F, 0xE0, 0x00, ##              0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x3F, 0x80, 0x00, ##            0000000             
            0x00, 0x7F, 0x80, 0x00, ##           00000000             
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x01, 0xFE, 0x00, 0x00, ##         00000000               
            0x03, 0xFC, 0x00, 0x00, ##        00000000                
            0x07, 0xF8, 0x00, 0x00, ##       00000000                 
            0x0F, 0xF0, 0x00, 0x00, ##      00000000                  
            0x1F, 0xE0, 0x00, 0x00, ##     00000000                   
            0x3F, 0xC0, 0x00, 0x00, ##    00000000                    
            0x7F, 0x80, 0x00, 0x00, ##   00000000                     
            0xFF, 0x00, 0x00, 0x00, ##  00000000                      
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000           
            0x3F, 0xFF, 0xFC, 0x00, ##    00000000000000000000        
            0x7F, 0xFF, 0xFF, 0x00, ##   00000000000000000000000      
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000    
            0x7F, 0x00, 0x7F, 0xE0, ##   0000000         0000000000   
            0x70, 0x00, 0x0F, 0xF0, ##   000                00000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000   
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000    
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000      
            0x00, 0xFF, 0xFE, 0x00, ##          000000000000000       
            0x00, 0xFF, 0xFC, 0x00, ##          00000000000000        
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000      
            0x00, 0xFF, 0xFF, 0xC0, ##          000000000000000000    
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000   
            0x00, 0x00, 0x0F, 0xF0, ##                      00000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x80, 0x00, 0x07, 0xF0, ##  0                    0000000  
            0xE0, 0x00, 0x1F, 0xF0, ##  000                000000000  
            0xFC, 0x00, 0x7F, 0xE0, ##  000000           0000000000   
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0x3F, 0xFF, 0xF8, 0x00, ##    0000000000000000000         
            0x03, 0xFF, 0xC0, 0x00, ##        000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 34, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000       
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000       
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000       
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000       
            0x00, 0x00, 0xFF, 0xE0, 0x00, ##                  00000000000       
            0x00, 0x00, 0xFF, 0xE0, 0x00, ##                  00000000000       
            0x00, 0x01, 0xF7, 0xE0, 0x00, ##                 00000 000000       
            0x00, 0x01, 0xF7, 0xE0, 0x00, ##                 00000 000000       
            0x00, 0x03, 0xE7, 0xE0, 0x00, ##                00000  000000       
            0x00, 0x07, 0xE7, 0xE0, 0x00, ##               000000  000000       
            0x00, 0x07, 0xC7, 0xE0, 0x00, ##               00000   000000       
            0x00, 0x0F, 0x87, 0xE0, 0x00, ##              00000    000000       
            0x00, 0x1F, 0x87, 0xE0, 0x00, ##             000000    000000       
            0x00, 0x1F, 0x07, 0xE0, 0x00, ##             00000     000000       
            0x00, 0x3E, 0x07, 0xE0, 0x00, ##            00000      000000       
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000       
            0x00, 0x7C, 0x07, 0xE0, 0x00, ##           00000       000000       
            0x00, 0xFC, 0x07, 0xE0, 0x00, ##          000000       000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x01, 0xF0, 0x07, 0xE0, 0x00, ##         00000         000000       
            0x03, 0xF0, 0x07, 0xE0, 0x00, ##        000000         000000       
            0x03, 0xE0, 0x07, 0xE0, 0x00, ##        00000          000000       
            0x07, 0xC0, 0x07, 0xE0, 0x00, ##       00000           000000       
            0x0F, 0xC0, 0x07, 0xE0, 0x00, ##      000000           000000       
            0x0F, 0x80, 0x07, 0xE0, 0x00, ##      00000            000000       
            0x1F, 0x80, 0x07, 0xE0, 0x00, ##     000000            000000       
            0x3F, 0x00, 0x07, 0xE0, 0x00, ##    000000             000000       
            0x3E, 0x00, 0x07, 0xE0, 0x00, ##    00000              000000       
            0x7E, 0x00, 0x07, 0xE0, 0x00, ##   000000              000000       
            0xFC, 0x00, 0x07, 0xE0, 0x00, ##  000000               000000       
            0xF8, 0x00, 0x07, 0xE0, 0x00, ##  00000                000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x00, 0x00, 0x00, ##    000000                      
            0x3F, 0x7F, 0xC0, 0x00, ##    000000 000000000            
            0x3F, 0xFF, 0xF8, 0x00, ##    0000000000000000000         
            0x3F, 0xFF, 0xFE, 0x00, ##    000000000000000000000       
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000     
            0x3F, 0xFF, 0xFF, 0xC0, ##    000000000000000000000000    
            0x3F, 0x00, 0xFF, 0xE0, ##    000000        00000000000   
            0x30, 0x00, 0x1F, 0xE0, ##    00               00000000   
            0x00, 0x00, 0x0F, 0xF0, ##                      00000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x01, 0xFC, ##                         0000000
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x07, 0xF8, ##                       00000000 
            0x80, 0x00, 0x0F, 0xF0, ##  0                   00000000  
            0xF0, 0x00, 0x1F, 0xE0, ##  0000               00000000   
            0xFE, 0x00, 0xFF, 0xE0, ##  0000000         00000000000   
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0x7F, 0xFF, 0xF8, 0x00, ##   00000000000000000000         
            0x03, 0xFF, 0xC0, 0x00, ##        000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x00, ##                 000000000        
            0x00, 0x0F, 0xFF, 0xF0, ##              0000000000000000    
            0x00, 0x3F, 0xFF, 0xF8, ##            0000000000000000000   
            0x00, 0xFF, 0xFF, 0xF8, ##          000000000000000000000   
            0x01, 0xFF, 0xFF, 0xF8, ##         0000000000000000000000   
            0x03, 0xFE, 0x00, 0xF8, ##        000000000         00000   
            0x07, 0xF8, 0x00, 0x18, ##       00000000              00   
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                     
            0x0F, 0xC0, 0x00, 0x00, ##      000000                      
            0x1F, 0x80, 0x00, 0x00, ##     000000                       
            0x1F, 0x00, 0x00, 0x00, ##     00000                        
            0x3F, 0x00, 0x00, 0x00, ##    000000                        
            0x3E, 0x00, 0x00, 0x00, ##    00000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0x7C, 0x07, 0xF8, 0x00, ##   00000       00000000           
            0xFC, 0x1F, 0xFF, 0x00, ##  000000     0000000000000        
            0xFC, 0x7F, 0xFF, 0xC0, ##  000000   00000000000000000      
            0xFC, 0xFF, 0xFF, 0xE0, ##  000000  0000000000000000000     
            0xFD, 0xFF, 0xFF, 0xF0, ##  000000 000000000000000000000    
            0xFF, 0xF8, 0x0F, 0xF8, ##  0000000000000       000000000   
            0xFF, 0xE0, 0x03, 0xFC, ##  00000000000           00000000  
            0xFF, 0xC0, 0x01, 0xFC, ##  0000000000             0000000  
            0xFF, 0x80, 0x00, 0xFE, ##  000000000               0000000 
            0xFF, 0x00, 0x00, 0x7E, ##  00000000                 000000 
            0xFF, 0x00, 0x00, 0x7E, ##  00000000                 000000 
            0xFF, 0x00, 0x00, 0x7F, ##  00000000                 0000000
            0xFE, 0x00, 0x00, 0x3F, ##  0000000                   000000
            0xFE, 0x00, 0x00, 0x3F, ##  0000000                   000000
            0xFE, 0x00, 0x00, 0x3F, ##  0000000                   000000
            0x7E, 0x00, 0x00, 0x3F, ##   000000                   000000
            0x7E, 0x00, 0x00, 0x3F, ##   000000                   000000
            0x7E, 0x00, 0x00, 0x3F, ##   000000                   000000
            0x7E, 0x00, 0x00, 0x3F, ##   000000                   000000
            0x7E, 0x00, 0x00, 0x3F, ##   000000                   000000
            0x3F, 0x00, 0x00, 0x7F, ##    000000                 0000000
            0x3F, 0x00, 0x00, 0x7E, ##    000000                 000000 
            0x3F, 0x00, 0x00, 0xFE, ##    000000                0000000 
            0x1F, 0x80, 0x00, 0xFE, ##     000000               0000000 
            0x1F, 0xC0, 0x01, 0xFC, ##     0000000             0000000  
            0x0F, 0xE0, 0x03, 0xF8, ##      0000000           0000000   
            0x07, 0xF8, 0x0F, 0xF8, ##       00000000       000000000   
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000    
            0x01, 0xFF, 0xFF, 0xE0, ##         00000000000000000000     
            0x00, 0xFF, 0xFF, 0xC0, ##          000000000000000000      
            0x00, 0x3F, 0xFF, 0x00, ##            00000000000000        
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 30, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000  
            0x00, 0x00, 0x07, 0xE0, ##                       000000   
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000   
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000   
            0x00, 0x00, 0x0F, 0xC0, ##                      000000    
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000    
            0x00, 0x00, 0x1F, 0x80, ##                     000000     
            0x00, 0x00, 0x3F, 0x80, ##                    0000000     
            0x00, 0x00, 0x3F, 0x80, ##                    0000000     
            0x00, 0x00, 0x3F, 0x00, ##                    000000      
            0x00, 0x00, 0x7F, 0x00, ##                   0000000      
            0x00, 0x00, 0x7E, 0x00, ##                   000000       
            0x00, 0x00, 0xFE, 0x00, ##                  0000000       
            0x00, 0x00, 0xFE, 0x00, ##                  0000000       
            0x00, 0x00, 0xFC, 0x00, ##                  000000        
            0x00, 0x01, 0xFC, 0x00, ##                 0000000        
            0x00, 0x01, 0xFC, 0x00, ##                 0000000        
            0x00, 0x01, 0xF8, 0x00, ##                 000000         
            0x00, 0x03, 0xF8, 0x00, ##                0000000         
            0x00, 0x03, 0xF0, 0x00, ##                000000          
            0x00, 0x07, 0xF0, 0x00, ##               0000000          
            0x00, 0x07, 0xF0, 0x00, ##               0000000          
            0x00, 0x07, 0xE0, 0x00, ##               000000           
            0x00, 0x0F, 0xE0, 0x00, ##              0000000           
            0x00, 0x0F, 0xC0, 0x00, ##              000000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x1F, 0x80, 0x00, ##             000000             
            0x00, 0x3F, 0x80, 0x00, ##            0000000             
            0x00, 0x3F, 0x80, 0x00, ##            0000000             
            0x00, 0x3F, 0x00, 0x00, ##            000000              
            0x00, 0x7F, 0x00, 0x00, ##           0000000              
            0x00, 0x7E, 0x00, 0x00, ##           000000               
            0x00, 0xFE, 0x00, 0x00, ##          0000000               
            0x00, 0xFE, 0x00, 0x00, ##          0000000               
            0x00, 0xFC, 0x00, 0x00, ##          000000                
            0x01, 0xFC, 0x00, 0x00, ##         0000000                
            0x01, 0xF8, 0x00, 0x00, ##         000000                 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xF0, ##      000000000000000000000000    
            0x1F, 0xF0, 0x0F, 0xF8, ##     000000000        000000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x1F, 0x80, 0x01, 0xF8, ##     000000              000000   
            0x0F, 0xC0, 0x03, 0xF8, ##      000000            0000000   
            0x07, 0xF0, 0x0F, 0xF0, ##       0000000        00000000    
            0x03, 0xFF, 0xFF, 0xE0, ##        000000000000000000000     
            0x00, 0xFF, 0xFF, 0x80, ##          00000000000000000       
            0x00, 0xFF, 0xFE, 0x00, ##          000000000000000         
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x0F, 0xFF, 0xFF, 0xE0, ##      00000000000000000000000     
            0x1F, 0xF0, 0x0F, 0xF8, ##     000000000        000000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x80, 0x01, 0xFE, ##   00000000              00000000 
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0xF0, 0x0F, 0xFC, ##    0000000000        0000000000  
            0x1F, 0xFF, 0xFF, 0xF8, ##     00000000000000000000000000   
            0x0F, 0xFF, 0xFF, 0xF0, ##      000000000000000000000000    
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xF0, 0x00, ##             000000000            
            0x00, 0xFF, 0xFC, 0x00, ##          00000000000000          
            0x03, 0xFF, 0xFF, 0x00, ##        000000000000000000        
            0x07, 0xFF, 0xFF, 0x80, ##       00000000000000000000       
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000      
            0x1F, 0xF0, 0x1F, 0xE0, ##     000000000       00000000     
            0x1F, 0xC0, 0x07, 0xF0, ##     0000000           0000000    
            0x3F, 0x80, 0x03, 0xF0, ##    0000000             000000    
            0x7F, 0x00, 0x01, 0xF8, ##   0000000               000000   
            0x7F, 0x00, 0x00, 0xF8, ##   0000000                00000   
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000  
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000  
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0xFE, 0x00, 0x00, 0xFF, ##  0000000                 00000000
            0x7E, 0x00, 0x00, 0xFF, ##   000000                 00000000
            0x7E, 0x00, 0x00, 0xFF, ##   000000                 00000000
            0x7F, 0x00, 0x01, 0xFF, ##   0000000               000000000
            0x3F, 0x80, 0x03, 0xFF, ##    0000000             0000000000
            0x3F, 0xC0, 0x07, 0xFF, ##    00000000           00000000000
            0x1F, 0xF0, 0x1F, 0xFF, ##     000000000       0000000000000
            0x0F, 0xFF, 0xFF, 0xBF, ##      000000000000000000000 000000
            0x07, 0xFF, 0xFF, 0x3F, ##       0000000000000000000  000000
            0x03, 0xFF, 0xFE, 0x3F, ##        00000000000000000   000000
            0x00, 0xFF, 0xF8, 0x3F, ##          0000000000000     000000
            0x00, 0x1F, 0xE0, 0x3E, ##             00000000       00000 
            0x00, 0x00, 0x00, 0x7E, ##                           000000 
            0x00, 0x00, 0x00, 0x7E, ##                           000000 
            0x00, 0x00, 0x00, 0x7E, ##                           000000 
            0x00, 0x00, 0x00, 0x7C, ##                           00000  
            0x00, 0x00, 0x00, 0xFC, ##                          000000  
            0x00, 0x00, 0x00, 0xFC, ##                          000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000   
            0x00, 0x00, 0x01, 0xF8, ##                         000000   
            0x00, 0x00, 0x03, 0xF0, ##                        000000    
            0x00, 0x00, 0x07, 0xE0, ##                       000000     
            0x18, 0x00, 0x1F, 0xE0, ##     00              00000000     
            0x1F, 0x00, 0x7F, 0xC0, ##     00000         000000000      
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000        
            0x1F, 0xFF, 0xFC, 0x00, ##     0000000000000000000          
            0x0F, 0xFF, 0xF0, 0x00, ##      0000000000000000            
            0x00, 0xFF, 0x80, 0x00, ##          000000000               
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 6, 
        'xoffset'  => 7, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 9, 
        'xoffset'  => 4, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x00, 0x00, ##           
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x80, ##     000000
            0x1F, 0x00, ##     00000 
            0x3F, 0x00, ##    000000 
            0x3E, 0x00, ##    00000  
            0x3E, 0x00, ##    00000  
            0x3E, 0x00, ##    00000  
            0x7C, 0x00, ##   00000   
            0x7C, 0x00, ##   00000   
            0x78, 0x00, ##   0000    
            0x78, 0x00, ##   0000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x03, ##                                        00
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x07, 0xFF, ##                               00000000000
            0x00, 0x00, 0x00, 0x1F, 0xFF, ##                             0000000000000
            0x00, 0x00, 0x00, 0xFF, 0xFF, ##                          0000000000000000
            0x00, 0x00, 0x07, 0xFF, 0xF8, ##                       0000000000000000   
            0x00, 0x00, 0x3F, 0xFF, 0xC0, ##                    0000000000000000      
            0x00, 0x00, 0xFF, 0xFE, 0x00, ##                  000000000000000         
            0x00, 0x07, 0xFF, 0xF0, 0x00, ##               000000000000000            
            0x00, 0x3F, 0xFF, 0xC0, 0x00, ##            0000000000000000              
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000                 
            0x07, 0xFF, 0xF0, 0x00, 0x00, ##       000000000000000                    
            0x3F, 0xFF, 0x80, 0x00, 0x00, ##    000000000000000                       
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                          
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                            
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                              
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                            
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                         
            0x1F, 0xFF, 0xC0, 0x00, 0x00, ##     000000000000000                      
            0x03, 0xFF, 0xF8, 0x00, 0x00, ##        000000000000000                   
            0x00, 0xFF, 0xFF, 0x00, 0x00, ##          0000000000000000                
            0x00, 0x1F, 0xFF, 0xC0, 0x00, ##             000000000000000              
            0x00, 0x03, 0xFF, 0xF8, 0x00, ##                000000000000000           
            0x00, 0x00, 0x7F, 0xFF, 0x00, ##                   000000000000000        
            0x00, 0x00, 0x1F, 0xFF, 0xE0, ##                     0000000000000000     
            0x00, 0x00, 0x03, 0xFF, 0xFC, ##                        0000000000000000  
            0x00, 0x00, 0x00, 0x7F, 0xFF, ##                           000000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, ##                              000000000000
            0x00, 0x00, 0x00, 0x03, 0xFF, ##                                0000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, ##                                   0000000
            0x00, 0x00, 0x00, 0x00, 0x0F, ##                                      0000
            0x00, 0x00, 0x00, 0x00, 0x03, ##                                        00
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xC0, 0x00, 0x00, 0x00, 0x00, ##  00                                      
            0xF8, 0x00, 0x00, 0x00, 0x00, ##  00000                                   
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                             
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                           
            0xFF, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000000                        
            0x1F, 0xFF, 0xE0, 0x00, 0x00, ##     0000000000000000                     
            0x03, 0xFF, 0xF8, 0x00, 0x00, ##        000000000000000                   
            0x00, 0x7F, 0xFF, 0x00, 0x00, ##           000000000000000                
            0x00, 0x0F, 0xFF, 0xE0, 0x00, ##              000000000000000             
            0x00, 0x03, 0xFF, 0xFC, 0x00, ##                0000000000000000          
            0x00, 0x00, 0x7F, 0xFF, 0x00, ##                   000000000000000        
            0x00, 0x00, 0x0F, 0xFF, 0xE0, ##                      000000000000000     
            0x00, 0x00, 0x01, 0xFF, 0xFC, ##                         000000000000000  
            0x00, 0x00, 0x00, 0x3F, 0xFF, ##                            00000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, ##                              000000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, ##                                 000000000
            0x00, 0x00, 0x00, 0x03, 0xFF, ##                                0000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, ##                              000000000000
            0x00, 0x00, 0x00, 0x7F, 0xFF, ##                           000000000000000
            0x00, 0x00, 0x03, 0xFF, 0xF8, ##                        000000000000000   
            0x00, 0x00, 0x1F, 0xFF, 0xC0, ##                     000000000000000      
            0x00, 0x00, 0xFF, 0xFF, 0x00, ##                  0000000000000000        
            0x00, 0x03, 0xFF, 0xF8, 0x00, ##                000000000000000           
            0x00, 0x1F, 0xFF, 0xC0, 0x00, ##             000000000000000              
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000                 
            0x07, 0xFF, 0xF8, 0x00, 0x00, ##       0000000000000000                   
            0x3F, 0xFF, 0xC0, 0x00, 0x00, ##    0000000000000000                      
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                         
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                            
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                              
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                                 
            0xF0, 0x00, 0x00, 0x00, 0x00, ##  0000                                    
            0xC0, 0x00, 0x00, 0x00, 0x00, ##  00                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 24, 
        'xoffset'  => 5, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0x00, ##         000000000        
            0x1F, 0xFF, 0xC0, ##     000000000000000      
            0x7F, 0xFF, 0xF0, ##   0000000000000000000    
            0xFF, 0xFF, 0xF8, ##  000000000000000000000   
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000  
            0xFE, 0x03, 0xFE, ##  0000000       000000000 
            0xF0, 0x00, 0xFE, ##  0000            0000000 
            0xC0, 0x00, 0x7E, ##  00               000000 
            0x80, 0x00, 0x7F, ##  0                0000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x7E, ##                   000000 
            0x00, 0x00, 0xFE, ##                  0000000 
            0x00, 0x00, 0xFC, ##                  000000  
            0x00, 0x01, 0xFC, ##                 0000000  
            0x00, 0x03, 0xF8, ##                0000000   
            0x00, 0x07, 0xF0, ##               0000000    
            0x00, 0x0F, 0xE0, ##              0000000     
            0x00, 0x1F, 0xC0, ##             0000000      
            0x00, 0x3F, 0x80, ##            0000000       
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0xFE, 0x00, ##          0000000         
            0x00, 0xFC, 0x00, ##          000000          
            0x01, 0xFC, 0x00, ##         0000000          
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x01, 0xF8, 0x00, ##         000000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 56, 
        'xoffset'  => 4, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                          0000000000                      
            0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##                      000000000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##                   000000000000000000000000               
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##                 0000000000000000000000000000             
            0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##               0000000000000000000000000000000            
            0x00, 0x0F, 0xFE, 0x00, 0x3F, 0xFC, 0x00, ##              00000000000           000000000000          
            0x00, 0x3F, 0xF0, 0x00, 0x07, 0xFE, 0x00, ##            0000000000                 0000000000         
            0x00, 0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##           00000000                       00000000        
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x7F, 0x80, ##          0000000                          00000000       
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##         0000000                             0000000      
            0x03, 0xF8, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##        0000000                               0000000     
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x07, 0xF0, ##        00000                                  0000000    
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xF0, ##       00000                                    000000    
            0x0F, 0x80, 0x00, 0x00, 0x00, 0x01, 0xF8, ##      00000                                      000000   
            0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFC, ##      00000                                       000000  
            0x1F, 0x00, 0x01, 0xFC, 0x00, 0x00, 0xFC, ##     00000               0000000                  000000  
            0x1E, 0x00, 0x07, 0xFF, 0x8F, 0x80, 0x7C, ##     0000              000000000000   00000        00000  
            0x3E, 0x00, 0x0F, 0xFF, 0xCF, 0x80, 0x7E, ##    00000             00000000000000  00000        000000 
            0x3C, 0x00, 0x1F, 0xFF, 0xEF, 0x80, 0x3E, ##    0000             0000000000000000 00000         00000 
            0x7C, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x3E, ##   00000            00000000000000000000000         00000 
            0x78, 0x00, 0x7F, 0x81, 0xFF, 0x80, 0x3F, ##   0000            00000000      0000000000         000000
            0x78, 0x00, 0x7E, 0x00, 0x7F, 0x80, 0x1F, ##   0000            000000          00000000          00000
            0x78, 0x00, 0xFC, 0x00, 0x3F, 0x80, 0x1F, ##   0000           000000            0000000          00000
            0xF8, 0x00, 0xF8, 0x00, 0x1F, 0x80, 0x1F, ##  00000           00000              000000          00000
            0xF0, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x1F, ##  0000           000000              000000          00000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x1F, ##  0000           00000                00000          00000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x1F, ##  0000           00000                00000          00000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x1F, ##  0000           00000                00000          00000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x1F, ##  0000           00000                00000          00000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x3F, ##  0000           00000                00000         000000
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x3E, ##  0000           00000                00000         00000 
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x3E, ##  0000           00000                00000         00000 
            0xF0, 0x01, 0xF0, 0x00, 0x0F, 0x80, 0x7E, ##  0000           00000                00000        000000 
            0xF0, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x7C, ##  0000           000000              000000        00000  
            0x78, 0x00, 0xF8, 0x00, 0x1F, 0x80, 0xFC, ##   0000           00000              000000       000000  
            0x78, 0x00, 0xFC, 0x00, 0x3F, 0x81, 0xF8, ##   0000           000000            0000000      000000   
            0x78, 0x00, 0x7E, 0x00, 0x7F, 0x87, 0xF0, ##   0000            000000          00000000    0000000    
            0x7C, 0x00, 0x7F, 0x81, 0xFF, 0x9F, 0xE0, ##   00000           00000000      0000000000  00000000     
            0x3C, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    0000            00000000000000000000000000000000      
            0x3E, 0x00, 0x1F, 0xFF, 0xEF, 0xFF, 0x80, ##    00000            0000000000000000 0000000000000       
            0x3E, 0x00, 0x0F, 0xFF, 0xCF, 0xFF, 0x00, ##    00000             00000000000000  000000000000        
            0x1F, 0x00, 0x07, 0xFF, 0x8F, 0xF8, 0x00, ##     00000             000000000000   000000000           
            0x1F, 0x00, 0x01, 0xFC, 0x0F, 0xC0, 0x00, ##     00000               0000000      000000              
            0x0F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##      00000                                               
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##       00000                                              
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##       000000                                             
            0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, ##        000000                                            
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x10, 0x00, ##         0000000                             0            
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x78, 0x00, ##          0000000                          0000           
            0x00, 0x7F, 0x80, 0x00, 0x01, 0xF8, 0x00, ##           00000000                      000000           
            0x00, 0x3F, 0xE0, 0x00, 0x07, 0xFC, 0x00, ##            000000000                  000000000          
            0x00, 0x1F, 0xFE, 0x00, 0x7F, 0xF8, 0x00, ##             000000000000          000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##               000000000000000000000000000000             
            0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                000000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##                  000000000000000000000000                
            0x00, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x00, ##                     000000000000000000                   
            0x00, 0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, ##                         0000000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x07, 0xE3, 0xF0, 0x00, 0x00, ##               000000   000000              
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x0F, 0xC1, 0xFC, 0x00, 0x00, ##              000000     0000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x1F, 0xC0, 0xFC, 0x00, 0x00, ##             0000000      000000            
            0x00, 0x1F, 0x80, 0xFE, 0x00, 0x00, ##             000000       0000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x3F, 0x80, 0x7E, 0x00, 0x00, ##            0000000        000000           
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x7E, 0x00, 0x3F, 0x80, 0x00, ##           000000           0000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0xFE, 0x00, 0x1F, 0x80, 0x00, ##          0000000            000000         
            0x00, 0xFC, 0x00, 0x1F, 0xC0, 0x00, ##          000000             0000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x01, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##         0000000              000000        
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##      0000000000000000000000000000000000    
            0x0F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##      000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##     0000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##     000000                        000000   
            0x3F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##    0000000                        000000   
            0x3F, 0x00, 0x00, 0x00, 0x7F, 0x00, ##    000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x7E, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   000000                           0000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  0000000                            000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  000000                              000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 33, 
        'xoffset'  => 6, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  000000000000000000000            
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  00000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000    
            0xFC, 0x00, 0x0F, 0xF8, 0x00, ##  000000              000000000    
            0xFC, 0x00, 0x03, 0xFC, 0x00, ##  000000                00000000   
            0xFC, 0x00, 0x01, 0xFC, 0x00, ##  000000                 0000000   
            0xFC, 0x00, 0x00, 0xFE, 0x00, ##  000000                  0000000  
            0xFC, 0x00, 0x00, 0xFE, 0x00, ##  000000                  0000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000   
            0xFC, 0x00, 0x01, 0xFC, 0x00, ##  000000                 0000000   
            0xFC, 0x00, 0x03, 0xF8, 0x00, ##  000000                0000000    
            0xFC, 0x00, 0x0F, 0xF8, 0x00, ##  000000              000000000    
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  00000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000    
            0xFC, 0x00, 0x07, 0xFC, 0x00, ##  000000               000000000   
            0xFC, 0x00, 0x00, 0xFE, 0x00, ##  000000                  0000000  
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000  
            0xFC, 0x00, 0x00, 0x3F, 0x00, ##  000000                    000000 
            0xFC, 0x00, 0x00, 0x3F, 0x00, ##  000000                    000000 
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFC, 0x00, 0x00, 0x3F, 0x80, ##  000000                    0000000
            0xFC, 0x00, 0x00, 0x3F, 0x00, ##  000000                    000000 
            0xFC, 0x00, 0x00, 0x7F, 0x00, ##  000000                   0000000 
            0xFC, 0x00, 0x00, 0xFE, 0x00, ##  000000                  0000000  
            0xFC, 0x00, 0x07, 0xFE, 0x00, ##  000000               0000000000  
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  00000000000000000000000000       
            0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  0000000000000000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 45, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000          
            0x00, 0x03, 0xFF, 0xFF, 0x00, ##                000000000000000000      
            0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##             00000000000000000000000    
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000  
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, ##          000000000000000000000000000000
            0x01, 0xFF, 0xC0, 0x1F, 0xFC, ##         00000000000         00000000000
            0x03, 0xFE, 0x00, 0x01, 0xFC, ##        000000000                0000000
            0x07, 0xF8, 0x00, 0x00, 0x7C, ##       00000000                    00000
            0x0F, 0xF0, 0x00, 0x00, 0x3C, ##      00000000                      0000
            0x0F, 0xE0, 0x00, 0x00, 0x0C, ##      0000000                         00
            0x1F, 0xC0, 0x00, 0x00, 0x04, ##     0000000                           0
            0x1F, 0x80, 0x00, 0x00, 0x00, ##     000000                             
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                             
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                              
            0x7F, 0x00, 0x00, 0x00, 0x00, ##   0000000                              
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                               
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7F, 0x00, 0x00, 0x00, 0x00, ##   0000000                              
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                              
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                             
            0x1F, 0x80, 0x00, 0x00, 0x00, ##     000000                             
            0x1F, 0xC0, 0x00, 0x00, 0x04, ##     0000000                           0
            0x0F, 0xE0, 0x00, 0x00, 0x0C, ##      0000000                         00
            0x0F, 0xF0, 0x00, 0x00, 0x3C, ##      00000000                      0000
            0x07, 0xF8, 0x00, 0x00, 0x7C, ##       00000000                    00000
            0x03, 0xFE, 0x00, 0x01, 0xFC, ##        000000000                0000000
            0x01, 0xFF, 0xC0, 0x1F, 0xFC, ##         00000000000         00000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, ##          000000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000  
            0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##             00000000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0x00, ##                000000000000000000      
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000          
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 39, 
        'xoffset'  => 6, 
        'xadvance' => 49, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                   
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000        
            0xFC, 0x00, 0x0F, 0xFF, 0x00, ##  000000              000000000000       
            0xFC, 0x00, 0x01, 0xFF, 0x80, ##  000000                 0000000000      
            0xFC, 0x00, 0x00, 0x3F, 0xC0, ##  000000                    00000000     
            0xFC, 0x00, 0x00, 0x1F, 0xE0, ##  000000                     00000000    
            0xFC, 0x00, 0x00, 0x0F, 0xF0, ##  000000                      00000000   
            0xFC, 0x00, 0x00, 0x07, 0xF0, ##  000000                       0000000   
            0xFC, 0x00, 0x00, 0x03, 0xF8, ##  000000                        0000000  
            0xFC, 0x00, 0x00, 0x01, 0xF8, ##  000000                         000000  
            0xFC, 0x00, 0x00, 0x01, 0xFC, ##  000000                         0000000 
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x00, 0xFE, ##  000000                          0000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0x7E, ##  000000                           000000
            0xFC, 0x00, 0x00, 0x00, 0xFE, ##  000000                          0000000
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x00, 0xFC, ##  000000                          000000 
            0xFC, 0x00, 0x00, 0x01, 0xFC, ##  000000                         0000000 
            0xFC, 0x00, 0x00, 0x01, 0xF8, ##  000000                         000000  
            0xFC, 0x00, 0x00, 0x03, 0xF8, ##  000000                        0000000  
            0xFC, 0x00, 0x00, 0x07, 0xF0, ##  000000                       0000000   
            0xFC, 0x00, 0x00, 0x0F, 0xF0, ##  000000                      00000000   
            0xFC, 0x00, 0x00, 0x1F, 0xE0, ##  000000                     00000000    
            0xFC, 0x00, 0x00, 0x3F, 0xC0, ##  000000                    00000000     
            0xFC, 0x00, 0x00, 0xFF, 0xC0, ##  000000                  0000000000     
            0xFC, 0x00, 0x0F, 0xFF, 0x00, ##  000000              000000000000       
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000              
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 27, 
        'xoffset'  => 6, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 41, 
        'xoffset'  => 4, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000            
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                00000000000000000000       
            0x00, 0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##              000000000000000000000000     
            0x00, 0x3F, 0xFF, 0xFF, 0xFC, 0x00, ##            0000000000000000000000000000   
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##          00000000000000000000000000000000 
            0x01, 0xFF, 0xE0, 0x0F, 0xFF, 0x00, ##         000000000000         000000000000 
            0x03, 0xFE, 0x00, 0x00, 0xFF, 0x00, ##        000000000                 00000000 
            0x07, 0xF8, 0x00, 0x00, 0x3F, 0x00, ##       00000000                     000000 
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0x00, ##      00000000                        0000 
            0x0F, 0xE0, 0x00, 0x00, 0x07, 0x00, ##      0000000                          000 
            0x1F, 0xC0, 0x00, 0x00, 0x01, 0x00, ##     0000000                             0 
            0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, ##     000000                                
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, ##    0000000                                
            0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, ##    000000                                 
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                 
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                  
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                  
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000                                  
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                  
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                   
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                   
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                   
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                   
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                   
            0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000000                  00000000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000000                  00000000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000000                  00000000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000000                  00000000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000000                  00000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  000000                             000000
            0xFC, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  000000                             000000
            0x7E, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   000000                            000000
            0x7E, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   000000                            000000
            0x7E, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   000000                            000000
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   0000000                           000000
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000
            0x3F, 0x80, 0x00, 0x00, 0x1F, 0x80, ##    0000000                          000000
            0x1F, 0x80, 0x00, 0x00, 0x1F, 0x80, ##     000000                          000000
            0x1F, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##     0000000                         000000
            0x0F, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##      0000000                        000000
            0x0F, 0xF0, 0x00, 0x00, 0x1F, 0x80, ##      00000000                       000000
            0x07, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##       00000000                      000000
            0x03, 0xFE, 0x00, 0x00, 0x7F, 0x80, ##        000000000                  00000000
            0x01, 0xFF, 0xE0, 0x03, 0xFF, 0x80, ##         000000000000           00000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##          00000000000000000000000000000000 
            0x00, 0x3F, 0xFF, 0xFF, 0xFC, 0x00, ##            0000000000000000000000000000   
            0x00, 0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##              000000000000000000000000     
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                00000000000000000000       
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 35, 
        'xoffset'  => 6, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 15, 
        'xoffset'  => -3, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0x7E, ##           000000
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x01, 0xFC, ##         0000000 
            0x03, 0xF8, ##        0000000  
            0x07, 0xF8, ##       00000000  
            0xFF, 0xF0, ##  000000000000   
            0xFF, 0xF0, ##  000000000000   
            0xFF, 0xE0, ##  00000000000    
            0xFF, 0x80, ##  000000000      
            0xFC, 0x00, ##  000000         
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 37, 
        'xoffset'  => 6, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x3F, 0xE0, ##  000000                    000000000  
            0xFC, 0x00, 0x00, 0x7F, 0x80, ##  000000                   00000000    
            0xFC, 0x00, 0x00, 0xFF, 0x00, ##  000000                  00000000     
            0xFC, 0x00, 0x01, 0xFE, 0x00, ##  000000                 00000000      
            0xFC, 0x00, 0x03, 0xFC, 0x00, ##  000000                00000000       
            0xFC, 0x00, 0x07, 0xF8, 0x00, ##  000000               00000000        
            0xFC, 0x00, 0x0F, 0xF0, 0x00, ##  000000              00000000         
            0xFC, 0x00, 0x1F, 0xE0, 0x00, ##  000000             00000000          
            0xFC, 0x00, 0x3F, 0xC0, 0x00, ##  000000            00000000           
            0xFC, 0x00, 0x7F, 0x80, 0x00, ##  000000           00000000            
            0xFC, 0x00, 0xFF, 0x00, 0x00, ##  000000          00000000             
            0xFC, 0x01, 0xFE, 0x00, 0x00, ##  000000         00000000              
            0xFC, 0x03, 0xFC, 0x00, 0x00, ##  000000        00000000               
            0xFC, 0x07, 0xF8, 0x00, 0x00, ##  000000       00000000                
            0xFC, 0x0F, 0xF0, 0x00, 0x00, ##  000000      00000000                 
            0xFC, 0x1F, 0xE0, 0x00, 0x00, ##  000000     00000000                  
            0xFC, 0x3F, 0xC0, 0x00, 0x00, ##  000000    00000000                   
            0xFC, 0xFF, 0x80, 0x00, 0x00, ##  000000  000000000                    
            0xFD, 0xFF, 0x00, 0x00, 0x00, ##  000000 000000000                     
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                       
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                        
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                         
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                        
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                        
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                       
            0xFD, 0xFE, 0x00, 0x00, 0x00, ##  000000 00000000                      
            0xFC, 0xFF, 0x00, 0x00, 0x00, ##  000000  00000000                     
            0xFC, 0x7F, 0x80, 0x00, 0x00, ##  000000   00000000                    
            0xFC, 0x3F, 0xC0, 0x00, 0x00, ##  000000    00000000                   
            0xFC, 0x1F, 0xE0, 0x00, 0x00, ##  000000     00000000                  
            0xFC, 0x0F, 0xF0, 0x00, 0x00, ##  000000      00000000                 
            0xFC, 0x07, 0xF8, 0x00, 0x00, ##  000000       00000000                
            0xFC, 0x03, 0xFC, 0x00, 0x00, ##  000000        00000000               
            0xFC, 0x01, 0xFE, 0x00, 0x00, ##  000000         00000000              
            0xFC, 0x00, 0xFF, 0x00, 0x00, ##  000000          00000000             
            0xFC, 0x00, 0x7F, 0x80, 0x00, ##  000000           00000000            
            0xFC, 0x00, 0x3F, 0xC0, 0x00, ##  000000            00000000           
            0xFC, 0x00, 0x1F, 0xE0, 0x00, ##  000000             00000000          
            0xFC, 0x00, 0x0F, 0xF0, 0x00, ##  000000              00000000         
            0xFC, 0x00, 0x07, 0xF8, 0x00, ##  000000               00000000        
            0xFC, 0x00, 0x03, 0xFC, 0x00, ##  000000                00000000       
            0xFC, 0x00, 0x01, 0xFE, 0x00, ##  000000                 00000000      
            0xFC, 0x00, 0x00, 0xFF, 0x00, ##  000000                  00000000     
            0xFC, 0x00, 0x00, 0x7F, 0x80, ##  000000                   00000000    
            0xFC, 0x00, 0x00, 0x3F, 0xC0, ##  000000                    00000000   
            0xFC, 0x00, 0x00, 0x1F, 0xE0, ##  000000                     00000000  
            0xFC, 0x00, 0x00, 0x0F, 0xF0, ##  000000                      00000000 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 29, 
        'xoffset'  => 6, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 43, 
        'xoffset'  => 6, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xE0, ##  0000000000                       0000000000
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xE0, ##  0000000000                       0000000000
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xE0, ##  0000000000                       0000000000
            0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xE0, ##  00000000000                     00000000000
            0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xE0, ##  00000000000                     00000000000
            0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xE0, ##  00000000000                     00000000000
            0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xE0, ##  000000000000                   000000000000
            0xFD, 0xF0, 0x00, 0x01, 0xF7, 0xE0, ##  000000 00000                   00000 000000
            0xFD, 0xF8, 0x00, 0x03, 0xF7, 0xE0, ##  000000 000000                 000000 000000
            0xFD, 0xF8, 0x00, 0x03, 0xF7, 0xE0, ##  000000 000000                 000000 000000
            0xFC, 0xF8, 0x00, 0x03, 0xE7, 0xE0, ##  000000  00000                 00000  000000
            0xFC, 0xFC, 0x00, 0x07, 0xE7, 0xE0, ##  000000  000000               000000  000000
            0xFC, 0x7C, 0x00, 0x07, 0xC7, 0xE0, ##  000000   00000               00000   000000
            0xFC, 0x7C, 0x00, 0x07, 0xC7, 0xE0, ##  000000   00000               00000   000000
            0xFC, 0x7E, 0x00, 0x0F, 0xC7, 0xE0, ##  000000   000000             000000   000000
            0xFC, 0x3E, 0x00, 0x0F, 0x87, 0xE0, ##  000000    00000             00000    000000
            0xFC, 0x3F, 0x00, 0x1F, 0x87, 0xE0, ##  000000    000000           000000    000000
            0xFC, 0x3F, 0x00, 0x1F, 0x87, 0xE0, ##  000000    000000           000000    000000
            0xFC, 0x1F, 0x00, 0x1F, 0x07, 0xE0, ##  000000     00000           00000     000000
            0xFC, 0x1F, 0x80, 0x3F, 0x07, 0xE0, ##  000000     000000         000000     000000
            0xFC, 0x0F, 0x80, 0x3E, 0x07, 0xE0, ##  000000      00000         00000      000000
            0xFC, 0x0F, 0xC0, 0x7E, 0x07, 0xE0, ##  000000      000000       000000      000000
            0xFC, 0x0F, 0xC0, 0x7E, 0x07, 0xE0, ##  000000      000000       000000      000000
            0xFC, 0x07, 0xC0, 0x7C, 0x07, 0xE0, ##  000000       00000       00000       000000
            0xFC, 0x07, 0xE0, 0xFC, 0x07, 0xE0, ##  000000       000000     000000       000000
            0xFC, 0x03, 0xE0, 0xF8, 0x07, 0xE0, ##  000000        00000     00000        000000
            0xFC, 0x03, 0xE0, 0xF8, 0x07, 0xE0, ##  000000        00000     00000        000000
            0xFC, 0x03, 0xF1, 0xF8, 0x07, 0xE0, ##  000000        000000   000000        000000
            0xFC, 0x01, 0xF1, 0xF0, 0x07, 0xE0, ##  000000         00000   00000         000000
            0xFC, 0x01, 0xFB, 0xF0, 0x07, 0xE0, ##  000000         000000 000000         000000
            0xFC, 0x01, 0xFB, 0xF0, 0x07, 0xE0, ##  000000         000000 000000         000000
            0xFC, 0x00, 0xFB, 0xE0, 0x07, 0xE0, ##  000000          00000 00000          000000
            0xFC, 0x00, 0xFF, 0xE0, 0x07, 0xE0, ##  000000          00000000000          000000
            0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xE0, ##  000000           000000000           000000
            0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xE0, ##  000000           000000000           000000
            0xFC, 0x00, 0x7F, 0xC0, 0x07, 0xE0, ##  000000           000000000           000000
            0xFC, 0x00, 0x3F, 0x80, 0x07, 0xE0, ##  000000            0000000            000000
            0xFC, 0x00, 0x3F, 0x80, 0x07, 0xE0, ##  000000            0000000            000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 35, 
        'xoffset'  => 6, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x07, 0xE0, ##  000000000                    000000
            0xFF, 0x80, 0x00, 0x07, 0xE0, ##  000000000                    000000
            0xFF, 0xC0, 0x00, 0x07, 0xE0, ##  0000000000                   000000
            0xFF, 0xC0, 0x00, 0x07, 0xE0, ##  0000000000                   000000
            0xFF, 0xE0, 0x00, 0x07, 0xE0, ##  00000000000                  000000
            0xFF, 0xE0, 0x00, 0x07, 0xE0, ##  00000000000                  000000
            0xFF, 0xF0, 0x00, 0x07, 0xE0, ##  000000000000                 000000
            0xFF, 0xF0, 0x00, 0x07, 0xE0, ##  000000000000                 000000
            0xFF, 0xF8, 0x00, 0x07, 0xE0, ##  0000000000000                000000
            0xFD, 0xF8, 0x00, 0x07, 0xE0, ##  000000 000000                000000
            0xFD, 0xFC, 0x00, 0x07, 0xE0, ##  000000 0000000               000000
            0xFC, 0xFC, 0x00, 0x07, 0xE0, ##  000000  000000               000000
            0xFC, 0x7E, 0x00, 0x07, 0xE0, ##  000000   000000              000000
            0xFC, 0x7E, 0x00, 0x07, 0xE0, ##  000000   000000              000000
            0xFC, 0x3F, 0x00, 0x07, 0xE0, ##  000000    000000             000000
            0xFC, 0x3F, 0x80, 0x07, 0xE0, ##  000000    0000000            000000
            0xFC, 0x1F, 0x80, 0x07, 0xE0, ##  000000     000000            000000
            0xFC, 0x1F, 0xC0, 0x07, 0xE0, ##  000000     0000000           000000
            0xFC, 0x0F, 0xC0, 0x07, 0xE0, ##  000000      000000           000000
            0xFC, 0x0F, 0xE0, 0x07, 0xE0, ##  000000      0000000          000000
            0xFC, 0x07, 0xE0, 0x07, 0xE0, ##  000000       000000          000000
            0xFC, 0x07, 0xF0, 0x07, 0xE0, ##  000000       0000000         000000
            0xFC, 0x03, 0xF0, 0x07, 0xE0, ##  000000        000000         000000
            0xFC, 0x03, 0xF8, 0x07, 0xE0, ##  000000        0000000        000000
            0xFC, 0x01, 0xF8, 0x07, 0xE0, ##  000000         000000        000000
            0xFC, 0x01, 0xFC, 0x07, 0xE0, ##  000000         0000000       000000
            0xFC, 0x00, 0xFC, 0x07, 0xE0, ##  000000          000000       000000
            0xFC, 0x00, 0xFE, 0x07, 0xE0, ##  000000          0000000      000000
            0xFC, 0x00, 0x7E, 0x07, 0xE0, ##  000000           000000      000000
            0xFC, 0x00, 0x7F, 0x07, 0xE0, ##  000000           0000000     000000
            0xFC, 0x00, 0x3F, 0x07, 0xE0, ##  000000            000000     000000
            0xFC, 0x00, 0x3F, 0x87, 0xE0, ##  000000            0000000    000000
            0xFC, 0x00, 0x1F, 0x87, 0xE0, ##  000000             000000    000000
            0xFC, 0x00, 0x0F, 0xC7, 0xE0, ##  000000              000000   000000
            0xFC, 0x00, 0x0F, 0xC7, 0xE0, ##  000000              000000   000000
            0xFC, 0x00, 0x07, 0xE7, 0xE0, ##  000000               000000  000000
            0xFC, 0x00, 0x07, 0xF7, 0xE0, ##  000000               0000000 000000
            0xFC, 0x00, 0x03, 0xF7, 0xE0, ##  000000                000000 000000
            0xFC, 0x00, 0x03, 0xFF, 0xE0, ##  000000                0000000000000
            0xFC, 0x00, 0x01, 0xFF, 0xE0, ##  000000                 000000000000
            0xFC, 0x00, 0x01, 0xFF, 0xE0, ##  000000                 000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xE0, ##  000000                  00000000000
            0xFC, 0x00, 0x00, 0xFF, 0xE0, ##  000000                  00000000000
            0xFC, 0x00, 0x00, 0x7F, 0xE0, ##  000000                   0000000000
            0xFC, 0x00, 0x00, 0x7F, 0xE0, ##  000000                   0000000000
            0xFC, 0x00, 0x00, 0x3F, 0xE0, ##  000000                    000000000
            0xFC, 0x00, 0x00, 0x3F, 0xE0, ##  000000                    000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000           
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0xFC, 0x00, 0x3F, 0xF0, ##  000000            0000000000  
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000  
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000 
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000 
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000  
            0xFC, 0x00, 0x3F, 0xF0, ##  000000            0000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000           
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  000000                              0000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  000000                              0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##     000000                         0000000  
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##      0000000                     00000000   
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xFC, 0x00, ##        000000000             0000000000     
            0x01, 0xFF, 0x80, 0x3F, 0xF8, 0x00, ##         0000000000         00000000000      
            0x00, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##          0000000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000          
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000            
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, ##                  0000000000000000           
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                           00000000          
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000         
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, ##                             0000000         
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##                              0000000        
            0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, ##                               0000000       
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##                                0000000      
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  00000000000000000000000000          
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  000000000000000000000000000         
            0xFC, 0x00, 0x3F, 0xF0, 0x00, ##  000000            0000000000        
            0xFC, 0x00, 0x07, 0xF0, 0x00, ##  000000               0000000        
            0xFC, 0x00, 0x03, 0xF8, 0x00, ##  000000                0000000       
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000       
            0xFC, 0x00, 0x01, 0xFC, 0x00, ##  000000                 0000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x01, 0xFC, 0x00, ##  000000                 0000000      
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000       
            0xFC, 0x00, 0x03, 0xF8, 0x00, ##  000000                0000000       
            0xFC, 0x00, 0x07, 0xF0, 0x00, ##  000000               0000000        
            0xFC, 0x00, 0x3F, 0xF0, 0x00, ##  000000            0000000000        
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000           
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000           
            0xFC, 0x00, 0x7F, 0xC0, 0x00, ##  000000           000000000          
            0xFC, 0x00, 0x1F, 0xC0, 0x00, ##  000000             0000000          
            0xFC, 0x00, 0x0F, 0xE0, 0x00, ##  000000              0000000         
            0xFC, 0x00, 0x07, 0xF0, 0x00, ##  000000               0000000        
            0xFC, 0x00, 0x03, 0xF0, 0x00, ##  000000                000000        
            0xFC, 0x00, 0x03, 0xF8, 0x00, ##  000000                0000000       
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000       
            0xFC, 0x00, 0x01, 0xFC, 0x00, ##  000000                 0000000      
            0xFC, 0x00, 0x00, 0xFC, 0x00, ##  000000                  000000      
            0xFC, 0x00, 0x00, 0xFE, 0x00, ##  000000                  0000000     
            0xFC, 0x00, 0x00, 0x7E, 0x00, ##  000000                   000000     
            0xFC, 0x00, 0x00, 0x7F, 0x00, ##  000000                   0000000    
            0xFC, 0x00, 0x00, 0x3F, 0x00, ##  000000                    000000    
            0xFC, 0x00, 0x00, 0x3F, 0x80, ##  000000                    0000000   
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000   
            0xFC, 0x00, 0x00, 0x1F, 0xC0, ##  000000                     0000000  
            0xFC, 0x00, 0x00, 0x0F, 0xC0, ##  000000                      000000  
            0xFC, 0x00, 0x00, 0x0F, 0xE0, ##  000000                      0000000 
            0xFC, 0x00, 0x00, 0x07, 0xE0, ##  000000                       000000 
            0xFC, 0x00, 0x00, 0x07, 0xF0, ##  000000                       0000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFC, 0x00, ##             00000000000          
            0x00, 0xFF, 0xFF, 0xE0, ##          0000000000000000000     
            0x03, 0xFF, 0xFF, 0xF8, ##        00000000000000000000000   
            0x0F, 0xFF, 0xFF, 0xF8, ##      0000000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xF8, ##     00000000000000000000000000   
            0x3F, 0xF0, 0x07, 0xF8, ##    0000000000         00000000   
            0x3F, 0xC0, 0x00, 0x78, ##    00000000               0000   
            0x7F, 0x00, 0x00, 0x18, ##   0000000                   00   
            0x7E, 0x00, 0x00, 0x00, ##   000000                         
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFC, 0x00, 0x00, 0x00, ##  000000                          
            0xFE, 0x00, 0x00, 0x00, ##  0000000                         
            0xFF, 0x00, 0x00, 0x00, ##  00000000                        
            0x7F, 0x80, 0x00, 0x00, ##   00000000                       
            0x7F, 0xF0, 0x00, 0x00, ##   00000000000                    
            0x3F, 0xFF, 0x00, 0x00, ##    00000000000000                
            0x1F, 0xFF, 0xF8, 0x00, ##     000000000000000000           
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000        
            0x07, 0xFF, 0xFF, 0xC0, ##       000000000000000000000      
            0x01, 0xFF, 0xFF, 0xE0, ##         00000000000000000000     
            0x00, 0x7F, 0xFF, 0xF0, ##           0000000000000000000    
            0x00, 0x07, 0xFF, 0xF8, ##               0000000000000000   
            0x00, 0x00, 0x3F, 0xFC, ##                    000000000000  
            0x00, 0x00, 0x07, 0xFE, ##                       0000000000 
            0x00, 0x00, 0x01, 0xFE, ##                         00000000 
            0x00, 0x00, 0x00, 0xFE, ##                          0000000 
            0x00, 0x00, 0x00, 0x7F, ##                           0000000
            0x00, 0x00, 0x00, 0x7F, ##                           0000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x3F, ##                            000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000 
            0xC0, 0x00, 0x00, 0xFE, ##  00                      0000000 
            0xF0, 0x00, 0x01, 0xFE, ##  0000                   00000000 
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000  
            0xFF, 0xC0, 0x1F, 0xF8, ##  0000000000         0000000000   
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000      
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000        
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 39, 
        'xoffset'  => 0, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x0F, 0xE0, ##   000000                     0000000 
            0x7F, 0x00, 0x00, 0x0F, 0xC0, ##   0000000                    000000  
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x3F, 0xC0, 0x00, 0x3F, 0xC0, ##    00000000                00000000  
            0x1F, 0xE0, 0x00, 0x7F, 0x80, ##     00000000              00000000   
            0x0F, 0xFC, 0x03, 0xFF, 0x00, ##      0000000000        0000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0x00, ##         0000000000000000000000       
            0x00, 0x7F, 0xFF, 0xE0, 0x00, ##           000000000000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  000000                             0000000
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  0000000                            000000 
            0x7E, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   000000                           0000000 
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x3F, 0x80, 0x00, 0x00, 0x7F, 0x00, ##    0000000                        0000000  
            0x3F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##    0000000                        000000   
            0x1F, 0x80, 0x00, 0x00, 0xFE, 0x00, ##     000000                       0000000   
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##     0000000                      000000    
            0x0F, 0xC0, 0x00, 0x01, 0xFC, 0x00, ##      000000                     0000000    
            0x0F, 0xE0, 0x00, 0x01, 0xFC, 0x00, ##      0000000                    0000000    
            0x07, 0xE0, 0x00, 0x01, 0xF8, 0x00, ##       000000                    000000     
            0x07, 0xF0, 0x00, 0x03, 0xF8, 0x00, ##       0000000                  0000000     
            0x07, 0xF0, 0x00, 0x03, 0xF0, 0x00, ##       0000000                  000000      
            0x03, 0xF0, 0x00, 0x07, 0xF0, 0x00, ##        000000                 0000000      
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x01, 0xF8, 0x00, 0x0F, 0xE0, 0x00, ##         000000               0000000       
            0x01, 0xFC, 0x00, 0x0F, 0xE0, 0x00, ##         0000000              0000000       
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x00, 0xFC, 0x00, 0x1F, 0xC0, 0x00, ##          000000             0000000        
            0x00, 0xFE, 0x00, 0x1F, 0x80, 0x00, ##          0000000            000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0x7F, 0x00, 0x3F, 0x80, 0x00, ##           0000000          0000000         
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x7F, 0x00, 0x00, ##            000000         0000000          
            0x00, 0x3F, 0x80, 0x7E, 0x00, 0x00, ##            0000000        000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x1F, 0x80, 0xFE, 0x00, 0x00, ##             000000       0000000           
            0x00, 0x1F, 0xC0, 0xFC, 0x00, 0x00, ##             0000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xE1, 0xFC, 0x00, 0x00, ##              0000000    0000000            
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE3, 0xF8, 0x00, 0x00, ##               000000   0000000             
            0x00, 0x07, 0xF3, 0xF0, 0x00, 0x00, ##               0000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF7, 0xF0, 0x00, 0x00, ##                000000 0000000              
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 59, 
        'xoffset'  => 2, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x07, 0xE0, ##  0000000                   0000000                    000000
            0xFE, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x0F, 0xE0, ##  0000000                   00000000                  0000000
            0x7E, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x0F, 0xE0, ##   000000                  000000000                  0000000
            0x7E, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x0F, 0xC0, ##   000000                  000000000                  000000 
            0x7F, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x0F, 0xC0, ##   0000000                 000000000                  000000 
            0x7F, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x1F, 0xC0, ##   0000000                 0000000000                0000000 
            0x3F, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x1F, 0xC0, ##    000000                00000000000                0000000 
            0x3F, 0x00, 0x00, 0xFB, 0xE0, 0x00, 0x1F, 0x80, ##    000000                00000 00000                000000  
            0x3F, 0x80, 0x00, 0xFB, 0xE0, 0x00, 0x1F, 0x80, ##    0000000               00000 00000                000000  
            0x3F, 0x80, 0x00, 0xFB, 0xF0, 0x00, 0x3F, 0x80, ##    0000000               00000 000000              0000000  
            0x1F, 0x80, 0x01, 0xF9, 0xF0, 0x00, 0x3F, 0x80, ##     000000              000000  00000              0000000  
            0x1F, 0x80, 0x01, 0xF1, 0xF0, 0x00, 0x3F, 0x00, ##     000000              00000   00000              000000   
            0x1F, 0xC0, 0x01, 0xF1, 0xF0, 0x00, 0x3F, 0x00, ##     0000000             00000   00000              000000   
            0x1F, 0xC0, 0x01, 0xF1, 0xF8, 0x00, 0x7F, 0x00, ##     0000000             00000   000000            0000000   
            0x0F, 0xC0, 0x01, 0xF0, 0xF8, 0x00, 0x7F, 0x00, ##      000000             00000    00000            0000000   
            0x0F, 0xC0, 0x03, 0xE0, 0xF8, 0x00, 0x7E, 0x00, ##      000000            00000     00000            000000    
            0x0F, 0xE0, 0x03, 0xE0, 0xF8, 0x00, 0x7E, 0x00, ##      0000000           00000     00000            000000    
            0x0F, 0xE0, 0x03, 0xE0, 0xFC, 0x00, 0xFE, 0x00, ##      0000000           00000     000000          0000000    
            0x07, 0xE0, 0x03, 0xE0, 0x7C, 0x00, 0xFE, 0x00, ##       000000           00000      00000          0000000    
            0x07, 0xE0, 0x07, 0xC0, 0x7C, 0x00, 0xFC, 0x00, ##       000000          00000       00000          000000     
            0x07, 0xF0, 0x07, 0xC0, 0x7C, 0x00, 0xFC, 0x00, ##       0000000         00000       00000          000000     
            0x07, 0xF0, 0x07, 0xC0, 0x7C, 0x01, 0xFC, 0x00, ##       0000000         00000       00000         0000000     
            0x03, 0xF0, 0x07, 0xC0, 0x3E, 0x01, 0xFC, 0x00, ##        000000         00000        00000        0000000     
            0x03, 0xF0, 0x0F, 0x80, 0x3E, 0x01, 0xF8, 0x00, ##        000000        00000         00000        000000      
            0x03, 0xF8, 0x0F, 0x80, 0x3E, 0x01, 0xF8, 0x00, ##        0000000       00000         00000        000000      
            0x03, 0xF8, 0x0F, 0x80, 0x3E, 0x03, 0xF8, 0x00, ##        0000000       00000         00000       0000000      
            0x01, 0xF8, 0x0F, 0x80, 0x1F, 0x03, 0xF8, 0x00, ##         000000       00000          00000      0000000      
            0x01, 0xF8, 0x1F, 0x80, 0x1F, 0x03, 0xF0, 0x00, ##         000000      000000          00000      000000       
            0x01, 0xFC, 0x1F, 0x00, 0x1F, 0x03, 0xF0, 0x00, ##         0000000     00000           00000      000000       
            0x01, 0xFC, 0x1F, 0x00, 0x1F, 0x03, 0xF0, 0x00, ##         0000000     00000           00000      000000       
            0x00, 0xFC, 0x1F, 0x00, 0x0F, 0x87, 0xF0, 0x00, ##          000000     00000            00000    0000000       
            0x00, 0xFC, 0x3F, 0x00, 0x0F, 0x87, 0xE0, 0x00, ##          000000    000000            00000    000000        
            0x00, 0xFE, 0x3E, 0x00, 0x0F, 0x87, 0xE0, 0x00, ##          0000000   00000             00000    000000        
            0x00, 0xFE, 0x3E, 0x00, 0x0F, 0x87, 0xE0, 0x00, ##          0000000   00000             00000    000000        
            0x00, 0x7E, 0x3E, 0x00, 0x07, 0xCF, 0xE0, 0x00, ##           000000   00000              00000  0000000        
            0x00, 0x7E, 0x7E, 0x00, 0x07, 0xCF, 0xC0, 0x00, ##           000000  000000              00000  000000         
            0x00, 0x7F, 0x7C, 0x00, 0x07, 0xCF, 0xC0, 0x00, ##           0000000 00000               00000  000000         
            0x00, 0x7F, 0x7C, 0x00, 0x07, 0xCF, 0xC0, 0x00, ##           0000000 00000               00000  000000         
            0x00, 0x3F, 0x7C, 0x00, 0x07, 0xFF, 0xC0, 0x00, ##            000000 00000               0000000000000         
            0x00, 0x3F, 0xFC, 0x00, 0x03, 0xFF, 0x80, 0x00, ##            000000000000                00000000000          
            0x00, 0x3F, 0xF8, 0x00, 0x03, 0xFF, 0x80, 0x00, ##            00000000000                 00000000000          
            0x00, 0x3F, 0xF8, 0x00, 0x03, 0xFF, 0x80, 0x00, ##            00000000000                 00000000000          
            0x00, 0x1F, 0xF8, 0x00, 0x03, 0xFF, 0x80, 0x00, ##             0000000000                 00000000000          
            0x00, 0x1F, 0xF8, 0x00, 0x01, 0xFF, 0x00, 0x00, ##             0000000000                  000000000           
            0x00, 0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x00, 0x00, ##             000000000                   000000000           
            0x00, 0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x00, 0x00, ##             000000000                   000000000           
            0x00, 0x0F, 0xF0, 0x00, 0x01, 0xFF, 0x00, 0x00, ##              00000000                   000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 40, 
        'xoffset'  => 2, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0x80, 0x00, 0x00, 0xFE, ##    0000000                       0000000 
            0x1F, 0xC0, 0x00, 0x01, 0xFC, ##     0000000                     0000000  
            0x0F, 0xC0, 0x00, 0x03, 0xF8, ##      000000                    0000000   
            0x0F, 0xE0, 0x00, 0x03, 0xF8, ##      0000000                   0000000   
            0x07, 0xF0, 0x00, 0x07, 0xF0, ##       0000000                 0000000    
            0x03, 0xF0, 0x00, 0x0F, 0xE0, ##        000000                0000000     
            0x03, 0xF8, 0x00, 0x0F, 0xE0, ##        0000000               0000000     
            0x01, 0xFC, 0x00, 0x1F, 0xC0, ##         0000000             0000000      
            0x00, 0xFC, 0x00, 0x3F, 0x80, ##          000000            0000000       
            0x00, 0xFE, 0x00, 0x3F, 0x80, ##          0000000           0000000       
            0x00, 0x7F, 0x00, 0x7F, 0x00, ##           0000000         0000000        
            0x00, 0x3F, 0x00, 0xFE, 0x00, ##            000000        0000000         
            0x00, 0x3F, 0x80, 0xFE, 0x00, ##            0000000       0000000         
            0x00, 0x1F, 0xC1, 0xFC, 0x00, ##             0000000     0000000          
            0x00, 0x0F, 0xC3, 0xF8, 0x00, ##              000000    0000000           
            0x00, 0x0F, 0xE3, 0xF8, 0x00, ##              0000000   0000000           
            0x00, 0x07, 0xF7, 0xF0, 0x00, ##               0000000 0000000            
            0x00, 0x03, 0xFF, 0xE0, 0x00, ##                0000000000000             
            0x00, 0x03, 0xFF, 0xE0, 0x00, ##                0000000000000             
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000              
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000               
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000               
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000                
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000               
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000              
            0x00, 0x07, 0xFF, 0xC0, 0x00, ##               0000000000000              
            0x00, 0x07, 0xFF, 0xE0, 0x00, ##               00000000000000             
            0x00, 0x0F, 0xE7, 0xF0, 0x00, ##              0000000  0000000            
            0x00, 0x0F, 0xC3, 0xF0, 0x00, ##              000000    000000            
            0x00, 0x1F, 0xC3, 0xF8, 0x00, ##             0000000    0000000           
            0x00, 0x3F, 0x81, 0xFC, 0x00, ##            0000000      0000000          
            0x00, 0x3F, 0x00, 0xFC, 0x00, ##            000000        000000          
            0x00, 0x7F, 0x00, 0xFE, 0x00, ##           0000000        0000000         
            0x00, 0xFE, 0x00, 0x7F, 0x00, ##          0000000          0000000        
            0x00, 0xFC, 0x00, 0x3F, 0x00, ##          000000            000000        
            0x01, 0xFC, 0x00, 0x3F, 0x80, ##         0000000            0000000       
            0x03, 0xF8, 0x00, 0x1F, 0xC0, ##        0000000              0000000      
            0x03, 0xF0, 0x00, 0x1F, 0xC0, ##        000000               0000000      
            0x07, 0xF0, 0x00, 0x0F, 0xE0, ##       0000000                0000000     
            0x0F, 0xE0, 0x00, 0x07, 0xF0, ##      0000000                  0000000    
            0x0F, 0xC0, 0x00, 0x07, 0xF0, ##      000000                   0000000    
            0x1F, 0xC0, 0x00, 0x03, 0xF8, ##     0000000                    0000000   
            0x3F, 0x80, 0x00, 0x01, 0xFC, ##    0000000                      0000000  
            0x3F, 0x00, 0x00, 0x01, 0xFC, ##    000000                       0000000  
            0x7F, 0x00, 0x00, 0x00, 0xFE, ##   0000000                        0000000 
            0xFE, 0x00, 0x00, 0x00, 0x7F, ##  0000000                          0000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 39, 
        'xoffset'  => 0, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, 0x01, 0xFC, ##  0000000                        0000000 
            0x7E, 0x00, 0x00, 0x01, 0xFC, ##   000000                        0000000 
            0x7F, 0x00, 0x00, 0x03, 0xF8, ##   0000000                      0000000  
            0x3F, 0x80, 0x00, 0x07, 0xF0, ##    0000000                    0000000   
            0x1F, 0x80, 0x00, 0x07, 0xF0, ##     000000                    0000000   
            0x1F, 0xC0, 0x00, 0x0F, 0xE0, ##     0000000                  0000000    
            0x0F, 0xE0, 0x00, 0x1F, 0xC0, ##      0000000                0000000     
            0x07, 0xE0, 0x00, 0x1F, 0x80, ##       000000                000000      
            0x07, 0xF0, 0x00, 0x3F, 0x80, ##       0000000              0000000      
            0x03, 0xF8, 0x00, 0x7F, 0x00, ##        0000000            0000000       
            0x01, 0xF8, 0x00, 0x7E, 0x00, ##         000000            000000        
            0x01, 0xFC, 0x00, 0xFE, 0x00, ##         0000000          0000000        
            0x00, 0xFE, 0x00, 0xFC, 0x00, ##          0000000         000000         
            0x00, 0x7E, 0x01, 0xF8, 0x00, ##           000000        000000          
            0x00, 0x7F, 0x03, 0xF8, 0x00, ##           0000000      0000000          
            0x00, 0x3F, 0x83, 0xF0, 0x00, ##            0000000     000000           
            0x00, 0x1F, 0x87, 0xE0, 0x00, ##             000000    000000            
            0x00, 0x1F, 0xCF, 0xE0, 0x00, ##             0000000  0000000            
            0x00, 0x0F, 0xCF, 0xC0, 0x00, ##              000000  000000             
            0x00, 0x07, 0xFF, 0x80, 0x00, ##               000000000000              
            0x00, 0x07, 0xFF, 0x80, 0x00, ##               000000000000              
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000               
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 38, 
        'xoffset'  => 3, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x03, 0xF8, ##                                0000000 
            0x00, 0x00, 0x00, 0x07, 0xF0, ##                               0000000  
            0x00, 0x00, 0x00, 0x0F, 0xF0, ##                              00000000  
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000   
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000    
            0x00, 0x00, 0x00, 0x3F, 0x80, ##                            0000000     
            0x00, 0x00, 0x00, 0x7F, 0x00, ##                           0000000      
            0x00, 0x00, 0x00, 0xFF, 0x00, ##                          00000000      
            0x00, 0x00, 0x01, 0xFE, 0x00, ##                         00000000       
            0x00, 0x00, 0x03, 0xFC, 0x00, ##                        00000000        
            0x00, 0x00, 0x03, 0xF8, 0x00, ##                        0000000         
            0x00, 0x00, 0x07, 0xF8, 0x00, ##                       00000000         
            0x00, 0x00, 0x0F, 0xF0, 0x00, ##                      00000000          
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000           
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000            
            0x00, 0x00, 0x3F, 0x80, 0x00, ##                    0000000             
            0x00, 0x00, 0x7F, 0x80, 0x00, ##                   00000000             
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000              
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000               
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000                
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                  
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000                   
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                    
            0x00, 0x3F, 0x80, 0x00, 0x00, ##            0000000                     
            0x00, 0x7F, 0x80, 0x00, 0x00, ##           00000000                     
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                      
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x03, 0xFC, 0x00, 0x00, 0x00, ##        00000000                        
            0x03, 0xF8, 0x00, 0x00, 0x00, ##        0000000                         
            0x07, 0xF8, 0x00, 0x00, 0x00, ##       00000000                         
            0x0F, 0xF0, 0x00, 0x00, 0x00, ##      00000000                          
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                           
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                             
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                             
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 14, 
        'xoffset'  => 5, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFC, 0x00, ##  000000        
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0xFF, 0xFC, ##  00000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xF8, 0x00, 0x00, ##  00000                 
            0xFC, 0x00, 0x00, ##  000000                
            0x7C, 0x00, 0x00, ##   00000                
            0x7C, 0x00, 0x00, ##   00000                
            0x7E, 0x00, 0x00, ##   000000               
            0x3E, 0x00, 0x00, ##    00000               
            0x3E, 0x00, 0x00, ##    00000               
            0x3F, 0x00, 0x00, ##    000000              
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x00, 0x00, ##     00000              
            0x1F, 0x80, 0x00, ##     000000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0x80, 0x00, ##      00000             
            0x0F, 0xC0, 0x00, ##      000000            
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xC0, 0x00, ##       00000            
            0x07, 0xE0, 0x00, ##       000000           
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xE0, 0x00, ##        00000           
            0x03, 0xF0, 0x00, ##        000000          
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF0, 0x00, ##         00000          
            0x01, 0xF8, 0x00, ##         000000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xF8, 0x00, ##          00000         
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7C, 0x00, ##           00000        
            0x00, 0x7E, 0x00, ##           000000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3E, 0x00, ##            00000       
            0x00, 0x3F, 0x00, ##            000000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x00, ##             00000      
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x1F, 0x80, ##             000000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0x80, ##              00000     
            0x00, 0x0F, 0xC0, ##              000000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xC0, ##               00000    
            0x00, 0x07, 0xE0, ##               000000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xE0, ##                00000   
            0x00, 0x03, 0xF0, ##                000000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF0, ##                 00000  
            0x00, 0x01, 0xF8, ##                 000000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 13, 
        'xoffset'  => 7, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000               
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000              
            0x00, 0x07, 0xFF, 0xE0, 0x00, ##               00000000000000             
            0x00, 0x0F, 0xFF, 0xF0, 0x00, ##              0000000000000000            
            0x00, 0x1F, 0xE7, 0xF8, 0x00, ##             00000000  00000000           
            0x00, 0x3F, 0xC3, 0xFC, 0x00, ##            00000000    00000000          
            0x00, 0x7F, 0x81, 0xFE, 0x00, ##           00000000      00000000         
            0x00, 0xFF, 0x00, 0xFF, 0x00, ##          00000000        00000000        
            0x01, 0xFC, 0x00, 0x7F, 0x80, ##         0000000           00000000       
            0x03, 0xF8, 0x00, 0x3F, 0xC0, ##        0000000             00000000      
            0x07, 0xF0, 0x00, 0x1F, 0xE0, ##       0000000               00000000     
            0x0F, 0xE0, 0x00, 0x07, 0xE0, ##      0000000                  000000     
            0x1F, 0xC0, 0x00, 0x03, 0xF0, ##     0000000                    000000    
            0x3F, 0x80, 0x00, 0x01, 0xF8, ##    0000000                      000000   
            0x7F, 0x00, 0x00, 0x00, 0xFC, ##   0000000                        000000  
            0xFE, 0x00, 0x00, 0x00, 0x7E, ##  0000000                          000000 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 33, 
        'xoffset'  => -1, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 15, 
        'xoffset'  => 5, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000         
            0x7E, 0x00, ##   000000        
            0x3F, 0x00, ##    000000       
            0x1F, 0x80, ##     000000      
            0x0F, 0xC0, ##      000000     
            0x07, 0xC0, ##       00000     
            0x03, 0xE0, ##        00000    
            0x01, 0xF0, ##         00000   
            0x01, 0xF8, ##         000000  
            0x00, 0xF8, ##          00000  
            0x00, 0x7C, ##           00000 
            0x00, 0x3E, ##            00000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000          
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0xFC, 0x7F, 0xFF, 0x00, ##  000000   000000000000000       
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFF, 0xF0, 0x3F, 0xE0, ##  000000000000      000000000    
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x00, 0x01, 0xF8, ##  00000000               000000  
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFF, 0x00, 0x01, 0xFC, ##  00000000               0000000 
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0xF0, 0x1F, 0xE0, ##  000000000000       00000000    
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000      
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0x00, 0x07, 0xF8, 0x00, ##               00000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 28, 
        'xoffset'  => 4, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFC, 0x00, ##               000000000      
            0x00, 0x3F, 0xFF, 0xC0, ##            0000000000000000  
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x0F, 0xFC, 0x03, 0xF0, ##      0000000000        000000
            0x1F, 0xF0, 0x00, 0x70, ##     000000000             000
            0x1F, 0xC0, 0x00, 0x10, ##     0000000                 0
            0x3F, 0x80, 0x00, 0x00, ##    0000000                   
            0x3F, 0x00, 0x00, 0x00, ##    000000                    
            0x7F, 0x00, 0x00, 0x00, ##   0000000                    
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0xFE, 0x00, 0x00, 0x00, ##  0000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7F, 0x00, 0x00, 0x00, ##   0000000                    
            0x3F, 0x00, 0x00, 0x00, ##    000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                   
            0x1F, 0xC0, 0x00, 0x10, ##     0000000                 0
            0x1F, 0xE0, 0x00, 0x70, ##     00000000              000
            0x0F, 0xFC, 0x03, 0xF0, ##      0000000000        000000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0x7F, 0xFF, 0xC0, ##           00000000000000000  
            0x00, 0x07, 0xFC, 0x00, ##               000000000      
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 31, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x3F, 0xC0, 0x7E, ##            00000000       000000
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x0F, 0xF0, 0x3F, 0x7E, ##      00000000      000000 000000
            0x1F, 0xE0, 0x0F, 0xFE, ##     00000000         00000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x1F, 0xE0, 0x0F, 0xFE, ##     00000000         00000000000
            0x0F, 0xF0, 0x1F, 0xFE, ##      00000000       000000000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x00, 0x3F, 0xC0, 0x00, ##            00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000        
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000    
            0x0F, 0xFC, 0x07, 0xF8, 0x00, ##      0000000000       00000000    
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000   
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000  
            0x3F, 0x80, 0x00, 0x7E, 0x00, ##    0000000                000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000 
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                         
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                        
            0x1F, 0xC0, 0x00, 0x03, 0x00, ##     0000000                    00 
            0x0F, 0xE0, 0x00, 0x0F, 0x00, ##      0000000                 0000 
            0x0F, 0xFC, 0x00, 0xFF, 0x00, ##      0000000000          00000000 
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xF0, 0x00, ##            000000000000000000     
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xFE, ##              00000000000
            0x00, 0x3F, 0xFE, ##            0000000000000
            0x00, 0xFF, 0xFE, ##          000000000000000
            0x01, 0xFF, 0xFE, ##         0000000000000000
            0x03, 0xFF, 0xFE, ##        00000000000000000
            0x03, 0xFC, 0x00, ##        00000000         
            0x03, 0xF0, 0x00, ##        000000           
            0x07, 0xF0, 0x00, ##       0000000           
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0xFF, 0xFF, 0xF8, ##  000000000000000000000  
            0xFF, 0xFF, 0xF8, ##  000000000000000000000  
            0xFF, 0xFF, 0xF8, ##  000000000000000000000  
            0xFF, 0xFF, 0xF8, ##  000000000000000000000  
            0xFF, 0xFF, 0xF8, ##  000000000000000000000  
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x07, 0xE0, 0x00, ##       000000            
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 31, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xC0, 0x00, ##            00000000             
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x1F, 0xF0, 0x1F, 0xFE, ##     000000000       000000000000
            0x1F, 0xC0, 0x07, 0xFE, ##     0000000           0000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x3F, 0x00, 0x01, 0xFE, ##    000000               00000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x3F, 0x00, 0x01, 0xFE, ##    000000               00000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x1F, 0xC0, 0x07, 0xFE, ##     0000000           0000000000
            0x1F, 0xF0, 0x1F, 0xFE, ##     000000000       000000000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x00, 0x3F, 0xC0, 0x7E, ##            00000000       000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x01, 0xFC, ##                         0000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000  
            0x0C, 0x00, 0x07, 0xF8, ##      00               00000000  
            0x0F, 0xC0, 0x3F, 0xF0, ##      000000        0000000000   
            0x0F, 0xFF, 0xFF, 0xE0, ##      00000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xC0, ##      0000000000000000000000     
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000      
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000        
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 29, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x00, 0x00, 0x00, ##  000000                       
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000        
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000      
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000   
            0xFD, 0xFF, 0xFF, 0xC0, ##  000000 0000000000000000000   
            0xFD, 0xF0, 0x3F, 0xE0, ##  000000 00000      000000000  
            0xFF, 0xC0, 0x0F, 0xF0, ##  0000000000          00000000 
            0xFF, 0x80, 0x07, 0xF0, ##  000000000            0000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFE, 0x00, 0x03, 0xF8, ##  0000000               0000000
            0xFE, 0x00, 0x01, 0xF8, ##  0000000                000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 13, 
        'xoffset'  => -1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x01, 0xF8, ##         000000
            0x03, 0xF0, ##        000000 
            0x03, 0xF0, ##        000000 
            0x0F, 0xF0, ##      00000000 
            0xFF, 0xE0, ##  00000000000  
            0xFF, 0xE0, ##  00000000000  
            0xFF, 0xC0, ##  0000000000   
            0xFF, 0x80, ##  000000000    
            0xFC, 0x00, ##  000000       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000 
            0xFC, 0x00, 0x07, 0xF8, ##  000000               00000000  
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000   
            0xFC, 0x00, 0x1F, 0xE0, ##  000000             00000000    
            0xFC, 0x00, 0x3F, 0x80, ##  000000            0000000      
            0xFC, 0x00, 0x7F, 0x00, ##  000000           0000000       
            0xFC, 0x00, 0xFE, 0x00, ##  000000          0000000        
            0xFC, 0x01, 0xFC, 0x00, ##  000000         0000000         
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000          
            0xFC, 0x0F, 0xF0, 0x00, ##  000000      00000000           
            0xFC, 0x1F, 0xE0, 0x00, ##  000000     00000000            
            0xFC, 0x3F, 0x80, 0x00, ##  000000    0000000              
            0xFC, 0x7F, 0x00, 0x00, ##  000000   0000000               
            0xFC, 0xFE, 0x00, 0x00, ##  000000  0000000                
            0xFD, 0xFC, 0x00, 0x00, ##  000000 0000000                 
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000                  
            0xFF, 0xF0, 0x00, 0x00, ##  000000000000                   
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000                  
            0xFD, 0xFC, 0x00, 0x00, ##  000000 0000000                 
            0xFC, 0xFE, 0x00, 0x00, ##  000000  0000000                
            0xFC, 0x7F, 0x00, 0x00, ##  000000   0000000               
            0xFC, 0x3F, 0x80, 0x00, ##  000000    0000000              
            0xFC, 0x1F, 0xC0, 0x00, ##  000000     0000000             
            0xFC, 0x0F, 0xE0, 0x00, ##  000000      0000000            
            0xFC, 0x07, 0xF0, 0x00, ##  000000       0000000           
            0xFC, 0x03, 0xF8, 0x00, ##  000000        0000000          
            0xFC, 0x01, 0xFC, 0x00, ##  000000         0000000         
            0xFC, 0x00, 0xFE, 0x00, ##  000000          0000000        
            0xFC, 0x00, 0x7F, 0x80, ##  000000           00000000      
            0xFC, 0x00, 0x3F, 0xC0, ##  000000            00000000     
            0xFC, 0x00, 0x1F, 0xE0, ##  000000             00000000    
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000   
            0xFC, 0x00, 0x07, 0xF8, ##  000000               00000000  
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000 
            0xFC, 0x00, 0x01, 0xFE, ##  000000                 00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 6, 
        'xoffset'  => 6, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 52, 
        'xoffset'  => 6, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF8, 0x00, 0x0F, 0xF0, 0x00, ##               00000000               00000000        
            0xFC, 0x1F, 0xFE, 0x00, 0x3F, 0xFC, 0x00, ##  000000     000000000000           000000000000      
            0xFC, 0x7F, 0xFF, 0x80, 0xFF, 0xFF, 0x00, ##  000000   0000000000000000       0000000000000000    
            0xFC, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0x80, ##  000000  000000000000000000     000000000000000000   
            0xFD, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0x80, ##  000000 0000000000000000000    0000000000000000000   
            0xFF, 0xF0, 0x1F, 0xE7, 0xE0, 0x3F, 0xC0, ##  000000000000       00000000  000000       00000000  
            0xFF, 0xC0, 0x0F, 0xF7, 0x80, 0x1F, 0xE0, ##  0000000000          00000000 0000          00000000 
            0xFF, 0x80, 0x07, 0xFF, 0x00, 0x0F, 0xE0, ##  000000000            00000000000            0000000 
            0xFF, 0x00, 0x03, 0xFE, 0x00, 0x07, 0xE0, ##  00000000              000000000              000000 
            0xFF, 0x00, 0x03, 0xFE, 0x00, 0x07, 0xE0, ##  00000000              000000000              000000 
            0xFE, 0x00, 0x01, 0xFC, 0x00, 0x03, 0xF0, ##  0000000                0000000                000000
            0xFE, 0x00, 0x01, 0xFC, 0x00, 0x03, 0xF0, ##  0000000                0000000                000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, ##  000000                 000000                 000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 29, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF8, 0x00, ##               00000000        
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000      
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000   
            0xFD, 0xFF, 0xFF, 0xC0, ##  000000 0000000000000000000   
            0xFD, 0xF0, 0x3F, 0xE0, ##  000000 00000      000000000  
            0xFF, 0xC0, 0x0F, 0xF0, ##  0000000000          00000000 
            0xFF, 0x80, 0x07, 0xF0, ##  000000000            0000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFE, 0x00, 0x03, 0xF8, ##  0000000               0000000
            0xFE, 0x00, 0x01, 0xF8, ##  0000000                000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF8, 0x00, ##               00000000          
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0xFC, 0x7F, 0xFF, 0x00, ##  000000   000000000000000       
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFF, 0xF0, 0x3F, 0xE0, ##  000000000000      000000000    
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x00, 0x01, 0xF8, ##  00000000               000000  
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFF, 0x00, 0x01, 0xFC, ##  00000000               0000000 
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0xF0, 0x1F, 0xE0, ##  000000000000       00000000    
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000      
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000          
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 31, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xC0, 0x00, ##            00000000             
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x0F, 0xF0, 0x3F, 0x7E, ##      00000000      000000 000000
            0x1F, 0xE0, 0x0F, 0xFE, ##     00000000         00000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000
            0x7F, 0x00, 0x01, 0xFE, ##   0000000               00000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x3F, 0x80, 0x03, 0xFE, ##    0000000             000000000
            0x1F, 0xE0, 0x0F, 0xFE, ##     00000000         00000000000
            0x0F, 0xF0, 0x1F, 0xFE, ##      00000000       000000000000
            0x0F, 0xFF, 0xFF, 0x7E, ##      00000000000000000000 000000
            0x07, 0xFF, 0xFE, 0x7E, ##       000000000000000000  000000
            0x03, 0xFF, 0xFC, 0x7E, ##        0000000000000000   000000
            0x00, 0xFF, 0xF0, 0x7E, ##          000000000000     000000
            0x00, 0x3F, 0xC0, 0x7E, ##            00000000       000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x7E, ##                           000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 21, 
        'xoffset'  => 6, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF8, ##               00000000
            0xFC, 0x1F, 0xF8, ##  000000     0000000000
            0xFC, 0x7F, 0xF8, ##  000000   000000000000
            0xFC, 0xFF, 0xF8, ##  000000  0000000000000
            0xFD, 0xFF, 0xF8, ##  000000 00000000000000
            0xFF, 0xF8, 0x18, ##  0000000000000      00
            0xFF, 0xC0, 0x00, ##  0000000000           
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x00, 0x00, ##  00000000             
            0xFF, 0x00, 0x00, ##  00000000             
            0xFE, 0x00, 0x00, ##  0000000              
            0xFE, 0x00, 0x00, ##  0000000              
            0xFE, 0x00, 0x00, ##  0000000              
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0xFC, 0x00, 0x00, ##  000000               
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 27, 
        'xoffset'  => 3, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000       
            0x03, 0xFF, 0xFF, 0x00, ##        000000000000000000   
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000  
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000  
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000  
            0x7F, 0xC0, 0x1F, 0x80, ##   000000000         000000  
            0x7F, 0x00, 0x01, 0x80, ##   0000000               00  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                     
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFF, 0x00, 0x00, 0x00, ##  00000000                   
            0x7F, 0xC0, 0x00, 0x00, ##   000000000                 
            0x7F, 0xF8, 0x00, 0x00, ##   000000000000              
            0x3F, 0xFF, 0xC0, 0x00, ##    0000000000000000         
            0x1F, 0xFF, 0xF8, 0x00, ##     000000000000000000      
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000    
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000   
            0x00, 0x0F, 0xFF, 0x80, ##              0000000000000  
            0x00, 0x00, 0xFF, 0xC0, ##                  0000000000 
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0x00, 0x00, 0x07, 0xE0, ##                       000000
            0xC0, 0x00, 0x0F, 0xE0, ##  00                  0000000
            0xF0, 0x00, 0x1F, 0xC0, ##  0000               0000000 
            0xFF, 0x00, 0x7F, 0xC0, ##  00000000         000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0x00, ##  000000000000000000000000   
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000    
            0x3F, 0xFF, 0xF8, 0x00, ##    0000000000000000000      
            0x01, 0xFF, 0xC0, 0x00, ##         00000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xC0, 0x00, ##      000000            
            0x0F, 0xE0, 0x00, ##      0000000           
            0x07, 0xF0, 0x00, ##       0000000          
            0x07, 0xFF, 0xFC, ##       00000000000000000
            0x03, 0xFF, 0xFC, ##        0000000000000000
            0x01, 0xFF, 0xFC, ##         000000000000000
            0x00, 0xFF, 0xFC, ##          00000000000000
            0x00, 0x1F, 0xFC, ##             00000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFE, 0x00, 0x07, 0xF8, ##  0000000              00000000
            0x7E, 0x00, 0x07, 0xF8, ##   000000              00000000
            0x7F, 0x00, 0x0F, 0xF8, ##   0000000            000000000
            0x7F, 0x80, 0x1F, 0xF8, ##   00000000          0000000000
            0x3F, 0xE0, 0x7D, 0xF8, ##    000000000      00000 000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x03, 0xFF, 0xC1, 0xF8, ##        000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x0F, 0xC0, ##  000000                      000000
            0xFE, 0x00, 0x00, 0x1F, 0x80, ##  0000000                    000000 
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000  
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x1F, 0xC0, 0x00, 0xFC, 0x00, ##     0000000              000000    
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x07, 0xE0, 0x03, 0xF8, 0x00, ##       000000           0000000     
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF8, 0x07, 0xE0, 0x00, ##        0000000        000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x1F, 0xC0, 0x00, ##          000000     0000000        
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x7E, 0x3F, 0x00, 0x00, ##           000000   000000          
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 47, 
        'xoffset'  => 3, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x0F, 0xE0, 0x00, 0x7E, ##  000000              0000000              000000
            0xFC, 0x00, 0x1F, 0xE0, 0x00, 0x7C, ##  000000             00000000              00000 
            0xFC, 0x00, 0x1F, 0xE0, 0x00, 0xFC, ##  000000             00000000             000000 
            0x7C, 0x00, 0x1F, 0xE0, 0x00, 0xFC, ##   00000             00000000             000000 
            0x7E, 0x00, 0x1F, 0xF0, 0x00, 0xFC, ##   000000            000000000            000000 
            0x7E, 0x00, 0x3F, 0xF0, 0x01, 0xF8, ##   000000           0000000000           000000  
            0x7E, 0x00, 0x3F, 0xF0, 0x01, 0xF8, ##   000000           0000000000           000000  
            0x3E, 0x00, 0x3E, 0xF8, 0x01, 0xF8, ##    00000           00000 00000          000000  
            0x3F, 0x00, 0x3E, 0xF8, 0x01, 0xF0, ##    000000          00000 00000          00000   
            0x3F, 0x00, 0x7C, 0xF8, 0x03, 0xF0, ##    000000         00000  00000         000000   
            0x3F, 0x00, 0x7C, 0xF8, 0x03, 0xF0, ##    000000         00000  00000         000000   
            0x1F, 0x00, 0x7C, 0x7C, 0x03, 0xF0, ##     00000         00000   00000        000000   
            0x1F, 0x80, 0xFC, 0x7C, 0x03, 0xE0, ##     000000       000000   00000        00000    
            0x1F, 0x80, 0xF8, 0x7C, 0x07, 0xE0, ##     000000       00000    00000       000000    
            0x1F, 0x80, 0xF8, 0x7C, 0x07, 0xE0, ##     000000       00000    00000       000000    
            0x0F, 0xC0, 0xF8, 0x3E, 0x07, 0xE0, ##      000000      00000     00000      000000    
            0x0F, 0xC1, 0xF8, 0x3E, 0x07, 0xC0, ##      000000     000000     00000      00000     
            0x0F, 0xC1, 0xF0, 0x3E, 0x0F, 0xC0, ##      000000     00000      00000     000000     
            0x07, 0xC1, 0xF0, 0x3E, 0x0F, 0xC0, ##       00000     00000      00000     000000     
            0x07, 0xE1, 0xF0, 0x1F, 0x0F, 0xC0, ##       000000    00000       00000    000000     
            0x07, 0xE3, 0xE0, 0x1F, 0x0F, 0x80, ##       000000   00000        00000    00000      
            0x07, 0xE3, 0xE0, 0x1F, 0x1F, 0x80, ##       000000   00000        00000   000000      
            0x03, 0xE3, 0xE0, 0x1F, 0x1F, 0x80, ##        00000   00000        00000   000000      
            0x03, 0xF3, 0xE0, 0x0F, 0x9F, 0x80, ##        000000  00000         00000  000000      
            0x03, 0xF7, 0xC0, 0x0F, 0xBF, 0x00, ##        000000 00000          00000 000000       
            0x03, 0xF7, 0xC0, 0x0F, 0xBF, 0x00, ##        000000 00000          00000 000000       
            0x01, 0xF7, 0xC0, 0x0F, 0xFF, 0x00, ##         00000 00000          000000000000       
            0x01, 0xFF, 0xC0, 0x07, 0xFE, 0x00, ##         00000000000           0000000000        
            0x01, 0xFF, 0x80, 0x07, 0xFE, 0x00, ##         0000000000            0000000000        
            0x01, 0xFF, 0x80, 0x07, 0xFE, 0x00, ##         0000000000            0000000000        
            0x00, 0xFF, 0x80, 0x03, 0xFE, 0x00, ##          000000000             000000000        
            0x00, 0xFF, 0x80, 0x03, 0xFC, 0x00, ##          000000000             00000000         
            0x00, 0xFF, 0x00, 0x03, 0xFC, 0x00, ##          00000000              00000000         
            0x00, 0xFF, 0x00, 0x03, 0xFC, 0x00, ##          00000000              00000000         
            0x00, 0x7F, 0x00, 0x01, 0xFC, 0x00, ##           0000000               0000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0x00, 0x00, 0x3F, 0x80, ##   0000000                  0000000 
            0x3F, 0x80, 0x00, 0x7F, 0x00, ##    0000000                0000000  
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000   
            0x0F, 0xC0, 0x00, 0xFE, 0x00, ##      000000              0000000   
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000    
            0x07, 0xF0, 0x03, 0xF8, 0x00, ##       0000000          0000000     
            0x03, 0xF8, 0x07, 0xF0, 0x00, ##        0000000        0000000      
            0x01, 0xF8, 0x07, 0xF0, 0x00, ##         000000        0000000      
            0x01, 0xFC, 0x0F, 0xE0, 0x00, ##         0000000      0000000       
            0x00, 0xFE, 0x1F, 0xC0, 0x00, ##          0000000    0000000        
            0x00, 0x7F, 0x1F, 0x80, 0x00, ##           0000000   000000         
            0x00, 0x3F, 0x3F, 0x80, 0x00, ##            000000  0000000         
            0x00, 0x3F, 0xFF, 0x00, 0x00, ##            00000000000000          
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x1F, 0xFC, 0x00, 0x00, ##             00000000000            
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x3F, 0xFF, 0x00, 0x00, ##            00000000000000          
            0x00, 0x7F, 0x3F, 0x80, 0x00, ##           0000000  0000000         
            0x00, 0xFE, 0x3F, 0x80, 0x00, ##          0000000   0000000         
            0x00, 0xFC, 0x1F, 0xC0, 0x00, ##          000000     0000000        
            0x01, 0xFC, 0x0F, 0xE0, 0x00, ##         0000000      0000000       
            0x03, 0xF8, 0x07, 0xE0, 0x00, ##        0000000        000000       
            0x07, 0xF0, 0x07, 0xF0, 0x00, ##       0000000         0000000      
            0x07, 0xE0, 0x03, 0xF8, 0x00, ##       000000           0000000     
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000    
            0x1F, 0xC0, 0x00, 0xFC, 0x00, ##     0000000              000000    
            0x3F, 0x80, 0x00, 0xFE, 0x00, ##    0000000               0000000   
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000  
            0x7F, 0x00, 0x00, 0x3F, 0x80, ##   0000000                  0000000 
            0xFE, 0x00, 0x00, 0x1F, 0x80, ##  0000000                    000000 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x0F, 0xC0, ##  000000                      000000
            0xFC, 0x00, 0x00, 0x1F, 0xC0, ##  000000                     0000000
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7F, 0x00, 0x00, 0x3F, 0x00, ##   0000000                  000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000  
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x01, 0xFC, 0x00, ##      000000             0000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x07, 0xF0, 0x00, ##        000000         0000000      
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x1F, 0xC0, 0x00, ##          000000     0000000        
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x1F, 0x7F, 0x00, 0x00, ##             00000 0000000          
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000              
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x1F, 0x80, 0x00, 0x00, ##             000000                 
            0x00, 0x3F, 0x80, 0x00, 0x00, ##            0000000                 
            0x00, 0x7F, 0x00, 0x00, 0x00, ##           0000000                  
            0x1F, 0xFF, 0x00, 0x00, 0x00, ##     0000000000000                  
            0x1F, 0xFE, 0x00, 0x00, 0x00, ##     000000000000                   
            0x1F, 0xFC, 0x00, 0x00, 0x00, ##     00000000000                    
            0x1F, 0xF8, 0x00, 0x00, 0x00, ##     0000000000                     
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 28, 
        'xoffset'  => 3, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000
            0x00, 0x00, 0x07, 0xF0, ##                       0000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000 
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000  
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000  
            0x00, 0x00, 0x3F, 0x80, ##                    0000000   
            0x00, 0x00, 0x7F, 0x00, ##                   0000000    
            0x00, 0x00, 0xFE, 0x00, ##                  0000000     
            0x00, 0x01, 0xFC, 0x00, ##                 0000000      
            0x00, 0x03, 0xF8, 0x00, ##                0000000       
            0x00, 0x07, 0xF0, 0x00, ##               0000000        
            0x00, 0x0F, 0xE0, 0x00, ##              0000000         
            0x00, 0x1F, 0xC0, 0x00, ##             0000000          
            0x00, 0x1F, 0xC0, 0x00, ##             0000000          
            0x00, 0x3F, 0x80, 0x00, ##            0000000           
            0x00, 0x7F, 0x00, 0x00, ##           0000000            
            0x00, 0xFE, 0x00, 0x00, ##          0000000             
            0x01, 0xFC, 0x00, 0x00, ##         0000000              
            0x03, 0xF8, 0x00, 0x00, ##        0000000               
            0x07, 0xF0, 0x00, 0x00, ##       0000000                
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                 
            0x1F, 0xE0, 0x00, 0x00, ##     00000000                 
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                  
            0x3F, 0x80, 0x00, 0x00, ##    0000000                   
            0x7F, 0x00, 0x00, 0x00, ##   0000000                    
            0xFE, 0x00, 0x00, 0x00, ##  0000000                     
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 24, 
        'xoffset'  => 8, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, ##                  00000000
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x3F, 0xFF, ##            00000000000000
            0x00, 0x3F, 0xC0, ##            00000000      
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFE, 0x00, ##          0000000         
            0x00, 0xFC, 0x00, ##          000000          
            0x01, 0xFC, 0x00, ##         0000000          
            0x07, 0xFC, 0x00, ##       000000000          
            0xFF, 0xF8, 0x00, ##  0000000000000           
            0xFF, 0xE0, 0x00, ##  00000000000             
            0xFF, 0x80, 0x00, ##  000000000               
            0xFF, 0xE0, 0x00, ##  00000000000             
            0xFF, 0xF8, 0x00, ##  0000000000000           
            0x07, 0xFC, 0x00, ##       000000000          
            0x01, 0xFC, 0x00, ##         0000000          
            0x00, 0xFC, 0x00, ##          000000          
            0x00, 0xFE, 0x00, ##          0000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x3F, 0xC0, ##            00000000      
            0x00, 0x3F, 0xFF, ##            00000000000000
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x1F, 0xFF, ##             0000000000000
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x00, 0xFF, ##                  00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 6, 
        'xoffset'  => 8, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 25, 
        'xoffset'  => 8, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, ##  00000000                 
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0xFF, 0xF0, 0x00, 0x00, ##  000000000000             
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xFC, 0x00, 0x00, ##  00000000000000           
            0x03, 0xFC, 0x00, 0x00, ##        00000000           
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x00, 0xFE, 0x00, 0x00, ##          0000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7F, 0x00, 0x00, ##           0000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x80, 0x00, ##            0000000        
            0x00, 0x3F, 0xE0, 0x00, ##            000000000      
            0x00, 0x1F, 0xFF, 0x80, ##             00000000000000
            0x00, 0x07, 0xFF, 0x80, ##               000000000000
            0x00, 0x01, 0xFF, 0x80, ##                 0000000000
            0x00, 0x07, 0xFF, 0x80, ##               000000000000
            0x00, 0x1F, 0xFF, 0x80, ##             00000000000000
            0x00, 0x3F, 0xE0, 0x00, ##            000000000      
            0x00, 0x3F, 0x80, 0x00, ##            0000000        
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x7F, 0x00, 0x00, ##           0000000         
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000          
            0x00, 0xFE, 0x00, 0x00, ##          0000000          
            0x00, 0xFE, 0x00, 0x00, ##          0000000          
            0x03, 0xFC, 0x00, 0x00, ##        00000000           
            0xFF, 0xFC, 0x00, 0x00, ##  00000000000000           
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0xFF, 0x00, 0x00, 0x00, ##  00000000                 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0xFF, 0x00, 0x00, 0x03, ##          00000000                      00
            0x07, 0xFF, 0xE0, 0x00, 0x07, ##       00000000000000                  000
            0x1F, 0xFF, 0xFC, 0x00, 0x1F, ##     0000000000000000000             00000
            0x7F, 0xFF, 0xFF, 0x80, 0xFF, ##   000000000000000000000000       00000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0x01, 0xFF, 0xFF, 0xFE, ##  00000000       000000000000000000000000 
            0xF8, 0x00, 0x3F, 0xFF, 0xF8, ##  00000             0000000000000000000   
            0xE0, 0x00, 0x07, 0xFF, 0xE0, ##  000                  00000000000000     
            0xC0, 0x00, 0x00, 0xFF, 0x00, ##  00                      00000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 6, 
        'xoffset'  => 10, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 28, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x07, 0xFE, 0x00, ##               0000000000     
            0x00, 0x3F, 0xFF, 0xC0, ##            0000000000000000  
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x0F, 0xFC, 0xE1, 0xF0, ##      0000000000  000    00000
            0x1F, 0xF0, 0xE0, 0x70, ##     000000000    000      000
            0x1F, 0xC0, 0xE0, 0x10, ##     0000000      000        0
            0x3F, 0x80, 0xE0, 0x00, ##    0000000       000         
            0x3F, 0x00, 0xE0, 0x00, ##    000000        000         
            0x7F, 0x00, 0xE0, 0x00, ##   0000000        000         
            0x7E, 0x00, 0xE0, 0x00, ##   000000         000         
            0x7E, 0x00, 0xE0, 0x00, ##   000000         000         
            0xFE, 0x00, 0xE0, 0x00, ##  0000000         000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFC, 0x00, 0xE0, 0x00, ##  000000          000         
            0xFE, 0x00, 0xE0, 0x00, ##  0000000         000         
            0x7E, 0x00, 0xE0, 0x00, ##   000000         000         
            0x7E, 0x00, 0xE0, 0x00, ##   000000         000         
            0x7F, 0x00, 0xE0, 0x00, ##   0000000        000         
            0x3F, 0x00, 0xE0, 0x00, ##    000000        000         
            0x3F, 0x80, 0xE0, 0x00, ##    0000000       000         
            0x1F, 0xC0, 0xE0, 0x10, ##     0000000      000        0
            0x1F, 0xE0, 0xE0, 0x70, ##     00000000     000      000
            0x0F, 0xFC, 0xE1, 0xF0, ##      0000000000  000    00000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0x3F, 0xFF, 0xC0, ##            0000000000000000  
            0x00, 0x07, 0xFE, 0x00, ##               0000000000     
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 31, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xC0, ##                   000000000     
            0x00, 0x03, 0xFF, 0xF8, ##                000000000000000  
            0x00, 0x07, 0xFF, 0xFC, ##               00000000000000000 
            0x00, 0x1F, 0xFF, 0xFC, ##             0000000000000000000 
            0x00, 0x1F, 0xFF, 0xFC, ##             0000000000000000000 
            0x00, 0x3F, 0xE0, 0x7C, ##            000000000      00000 
            0x00, 0x3F, 0x80, 0x0C, ##            0000000           00 
            0x00, 0x7F, 0x00, 0x00, ##           0000000               
            0x00, 0x7E, 0x00, 0x00, ##           000000                
            0x00, 0x7E, 0x00, 0x00, ##           000000                
            0x00, 0xFE, 0x00, 0x00, ##          0000000                
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000     
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                 
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFE, ##  0000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 35, 
        'xoffset'  => 3, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x10, 0x00, 0x00, 0x01, 0x00, ##     0                           0   
            0x38, 0x00, 0x00, 0x03, 0x80, ##    000                         000  
            0x7C, 0x00, 0x00, 0x07, 0xC0, ##   00000                       00000 
            0xFE, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                     0000000
            0x7F, 0x03, 0xF8, 0x1F, 0xC0, ##   0000000      0000000      0000000 
            0x3F, 0x8F, 0xFF, 0x3F, 0x80, ##    0000000   000000000000  0000000  
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, ##     00000000000000000000000000000   
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##      000000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFC, 0x00, ##       0000000000000000000000000     
            0x03, 0xFE, 0x0F, 0xF8, 0x00, ##        000000000     000000000      
            0x03, 0xF8, 0x03, 0xF8, 0x00, ##        0000000         0000000      
            0x03, 0xE0, 0x00, 0xFC, 0x00, ##        00000             000000     
            0x07, 0xE0, 0x00, 0xFC, 0x00, ##       000000             000000     
            0x07, 0xC0, 0x00, 0x7C, 0x00, ##       00000               00000     
            0x0F, 0x80, 0x00, 0x7E, 0x00, ##      00000                000000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x3E, 0x00, ##      00000                 00000    
            0x0F, 0x80, 0x00, 0x7E, 0x00, ##      00000                000000    
            0x07, 0xC0, 0x00, 0x7C, 0x00, ##       00000               00000     
            0x07, 0xE0, 0x00, 0xFC, 0x00, ##       000000             000000     
            0x07, 0xE0, 0x00, 0xF8, 0x00, ##       000000             00000      
            0x03, 0xF8, 0x03, 0xF8, 0x00, ##        0000000         0000000      
            0x03, 0xFE, 0x0F, 0xF8, 0x00, ##        000000000     000000000      
            0x07, 0xFF, 0xFF, 0xFC, 0x00, ##       0000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##      000000000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, ##     00000000000000000000000000000   
            0x3F, 0x9F, 0xFE, 0x3F, 0x80, ##    0000000  000000000000   0000000  
            0x7F, 0x03, 0xF8, 0x1F, 0xC0, ##   0000000      0000000      0000000 
            0xFE, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                     0000000
            0x7C, 0x00, 0x00, 0x07, 0xC0, ##   00000                       00000 
            0x38, 0x00, 0x00, 0x03, 0x80, ##    000                         000  
            0x10, 0x00, 0x00, 0x01, 0x00, ##     0                           0   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x3F, 0x00, 0x00, 0x0F, 0xC0, ##    000000                    000000  
            0x3F, 0x00, 0x00, 0x0F, 0xC0, ##    000000                    000000  
            0x1F, 0x80, 0x00, 0x1F, 0x80, ##     000000                  000000   
            0x0F, 0x80, 0x00, 0x1F, 0x00, ##      00000                  00000    
            0x0F, 0xC0, 0x00, 0x3F, 0x00, ##      000000                000000    
            0x07, 0xC0, 0x00, 0x7E, 0x00, ##       00000               000000     
            0x07, 0xE0, 0x00, 0x7E, 0x00, ##       000000              000000     
            0x03, 0xF0, 0x00, 0xFC, 0x00, ##        000000            000000      
            0x03, 0xF0, 0x00, 0xFC, 0x00, ##        000000            000000      
            0x01, 0xF8, 0x01, 0xF8, 0x00, ##         000000          000000       
            0x01, 0xF8, 0x01, 0xF8, 0x00, ##         000000          000000       
            0x00, 0xFC, 0x03, 0xF0, 0x00, ##          000000        000000        
            0x00, 0xFC, 0x03, 0xF0, 0x00, ##          000000        000000        
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x3F, 0x0F, 0xC0, 0x00, ##            000000    000000          
            0x3F, 0xFF, 0x0F, 0xFF, 0xC0, ##    00000000000000    00000000000000  
            0x3F, 0xFF, 0x9F, 0xFF, 0xC0, ##    000000000000000  000000000000000  
            0x3F, 0xFF, 0x9F, 0xFF, 0xC0, ##    000000000000000  000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000  
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000  
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 6, 
        'xoffset'  => 8, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0x00, ##        
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 26, 
        'xoffset'  => 3, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xC0, 0x00, ##           000000000        
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000    
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000   
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000   
            0x1F, 0xFF, 0xFE, 0x00, ##     00000000000000000000   
            0x1F, 0xE0, 0x3E, 0x00, ##     00000000       00000   
            0x3F, 0x80, 0x06, 0x00, ##    0000000            00   
            0x3F, 0x80, 0x00, 0x00, ##    0000000                 
            0x3F, 0x00, 0x00, 0x00, ##    000000                  
            0x3F, 0x00, 0x00, 0x00, ##    000000                  
            0x3F, 0x00, 0x00, 0x00, ##    000000                  
            0x3F, 0x80, 0x00, 0x00, ##    0000000                 
            0x1F, 0x80, 0x00, 0x00, ##     000000                 
            0x1F, 0xE0, 0x00, 0x00, ##     00000000               
            0x0F, 0xF0, 0x00, 0x00, ##      00000000              
            0x07, 0xF8, 0x00, 0x00, ##       00000000             
            0x03, 0xFE, 0x00, 0x00, ##        000000000           
            0x0F, 0xFF, 0x80, 0x00, ##      0000000000000         
            0x1F, 0xFF, 0xE0, 0x00, ##     0000000000000000       
            0x3E, 0x1F, 0xF0, 0x00, ##    00000    000000000      
            0x7C, 0x07, 0xF8, 0x00, ##   00000       00000000     
            0x7C, 0x03, 0xFE, 0x00, ##   00000        000000000   
            0xF8, 0x00, 0xFF, 0x00, ##  00000           00000000  
            0xF8, 0x00, 0x7F, 0x80, ##  00000            00000000 
            0xF8, 0x00, 0x1F, 0x80, ##  00000              000000 
            0xF8, 0x00, 0x0F, 0xC0, ##  00000               000000
            0xFC, 0x00, 0x0F, 0xC0, ##  000000              000000
            0xFC, 0x00, 0x07, 0xC0, ##  000000               00000
            0x7E, 0x00, 0x07, 0xC0, ##   000000              00000
            0x7F, 0x00, 0x07, 0xC0, ##   0000000             00000
            0x3F, 0xC0, 0x07, 0xC0, ##    00000000           00000
            0x1F, 0xE0, 0x0F, 0x80, ##     00000000         00000 
            0x0F, 0xF8, 0x0F, 0x80, ##      000000000       00000 
            0x07, 0xFE, 0x1F, 0x00, ##       0000000000    00000  
            0x01, 0xFF, 0x7E, 0x00, ##         000000000 000000   
            0x00, 0xFF, 0xFC, 0x00, ##          00000000000000    
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000     
            0x00, 0x0F, 0xF8, 0x00, ##              000000000     
            0x00, 0x07, 0xFC, 0x00, ##               000000000    
            0x00, 0x01, 0xFE, 0x00, ##                 00000000   
            0x00, 0x00, 0xFE, 0x00, ##                  0000000   
            0x00, 0x00, 0x7F, 0x00, ##                   0000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x7F, 0x00, ##                   0000000  
            0x38, 0x00, 0x7E, 0x00, ##    000            000000   
            0x3F, 0x01, 0xFE, 0x00, ##    000000       00000000   
            0x3F, 0xFF, 0xFC, 0x00, ##    00000000000000000000    
            0x3F, 0xFF, 0xFC, 0x00, ##    00000000000000000000    
            0x3F, 0xFF, 0xF8, 0x00, ##    0000000000000000000     
            0x0F, 0xFF, 0xE0, 0x00, ##      000000000000000       
            0x00, 0xFF, 0x00, 0x00, ##          00000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 18, 
        'xoffset'  => 7, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 46, 
        'xoffset'  => 9, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, ##               00000000000000000000             
            0x00, 0x1F, 0xE0, 0x1F, 0xE0, 0x00, ##             00000000        00000000           
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x0F, 0x00, 0x1F, 0xF8, 0x03, 0xC0, ##      0000           0000000000         0000    
            0x0E, 0x00, 0xFF, 0xFF, 0x01, 0xC0, ##      000         0000000000000000       000    
            0x1E, 0x03, 0xFF, 0xFF, 0x01, 0xE0, ##     0000       000000000000000000       0000   
            0x3C, 0x07, 0xF0, 0x0F, 0x00, 0xE0, ##    0000       0000000        0000        000   
            0x38, 0x0F, 0xC0, 0x01, 0x00, 0x70, ##    000       000000             0         000  
            0x38, 0x1F, 0x80, 0x00, 0x00, 0x70, ##    000      000000                        000  
            0x70, 0x1F, 0x00, 0x00, 0x00, 0x38, ##   000       00000                          000 
            0x70, 0x3E, 0x00, 0x00, 0x00, 0x38, ##   000      00000                           000 
            0x70, 0x3E, 0x00, 0x00, 0x00, 0x38, ##   000      00000                           000 
            0xF0, 0x3E, 0x00, 0x00, 0x00, 0x1C, ##  0000      00000                            000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x7C, 0x00, 0x00, 0x00, 0x1C, ##  000      00000                             000
            0xE0, 0x3E, 0x00, 0x00, 0x00, 0x3C, ##  000       00000                           0000
            0x70, 0x3E, 0x00, 0x00, 0x00, 0x38, ##   000      00000                           000 
            0x70, 0x3E, 0x00, 0x00, 0x00, 0x38, ##   000      00000                           000 
            0x70, 0x1F, 0x00, 0x00, 0x00, 0x38, ##   000       00000                          000 
            0x38, 0x1F, 0x80, 0x00, 0x00, 0x70, ##    000      000000                        000  
            0x38, 0x0F, 0xC0, 0x01, 0x00, 0x70, ##    000       000000             0         000  
            0x3C, 0x07, 0xF8, 0x0F, 0x00, 0xF0, ##    0000       00000000       0000        0000  
            0x1E, 0x03, 0xFF, 0xFF, 0x01, 0xE0, ##     0000       000000000000000000       0000   
            0x0E, 0x00, 0xFF, 0xFF, 0x01, 0xC0, ##      000         0000000000000000       000    
            0x0F, 0x00, 0x1F, 0xF8, 0x03, 0xC0, ##      0000           0000000000         0000    
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0x1F, 0xE0, 0x0F, 0xE0, 0x00, ##             00000000         0000000           
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000            
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 22, 
        'xoffset'  => 4, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0xFE, 0x00, ##       0000000000       
            0x7F, 0xFF, 0xC0, ##   00000000000000000    
            0x7F, 0xFF, 0xE0, ##   000000000000000000   
            0x7C, 0x07, 0xF0, ##   00000       0000000  
            0x60, 0x01, 0xF8, ##   00            000000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0x78, ##                   0000 
            0x00, 0x00, 0x7C, ##                   00000
            0x00, 0x00, 0x7C, ##                   00000
            0x01, 0xFF, 0xFC, ##         000000000000000
            0x0F, 0xFF, 0xFC, ##      000000000000000000
            0x3F, 0xFF, 0xFC, ##    00000000000000000000
            0x7F, 0x80, 0x7C, ##   00000000        00000
            0x7C, 0x00, 0x7C, ##   00000           00000
            0xFC, 0x00, 0x7C, ##  000000           00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xFC, 0x01, 0xFC, ##  000000         0000000
            0x7C, 0x03, 0xFC, ##   00000        00000000
            0x7F, 0x07, 0xFC, ##   0000000     000000000
            0x3F, 0xFF, 0x7C, ##    00000000000000 00000
            0x1F, 0xFE, 0x7C, ##     000000000000  00000
            0x07, 0xF0, 0x7C, ##       0000000     00000
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 28, 
        'xoffset'  => 5, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x02, 0x00, 0x10, ##                0            0
            0x00, 0x06, 0x00, 0x30, ##               00           00
            0x00, 0x1E, 0x00, 0x70, ##             0000          000
            0x00, 0x3E, 0x00, 0xF0, ##            00000         0000
            0x00, 0x7E, 0x01, 0xF0, ##           000000        00000
            0x00, 0xFE, 0x03, 0xF0, ##          0000000       000000
            0x01, 0xFC, 0x07, 0xE0, ##         0000000       000000 
            0x03, 0xF8, 0x1F, 0xC0, ##        0000000      0000000  
            0x07, 0xE0, 0x3F, 0x80, ##       000000       0000000   
            0x0F, 0xC0, 0x7F, 0x00, ##      000000       0000000    
            0x1F, 0x80, 0xFE, 0x00, ##     000000       0000000     
            0x3F, 0x01, 0xFC, 0x00, ##    000000       0000000      
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000       
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000         
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000         
            0xFE, 0x03, 0xF0, 0x00, ##  0000000       000000        
            0x7F, 0x01, 0xF8, 0x00, ##   0000000       000000       
            0x3F, 0x80, 0xFC, 0x00, ##    0000000       000000      
            0x1F, 0xC0, 0x7E, 0x00, ##     0000000       000000     
            0x0F, 0xE0, 0x3F, 0x80, ##      0000000       0000000   
            0x03, 0xF0, 0x1F, 0xC0, ##        000000       0000000  
            0x01, 0xF8, 0x0F, 0xE0, ##         000000       0000000 
            0x00, 0xFC, 0x07, 0xF0, ##          000000       0000000
            0x00, 0x7E, 0x03, 0xF0, ##           000000       000000
            0x00, 0x3E, 0x01, 0xF0, ##            00000        00000
            0x00, 0x1E, 0x00, 0x70, ##             0000          000
            0x00, 0x0E, 0x00, 0x30, ##              000           00
            0x00, 0x06, 0x00, 0x10, ##               00            0
            0x00, 0x02, 0x00, 0x00, ##                0             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x1F, ##                                     00000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 46, 
        'xoffset'  => 9, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, ##               00000000000000000000             
            0x00, 0x1F, 0xE0, 0x1F, 0xE0, 0x00, ##             00000000        00000000           
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x0F, 0x03, 0xFF, 0xE0, 0x03, 0xC0, ##      0000      0000000000000           0000    
            0x0E, 0x03, 0xFF, 0xFC, 0x01, 0xC0, ##      000       0000000000000000         000    
            0x1E, 0x03, 0xFF, 0xFE, 0x01, 0xE0, ##     0000       00000000000000000        0000   
            0x3C, 0x03, 0xE0, 0x3F, 0x00, 0xE0, ##    0000        00000       000000        000   
            0x38, 0x03, 0xE0, 0x1F, 0x00, 0x70, ##    000         00000        00000         000  
            0x38, 0x03, 0xE0, 0x0F, 0x80, 0x70, ##    000         00000         00000        000  
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0x70, 0x03, 0xE0, 0x0F, 0x80, 0x38, ##   000          00000         00000         000 
            0xF0, 0x03, 0xE0, 0x0F, 0x80, 0x1C, ##  0000          00000         00000          000
            0xE0, 0x03, 0xE0, 0x1F, 0x00, 0x1C, ##  000           00000        00000           000
            0xE0, 0x03, 0xE0, 0x3F, 0x00, 0x1C, ##  000           00000       000000           000
            0xE0, 0x03, 0xFF, 0xFE, 0x00, 0x1C, ##  000           00000000000000000            000
            0xE0, 0x03, 0xFF, 0xF8, 0x00, 0x1C, ##  000           000000000000000              000
            0xE0, 0x03, 0xFF, 0xE0, 0x00, 0x1C, ##  000           0000000000000                000
            0xE0, 0x03, 0xE1, 0xF0, 0x00, 0x1C, ##  000           00000    00000               000
            0xE0, 0x03, 0xE0, 0xF8, 0x00, 0x1C, ##  000           00000     00000              000
            0xE0, 0x03, 0xE0, 0x7C, 0x00, 0x1C, ##  000           00000      00000             000
            0xE0, 0x03, 0xE0, 0x3E, 0x00, 0x3C, ##  000           00000       00000           0000
            0x70, 0x03, 0xE0, 0x3E, 0x00, 0x38, ##   000          00000       00000           000 
            0x70, 0x03, 0xE0, 0x1F, 0x00, 0x38, ##   000          00000        00000          000 
            0x70, 0x03, 0xE0, 0x1F, 0x00, 0x38, ##   000          00000        00000          000 
            0x38, 0x03, 0xE0, 0x0F, 0x80, 0x70, ##    000         00000         00000        000  
            0x38, 0x03, 0xE0, 0x0F, 0xC0, 0x70, ##    000         00000         000000       000  
            0x3C, 0x03, 0xE0, 0x07, 0xC0, 0xF0, ##    0000        00000          00000      0000  
            0x1E, 0x03, 0xE0, 0x07, 0xE1, 0xE0, ##     0000       00000          000000    0000   
            0x0E, 0x00, 0x00, 0x00, 0x01, 0xC0, ##      000                                000    
            0x0F, 0x00, 0x00, 0x00, 0x03, 0xC0, ##      0000                              0000    
            0x07, 0x80, 0x00, 0x00, 0x07, 0x80, ##       0000                            0000     
            0x03, 0xC0, 0x00, 0x00, 0x0F, 0x00, ##        0000                          0000      
            0x01, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##         00000                      00000       
            0x00, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##          00000                    00000        
            0x00, 0x7E, 0x00, 0x01, 0xF8, 0x00, ##           000000                000000         
            0x00, 0x1F, 0xE0, 0x0F, 0xE0, 0x00, ##             00000000         0000000           
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000            
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 19, 
        'xoffset'  => 7, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 20, 
        'xoffset'  => 6, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xF8, 0x00, ##         000000       
            0x07, 0xFE, 0x00, ##       0000000000     
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x3F, 0x0F, 0xC0, ##    000000    000000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF8, 0x01, 0xF0, ##  00000          00000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x00, 0xF0, ##  0000            0000
            0xF0, 0x01, 0xF0, ##  0000           00000
            0x78, 0x01, 0xE0, ##   0000          0000 
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x7E, 0x0F, 0xC0, ##   000000     000000  
            0x3F, 0xFF, 0xC0, ##    0000000000000000  
            0x1F, 0xFF, 0x80, ##     00000000000000   
            0x0F, 0xFE, 0x00, ##      00000000000     
            0x01, 0xF8, 0x00, ##         000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xF8, 0x00, ##      000000000      
            0xFF, 0xFE, 0x00, ##  000000000000000    
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xF8, 0x1F, 0xC0, ##  00000      0000000 
            0xC0, 0x0F, 0xC0, ##  00          000000 
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x0F, 0xC0, ##              000000 
            0x00, 0x1F, 0x80, ##             000000  
            0x00, 0x1F, 0x00, ##             00000   
            0x00, 0x3F, 0x00, ##            000000   
            0x00, 0x7E, 0x00, ##           000000    
            0x00, 0xFC, 0x00, ##          000000     
            0x01, 0xF8, 0x00, ##         000000      
            0x03, 0xF0, 0x00, ##        000000       
            0x07, 0xE0, 0x00, ##       000000        
            0x0F, 0xC0, 0x00, ##      000000         
            0x1F, 0x00, 0x00, ##     00000           
            0x3E, 0x00, 0x00, ##    00000            
            0x7C, 0x00, 0x00, ##   00000             
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xF8, 0x00, ##      000000000      
            0x7F, 0xFF, 0x00, ##   000000000000000   
            0x7F, 0xFF, 0x80, ##   0000000000000000  
            0x70, 0x1F, 0xC0, ##   000       0000000 
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x1F, 0xC0, ##             0000000 
            0x07, 0xFF, 0x00, ##       00000000000   
            0x07, 0xFC, 0x00, ##       000000000     
            0x07, 0xFF, 0x00, ##       00000000000   
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x07, 0xC0, ##               00000 
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x03, 0xE0, ##                00000
            0x00, 0x07, 0xE0, ##               000000
            0x00, 0x0F, 0xC0, ##              000000 
            0xE0, 0x1F, 0xC0, ##  000        0000000 
            0xFF, 0xFF, 0x80, ##  00000000000000000  
            0xFF, 0xFE, 0x00, ##  000000000000000    
            0x1F, 0xF0, 0x00, ##     000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 15, 
        'xoffset'  => 12, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xFC, ##          000000 
            0x01, 0xF8, ##         000000  
            0x01, 0xF0, ##         00000   
            0x03, 0xF0, ##        000000   
            0x07, 0xE0, ##       000000    
            0x0F, 0xC0, ##      000000     
            0x0F, 0x80, ##      00000      
            0x1F, 0x00, ##     00000       
            0x3E, 0x00, ##    00000        
            0x7E, 0x00, ##   000000        
            0x7C, 0x00, ##   00000         
            0xF8, 0x00, ##  00000          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 34, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x01, 0xF8, 0x00, ##  000000                 000000     
            0xFC, 0x00, 0x03, 0xF8, 0x00, ##  000000                0000000     
            0xFE, 0x00, 0x03, 0xF8, 0x00, ##  0000000               0000000     
            0xFE, 0x00, 0x07, 0xF8, 0x00, ##  0000000              00000000     
            0xFF, 0x00, 0x07, 0xF8, 0x00, ##  00000000             00000000     
            0xFF, 0x80, 0x0F, 0xF8, 0x00, ##  000000000           000000000     
            0xFF, 0xE0, 0x3F, 0xFC, 0xC0, ##  00000000000       000000000000  00
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000
            0xFD, 0xFF, 0xFC, 0xFF, 0xC0, ##  000000 000000000000000  0000000000
            0xFC, 0xFF, 0xF8, 0xFF, 0xC0, ##  000000  0000000000000   0000000000
            0xFC, 0x7F, 0xF0, 0x7F, 0xC0, ##  000000   00000000000     000000000
            0xFC, 0x1F, 0xC0, 0x3E, 0x00, ##  000000     0000000        00000   
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xFF, 0xF8, ##            0000000000000000000
            0x01, 0xFF, 0xFF, 0xF8, ##         0000000000000000000000
            0x03, 0xFF, 0xFF, 0xF8, ##        00000000000000000000000
            0x0F, 0xFF, 0xFF, 0xF8, ##      0000000000000000000000000
            0x1F, 0xFF, 0xC0, 0x78, ##     000000000000000       0000
            0x3F, 0xFF, 0xC0, 0x78, ##    0000000000000000       0000
            0x3F, 0xFF, 0xC0, 0x78, ##    0000000000000000       0000
            0x7F, 0xFF, 0xC0, 0x78, ##   00000000000000000       0000
            0x7F, 0xFF, 0xC0, 0x78, ##   00000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0xFF, 0xFF, 0xC0, 0x78, ##  000000000000000000       0000
            0x7F, 0xFF, 0xC0, 0x78, ##   00000000000000000       0000
            0x7F, 0xFF, 0xC0, 0x78, ##   00000000000000000       0000
            0x7F, 0xFF, 0xC0, 0x78, ##   00000000000000000       0000
            0x3F, 0xFF, 0xC0, 0x78, ##    0000000000000000       0000
            0x1F, 0xFF, 0xC0, 0x78, ##     000000000000000       0000
            0x0F, 0xFF, 0xC0, 0x78, ##      00000000000000       0000
            0x07, 0xFF, 0xC0, 0x78, ##       0000000000000       0000
            0x03, 0xFF, 0xC0, 0x78, ##        000000000000       0000
            0x00, 0x7F, 0xC0, 0x78, ##           000000000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x03, 0xC0, 0x78, ##                0000       0000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 6, 
        'xoffset'  => 7, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 12, 
        'xoffset'  => 10, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000   
            0x03, 0xC0, ##        0000  
            0x01, 0xC0, ##         000  
            0x01, 0xE0, ##         0000 
            0x00, 0xE0, ##          000 
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x00, 0xF0, ##          0000
            0x81, 0xF0, ##  0      00000
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xE0, ##  00000000000 
            0xFF, 0xC0, ##  0000000000  
            0x7F, 0x00, ##   0000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 17, 
        'xoffset'  => 5, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0xE0, 0x00, ##      0000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xFF, 0xE0, 0x00, ##  00000000000      
            0xC3, 0xE0, 0x00, ##  00    00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0x03, 0xE0, 0x00, ##        00000      
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 24, 
        'xoffset'  => 3, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x00, ##          00000000        
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x1F, 0xC3, 0xF8, ##     0000000    0000000   
            0x3F, 0x00, 0xFC, ##    000000        000000  
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0xFC, 0x00, 0x3F, ##  000000            000000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x1F, ##  00000              00000
            0xF8, 0x00, 0x3F, ##  00000             000000
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x7C, 0x00, 0x3E, ##   00000            00000 
            0x3E, 0x00, 0x7C, ##    00000          00000  
            0x3F, 0x00, 0xFC, ##    000000        000000  
            0x1F, 0xC3, 0xF8, ##     0000000    0000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000      
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x7F, 0xFF, 0xFE, ##   0000000000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 28, 
        'xoffset'  => 6, 
        'xadvance' => 39, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x80, 0x04, 0x00, 0x00, ##  0            0              
            0xC0, 0x06, 0x00, 0x00, ##  00           00             
            0xE0, 0x07, 0x80, 0x00, ##  000          0000           
            0xF0, 0x07, 0xC0, 0x00, ##  0000         00000          
            0xF8, 0x07, 0xE0, 0x00, ##  00000        000000         
            0xFC, 0x07, 0xF0, 0x00, ##  000000       0000000        
            0x7E, 0x03, 0xF8, 0x00, ##   000000       0000000       
            0x3F, 0x81, 0xFC, 0x00, ##    0000000      0000000      
            0x1F, 0xC0, 0x7E, 0x00, ##     0000000       000000     
            0x0F, 0xE0, 0x3F, 0x00, ##      0000000       000000    
            0x07, 0xF0, 0x1F, 0x80, ##       0000000       000000   
            0x03, 0xF8, 0x0F, 0xC0, ##        0000000       000000  
            0x01, 0xFC, 0x07, 0xF0, ##         0000000       0000000
            0x00, 0x7E, 0x03, 0xF0, ##           000000       000000
            0x00, 0x7E, 0x03, 0xF0, ##           000000       000000
            0x00, 0xFC, 0x07, 0xF0, ##          000000       0000000
            0x01, 0xF8, 0x0F, 0xE0, ##         000000       0000000 
            0x03, 0xF0, 0x1F, 0xC0, ##        000000       0000000  
            0x07, 0xE0, 0x3F, 0x80, ##       000000       0000000   
            0x1F, 0xC0, 0x7F, 0x00, ##     0000000       0000000    
            0x3F, 0x80, 0xFC, 0x00, ##    0000000       000000      
            0x7F, 0x01, 0xF8, 0x00, ##   0000000       000000       
            0xFE, 0x03, 0xF0, 0x00, ##  0000000       000000        
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000         
            0xF8, 0x07, 0xC0, 0x00, ##  00000        00000          
            0xE0, 0x07, 0x80, 0x00, ##  000          0000           
            0xC0, 0x07, 0x00, 0x00, ##  00           000            
            0x80, 0x06, 0x00, 0x00, ##  0            00             
            0x00, 0x04, 0x00, 0x00, ##               0              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 55, 
        'xoffset'  => 5, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        00000                           00000            
            0x7F, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##   0000000000                          00000             
            0xFF, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##  00000000000                         00000              
            0xFF, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##  00000000000                         00000              
            0xF3, 0xE0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##  0000  00000                        00000               
            0x03, 0xE0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##        00000                        00000               
            0x03, 0xE0, 0x00, 0x00, 0x3E, 0x00, 0x00, ##        00000                       00000                
            0x03, 0xE0, 0x00, 0x00, 0x7C, 0x00, 0x00, ##        00000                      00000                 
            0x03, 0xE0, 0x00, 0x00, 0x7C, 0x00, 0x00, ##        00000                      00000                 
            0x03, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, ##        00000                     00000                  
            0x03, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, ##        00000                     00000                  
            0x03, 0xE0, 0x00, 0x01, 0xF0, 0x00, 0x00, ##        00000                    00000                   
            0x03, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##        00000                   00000                    
            0x03, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##        00000                   00000                    
            0x03, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##        00000                  00000                     
            0x03, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##        00000                  00000                     
            0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##        00000                 00000                      
            0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##        00000                00000                       
            0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##        00000                00000                       
            0x03, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##        00000               00000                        
            0x03, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##        00000               00000                        
            0x03, 0xE0, 0x00, 0x7C, 0x00, 0x07, 0xE0, ##        00000              00000               000000    
            0x03, 0xE0, 0x00, 0xF8, 0x00, 0x07, 0xE0, ##        00000             00000                000000    
            0x03, 0xE0, 0x00, 0xF8, 0x00, 0x0F, 0xE0, ##        00000             00000               0000000    
            0xFF, 0xFF, 0x81, 0xF0, 0x00, 0x1F, 0xE0, ##  00000000000000000      00000               00000000    
            0xFF, 0xFF, 0x81, 0xF0, 0x00, 0x3F, 0xE0, ##  00000000000000000      00000              000000000    
            0xFF, 0xFF, 0x83, 0xE0, 0x00, 0x3B, 0xE0, ##  00000000000000000     00000               000 00000    
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x7B, 0xE0, ##                       00000               0000 00000    
            0x00, 0x00, 0x07, 0xC0, 0x00, 0xF3, 0xE0, ##                       00000              0000  00000    
            0x00, 0x00, 0x0F, 0x80, 0x00, 0xE3, 0xE0, ##                      00000               000   00000    
            0x00, 0x00, 0x0F, 0x80, 0x01, 0xE3, 0xE0, ##                      00000              0000   00000    
            0x00, 0x00, 0x1F, 0x00, 0x03, 0xC3, 0xE0, ##                     00000              0000    00000    
            0x00, 0x00, 0x3F, 0x00, 0x07, 0x83, 0xE0, ##                    000000             0000     00000    
            0x00, 0x00, 0x3E, 0x00, 0x07, 0x03, 0xE0, ##                    00000              000      00000    
            0x00, 0x00, 0x7C, 0x00, 0x0F, 0x03, 0xE0, ##                   00000              0000      00000    
            0x00, 0x00, 0x7C, 0x00, 0x1E, 0x03, 0xE0, ##                   00000             0000       00000    
            0x00, 0x00, 0xF8, 0x00, 0x1C, 0x03, 0xE0, ##                  00000              000        00000    
            0x00, 0x00, 0xF8, 0x00, 0x38, 0x03, 0xE0, ##                  00000             000         00000    
            0x00, 0x01, 0xF0, 0x00, 0x78, 0x03, 0xE0, ##                 00000             0000         00000    
            0x00, 0x03, 0xE0, 0x00, 0x7F, 0xFF, 0xFE, ##                00000              0000000000000000000000
            0x00, 0x03, 0xE0, 0x00, 0x7F, 0xFF, 0xFE, ##                00000              0000000000000000000000
            0x00, 0x07, 0xC0, 0x00, 0x7F, 0xFF, 0xFE, ##               00000               0000000000000000000000
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x03, 0xE0, ##               00000                            00000    
            0x00, 0x0F, 0x80, 0x00, 0x00, 0x03, 0xE0, ##              00000                             00000    
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x03, 0xE0, ##             00000                              00000    
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x03, 0xE0, ##             00000                              00000    
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x03, 0xE0, ##            00000                               00000    
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x03, 0xE0, ##            00000                               00000    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 53, 
        'xoffset'  => 5, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##                                        00000          
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##     00000000                          00000           
            0xFF, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##  00000000000                          00000           
            0xFF, 0xE0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##  00000000000                         00000            
            0xFF, 0xE0, 0x00, 0x00, 0x1F, 0x80, 0x00, ##  00000000000                        000000            
            0x83, 0xE0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##  0     00000                        00000             
            0x03, 0xE0, 0x00, 0x00, 0x3E, 0x00, 0x00, ##        00000                       00000              
            0x03, 0xE0, 0x00, 0x00, 0x3E, 0x00, 0x00, ##        00000                       00000              
            0x03, 0xE0, 0x00, 0x00, 0x7C, 0x00, 0x00, ##        00000                      00000               
            0x03, 0xE0, 0x00, 0x00, 0xFC, 0x00, 0x00, ##        00000                     000000               
            0x03, 0xE0, 0x00, 0x00, 0xF8, 0x00, 0x00, ##        00000                     00000                
            0x03, 0xE0, 0x00, 0x01, 0xF0, 0x00, 0x00, ##        00000                    00000                 
            0x03, 0xE0, 0x00, 0x01, 0xF0, 0x00, 0x00, ##        00000                    00000                 
            0x03, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##        00000                   00000                  
            0x03, 0xE0, 0x00, 0x07, 0xE0, 0x00, 0x00, ##        00000                  000000                  
            0x03, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##        00000                  00000                   
            0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##        00000                 00000                    
            0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##        00000                 00000                    
            0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##        00000                00000                     
            0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##        00000                00000                     
            0x03, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##        00000               00000                      
            0x03, 0xE0, 0x00, 0x7C, 0x01, 0xFE, 0x00, ##        00000              00000         00000000      
            0x03, 0xE0, 0x00, 0x7C, 0x0F, 0xFF, 0x80, ##        00000              00000      0000000000000    
            0x03, 0xE0, 0x00, 0xF8, 0x3F, 0xFF, 0xE0, ##        00000             00000     00000000000000000  
            0xFF, 0xFF, 0x80, 0xF8, 0x3E, 0x07, 0xF0, ##  00000000000000000       00000     00000      0000000 
            0xFF, 0xFF, 0x81, 0xF0, 0x30, 0x03, 0xF0, ##  00000000000000000      00000      00          000000 
            0xFF, 0xFF, 0x83, 0xE0, 0x20, 0x01, 0xF8, ##  00000000000000000     00000       0            000000
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0xF8, ##                        00000                     00000
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0xF8, ##                       00000                      00000
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0xF8, ##                       00000                      00000
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0xF8, ##                      00000                       00000
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x01, 0xF0, ##                     00000                       00000 
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x03, 0xF0, ##                     00000                      000000 
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x07, 0xE0, ##                    00000                      000000  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x07, 0xC0, ##                    00000                      00000   
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x0F, 0xC0, ##                   00000                      000000   
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##                  00000                      000000    
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x3F, 0x00, ##                  00000                     000000     
            0x00, 0x01, 0xF0, 0x00, 0x00, 0x7E, 0x00, ##                 00000                     000000      
            0x00, 0x01, 0xF0, 0x00, 0x00, 0xFC, 0x00, ##                 00000                    000000       
            0x00, 0x03, 0xE0, 0x00, 0x01, 0xF8, 0x00, ##                00000                    000000        
            0x00, 0x07, 0xC0, 0x00, 0x03, 0xF0, 0x00, ##               00000                    000000         
            0x00, 0x07, 0xC0, 0x00, 0x07, 0xC0, 0x00, ##               00000                   00000           
            0x00, 0x0F, 0x80, 0x00, 0x0F, 0x80, 0x00, ##              00000                   00000            
            0x00, 0x0F, 0x80, 0x00, 0x1F, 0x00, 0x00, ##              00000                  00000             
            0x00, 0x1F, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##             00000                  0000000000000000000
            0x00, 0x3E, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##            00000                   0000000000000000000
            0x00, 0x3E, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##            00000                   0000000000000000000
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, ##           00000                                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 57, 
        'xoffset'  => 3, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x0F, 0xF8, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##      000000000                          000000            
            0x7F, 0xFF, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##   000000000000000                       00000             
            0x7F, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, 0x00, ##   0000000000000000                     00000              
            0x70, 0x1F, 0xC0, 0x00, 0x03, 0xE0, 0x00, 0x00, ##   000       0000000                    00000              
            0x00, 0x07, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x00, ##               000000                  00000               
            0x00, 0x03, 0xE0, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                00000                 000000               
            0x00, 0x03, 0xE0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                00000                 00000                
            0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                00000                00000                 
            0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                00000                00000                 
            0x00, 0x07, 0xC0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##               00000                00000                  
            0x00, 0x1F, 0xC0, 0x00, 0x3C, 0x00, 0x00, 0x00, ##             0000000                0000                   
            0x07, 0xFF, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##       00000000000                 00000                   
            0x07, 0xFC, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##       000000000                  00000                    
            0x07, 0xFF, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##       00000000000                00000                    
            0x00, 0x1F, 0xC0, 0x01, 0xF0, 0x00, 0x00, 0x00, ##             0000000             00000                     
            0x00, 0x07, 0xC0, 0x01, 0xE0, 0x00, 0x00, 0x00, ##               00000             0000                      
            0x00, 0x07, 0xE0, 0x03, 0xE0, 0x00, 0x00, 0x00, ##               000000           00000                      
            0x00, 0x03, 0xE0, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                00000          00000                       
            0x00, 0x03, 0xE0, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                00000          00000                       
            0x00, 0x03, 0xE0, 0x0F, 0x80, 0x00, 0x00, 0x00, ##                00000         00000                        
            0x00, 0x03, 0xE0, 0x0F, 0x00, 0x00, 0x00, 0x00, ##                00000         0000                         
            0x00, 0x07, 0xE0, 0x1F, 0x00, 0x00, 0x00, 0x00, ##               000000        00000                         
            0x00, 0x0F, 0xC0, 0x3E, 0x00, 0x01, 0xF8, 0x00, ##              000000        00000                000000    
            0xE0, 0x1F, 0xC0, 0x3E, 0x00, 0x03, 0xF8, 0x00, ##  000        0000000        00000               0000000    
            0xFF, 0xFF, 0x80, 0x7C, 0x00, 0x07, 0xF8, 0x00, ##  00000000000000000        00000               00000000    
            0xFF, 0xFE, 0x00, 0x78, 0x00, 0x0F, 0xF8, 0x00, ##  000000000000000          0000               000000000    
            0x1F, 0xF0, 0x00, 0xF8, 0x00, 0x0E, 0xF8, 0x00, ##     000000000            00000               000 00000    
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x1C, 0xF8, 0x00, ##                         00000               000  00000    
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x3C, 0xF8, 0x00, ##                         00000              0000  00000    
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x38, 0xF8, 0x00, ##                        00000               000   00000    
            0x00, 0x00, 0x03, 0xC0, 0x00, 0x70, 0xF8, 0x00, ##                        0000               000    00000    
            0x00, 0x00, 0x07, 0xC0, 0x00, 0xF0, 0xF8, 0x00, ##                       00000              0000    00000    
            0x00, 0x00, 0x0F, 0x80, 0x01, 0xE0, 0xF8, 0x00, ##                      00000              0000     00000    
            0x00, 0x00, 0x0F, 0x80, 0x01, 0xC0, 0xF8, 0x00, ##                      00000              000      00000    
            0x00, 0x00, 0x1F, 0x00, 0x03, 0xC0, 0xF8, 0x00, ##                     00000              0000      00000    
            0x00, 0x00, 0x1E, 0x00, 0x07, 0x80, 0xF8, 0x00, ##                     0000              0000       00000    
            0x00, 0x00, 0x3E, 0x00, 0x0F, 0x00, 0xF8, 0x00, ##                    00000             0000        00000    
            0x00, 0x00, 0x7C, 0x00, 0x0E, 0x00, 0xF8, 0x00, ##                   00000              000         00000    
            0x00, 0x00, 0x7C, 0x00, 0x1E, 0x00, 0xF8, 0x00, ##                   00000             0000         00000    
            0x00, 0x00, 0xF8, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                  00000              0000000000000000000000
            0x00, 0x00, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                  0000               0000000000000000000000
            0x00, 0x01, 0xF0, 0x00, 0x1F, 0xFF, 0xFF, 0x80, ##                 00000               0000000000000000000000
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0xF8, 0x00, ##                00000                             00000    
            0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, 0xF8, 0x00, ##                00000                             00000    
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0xF8, 0x00, ##               00000                              00000    
            0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0xF8, 0x00, ##               0000                               00000    
            0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, 0xF8, 0x00, ##              00000                               00000    
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, ##             00000                                00000    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 25, 
        'xoffset'  => 4, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x1F, 0x80, 0x00, ##             000000        
            0x00, 0x3F, 0x80, 0x00, ##            0000000        
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x7F, 0x00, 0x00, ##           0000000         
            0x00, 0xFE, 0x00, 0x00, ##          0000000          
            0x01, 0xFC, 0x00, 0x00, ##         0000000           
            0x03, 0xFC, 0x00, 0x00, ##        00000000           
            0x07, 0xF8, 0x00, 0x00, ##       00000000            
            0x0F, 0xF0, 0x00, 0x00, ##      00000000             
            0x1F, 0xC0, 0x00, 0x00, ##     0000000               
            0x3F, 0x80, 0x00, 0x00, ##    0000000                
            0x3F, 0x00, 0x00, 0x00, ##    000000                 
            0x7F, 0x00, 0x00, 0x00, ##   0000000                 
            0x7E, 0x00, 0x00, 0x00, ##   000000                  
            0xFC, 0x00, 0x00, 0x00, ##  000000                   
            0xFC, 0x00, 0x00, 0x00, ##  000000                   
            0xFC, 0x00, 0x00, 0x00, ##  000000                   
            0xFC, 0x00, 0x00, 0x00, ##  000000                   
            0xFC, 0x00, 0x00, 0x00, ##  000000                   
            0xFE, 0x00, 0x00, 0x80, ##  0000000                 0
            0x7E, 0x00, 0x03, 0x80, ##   000000               000
            0x7F, 0x00, 0x0F, 0x80, ##   0000000            00000
            0x7F, 0xC0, 0x7F, 0x80, ##   000000000       00000000
            0x3F, 0xFF, 0xFF, 0x80, ##    00000000000000000000000
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000  
            0x03, 0xFF, 0xF8, 0x00, ##        000000000000000    
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                       
            0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                000000                      
            0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                 000000                     
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##                  00000                     
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                   00000                    
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                   
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                  
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                  
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x07, 0xE3, 0xF0, 0x00, 0x00, ##               000000   000000              
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x0F, 0xC1, 0xFC, 0x00, 0x00, ##              000000     0000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x1F, 0xC0, 0xFC, 0x00, 0x00, ##             0000000      000000            
            0x00, 0x1F, 0x80, 0xFE, 0x00, 0x00, ##             000000       0000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x3F, 0x80, 0x7E, 0x00, 0x00, ##            0000000        000000           
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x7E, 0x00, 0x3F, 0x80, 0x00, ##           000000           0000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0xFE, 0x00, 0x1F, 0x80, 0x00, ##          0000000            000000         
            0x00, 0xFC, 0x00, 0x1F, 0xC0, 0x00, ##          000000             0000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x01, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##         0000000              000000        
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##      0000000000000000000000000000000000    
            0x0F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##      000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##     0000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##     000000                        000000   
            0x3F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##    0000000                        000000   
            0x3F, 0x00, 0x00, 0x00, 0x7F, 0x00, ##    000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x7E, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   000000                           0000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  0000000                            000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  000000                              000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##                         00000              
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                        00000               
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000               
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                 
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                   
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                   00000                    
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, ##                  00000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x07, 0xE3, 0xF0, 0x00, 0x00, ##               000000   000000              
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x0F, 0xC1, 0xFC, 0x00, 0x00, ##              000000     0000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x1F, 0xC0, 0xFC, 0x00, 0x00, ##             0000000      000000            
            0x00, 0x1F, 0x80, 0xFE, 0x00, 0x00, ##             000000       0000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x3F, 0x80, 0x7E, 0x00, 0x00, ##            0000000        000000           
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x7E, 0x00, 0x3F, 0x80, 0x00, ##           000000           0000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0xFE, 0x00, 0x1F, 0x80, 0x00, ##          0000000            000000         
            0x00, 0xFC, 0x00, 0x1F, 0xC0, 0x00, ##          000000             0000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x01, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##         0000000              000000        
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##      0000000000000000000000000000000000    
            0x0F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##      000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##     0000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##     000000                        000000   
            0x3F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##    0000000                        000000   
            0x3F, 0x00, 0x00, 0x00, 0x7F, 0x00, ##    000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x7E, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   000000                           0000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  0000000                            000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  000000                              000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##                    000000                  
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000                
            0x00, 0x01, 0xF3, 0xE0, 0x00, 0x00, ##                 00000  00000               
            0x00, 0x03, 0xE1, 0xF0, 0x00, 0x00, ##                00000    00000              
            0x00, 0x07, 0xC0, 0xF8, 0x00, 0x00, ##               00000      00000             
            0x00, 0x0F, 0x80, 0x7C, 0x00, 0x00, ##              00000        00000            
            0x00, 0x1F, 0x00, 0x3C, 0x00, 0x00, ##             00000          0000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x07, 0xE3, 0xF0, 0x00, 0x00, ##               000000   000000              
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x0F, 0xC1, 0xFC, 0x00, 0x00, ##              000000     0000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x1F, 0xC0, 0xFC, 0x00, 0x00, ##             0000000      000000            
            0x00, 0x1F, 0x80, 0xFE, 0x00, 0x00, ##             000000       0000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x3F, 0x80, 0x7E, 0x00, 0x00, ##            0000000        000000           
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x7E, 0x00, 0x3F, 0x80, 0x00, ##           000000           0000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0xFE, 0x00, 0x1F, 0x80, 0x00, ##          0000000            000000         
            0x00, 0xFC, 0x00, 0x1F, 0xC0, 0x00, ##          000000             0000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x01, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##         0000000              000000        
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##        0000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##      0000000000000000000000000000000000    
            0x0F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##      000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##     0000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##     000000                        000000   
            0x3F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##    0000000                        000000   
            0x3F, 0x00, 0x00, 0x00, 0x7F, 0x00, ##    000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x7E, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   000000                           0000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0x80, ##  0000000                            000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFC, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  000000                              000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 43, 
        'xoffset'  => 1, 
        'xadvance' => 45, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xF0, 0x0F, 0x00, 0x00, ##                000000        0000           
            0x00, 0x07, 0xFC, 0x0F, 0x00, 0x00, ##               000000000      0000           
            0x00, 0x0F, 0xFF, 0x1F, 0x00, 0x00, ##              000000000000   00000           
            0x00, 0x1F, 0x1F, 0xFE, 0x00, 0x00, ##             00000   000000000000            
            0x00, 0x1E, 0x07, 0xFC, 0x00, 0x00, ##             0000      000000000             
            0x00, 0x1E, 0x01, 0xF8, 0x00, 0x00, ##             0000        000000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                  
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, ##                 0000000000000               
            0x00, 0x01, 0xFB, 0xF0, 0x00, 0x00, ##                 000000 000000               
            0x00, 0x01, 0xFB, 0xF0, 0x00, 0x00, ##                 000000 000000               
            0x00, 0x03, 0xF1, 0xF8, 0x00, 0x00, ##                000000   000000              
            0x00, 0x03, 0xF1, 0xF8, 0x00, 0x00, ##                000000   000000              
            0x00, 0x07, 0xF1, 0xFC, 0x00, 0x00, ##               0000000   0000000             
            0x00, 0x07, 0xE0, 0xFC, 0x00, 0x00, ##               000000     000000             
            0x00, 0x07, 0xE0, 0xFC, 0x00, 0x00, ##               000000     000000             
            0x00, 0x0F, 0xE0, 0xFE, 0x00, 0x00, ##              0000000     0000000            
            0x00, 0x0F, 0xC0, 0x7E, 0x00, 0x00, ##              000000       000000            
            0x00, 0x1F, 0xC0, 0x7F, 0x00, 0x00, ##             0000000       0000000           
            0x00, 0x1F, 0x80, 0x3F, 0x00, 0x00, ##             000000         000000           
            0x00, 0x1F, 0x80, 0x3F, 0x00, 0x00, ##             000000         000000           
            0x00, 0x3F, 0x80, 0x3F, 0x80, 0x00, ##            0000000         0000000          
            0x00, 0x3F, 0x00, 0x1F, 0x80, 0x00, ##            000000           000000          
            0x00, 0x3F, 0x00, 0x1F, 0x80, 0x00, ##            000000           000000          
            0x00, 0x7F, 0x00, 0x1F, 0xC0, 0x00, ##           0000000           0000000         
            0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, ##           000000             000000         
            0x00, 0xFE, 0x00, 0x0F, 0xE0, 0x00, ##          0000000             0000000        
            0x00, 0xFE, 0x00, 0x07, 0xE0, 0x00, ##          0000000              000000        
            0x00, 0xFC, 0x00, 0x07, 0xE0, 0x00, ##          000000               000000        
            0x01, 0xFC, 0x00, 0x07, 0xF0, 0x00, ##         0000000               0000000       
            0x01, 0xF8, 0x00, 0x03, 0xF0, 0x00, ##         000000                 000000       
            0x01, 0xF8, 0x00, 0x03, 0xF0, 0x00, ##         000000                 000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##       000000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##       000000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##       000000000000000000000000000000000     
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xC0, 0x00, 0x00, 0x7E, 0x00, ##      000000                       000000    
            0x0F, 0xC0, 0x00, 0x00, 0x7E, 0x00, ##      000000                       000000    
            0x1F, 0xC0, 0x00, 0x00, 0x3F, 0x00, ##     0000000                        000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x80, 0x00, 0x00, 0x1F, 0x80, ##    0000000                          000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 42, 
        'xoffset'  => 1, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                            
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000               
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x03, 0xF3, 0xF0, 0x00, 0x00, ##                000000  000000              
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x07, 0xE1, 0xF8, 0x00, 0x00, ##               000000    000000             
            0x00, 0x0F, 0xE1, 0xFC, 0x00, 0x00, ##              0000000    0000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x0F, 0xC0, 0xFC, 0x00, 0x00, ##              000000      000000            
            0x00, 0x1F, 0xC0, 0x7E, 0x00, 0x00, ##             0000000       000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x1F, 0x80, 0x7E, 0x00, 0x00, ##             000000        000000           
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x3F, 0x00, 0x3F, 0x00, 0x00, ##            000000          000000          
            0x00, 0x7F, 0x00, 0x3F, 0x80, 0x00, ##           0000000          0000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0x7E, 0x00, 0x1F, 0x80, 0x00, ##           000000            000000         
            0x00, 0xFE, 0x00, 0x1F, 0xC0, 0x00, ##          0000000            0000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, ##          000000              000000        
            0x01, 0xFC, 0x00, 0x0F, 0xE0, 0x00, ##         0000000              0000000       
            0x01, 0xF8, 0x00, 0x07, 0xE0, 0x00, ##         000000                000000       
            0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, ##        0000000                0000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000     
            0x0F, 0xE0, 0x00, 0x01, 0xFC, 0x00, ##      0000000                    0000000    
            0x0F, 0xC0, 0x00, 0x00, 0xFC, 0x00, ##      000000                      000000    
            0x1F, 0xC0, 0x00, 0x00, 0xFE, 0x00, ##     0000000                      0000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7E, 0x00, ##     0000000                       000000   
            0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, ##     000000                        000000   
            0x3F, 0x80, 0x00, 0x00, 0x7F, 0x00, ##    0000000                        0000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##    0000000                         000000  
            0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, ##    000000                          000000  
            0x7F, 0x00, 0x00, 0x00, 0x3F, 0x80, ##   0000000                          0000000 
            0x7E, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   000000                            000000 
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0xFE, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##  0000000                            0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 43, 
        'xoffset'  => 0, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                   
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##                 000000000000                
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, ##                 0000000000000               
            0x00, 0x03, 0xE1, 0xF8, 0x00, 0x00, ##                00000    000000              
            0x00, 0x03, 0xC0, 0x78, 0x00, 0x00, ##                0000       0000              
            0x00, 0x07, 0xC0, 0x7C, 0x00, 0x00, ##               00000       00000             
            0x00, 0x07, 0x80, 0x3C, 0x00, 0x00, ##               0000         0000             
            0x00, 0x07, 0x80, 0x3C, 0x00, 0x00, ##               0000         0000             
            0x00, 0x07, 0x80, 0x3C, 0x00, 0x00, ##               0000         0000             
            0x00, 0x07, 0x80, 0x3C, 0x00, 0x00, ##               0000         0000             
            0x00, 0x07, 0xC0, 0x7C, 0x00, 0x00, ##               00000       00000             
            0x00, 0x03, 0xE0, 0xF8, 0x00, 0x00, ##                00000     00000              
            0x00, 0x03, 0xFB, 0xF8, 0x00, 0x00, ##                0000000 0000000              
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, ##                 0000000000000               
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, ##                 0000000000000               
            0x00, 0x01, 0xFB, 0xF0, 0x00, 0x00, ##                 000000 000000               
            0x00, 0x01, 0xFB, 0xF0, 0x00, 0x00, ##                 000000 000000               
            0x00, 0x03, 0xF3, 0xF8, 0x00, 0x00, ##                000000  0000000              
            0x00, 0x03, 0xF1, 0xF8, 0x00, 0x00, ##                000000   000000              
            0x00, 0x03, 0xF1, 0xF8, 0x00, 0x00, ##                000000   000000              
            0x00, 0x07, 0xE0, 0xFC, 0x00, 0x00, ##               000000     000000             
            0x00, 0x07, 0xE0, 0xFC, 0x00, 0x00, ##               000000     000000             
            0x00, 0x0F, 0xE0, 0xFE, 0x00, 0x00, ##              0000000     0000000            
            0x00, 0x0F, 0xC0, 0x7E, 0x00, 0x00, ##              000000       000000            
            0x00, 0x0F, 0xC0, 0x7E, 0x00, 0x00, ##              000000       000000            
            0x00, 0x1F, 0xC0, 0x7F, 0x00, 0x00, ##             0000000       0000000           
            0x00, 0x1F, 0x80, 0x3F, 0x00, 0x00, ##             000000         000000           
            0x00, 0x1F, 0x80, 0x3F, 0x00, 0x00, ##             000000         000000           
            0x00, 0x3F, 0x80, 0x3F, 0x80, 0x00, ##            0000000         0000000          
            0x00, 0x3F, 0x00, 0x1F, 0x80, 0x00, ##            000000           000000          
            0x00, 0x7F, 0x00, 0x1F, 0xC0, 0x00, ##           0000000           0000000         
            0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, ##           000000             000000         
            0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, ##           000000             000000         
            0x00, 0xFE, 0x00, 0x0F, 0xE0, 0x00, ##          0000000             0000000        
            0x00, 0xFC, 0x00, 0x07, 0xE0, 0x00, ##          000000               000000        
            0x00, 0xFC, 0x00, 0x07, 0xE0, 0x00, ##          000000               000000        
            0x01, 0xFC, 0x00, 0x07, 0xF0, 0x00, ##         0000000               0000000       
            0x01, 0xF8, 0x00, 0x03, 0xF0, 0x00, ##         000000                 000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##       000000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##       000000000000000000000000000000000     
            0x07, 0xE0, 0x00, 0x00, 0xFC, 0x00, ##       000000                     000000     
            0x0F, 0xE0, 0x00, 0x00, 0x7E, 0x00, ##      0000000                      000000    
            0x0F, 0xC0, 0x00, 0x00, 0x7E, 0x00, ##      000000                       000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0xC0, 0x00, 0x00, 0x3F, 0x00, ##     0000000                        000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##   0000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 58, 
        'xoffset'  => 0, 
        'xadvance' => 62, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                     000000000000000000000000000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                     000000000000000000000000000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                     000000000000000000000000000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                    0000000000000000000000000000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                    0000000000000000000000000000000000000000
            0x00, 0x00, 0x7F, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                   0000000    000000                        
            0x00, 0x00, 0x7E, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                   000000     000000                        
            0x00, 0x00, 0xFE, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                  0000000     000000                        
            0x00, 0x00, 0xFC, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                  000000      000000                        
            0x00, 0x00, 0xFC, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                  000000      000000                        
            0x00, 0x01, 0xFC, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                 0000000      000000                        
            0x00, 0x01, 0xF8, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                 000000       000000                        
            0x00, 0x03, 0xF8, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                0000000       000000                        
            0x00, 0x03, 0xF0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                000000        000000                        
            0x00, 0x03, 0xF0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##                000000        000000                        
            0x00, 0x07, 0xF0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##               0000000        000000                        
            0x00, 0x07, 0xE0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##               000000         000000                        
            0x00, 0x0F, 0xE0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##              0000000         000000                        
            0x00, 0x0F, 0xC0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##              000000          000000                        
            0x00, 0x0F, 0xC0, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##              000000          000000                        
            0x00, 0x1F, 0xC0, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##             0000000          00000000000000000000000000000 
            0x00, 0x1F, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##             000000           00000000000000000000000000000 
            0x00, 0x3F, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##            0000000           00000000000000000000000000000 
            0x00, 0x3F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##            000000            00000000000000000000000000000 
            0x00, 0x7F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##           0000000            00000000000000000000000000000 
            0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##           000000             000000                        
            0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##           000000             000000                        
            0x00, 0xFE, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##          0000000             000000                        
            0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##          000000              000000                        
            0x01, 0xFC, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##         0000000              000000                        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##         000000000000000000000000000                        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##         000000000000000000000000000                        
            0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        0000000000000000000000000000                        
            0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        0000000000000000000000000000                        
            0x07, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##       00000000000000000000000000000                        
            0x07, 0xE0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##       000000                 000000                        
            0x0F, 0xE0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##      0000000                 000000                        
            0x0F, 0xC0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##      000000                  000000                        
            0x0F, 0xC0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##      000000                  000000                        
            0x1F, 0xC0, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##     0000000                  000000                        
            0x1F, 0x80, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##     000000                   000000                        
            0x3F, 0x80, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##    0000000                   000000                        
            0x3F, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##    000000                    000000000000000000000000000000
            0x3F, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##    000000                    000000000000000000000000000000
            0x7F, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##   0000000                    000000000000000000000000000000
            0x7E, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##   000000                     000000000000000000000000000000
            0xFE, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000                     000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 45, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000          
            0x00, 0x03, 0xFF, 0xFF, 0x00, ##                000000000000000000      
            0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##             00000000000000000000000    
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000  
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, ##          000000000000000000000000000000
            0x01, 0xFF, 0xC0, 0x1F, 0xFC, ##         00000000000         00000000000
            0x03, 0xFE, 0x00, 0x01, 0xFC, ##        000000000                0000000
            0x07, 0xF8, 0x00, 0x00, 0x7C, ##       00000000                    00000
            0x0F, 0xF0, 0x00, 0x00, 0x3C, ##      00000000                      0000
            0x0F, 0xE0, 0x00, 0x00, 0x0C, ##      0000000                         00
            0x1F, 0xC0, 0x00, 0x00, 0x04, ##     0000000                           0
            0x1F, 0x80, 0x00, 0x00, 0x00, ##     000000                             
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                             
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                              
            0x7F, 0x00, 0x00, 0x00, 0x00, ##   0000000                              
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                                
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                               
            0x7F, 0x00, 0x00, 0x00, 0x00, ##   0000000                              
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                              
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                              
            0x1F, 0x80, 0x00, 0x00, 0x00, ##     000000                             
            0x1F, 0xC0, 0x00, 0x00, 0x04, ##     0000000                           0
            0x0F, 0xE0, 0x00, 0x00, 0x0C, ##      0000000                         00
            0x0F, 0xF0, 0x00, 0x00, 0x3C, ##      00000000                      0000
            0x07, 0xF8, 0x00, 0x00, 0x7C, ##       00000000                    00000
            0x03, 0xFE, 0x00, 0x01, 0xFC, ##        000000000                0000000
            0x01, 0xFF, 0xC0, 0x1F, 0xFC, ##         00000000000         00000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xFC, ##          000000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000  
            0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##             00000000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0x00, ##                000000000000000000      
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000          
            0x00, 0x00, 0x03, 0xC0, 0x00, ##                        0000            
            0x00, 0x00, 0x01, 0xC0, 0x00, ##                         000            
            0x00, 0x00, 0x01, 0xE0, 0x00, ##                         0000           
            0x00, 0x00, 0x00, 0xE0, 0x00, ##                          000           
            0x00, 0x00, 0x00, 0xF0, 0x00, ##                          0000          
            0x00, 0x00, 0x00, 0xF0, 0x00, ##                          0000          
            0x00, 0x00, 0x00, 0xF0, 0x00, ##                          0000          
            0x00, 0x01, 0x01, 0xF0, 0x00, ##                 0       00000          
            0x00, 0x01, 0xFF, 0xF0, 0x00, ##                 0000000000000          
            0x00, 0x01, 0xFF, 0xE0, 0x00, ##                 000000000000           
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000            
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x01, 0xF8, 0x00, 0x00, ##         000000                 
            0x00, 0xF8, 0x00, 0x00, ##          00000                 
            0x00, 0x7C, 0x00, 0x00, ##           00000                
            0x00, 0x7E, 0x00, 0x00, ##           000000               
            0x00, 0x3F, 0x00, 0x00, ##            000000              
            0x00, 0x1F, 0x80, 0x00, ##             000000             
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x07, 0xC0, 0x00, ##               00000            
            0x00, 0x03, 0xE0, 0x00, ##                00000           
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0xFC, 0x00, ##                  000000        
            0x00, 0x01, 0xF8, 0x00, ##                 000000         
            0x00, 0x01, 0xF0, 0x00, ##                 00000          
            0x00, 0x03, 0xE0, 0x00, ##                00000           
            0x00, 0x07, 0xC0, 0x00, ##               00000            
            0x00, 0x0F, 0xC0, 0x00, ##              000000            
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x1F, 0x00, 0x00, ##             00000              
            0x00, 0x3E, 0x00, 0x00, ##            00000               
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x1F, 0x80, 0x00, ##             000000             
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x3F, 0xE0, 0x00, ##            000000000           
            0x00, 0x7D, 0xF0, 0x00, ##           00000 00000          
            0x00, 0xF8, 0xF8, 0x00, ##          00000   00000         
            0x01, 0xF0, 0x7C, 0x00, ##         00000     00000        
            0x01, 0xE0, 0x3C, 0x00, ##         0000       0000        
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x07, 0x80, 0x0F, 0x00, ##       0000           0000      
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000 
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0xF8, 0x00, ##  00000      
            0xFC, 0x00, ##  000000     
            0x7E, 0x00, ##   000000    
            0x3F, 0x00, ##    000000   
            0x1F, 0x00, ##     00000   
            0x0F, 0x80, ##      00000  
            0x07, 0xC0, ##       00000 
            0x03, 0xC0, ##        0000 
            0x01, 0xE0, ##         0000
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x0F, 0xC0, ##      000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 11, 
        'xoffset'  => 5, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x03, 0xE0, ##        00000
            0x07, 0xE0, ##       000000
            0x0F, 0xC0, ##      000000 
            0x1F, 0x80, ##     000000  
            0x1F, 0x00, ##     00000   
            0x3E, 0x00, ##    00000    
            0x7C, 0x00, ##   00000     
            0x78, 0x00, ##   0000      
            0xF0, 0x00, ##  0000       
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x7E, 0x00, ##   000000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x03, 0xF0, 0x00, ##        000000      
            0x07, 0xF8, 0x00, ##       00000000     
            0x07, 0xF8, 0x00, ##       00000000     
            0x0F, 0xFC, 0x00, ##      0000000000    
            0x1F, 0x3E, 0x00, ##     00000  00000   
            0x3E, 0x1F, 0x00, ##    00000    00000  
            0x7C, 0x0F, 0x80, ##   00000      00000 
            0xF8, 0x07, 0xC0, ##  00000        00000
            0xF0, 0x03, 0xC0, ##  0000          0000
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 18, 
        'xoffset'  => 1, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 45, 
        'xoffset'  => 1, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##        00000000000000000000                   
            0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##        0000000000000000000000000              
            0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        0000000000000000000000000000           
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000         
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000        
            0x03, 0xF0, 0x00, 0x3F, 0xFC, 0x00, ##        000000              000000000000       
            0x03, 0xF0, 0x00, 0x07, 0xFE, 0x00, ##        000000                 0000000000      
            0x03, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##        000000                    00000000     
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x80, ##        000000                     00000000    
            0x03, 0xF0, 0x00, 0x00, 0x3F, 0xC0, ##        000000                      00000000   
            0x03, 0xF0, 0x00, 0x00, 0x1F, 0xC0, ##        000000                       0000000   
            0x03, 0xF0, 0x00, 0x00, 0x0F, 0xE0, ##        000000                        0000000  
            0x03, 0xF0, 0x00, 0x00, 0x07, 0xE0, ##        000000                         000000  
            0x03, 0xF0, 0x00, 0x00, 0x07, 0xF0, ##        000000                         0000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF8, ##        000000                          0000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xF8, ##  00000000000000000000000                000000
            0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xF8, ##  00000000000000000000000                000000
            0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xF8, ##  00000000000000000000000                000000
            0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xF8, ##  00000000000000000000000                000000
            0xFF, 0xFF, 0xFE, 0x00, 0x01, 0xF8, ##  00000000000000000000000                000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0x03, 0xF0, 0x00, 0x00, 0x01, 0xF8, ##        000000                           000000
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF8, ##        000000                          0000000
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x03, 0xF0, ##        000000                          000000 
            0x03, 0xF0, 0x00, 0x00, 0x07, 0xF0, ##        000000                         0000000 
            0x03, 0xF0, 0x00, 0x00, 0x07, 0xE0, ##        000000                         000000  
            0x03, 0xF0, 0x00, 0x00, 0x0F, 0xE0, ##        000000                        0000000  
            0x03, 0xF0, 0x00, 0x00, 0x1F, 0xC0, ##        000000                       0000000   
            0x03, 0xF0, 0x00, 0x00, 0x3F, 0xC0, ##        000000                      00000000   
            0x03, 0xF0, 0x00, 0x00, 0x7F, 0x80, ##        000000                     00000000    
            0x03, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##        000000                    00000000     
            0x03, 0xF0, 0x00, 0x03, 0xFF, 0x00, ##        000000                  0000000000     
            0x03, 0xF0, 0x00, 0x3F, 0xFC, 0x00, ##        000000              000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##        0000000000000000000000000000000        
            0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        000000000000000000000000000000         
            0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        0000000000000000000000000000           
            0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##        0000000000000000000000000              
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##        00000000000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 35, 
        'xoffset'  => 6, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x00, 0xF0, 0x00, ##            000000        0000       
            0x00, 0x7F, 0xC0, 0xF0, 0x00, ##           000000000      0000       
            0x00, 0xFF, 0xF1, 0xF0, 0x00, ##          000000000000   00000       
            0x01, 0xF1, 0xFF, 0xE0, 0x00, ##         00000   000000000000        
            0x01, 0xE0, 0x7F, 0xC0, 0x00, ##         0000      000000000         
            0x01, 0xE0, 0x1F, 0x80, 0x00, ##         0000        000000          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0xFF, 0x00, 0x00, 0x07, 0xE0, ##  00000000                     000000
            0xFF, 0x80, 0x00, 0x07, 0xE0, ##  000000000                    000000
            0xFF, 0xC0, 0x00, 0x07, 0xE0, ##  0000000000                   000000
            0xFF, 0xC0, 0x00, 0x07, 0xE0, ##  0000000000                   000000
            0xFF, 0xE0, 0x00, 0x07, 0xE0, ##  00000000000                  000000
            0xFF, 0xE0, 0x00, 0x07, 0xE0, ##  00000000000                  000000
            0xFF, 0xF0, 0x00, 0x07, 0xE0, ##  000000000000                 000000
            0xFF, 0xF0, 0x00, 0x07, 0xE0, ##  000000000000                 000000
            0xFF, 0xF8, 0x00, 0x07, 0xE0, ##  0000000000000                000000
            0xFD, 0xF8, 0x00, 0x07, 0xE0, ##  000000 000000                000000
            0xFD, 0xFC, 0x00, 0x07, 0xE0, ##  000000 0000000               000000
            0xFC, 0xFC, 0x00, 0x07, 0xE0, ##  000000  000000               000000
            0xFC, 0x7E, 0x00, 0x07, 0xE0, ##  000000   000000              000000
            0xFC, 0x7E, 0x00, 0x07, 0xE0, ##  000000   000000              000000
            0xFC, 0x3F, 0x00, 0x07, 0xE0, ##  000000    000000             000000
            0xFC, 0x3F, 0x00, 0x07, 0xE0, ##  000000    000000             000000
            0xFC, 0x1F, 0x80, 0x07, 0xE0, ##  000000     000000            000000
            0xFC, 0x1F, 0x80, 0x07, 0xE0, ##  000000     000000            000000
            0xFC, 0x0F, 0xC0, 0x07, 0xE0, ##  000000      000000           000000
            0xFC, 0x0F, 0xE0, 0x07, 0xE0, ##  000000      0000000          000000
            0xFC, 0x07, 0xE0, 0x07, 0xE0, ##  000000       000000          000000
            0xFC, 0x07, 0xF0, 0x07, 0xE0, ##  000000       0000000         000000
            0xFC, 0x03, 0xF0, 0x07, 0xE0, ##  000000        000000         000000
            0xFC, 0x03, 0xF8, 0x07, 0xE0, ##  000000        0000000        000000
            0xFC, 0x01, 0xF8, 0x07, 0xE0, ##  000000         000000        000000
            0xFC, 0x01, 0xFC, 0x07, 0xE0, ##  000000         0000000       000000
            0xFC, 0x00, 0xFC, 0x07, 0xE0, ##  000000          000000       000000
            0xFC, 0x00, 0x7E, 0x07, 0xE0, ##  000000           000000      000000
            0xFC, 0x00, 0x7E, 0x07, 0xE0, ##  000000           000000      000000
            0xFC, 0x00, 0x3F, 0x07, 0xE0, ##  000000            000000     000000
            0xFC, 0x00, 0x3F, 0x07, 0xE0, ##  000000            000000     000000
            0xFC, 0x00, 0x1F, 0x87, 0xE0, ##  000000             000000    000000
            0xFC, 0x00, 0x1F, 0x87, 0xE0, ##  000000             000000    000000
            0xFC, 0x00, 0x0F, 0xC7, 0xE0, ##  000000              000000   000000
            0xFC, 0x00, 0x0F, 0xC7, 0xE0, ##  000000              000000   000000
            0xFC, 0x00, 0x07, 0xE7, 0xE0, ##  000000               000000  000000
            0xFC, 0x00, 0x07, 0xF7, 0xE0, ##  000000               0000000 000000
            0xFC, 0x00, 0x03, 0xF7, 0xE0, ##  000000                000000 000000
            0xFC, 0x00, 0x03, 0xFF, 0xE0, ##  000000                0000000000000
            0xFC, 0x00, 0x01, 0xFF, 0xE0, ##  000000                 000000000000
            0xFC, 0x00, 0x01, 0xFF, 0xE0, ##  000000                 000000000000
            0xFC, 0x00, 0x00, 0xFF, 0xE0, ##  000000                  00000000000
            0xFC, 0x00, 0x00, 0xFF, 0xE0, ##  000000                  00000000000
            0xFC, 0x00, 0x00, 0x7F, 0xE0, ##  000000                   0000000000
            0xFC, 0x00, 0x00, 0x3F, 0xE0, ##  000000                    000000000
            0xFC, 0x00, 0x00, 0x3F, 0xE0, ##  000000                    000000000
            0xFC, 0x00, 0x00, 0x1F, 0xE0, ##  000000                     00000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                000000                       
            0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, ##                 00000                       
            0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                 000000                      
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                  000000                     
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##                   000000                    
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                    
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                   
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                  
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                       00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000              
            0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##                         00000               
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000               
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                 
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                      00000                  
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                     00000                   
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                    
            0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                   00000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                  
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                  
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x00, 0xFB, 0xE0, 0x00, 0x00, ##                  00000 00000                
            0x00, 0x01, 0xF1, 0xF0, 0x00, 0x00, ##                 00000   00000               
            0x00, 0x03, 0xE0, 0xF8, 0x00, 0x00, ##                00000     00000              
            0x00, 0x03, 0xE0, 0x78, 0x00, 0x00, ##                00000      0000              
            0x00, 0x07, 0xC0, 0x3C, 0x00, 0x00, ##               00000        0000             
            0x00, 0x0F, 0x80, 0x3E, 0x00, 0x00, ##              00000         00000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xF0, 0x0F, 0x00, 0x00, ##                000000        0000           
            0x00, 0x07, 0xFC, 0x0F, 0x00, 0x00, ##               000000000      0000           
            0x00, 0x0F, 0xFF, 0x1F, 0x00, 0x00, ##              000000000000   00000           
            0x00, 0x1F, 0x1F, 0xFE, 0x00, 0x00, ##             00000   000000000000            
            0x00, 0x1E, 0x07, 0xFC, 0x00, 0x00, ##             0000      000000000             
            0x00, 0x1E, 0x01, 0xF8, 0x00, 0x00, ##             0000        000000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x07, 0xE0, 0x7E, 0x00, 0x00, ##               000000      000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x01, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##         00000000000        0000000000       
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##  0000000                             000000 
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, ##  000000                               000000
            0xFE, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##  0000000                             0000000
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##   000000                             000000 
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##   0000000                           0000000 
            0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, ##    000000                           000000  
            0x3F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##    0000000                         0000000  
            0x1F, 0x80, 0x00, 0x00, 0x3F, 0x00, ##     000000                         000000   
            0x1F, 0xC0, 0x00, 0x00, 0x7F, 0x00, ##     0000000                       0000000   
            0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, ##      0000000                     0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x03, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##        000000000             000000000      
            0x01, 0xFF, 0x80, 0x3F, 0xF0, 0x00, ##         0000000000         0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000           
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000             
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 36, 
        'xoffset'  => 9, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x10, 0x00, 0x00, 0x01, 0x80, ##     0                           00   
            0x38, 0x00, 0x00, 0x03, 0xC0, ##    000                         0000  
            0x7C, 0x00, 0x00, 0x07, 0xE0, ##   00000                       000000 
            0xFE, 0x00, 0x00, 0x0F, 0xF0, ##  0000000                     00000000
            0x7F, 0x00, 0x00, 0x1F, 0xE0, ##   0000000                   00000000 
            0x3F, 0x80, 0x00, 0x3F, 0xC0, ##    0000000                 00000000  
            0x1F, 0xC0, 0x00, 0x7F, 0x80, ##     0000000               00000000   
            0x0F, 0xE0, 0x00, 0xFF, 0x00, ##      0000000             00000000    
            0x07, 0xF0, 0x01, 0xFE, 0x00, ##       0000000           00000000     
            0x03, 0xF8, 0x03, 0xFC, 0x00, ##        0000000         00000000      
            0x01, 0xFC, 0x07, 0xF8, 0x00, ##         0000000       00000000       
            0x00, 0xFE, 0x0F, 0xF0, 0x00, ##          0000000     00000000        
            0x00, 0x7F, 0x1F, 0xE0, 0x00, ##           0000000   00000000         
            0x00, 0x3F, 0xBF, 0xC0, 0x00, ##            0000000 00000000          
            0x00, 0x1F, 0xFF, 0x80, 0x00, ##             00000000000000           
            0x00, 0x0F, 0xFF, 0x00, 0x00, ##              000000000000            
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000              
            0x00, 0x0F, 0xFE, 0x00, 0x00, ##              00000000000             
            0x00, 0x1F, 0xFF, 0x00, 0x00, ##             0000000000000            
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000           
            0x00, 0x7F, 0x9F, 0xC0, 0x00, ##           00000000  0000000          
            0x00, 0xFF, 0x0F, 0xE0, 0x00, ##          00000000    0000000         
            0x01, 0xFE, 0x07, 0xF0, 0x00, ##         00000000      0000000        
            0x03, 0xFC, 0x03, 0xF8, 0x00, ##        00000000        0000000       
            0x07, 0xF8, 0x01, 0xFC, 0x00, ##       00000000          0000000      
            0x0F, 0xF0, 0x00, 0xFE, 0x00, ##      00000000            0000000     
            0x1F, 0xE0, 0x00, 0x7F, 0x00, ##     00000000              0000000    
            0x3F, 0xC0, 0x00, 0x3F, 0x80, ##    00000000                0000000   
            0x7F, 0x80, 0x00, 0x1F, 0xC0, ##   00000000                  0000000  
            0xFF, 0x00, 0x00, 0x0F, 0xE0, ##  00000000                    0000000 
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7C, 0x00, 0x00, 0x03, 0xE0, ##   00000                        00000 
            0x38, 0x00, 0x00, 0x01, 0xC0, ##    000                          000  
            0x10, 0x00, 0x00, 0x00, 0x80, ##     0                            0   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, ##                                          0  
            0x00, 0x00, 0x7F, 0xE0, 0x01, 0xC0, ##                   0000000000            000 
            0x00, 0x07, 0xFF, 0xFC, 0x03, 0xE0, ##               00000000000000000        00000
            0x00, 0x1F, 0xFF, 0xFF, 0x87, 0xE0, ##             0000000000000000000000    000000
            0x00, 0x3F, 0xFF, 0xFF, 0xC7, 0xC0, ##            000000000000000000000000   00000 
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##          000000000000000000000000000000000  
            0x01, 0xFF, 0x80, 0x7F, 0xFF, 0x00, ##         0000000000        000000000000000   
            0x03, 0xFE, 0x00, 0x1F, 0xFE, 0x00, ##        000000000            000000000000    
            0x07, 0xF8, 0x00, 0x07, 0xFE, 0x00, ##       00000000                0000000000    
            0x0F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##      00000000                  000000000    
            0x0F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##      0000000                    000000000   
            0x1F, 0xC0, 0x00, 0x03, 0xFF, 0x00, ##     0000000                    0000000000   
            0x1F, 0x80, 0x00, 0x07, 0xFF, 0x80, ##     000000                    000000000000  
            0x3F, 0x80, 0x00, 0x0F, 0xFF, 0x80, ##    0000000                   0000000000000  
            0x3F, 0x00, 0x00, 0x1F, 0xDF, 0x80, ##    000000                   0000000 000000  
            0x7F, 0x00, 0x00, 0x1F, 0x9F, 0xC0, ##   0000000                   000000  0000000 
            0x7E, 0x00, 0x00, 0x3F, 0x9F, 0xC0, ##   000000                   0000000  0000000 
            0x7E, 0x00, 0x00, 0x7F, 0x0F, 0xC0, ##   000000                  0000000    000000 
            0x7E, 0x00, 0x00, 0xFE, 0x0F, 0xC0, ##   000000                 0000000     000000 
            0xFE, 0x00, 0x01, 0xFC, 0x0F, 0xE0, ##  0000000                0000000      0000000
            0xFC, 0x00, 0x03, 0xF8, 0x07, 0xE0, ##  000000                0000000        000000
            0xFC, 0x00, 0x03, 0xF0, 0x07, 0xE0, ##  000000                000000         000000
            0xFC, 0x00, 0x07, 0xE0, 0x07, 0xE0, ##  000000               000000          000000
            0xFC, 0x00, 0x0F, 0xC0, 0x07, 0xE0, ##  000000              000000           000000
            0xFC, 0x00, 0x1F, 0xC0, 0x07, 0xE0, ##  000000             0000000           000000
            0xFC, 0x00, 0x3F, 0x80, 0x07, 0xE0, ##  000000            0000000            000000
            0xFC, 0x00, 0x7F, 0x00, 0x07, 0xE0, ##  000000           0000000             000000
            0xFC, 0x00, 0x7E, 0x00, 0x07, 0xE0, ##  000000           000000              000000
            0xFC, 0x00, 0xFC, 0x00, 0x07, 0xE0, ##  000000          000000               000000
            0xFC, 0x01, 0xF8, 0x00, 0x07, 0xE0, ##  000000         000000                000000
            0xFC, 0x03, 0xF0, 0x00, 0x07, 0xE0, ##  000000        000000                 000000
            0xFC, 0x07, 0xE0, 0x00, 0x0F, 0xE0, ##  000000       000000                 0000000
            0x7E, 0x0F, 0xE0, 0x00, 0x0F, 0xC0, ##   000000     0000000                 000000 
            0x7E, 0x0F, 0xC0, 0x00, 0x0F, 0xC0, ##   000000     000000                  000000 
            0x7E, 0x1F, 0x80, 0x00, 0x0F, 0xC0, ##   000000    000000                   000000 
            0x7F, 0x3F, 0x00, 0x00, 0x1F, 0xC0, ##   0000000  000000                   0000000 
            0x3F, 0x7E, 0x00, 0x00, 0x1F, 0x80, ##    000000 000000                    000000  
            0x3F, 0xFC, 0x00, 0x00, 0x3F, 0x80, ##    000000000000                    0000000  
            0x1F, 0xF8, 0x00, 0x00, 0x3F, 0x00, ##     0000000000                     000000   
            0x1F, 0xF0, 0x00, 0x00, 0x7F, 0x00, ##     000000000                     0000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFE, 0x00, ##      00000000                    0000000    
            0x0F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##      00000000                   00000000    
            0x07, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##       00000000                 00000000     
            0x0F, 0xFE, 0x00, 0x0F, 0xF8, 0x00, ##      00000000000             000000000      
            0x1F, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##     000000000000000        0000000000       
            0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##    000000000000000000000000000000000        
            0x7C, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##   00000   0000000000000000000000000         
            0xFC, 0x3F, 0xFF, 0xFF, 0x00, 0x00, ##  000000    0000000000000000000000           
            0xF8, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##  00000        00000000000000000             
            0x70, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##   000            0000000000                 
            0x20, 0x00, 0x00, 0x00, 0x00, 0x00, ##    0                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x3F, 0x00, 0x00, 0x00, ##            000000                    
            0x00, 0x1F, 0x80, 0x00, 0x00, ##             000000                   
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                  
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000                  
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000                 
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000                
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000               
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x0F, 0xE0, ##   000000                     0000000 
            0x7F, 0x00, 0x00, 0x0F, 0xC0, ##   0000000                    000000  
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x3F, 0xC0, 0x00, 0x3F, 0xC0, ##    00000000                00000000  
            0x1F, 0xE0, 0x00, 0x7F, 0x80, ##     00000000              00000000   
            0x0F, 0xFC, 0x03, 0xFF, 0x00, ##      0000000000        0000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0x00, ##         0000000000000000000000       
            0x00, 0x7F, 0xFF, 0xE0, 0x00, ##           000000000000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000          
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000           
            0x00, 0x00, 0x3F, 0x00, 0x00, ##                    000000            
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000             
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000              
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000               
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000                
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x0F, 0xE0, ##   000000                     0000000 
            0x7F, 0x00, 0x00, 0x0F, 0xC0, ##   0000000                    000000  
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x3F, 0xC0, 0x00, 0x3F, 0xC0, ##    00000000                00000000  
            0x1F, 0xE0, 0x00, 0x7F, 0x80, ##     00000000              00000000   
            0x0F, 0xFC, 0x03, 0xFF, 0x00, ##      0000000000        0000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0x00, ##         0000000000000000000000       
            0x00, 0x7F, 0xFF, 0xE0, 0x00, ##           000000000000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000               
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000              
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000            
            0x00, 0x0F, 0x9F, 0x00, 0x00, ##              00000  00000            
            0x00, 0x1F, 0x0F, 0x80, 0x00, ##             00000    00000           
            0x00, 0x3E, 0x07, 0xC0, 0x00, ##            00000      00000          
            0x00, 0x7C, 0x03, 0xE0, 0x00, ##           00000        00000         
            0x00, 0xF8, 0x01, 0xF0, 0x00, ##          00000          00000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFE, 0x00, 0x00, 0x07, 0xF0, ##  0000000                      0000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x0F, 0xE0, ##   000000                     0000000 
            0x7F, 0x00, 0x00, 0x0F, 0xC0, ##   0000000                    000000  
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x3F, 0xC0, 0x00, 0x3F, 0xC0, ##    00000000                00000000  
            0x1F, 0xE0, 0x00, 0x7F, 0x80, ##     00000000              00000000   
            0x0F, 0xFC, 0x03, 0xFF, 0x00, ##      0000000000        0000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0x00, ##         0000000000000000000000       
            0x00, 0x7F, 0xFF, 0xE0, 0x00, ##           000000000000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x7E, 0x07, 0xE0, 0x00, ##           000000      000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x03, 0xF0, ##  000000                        000000
            0xFC, 0x00, 0x00, 0x07, 0xF0, ##  000000                       0000000
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7E, 0x00, 0x00, 0x07, 0xE0, ##   000000                      000000 
            0x7F, 0x00, 0x00, 0x0F, 0xE0, ##   0000000                    0000000 
            0x3F, 0x80, 0x00, 0x1F, 0xC0, ##    0000000                  0000000  
            0x3F, 0xC0, 0x00, 0x3F, 0xC0, ##    00000000                00000000  
            0x1F, 0xE0, 0x00, 0x7F, 0x80, ##     00000000              00000000   
            0x0F, 0xFC, 0x03, 0xFF, 0x00, ##      0000000000        0000000000    
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0x00, ##         0000000000000000000000       
            0x00, 0x7F, 0xFF, 0xE0, 0x00, ##           000000000000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 39, 
        'xoffset'  => 0, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x07, 0xC0, 0x00, ##                       00000             
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000             
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000              
            0x00, 0x00, 0x3F, 0x00, 0x00, ##                    000000               
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000                
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000                  
            0x00, 0x00, 0xF0, 0x00, 0x00, ##                  0000                   
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFE, 0x00, 0x00, 0x01, 0xFC, ##  0000000                        0000000 
            0x7E, 0x00, 0x00, 0x01, 0xFC, ##   000000                        0000000 
            0x7F, 0x00, 0x00, 0x03, 0xF8, ##   0000000                      0000000  
            0x3F, 0x80, 0x00, 0x07, 0xF0, ##    0000000                    0000000   
            0x1F, 0x80, 0x00, 0x07, 0xF0, ##     000000                    0000000   
            0x1F, 0xC0, 0x00, 0x0F, 0xE0, ##     0000000                  0000000    
            0x0F, 0xE0, 0x00, 0x1F, 0xC0, ##      0000000                0000000     
            0x07, 0xE0, 0x00, 0x1F, 0x80, ##       000000                000000      
            0x07, 0xF0, 0x00, 0x3F, 0x80, ##       0000000              0000000      
            0x03, 0xF8, 0x00, 0x7F, 0x00, ##        0000000            0000000       
            0x01, 0xF8, 0x00, 0x7E, 0x00, ##         000000            000000        
            0x01, 0xFC, 0x00, 0xFE, 0x00, ##         0000000          0000000        
            0x00, 0xFE, 0x00, 0xFC, 0x00, ##          0000000         000000         
            0x00, 0x7E, 0x01, 0xF8, 0x00, ##           000000        000000          
            0x00, 0x7F, 0x03, 0xF8, 0x00, ##           0000000      0000000          
            0x00, 0x3F, 0x83, 0xF0, 0x00, ##            0000000     000000           
            0x00, 0x1F, 0x87, 0xE0, 0x00, ##             000000    000000            
            0x00, 0x1F, 0xCF, 0xE0, 0x00, ##             0000000  0000000            
            0x00, 0x0F, 0xCF, 0xC0, 0x00, ##              000000  000000             
            0x00, 0x07, 0xFF, 0x80, 0x00, ##               000000000000              
            0x00, 0x07, 0xFF, 0x80, 0x00, ##               000000000000              
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000               
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 30, 
        'xoffset'  => 6, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000           
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0xFC, 0x00, 0x3F, 0xF0, ##  000000            0000000000  
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000  
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000 
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000 
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000 
            0xFC, 0x00, 0x0F, 0xF0, ##  000000              00000000  
            0xFC, 0x00, 0x3F, 0xF0, ##  000000            0000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000     
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000       
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000          
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0xFC, 0x00, 0x00, 0x00, ##  000000                        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 32, 
        'xoffset'  => 6, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xE0, 0x00, ##            000000000             
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000          
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000         
            0x0F, 0xFF, 0xFF, 0x00, ##      00000000000000000000        
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000       
            0x3F, 0xE0, 0x3F, 0xC0, ##    000000000       00000000      
            0x7F, 0x80, 0x0F, 0xC0, ##   00000000           000000      
            0x7F, 0x00, 0x07, 0xE0, ##   0000000             000000     
            0x7E, 0x00, 0x07, 0xE0, ##   000000              000000     
            0xFE, 0x00, 0x03, 0xE0, ##  0000000               00000     
            0xFC, 0x00, 0x03, 0xF0, ##  000000                000000    
            0xFC, 0x00, 0x03, 0xF0, ##  000000                000000    
            0xFC, 0x00, 0x1F, 0xF0, ##  000000             000000000    
            0xFC, 0x00, 0x7F, 0xF0, ##  000000           00000000000    
            0xFC, 0x00, 0xFF, 0xF0, ##  000000          000000000000    
            0xFC, 0x01, 0xFC, 0x00, ##  000000         0000000          
            0xFC, 0x03, 0xF8, 0x00, ##  000000        0000000           
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000             
            0xFC, 0x07, 0xE0, 0x00, ##  000000       000000             
            0xFC, 0x0F, 0xC0, 0x00, ##  000000      000000              
            0xFC, 0x0F, 0xC0, 0x00, ##  000000      000000              
            0xFC, 0x0F, 0xC0, 0x00, ##  000000      000000              
            0xFC, 0x0F, 0xC0, 0x00, ##  000000      000000              
            0xFC, 0x0F, 0xE0, 0x00, ##  000000      0000000             
            0xFC, 0x0F, 0xE0, 0x00, ##  000000      0000000             
            0xFC, 0x07, 0xF0, 0x00, ##  000000       0000000            
            0xFC, 0x07, 0xFC, 0x00, ##  000000       000000000          
            0xFC, 0x03, 0xFE, 0x00, ##  000000        000000000         
            0xFC, 0x01, 0xFF, 0x80, ##  000000         0000000000       
            0xFC, 0x00, 0xFF, 0xC0, ##  000000          0000000000      
            0xFC, 0x00, 0x7F, 0xF0, ##  000000           00000000000    
            0xFC, 0x00, 0x1F, 0xF8, ##  000000             0000000000   
            0xFC, 0x00, 0x07, 0xFC, ##  000000               000000000  
            0xFC, 0x00, 0x03, 0xFE, ##  000000                000000000 
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000 
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000 
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0xFC, 0x40, 0x00, 0xFE, ##  000000   0              0000000 
            0xFC, 0x7C, 0x03, 0xFE, ##  000000   00000        000000000 
            0xFC, 0x7F, 0xFF, 0xFC, ##  000000   000000000000000000000  
            0xFC, 0x7F, 0xFF, 0xF8, ##  000000   00000000000000000000   
            0xFC, 0x7F, 0xFF, 0xF0, ##  000000   0000000000000000000    
            0xFC, 0x3F, 0xFF, 0xC0, ##  000000    0000000000000000      
            0x00, 0x07, 0xFE, 0x00, ##               0000000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x0F, 0xC0, 0x00, 0x00, ##      000000                    
            0x07, 0xE0, 0x00, 0x00, ##       000000                   
            0x03, 0xF0, 0x00, 0x00, ##        000000                  
            0x01, 0xF8, 0x00, 0x00, ##         000000                 
            0x00, 0xF8, 0x00, 0x00, ##          00000                 
            0x00, 0xFC, 0x00, 0x00, ##          000000                
            0x00, 0x7E, 0x00, 0x00, ##           000000               
            0x00, 0x3F, 0x00, 0x00, ##            000000              
            0x00, 0x1F, 0x00, 0x00, ##             00000              
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x07, 0xC0, 0x00, ##               00000            
            0x00, 0x03, 0xC0, 0x00, ##                0000            
            0x00, 0x03, 0xE0, 0x00, ##                00000           
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000    
            0x00, 0x00, 0x1F, 0x80, ##                     000000     
            0x00, 0x00, 0x3F, 0x00, ##                    000000      
            0x00, 0x00, 0x7E, 0x00, ##                   000000       
            0x00, 0x00, 0xFC, 0x00, ##                  000000        
            0x00, 0x00, 0xF8, 0x00, ##                  00000         
            0x00, 0x01, 0xF0, 0x00, ##                 00000          
            0x00, 0x03, 0xF0, 0x00, ##                000000          
            0x00, 0x07, 0xE0, 0x00, ##               000000           
            0x00, 0x07, 0xC0, 0x00, ##               00000            
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x1F, 0x00, 0x00, ##             00000              
            0x00, 0x1E, 0x00, 0x00, ##             0000               
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, 0x00, ##               0000             
            0x00, 0x0F, 0xC0, 0x00, ##              000000            
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x1F, 0xE0, 0x00, ##             00000000           
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x00, 0x7C, 0xF0, 0x00, ##           00000  0000          
            0x00, 0x7C, 0xF8, 0x00, ##           00000  00000         
            0x00, 0xF8, 0x7C, 0x00, ##          00000    00000        
            0x00, 0xF0, 0x3C, 0x00, ##          0000      0000        
            0x01, 0xF0, 0x3E, 0x00, ##         00000      00000       
            0x03, 0xE0, 0x1F, 0x00, ##        00000        00000      
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000      
            0x07, 0x80, 0x07, 0x80, ##       0000            0000     
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x07, 0x80, ##          0000         0000     
            0x03, 0xFC, 0x07, 0x80, ##        00000000       0000     
            0x03, 0xFE, 0x07, 0x80, ##        000000000      0000     
            0x07, 0xFF, 0x07, 0x80, ##       00000000000     0000     
            0x07, 0x8F, 0x8F, 0x00, ##       0000   00000   0000      
            0x0F, 0x07, 0xFF, 0x00, ##      0000     00000000000      
            0x0F, 0x03, 0xFE, 0x00, ##      0000      000000000       
            0x0F, 0x01, 0xFE, 0x00, ##      0000       00000000       
            0x0F, 0x00, 0xF8, 0x00, ##      0000        00000         
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000           
            0x07, 0xFF, 0xFE, 0x00, ##       000000000000000000       
            0x3F, 0xFF, 0xFF, 0x00, ##    0000000000000000000000      
            0x3F, 0xFF, 0xFF, 0xC0, ##    000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xE0, ##    0000000000000000000000000   
            0x3F, 0x80, 0x3F, 0xE0, ##    0000000         000000000   
            0x38, 0x00, 0x0F, 0xF0, ##    000               00000000  
            0x20, 0x00, 0x03, 0xF0, ##    0                   000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x03, 0xF0, 0x3F, 0x00, ##        000000      000000      
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 30, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x3F, 0xE0, 0x00, ##            000000000           
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000         
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000         
            0x01, 0xF0, 0x7C, 0x00, ##         00000     00000        
            0x03, 0xE0, 0x3C, 0x00, ##        00000       0000        
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x03, 0xC0, 0x1E, 0x00, ##        0000         0000       
            0x03, 0xE0, 0x3E, 0x00, ##        00000       00000       
            0x01, 0xF0, 0x7C, 0x00, ##         00000     00000        
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000         
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000         
            0x00, 0x3F, 0xE0, 0x00, ##            000000000           
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x00, 0x00, 0x00, ##                                
            0x00, 0x3F, 0xF0, 0x00, ##            0000000000          
            0x03, 0xFF, 0xFE, 0x00, ##        00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xE0, ##     000000000000000000000000   
            0x1F, 0x80, 0x3F, 0xE0, ##     000000         000000000   
            0x1C, 0x00, 0x0F, 0xF0, ##     000              00000000  
            0x10, 0x00, 0x03, 0xF0, ##     0                  000000  
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000 
            0x00, 0x00, 0x00, 0xF8, ##                          00000 
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x00, 0x00, 0xFC, ##                          000000
            0x00, 0x3F, 0xFF, 0xFC, ##            00000000000000000000
            0x01, 0xFF, 0xFF, 0xFC, ##         00000000000000000000000
            0x07, 0xFF, 0xFF, 0xFC, ##       0000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFC, ##     000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFC, ##    0000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFC, ##    0000000000            000000
            0x7F, 0x80, 0x00, 0xFC, ##   00000000               000000
            0x7E, 0x00, 0x00, 0xFC, ##   000000                 000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000
            0xFC, 0x00, 0x00, 0xFC, ##  000000                  000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x01, 0xFC, ##  000000                 0000000
            0xFC, 0x00, 0x03, 0xFC, ##  000000                00000000
            0xFE, 0x00, 0x07, 0xFC, ##  0000000              000000000
            0xFE, 0x00, 0x0F, 0xFC, ##  0000000             0000000000
            0x7F, 0x00, 0x1F, 0xFC, ##   0000000           00000000000
            0x7F, 0xC0, 0x7E, 0xFC, ##   000000000       000000 000000
            0x3F, 0xFF, 0xFE, 0xFC, ##    000000000000000000000 000000
            0x1F, 0xFF, 0xFC, 0xFC, ##     0000000000000000000  000000
            0x0F, 0xFF, 0xF8, 0xFC, ##      00000000000000000   000000
            0x07, 0xFF, 0xE0, 0xFC, ##       00000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 56, 
        'xoffset'  => 4, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xE0, 0x00, 0x0F, 0xF8, 0x00, ##            000000000                 000000000           
            0x07, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0x00, ##       00000000000000000           000000000000000        
            0x1F, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x80, ##     000000000000000000000       000000000000000000       
            0x1F, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xE0, ##     00000000000000000000000    000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xF0, ##     000000000000000000000000  00000000000000000000000    
            0x1F, 0x80, 0x3F, 0xEF, 0xF8, 0x0F, 0xF8, ##     000000         000000000 000000000       000000000   
            0x1C, 0x00, 0x0F, 0xFF, 0xE0, 0x03, 0xF8, ##     000              000000000000000           0000000   
            0x10, 0x00, 0x03, 0xFF, 0x80, 0x01, 0xFC, ##     0                  00000000000              0000000  
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0xFC, ##                         000000000                000000  
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x7E, ##                         000000000                 000000 
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x7E, ##                          0000000                  000000 
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x3E, ##                          0000000                   00000 
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x3F, ##                          000000                    000000
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x3F, ##                          000000                    000000
            0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x3F, ##            00000000000000000000                    000000
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##         0000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##       000000000000000000000000000000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##     00000000000000000000000000000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##    000000000000000000000000000000000000000000000000000000
            0x3F, 0xF0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, ##    0000000000            00000000000000000000000000000000
            0x7F, 0x80, 0x00, 0xFC, 0x00, 0x00, 0x00, ##   00000000               000000                          
            0x7E, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##   000000                 000000                          
            0xFE, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##  0000000                 000000                          
            0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##  000000                  000000                          
            0xFC, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##  000000                 00000000                         
            0xFC, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##  000000                 00000000                         
            0xFC, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##  000000                 00000000                         
            0xFC, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x00, ##  000000                0000000000                        
            0xFE, 0x00, 0x07, 0xFF, 0x80, 0x00, 0x00, ##  0000000              000000000000                       
            0xFE, 0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x06, ##  0000000             00000000000000                   00 
            0x7F, 0x00, 0x1F, 0xDF, 0xE0, 0x00, 0x1E, ##   0000000           0000000 00000000                0000 
            0x7F, 0xC0, 0x7F, 0x8F, 0xFC, 0x01, 0xFE, ##   000000000       00000000   0000000000         00000000 
            0x3F, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFE, ##    0000000000000000000000     00000000000000000000000000 
            0x1F, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xFE, ##     00000000000000000000       0000000000000000000000000 
            0x0F, 0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0xFC, ##      000000000000000000          0000000000000000000000  
            0x07, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0xE0, ##       000000000000000             000000000000000000     
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFE, 0x00, ##          000000000                    0000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 28, 
        'xoffset'  => 4, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFC, 0x00, ##               000000000      
            0x00, 0x3F, 0xFF, 0xC0, ##            0000000000000000  
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x0F, 0xFC, 0x03, 0xF0, ##      0000000000        000000
            0x1F, 0xF0, 0x00, 0x70, ##     000000000             000
            0x1F, 0xC0, 0x00, 0x10, ##     0000000                 0
            0x3F, 0x80, 0x00, 0x00, ##    0000000                   
            0x3F, 0x00, 0x00, 0x00, ##    000000                    
            0x7F, 0x00, 0x00, 0x00, ##   0000000                    
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0xFE, 0x00, 0x00, 0x00, ##  0000000                     
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFC, 0x00, 0x00, 0x00, ##  000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7E, 0x00, 0x00, 0x00, ##   000000                     
            0x7F, 0x00, 0x00, 0x00, ##   0000000                    
            0x3F, 0x00, 0x00, 0x00, ##    000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                   
            0x1F, 0xC0, 0x00, 0x10, ##     0000000                 0
            0x1F, 0xE0, 0x00, 0x70, ##     00000000              000
            0x0F, 0xFC, 0x03, 0xF0, ##      0000000000        000000
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000
            0x00, 0xFF, 0xFF, 0xF0, ##          00000000000000000000
            0x00, 0x7F, 0xFF, 0xC0, ##           00000000000000000  
            0x00, 0x07, 0xFC, 0x00, ##               000000000      
            0x00, 0x00, 0x78, 0x00, ##                   0000       
            0x00, 0x00, 0x3C, 0x00, ##                    0000      
            0x00, 0x00, 0x3C, 0x00, ##                    0000      
            0x00, 0x00, 0x1E, 0x00, ##                     0000     
            0x00, 0x00, 0x1E, 0x00, ##                     0000     
            0x00, 0x00, 0x1E, 0x00, ##                     0000     
            0x00, 0x20, 0x3E, 0x00, ##            0       00000     
            0x00, 0x3F, 0xFE, 0x00, ##            0000000000000     
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000      
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000       
            0x00, 0x1F, 0xE0, 0x00, ##             00000000         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xF0, 0x00, 0x00, 0x00, ##        000000                     
            0x01, 0xF8, 0x00, 0x00, 0x00, ##         000000                    
            0x00, 0xFC, 0x00, 0x00, 0x00, ##          000000                   
            0x00, 0x7E, 0x00, 0x00, 0x00, ##           000000                  
            0x00, 0x7E, 0x00, 0x00, 0x00, ##           000000                  
            0x00, 0x3F, 0x00, 0x00, 0x00, ##            000000                 
            0x00, 0x1F, 0x80, 0x00, 0x00, ##             000000                
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000               
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000               
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000              
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000             
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000            
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000        
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000    
            0x0F, 0xFC, 0x07, 0xF8, 0x00, ##      0000000000       00000000    
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000   
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000  
            0x3F, 0x80, 0x00, 0x7E, 0x00, ##    0000000                000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000 
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                         
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                        
            0x1F, 0xC0, 0x00, 0x03, 0x00, ##     0000000                    00 
            0x0F, 0xE0, 0x00, 0x0F, 0x00, ##      0000000                 0000 
            0x0F, 0xFC, 0x00, 0xFF, 0x00, ##      0000000000          00000000 
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xF0, 0x00, ##            000000000000000000     
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xF0, 0x00, ##                       0000000     
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000      
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000       
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000        
            0x00, 0x00, 0x3F, 0x00, 0x00, ##                    000000         
            0x00, 0x00, 0x3E, 0x00, 0x00, ##                    00000          
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000          
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000           
            0x00, 0x01, 0xF8, 0x00, 0x00, ##                 000000            
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000             
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000              
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000               
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000        
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000    
            0x0F, 0xFC, 0x07, 0xF8, 0x00, ##      0000000000       00000000    
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000   
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000  
            0x3F, 0x80, 0x00, 0x7E, 0x00, ##    0000000                000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000 
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                         
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                        
            0x1F, 0xC0, 0x00, 0x03, 0x00, ##     0000000                    00 
            0x0F, 0xE0, 0x00, 0x0F, 0x00, ##      0000000                 0000 
            0x0F, 0xFC, 0x00, 0xFF, 0x00, ##      0000000000          00000000 
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xF0, 0x00, ##            000000000000000000     
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xE0, 0x00, 0x00, ##                 0000              
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000           
            0x00, 0x1F, 0x3E, 0x00, 0x00, ##             00000  00000          
            0x00, 0x1F, 0x3E, 0x00, 0x00, ##             00000  00000          
            0x00, 0x3E, 0x1F, 0x00, 0x00, ##            00000    00000         
            0x00, 0x7C, 0x0F, 0x80, 0x00, ##           00000      00000        
            0x00, 0x78, 0x0F, 0x80, 0x00, ##           0000       00000        
            0x00, 0xF8, 0x07, 0xC0, 0x00, ##          00000        00000       
            0x01, 0xF0, 0x03, 0xC0, 0x00, ##         00000          0000       
            0x01, 0xE0, 0x01, 0xE0, 0x00, ##         0000            0000      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000        
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000    
            0x0F, 0xFC, 0x07, 0xF8, 0x00, ##      0000000000       00000000    
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000   
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000  
            0x3F, 0x80, 0x00, 0x7E, 0x00, ##    0000000                000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000 
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                         
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                        
            0x1F, 0xC0, 0x00, 0x03, 0x00, ##     0000000                    00 
            0x0F, 0xE0, 0x00, 0x0F, 0x00, ##      0000000                 0000 
            0x0F, 0xFC, 0x00, 0xFF, 0x00, ##      0000000000          00000000 
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xF0, 0x00, ##            000000000000000000     
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000       
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x3F, 0xFF, 0x80, 0x00, ##            000000000000000        
            0x00, 0xFF, 0xFF, 0xC0, 0x00, ##          000000000000000000       
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000     
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000    
            0x0F, 0xFC, 0x07, 0xF8, 0x00, ##      0000000000       00000000    
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000   
            0x1F, 0xC0, 0x00, 0xFE, 0x00, ##     0000000              0000000  
            0x3F, 0x80, 0x00, 0x7E, 0x00, ##    0000000                000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7E, 0x00, 0x00, 0x1F, 0x00, ##   000000                    00000 
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0x7C, 0x00, 0x00, 0x1F, 0x80, ##   00000                     000000
            0xFC, 0x00, 0x00, 0x1F, 0x80, ##  000000                     000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0xFC, 0x00, 0x00, 0x00, 0x00, ##  000000                           
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x7E, 0x00, 0x00, 0x00, 0x00, ##   000000                          
            0x3F, 0x00, 0x00, 0x00, 0x00, ##    000000                         
            0x3F, 0x80, 0x00, 0x00, 0x00, ##    0000000                        
            0x1F, 0xC0, 0x00, 0x03, 0x00, ##     0000000                    00 
            0x0F, 0xE0, 0x00, 0x0F, 0x00, ##      0000000                 0000 
            0x0F, 0xFC, 0x00, 0xFF, 0x00, ##      0000000000          00000000 
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xF0, 0x00, ##            000000000000000000     
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 15, 
        'xoffset'  => -2, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFC, 0x00, ##  000000         
            0x7E, 0x00, ##   000000        
            0x3F, 0x00, ##    000000       
            0x1F, 0x80, ##     000000      
            0x0F, 0x80, ##      00000      
            0x0F, 0xC0, ##      000000     
            0x07, 0xE0, ##       000000    
            0x03, 0xF0, ##        000000   
            0x01, 0xF0, ##         00000   
            0x00, 0xF8, ##          00000  
            0x00, 0x7C, ##           00000 
            0x00, 0x3E, ##            00000
            0x00, 0x3E, ##            00000
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0xFC, ##          000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 16, 
        'xoffset'  => 4, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x7F, ##           0000000
            0x00, 0x7E, ##           000000 
            0x00, 0xFC, ##          000000  
            0x01, 0xF8, ##         000000   
            0x03, 0xF0, ##        000000    
            0x03, 0xE0, ##        00000     
            0x07, 0xE0, ##       000000     
            0x0F, 0xC0, ##      000000      
            0x1F, 0x80, ##     000000       
            0x1F, 0x00, ##     00000        
            0x3E, 0x00, ##    00000         
            0x7C, 0x00, ##   00000          
            0xF8, 0x00, ##  00000           
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x3F, 0x00, ##    000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 20, 
        'xoffset'  => -1, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xF8, 0x00, ##         000000       
            0x03, 0xFC, 0x00, ##        00000000      
            0x03, 0xFC, 0x00, ##        00000000      
            0x07, 0xFE, 0x00, ##       0000000000     
            0x0F, 0x9F, 0x00, ##      00000  00000    
            0x0F, 0x9F, 0x00, ##      00000  00000    
            0x1F, 0x0F, 0x80, ##     00000    00000   
            0x3E, 0x07, 0xC0, ##    00000      00000  
            0x3C, 0x03, 0xC0, ##    0000        0000  
            0x7C, 0x03, 0xE0, ##   00000        00000 
            0x78, 0x01, 0xE0, ##   0000          0000 
            0xF0, 0x00, 0xF0, ##  0000            0000
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x00, 0x00, 0x00, ##                      
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x01, 0xF8, 0x00, ##         000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 18, 
        'xoffset'  => 0, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0xFC, 0x0F, 0xC0, ##  000000      000000
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x03, 0xF0, 0x00, ##        000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFC, 0x00, 0x00, ##         0000000                  
            0x01, 0xFE, 0x00, 0x30, ##         00000000           00    
            0x00, 0xFF, 0x01, 0xF0, ##          00000000       00000    
            0x00, 0x7F, 0x0F, 0xF0, ##           0000000    00000000    
            0x00, 0x3F, 0xFF, 0xE0, ##            00000000000000000     
            0x00, 0x1F, 0xFF, 0x00, ##             0000000000000        
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000            
            0x07, 0xFF, 0xF8, 0x00, ##       0000000000000000           
            0x1F, 0xF1, 0xFC, 0x00, ##     000000000   0000000          
            0x0F, 0x80, 0xFC, 0x00, ##      00000       000000          
            0x0C, 0x00, 0xFE, 0x00, ##      00          0000000         
            0x00, 0x00, 0x7F, 0x00, ##                   0000000        
            0x00, 0x00, 0x3F, 0x80, ##                    0000000       
            0x00, 0x1F, 0xFF, 0xC0, ##             000000000000000      
            0x00, 0x7F, 0xFF, 0xE0, ##           000000000000000000     
            0x01, 0xFF, 0xFF, 0xE0, ##         00000000000000000000     
            0x03, 0xFF, 0xFF, 0xF0, ##        0000000000000000000000    
            0x07, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000    
            0x0F, 0xF8, 0x07, 0xF8, ##      000000000        00000000   
            0x1F, 0xE0, 0x01, 0xFC, ##     00000000            0000000  
            0x3F, 0xC0, 0x00, 0xFC, ##    00000000              000000  
            0x3F, 0x80, 0x00, 0xFC, ##    0000000               000000  
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7F, 0x00, 0x00, 0x7E, ##   0000000                 000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0xFE, ##   000000                 0000000 
            0x3F, 0x00, 0x00, 0xFC, ##    000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x1F, 0xC0, 0x03, 0xF8, ##     0000000            0000000   
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 29, 
        'xoffset'  => 6, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x07, 0x80, ##           0000        0000    
            0x01, 0xFC, 0x07, 0x80, ##         0000000       0000    
            0x03, 0xFF, 0x07, 0x80, ##        0000000000     0000    
            0x03, 0xFF, 0x07, 0x80, ##        0000000000     0000    
            0x03, 0xCF, 0xCF, 0x00, ##        0000  000000  0000     
            0x07, 0x83, 0xFF, 0x00, ##       0000     0000000000     
            0x07, 0x83, 0xFF, 0x00, ##       0000     0000000000     
            0x07, 0x81, 0xFE, 0x00, ##       0000      00000000      
            0x07, 0x80, 0x78, 0x00, ##       0000        0000        
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x07, 0xF8, 0x00, ##               00000000        
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000      
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000   
            0xFD, 0xFF, 0xFF, 0xC0, ##  000000 0000000000000000000   
            0xFD, 0xF0, 0x3F, 0xE0, ##  000000 00000      000000000  
            0xFF, 0xC0, 0x0F, 0xF0, ##  0000000000          00000000 
            0xFF, 0x80, 0x07, 0xF0, ##  000000000            0000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFF, 0x00, 0x03, 0xF0, ##  00000000              000000 
            0xFE, 0x00, 0x03, 0xF8, ##  0000000               0000000
            0xFE, 0x00, 0x01, 0xF8, ##  0000000                000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, 0x00, ##       000000                     
            0x03, 0xF0, 0x00, 0x00, ##        000000                    
            0x01, 0xF8, 0x00, 0x00, ##         000000                   
            0x00, 0xFC, 0x00, 0x00, ##          000000                  
            0x00, 0x7C, 0x00, 0x00, ##           00000                  
            0x00, 0x3E, 0x00, 0x00, ##            00000                 
            0x00, 0x3F, 0x00, 0x00, ##            000000                
            0x00, 0x1F, 0x80, 0x00, ##             000000               
            0x00, 0x0F, 0x80, 0x00, ##              00000               
            0x00, 0x07, 0xC0, 0x00, ##               00000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x01, 0xF0, 0x00, ##                 00000            
            0x00, 0x00, 0xF0, 0x00, ##                  0000            
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000     
            0x00, 0x00, 0x0F, 0xC0, ##                      000000      
            0x00, 0x00, 0x1F, 0x80, ##                     000000       
            0x00, 0x00, 0x3F, 0x00, ##                    000000        
            0x00, 0x00, 0x7E, 0x00, ##                   000000         
            0x00, 0x00, 0x7C, 0x00, ##                   00000          
            0x00, 0x00, 0xF8, 0x00, ##                  00000           
            0x00, 0x01, 0xF8, 0x00, ##                 000000           
            0x00, 0x01, 0xF0, 0x00, ##                 00000            
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xC0, 0x00, ##               00000              
            0x00, 0x0F, 0x80, 0x00, ##              00000               
            0x00, 0x0F, 0x00, 0x00, ##              0000                
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x3E, 0x7C, 0x00, ##            00000  00000          
            0x00, 0x3E, 0x7C, 0x00, ##            00000  00000          
            0x00, 0x7C, 0x3E, 0x00, ##           00000    00000         
            0x00, 0x78, 0x1E, 0x00, ##           0000      0000         
            0x00, 0xF8, 0x1F, 0x00, ##          00000      00000        
            0x01, 0xF0, 0x0F, 0x80, ##         00000        00000       
            0x01, 0xE0, 0x07, 0x80, ##         0000          0000       
            0x03, 0xC0, 0x03, 0xC0, ##        0000            0000      
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3C, 0x03, 0xC0, ##            0000        0000      
            0x00, 0xFE, 0x03, 0xC0, ##          0000000       0000      
            0x01, 0xFF, 0x83, 0xC0, ##         0000000000     0000      
            0x01, 0xFF, 0x83, 0xC0, ##         0000000000     0000      
            0x01, 0xE7, 0xE7, 0x80, ##         0000  000000  0000       
            0x03, 0xC1, 0xFF, 0x80, ##        0000     0000000000       
            0x03, 0xC1, 0xFF, 0x80, ##        0000     0000000000       
            0x03, 0xC0, 0xFF, 0x00, ##        0000      00000000        
            0x03, 0xC0, 0x3C, 0x00, ##        0000        0000          
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 32, 
        'xoffset'  => 4, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x01, 0xF8, 0x1F, 0x80, ##         000000      000000       
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x3F, ##  000000                    000000
            0xFC, 0x00, 0x00, 0x7F, ##  000000                   0000000
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7E, 0x00, 0x00, 0x7E, ##   000000                  000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFC, ##   0000000                000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 40, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                          
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 34, 
        'xoffset'  => 3, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x01, 0x00, ##                                 0  
            0x00, 0x00, 0x00, 0x03, 0x80, ##                                000 
            0x00, 0x07, 0xF8, 0x07, 0xC0, ##               00000000        00000
            0x00, 0x3F, 0xFF, 0x0F, 0x80, ##            00000000000000    00000 
            0x00, 0xFF, 0xFF, 0xCF, 0x80, ##          000000000000000000  00000 
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000  
            0x03, 0xFF, 0xFF, 0xFE, 0x00, ##        0000000000000000000000000   
            0x07, 0xFC, 0x0F, 0xFC, 0x00, ##       000000000      0000000000    
            0x0F, 0xF0, 0x03, 0xFC, 0x00, ##      00000000          00000000    
            0x1F, 0xE0, 0x01, 0xFC, 0x00, ##     00000000            0000000    
            0x1F, 0xC0, 0x01, 0xFE, 0x00, ##     0000000             00000000   
            0x3F, 0x80, 0x03, 0xFE, 0x00, ##    0000000             000000000   
            0x3F, 0x80, 0x07, 0xFF, 0x00, ##    0000000            00000000000  
            0x3F, 0x00, 0x0F, 0xBF, 0x00, ##    000000            00000 000000  
            0x3F, 0x00, 0x1F, 0x3F, 0x00, ##    000000           00000  000000  
            0x7F, 0x00, 0x1F, 0x1F, 0x80, ##   0000000           00000   000000 
            0x7E, 0x00, 0x3E, 0x1F, 0x80, ##   000000           00000    000000 
            0x7E, 0x00, 0x7C, 0x1F, 0x80, ##   000000          00000     000000 
            0x7E, 0x00, 0xF8, 0x1F, 0x80, ##   000000         00000      000000 
            0x7E, 0x01, 0xF0, 0x1F, 0x80, ##   000000        00000       000000 
            0x7E, 0x03, 0xE0, 0x1F, 0x80, ##   000000       00000        000000 
            0x7E, 0x03, 0xE0, 0x1F, 0x80, ##   000000       00000        000000 
            0x7E, 0x07, 0xC0, 0x1F, 0x80, ##   000000      00000         000000 
            0x7E, 0x0F, 0x80, 0x1F, 0x80, ##   000000     00000          000000 
            0x7E, 0x1F, 0x00, 0x1F, 0x80, ##   000000    00000           000000 
            0x7E, 0x3E, 0x00, 0x3F, 0x80, ##   000000   00000           0000000 
            0x3F, 0x7E, 0x00, 0x3F, 0x00, ##    000000 000000           000000  
            0x3F, 0x7C, 0x00, 0x3F, 0x00, ##    000000 00000            000000  
            0x3F, 0xF8, 0x00, 0x7F, 0x00, ##    00000000000            0000000  
            0x1F, 0xF0, 0x00, 0x7E, 0x00, ##     000000000             000000   
            0x1F, 0xE0, 0x00, 0xFE, 0x00, ##     00000000             0000000   
            0x0F, 0xE0, 0x01, 0xFE, 0x00, ##      0000000            00000000   
            0x0F, 0xF0, 0x03, 0xFC, 0x00, ##      00000000          00000000    
            0x0F, 0xFC, 0x0F, 0xF8, 0x00, ##      0000000000      000000000     
            0x1F, 0xFF, 0xFF, 0xF0, 0x00, ##     0000000000000000000000000      
            0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##    0000000000000000000000000       
            0x7C, 0xFF, 0xFF, 0xC0, 0x00, ##   00000  000000000000000000        
            0x7C, 0x3F, 0xFF, 0x00, 0x00, ##   00000    00000000000000          
            0xF8, 0x07, 0xF8, 0x00, 0x00, ##  00000        00000000             
            0x70, 0x00, 0x00, 0x00, 0x00, ##   000                              
            0x20, 0x00, 0x00, 0x00, 0x00, ##    0                               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x0F, 0xC0, 0x00, 0x00, ##      000000                   
            0x07, 0xE0, 0x00, 0x00, ##       000000                  
            0x03, 0xE0, 0x00, 0x00, ##        00000                  
            0x03, 0xF0, 0x00, 0x00, ##        000000                 
            0x01, 0xF8, 0x00, 0x00, ##         000000                
            0x00, 0xF8, 0x00, 0x00, ##          00000                
            0x00, 0x7C, 0x00, 0x00, ##           00000               
            0x00, 0x3E, 0x00, 0x00, ##            00000              
            0x00, 0x3F, 0x00, 0x00, ##            000000             
            0x00, 0x1F, 0x00, 0x00, ##             00000             
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x07, 0xC0, 0x00, ##               00000           
            0x00, 0x03, 0xC0, 0x00, ##                0000           
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFE, 0x00, 0x07, 0xF8, ##  0000000              00000000
            0x7E, 0x00, 0x07, 0xF8, ##   000000              00000000
            0x7F, 0x00, 0x0F, 0xF8, ##   0000000            000000000
            0x7F, 0x80, 0x1F, 0xF8, ##   00000000          0000000000
            0x3F, 0xE0, 0x7D, 0xF8, ##    000000000      00000 000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x03, 0xFF, 0xC1, 0xF8, ##        000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0x00, ##                    000000     
            0x00, 0x00, 0x3F, 0x00, ##                    000000     
            0x00, 0x00, 0x7E, 0x00, ##                   000000      
            0x00, 0x00, 0xFC, 0x00, ##                  000000       
            0x00, 0x00, 0xF8, 0x00, ##                  00000        
            0x00, 0x01, 0xF0, 0x00, ##                 00000         
            0x00, 0x03, 0xF0, 0x00, ##                000000         
            0x00, 0x03, 0xE0, 0x00, ##                00000          
            0x00, 0x07, 0xC0, 0x00, ##               00000           
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x1F, 0x00, 0x00, ##             00000             
            0x00, 0x1E, 0x00, 0x00, ##             0000              
            0x00, 0x3E, 0x00, 0x00, ##            00000              
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFE, 0x00, 0x07, 0xF8, ##  0000000              00000000
            0x7E, 0x00, 0x07, 0xF8, ##   000000              00000000
            0x7F, 0x00, 0x0F, 0xF8, ##   0000000            000000000
            0x7F, 0x80, 0x1F, 0xF8, ##   00000000          0000000000
            0x3F, 0xE0, 0x7D, 0xF8, ##    000000000      00000 000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x03, 0xFF, 0xC1, 0xF8, ##        000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0x00, 0x00, ##              0000             
            0x00, 0x1F, 0x80, 0x00, ##             000000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x3F, 0xC0, 0x00, ##            00000000           
            0x00, 0x3F, 0xE0, 0x00, ##            000000000          
            0x00, 0x7D, 0xF0, 0x00, ##           00000 00000         
            0x00, 0xF8, 0xF0, 0x00, ##          00000   0000         
            0x00, 0xF0, 0xF8, 0x00, ##          0000    00000        
            0x01, 0xF0, 0x78, 0x00, ##         00000     0000        
            0x03, 0xE0, 0x3C, 0x00, ##        00000       0000       
            0x03, 0xC0, 0x3E, 0x00, ##        0000        00000      
            0x07, 0xC0, 0x1E, 0x00, ##       00000         0000      
            0x07, 0x80, 0x0F, 0x00, ##       0000           0000     
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFE, 0x00, 0x07, 0xF8, ##  0000000              00000000
            0x7E, 0x00, 0x07, 0xF8, ##   000000              00000000
            0x7F, 0x00, 0x0F, 0xF8, ##   0000000            000000000
            0x7F, 0x80, 0x1F, 0xF8, ##   00000000          0000000000
            0x3F, 0xE0, 0x7D, 0xF8, ##    000000000      00000 000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x03, 0xFF, 0xC1, 0xF8, ##        000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 29, 
        'xoffset'  => 5, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x07, 0xE0, 0x3F, 0x00, ##       000000       000000     
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFE, 0x00, 0x07, 0xF8, ##  0000000              00000000
            0x7E, 0x00, 0x07, 0xF8, ##   000000              00000000
            0x7F, 0x00, 0x0F, 0xF8, ##   0000000            000000000
            0x7F, 0x80, 0x1F, 0xF8, ##   00000000          0000000000
            0x3F, 0xE0, 0x7D, 0xF8, ##    000000000      00000 000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x03, 0xFF, 0xC1, 0xF8, ##        000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xE0, 0x00, ##                       000000       
            0x00, 0x00, 0x0F, 0xC0, 0x00, ##                      000000        
            0x00, 0x00, 0x1F, 0x80, 0x00, ##                     000000         
            0x00, 0x00, 0x1F, 0x00, 0x00, ##                     00000          
            0x00, 0x00, 0x3F, 0x00, 0x00, ##                    000000          
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000           
            0x00, 0x00, 0xFC, 0x00, 0x00, ##                  000000            
            0x00, 0x00, 0xF8, 0x00, 0x00, ##                  00000             
            0x00, 0x01, 0xF0, 0x00, 0x00, ##                 00000              
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000               
            0x00, 0x03, 0xE0, 0x00, 0x00, ##                00000               
            0x00, 0x07, 0xC0, 0x00, 0x00, ##               00000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0xFC, 0x00, 0x00, 0x0F, 0xC0, ##  000000                      000000
            0xFC, 0x00, 0x00, 0x1F, 0xC0, ##  000000                     0000000
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7F, 0x00, 0x00, 0x3F, 0x00, ##   0000000                  000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x7F, 0x00, ##    000000                 0000000  
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x01, 0xFC, 0x00, ##      000000             0000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x07, 0xF0, 0x00, ##        000000         0000000      
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x1F, 0xC0, 0x00, ##          000000     0000000        
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x1F, 0x7F, 0x00, 0x00, ##             00000 0000000          
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000              
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x1F, 0x80, 0x00, 0x00, ##             000000                 
            0x00, 0x3F, 0x80, 0x00, 0x00, ##            0000000                 
            0x00, 0x7F, 0x00, 0x00, 0x00, ##           0000000                  
            0x1F, 0xFF, 0x00, 0x00, 0x00, ##     0000000000000                  
            0x1F, 0xFE, 0x00, 0x00, 0x00, ##     000000000000                   
            0x1F, 0xFC, 0x00, 0x00, 0x00, ##     00000000000                    
            0x1F, 0xF8, 0x00, 0x00, 0x00, ##     0000000000                     
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000          
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0xFC, 0x7F, 0xFF, 0x00, ##  000000   000000000000000       
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFF, 0xF0, 0x3F, 0xE0, ##  000000000000      000000000    
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x00, 0x01, 0xF8, ##  00000000               000000  
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0x7E, ##  000000                   000000
            0xFC, 0x00, 0x00, 0xFE, ##  000000                  0000000
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFE, 0x00, 0x00, 0xFC, ##  0000000                 000000 
            0xFF, 0x00, 0x01, 0xFC, ##  00000000               0000000 
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0x80, 0x03, 0xF8, ##  000000000             0000000  
            0xFF, 0xE0, 0x0F, 0xF0, ##  00000000000         00000000   
            0xFF, 0xF0, 0x1F, 0xE0, ##  000000000000       00000000    
            0xFD, 0xFF, 0xFF, 0xE0, ##  000000 00000000000000000000    
            0xFC, 0xFF, 0xFF, 0xC0, ##  000000  000000000000000000     
            0xFC, 0x7F, 0xFF, 0x80, ##  000000   0000000000000000      
            0xFC, 0x1F, 0xFE, 0x00, ##  000000     000000000000        
            0xFC, 0x07, 0xF8, 0x00, ##  000000       00000000          
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0xFC, 0x00, 0x00, 0x00, ##  000000                         
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0xFC, 0x00, 0x00, 0x0F, 0xC0, ##  000000                      000000
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000 
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x3F, 0x00, 0x00, 0x3F, 0x00, ##    000000                  000000  
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x1F, 0x80, 0x00, 0x7E, 0x00, ##     000000                000000   
            0x0F, 0xC0, 0x00, 0xFE, 0x00, ##      000000              0000000   
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x0F, 0xC0, 0x00, 0xFC, 0x00, ##      000000              000000    
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x07, 0xE0, 0x01, 0xF8, 0x00, ##       000000            000000     
            0x03, 0xE0, 0x01, 0xF8, 0x00, ##        00000            000000     
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x03, 0xF0, 0x03, 0xF0, 0x00, ##        000000          000000      
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x01, 0xF8, 0x07, 0xE0, 0x00, ##         000000        000000       
            0x00, 0xF8, 0x07, 0xE0, 0x00, ##          00000        000000       
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0xFC, 0x0F, 0xC0, 0x00, ##          000000      000000        
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x7E, 0x1F, 0x80, 0x00, ##           000000    000000         
            0x00, 0x3E, 0x1F, 0x80, 0x00, ##            00000    000000         
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x3F, 0x3F, 0x00, 0x00, ##            000000  000000          
            0x00, 0x1F, 0xFF, 0x00, 0x00, ##             0000000000000          
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000           
            0x00, 0x0F, 0xFE, 0x00, 0x00, ##              00000000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000             
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000              
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000               
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x0F, 0xC0, 0x00, 0x00, ##              000000                
            0x00, 0x1F, 0xC0, 0x00, 0x00, ##             0000000                
            0x00, 0x1F, 0x80, 0x00, 0x00, ##             000000                 
            0x00, 0x7F, 0x80, 0x00, 0x00, ##           00000000                 
            0x1F, 0xFF, 0x00, 0x00, 0x00, ##     0000000000000                  
            0x1F, 0xFE, 0x00, 0x00, 0x00, ##     000000000000                   
            0x1F, 0xFE, 0x00, 0x00, 0x00, ##     000000000000                   
            0x1F, 0xFC, 0x00, 0x00, 0x00, ##     00000000000                    
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '65' => -1, '66' => -2, '71' => 2, '74' => 4, '79' => 2, '81' => 2, '84' => -6, '86' => -4, '87' => -3, '88' => -3, '89' => -8, '111' => 1, '118' => -2, '121' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '210' => 2, '211' => 2, '212' => 2, '213' => 2, '214' => 2, '221' => -8, '242' => 1, '243' => 1, '244' => 1, '245' => 1, '246' => 1, '253' => -1, '255' => -1, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '45' => -1, '46' => -1, '58' => -1, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '192' => 2, '193' => 2, '194' => 2, '195' => 2, '196' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # A
    '66' => { '67' => -1, '71' => -1, '79' => -1, '83' => -1, '86' => -2, '87' => -2, '89' => -3, '171' => -2, '187' => -1, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -3, },  # B
    '67' => { '89' => -1, '171' => -1, '187' => -1, '221' => -1, },  # C
    '68' => { '65' => -1, '86' => -1, '89' => -3, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # D
    '69' => { },  # E
    '70' => { '46' => -10, '58' => -5, '65' => -6, '83' => -1, '84' => -1, '97' => -6, '101' => -3, '105' => -5, '111' => -2, '114' => -5, '117' => -3, '121' => -6, '192' => -6, '193' => -6, '194' => -6, '195' => -6, '196' => -6, '224' => -6, '225' => -6, '226' => -6, '227' => -6, '228' => -6, '229' => -6, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -6, '255' => -6, },  # F
    '71' => { '84' => -2, '89' => -3, '171' => -1, '187' => -1, '221' => -3, },  # G
    '72' => { '46' => -1, },  # H
    '73' => { },  # I
    '74' => { '45' => -2, '65' => -1, '171' => -1, '187' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # J
    '75' => { '45' => -7, '65' => -1, '67' => -3, '79' => -3, '84' => -5, '85' => -2, '87' => -2, '89' => -2, '97' => -1, '101' => -3, '111' => -3, '117' => -3, '121' => -5, '171' => -4, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '199' => -3, '210' => -3, '211' => -3, '212' => -3, '213' => -3, '214' => -3, '217' => -2, '218' => -2, '219' => -2, '220' => -2, '221' => -2, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -5, '255' => -5, },  # K
    '76' => { '45' => -1, '65' => 1, '79' => -2, '84' => -9, '85' => -3, '86' => -7, '87' => -6, '89' => -8, '101' => -1, '111' => -1, '117' => -1, '121' => -6, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '196' => 1, '210' => -2, '211' => -2, '212' => -2, '213' => -2, '214' => -2, '217' => -3, '218' => -3, '219' => -3, '220' => -3, '221' => -8, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -6, '255' => -6, },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # O
    '80' => { '45' => -1, '46' => -10, '65' => -4, '89' => -1, '97' => -3, '101' => -2, '105' => -1, '110' => -1, '111' => -2, '114' => -1, '115' => -1, '117' => -1, '171' => -1, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '221' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '241' => -1, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -1, '250' => -1, '251' => -1, '252' => -1, },  # P
    '81' => { '45' => 2, },  # Q
    '82' => { '45' => -3, '46' => -2, '58' => -2, '65' => -3, '67' => -3, '84' => -5, '86' => -3, '87' => -3, '89' => -4, '97' => -1, '101' => -3, '111' => -3, '117' => -3, '121' => -3, '171' => -3, '187' => -1, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -3, '221' => -4, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -3, '255' => -3, },  # R
    '83' => { '65' => 1, '192' => 1, '193' => 1, '194' => 1, '195' => 1, '196' => 1, },  # S
    '84' => { '45' => -6, '46' => -8, '58' => -7, '65' => -5, '67' => -4, '97' => -11, '99' => -11, '101' => -11, '105' => -2, '111' => -11, '114' => -9, '115' => -11, '117' => -10, '119' => -11, '121' => -10, '171' => -6, '187' => -3, '192' => -5, '193' => -5, '194' => -5, '195' => -5, '196' => -5, '199' => -4, '224' => -11, '225' => -11, '226' => -11, '227' => -11, '228' => -11, '229' => -11, '231' => -11, '232' => -11, '233' => -11, '234' => -11, '235' => -11, '242' => -11, '243' => -11, '244' => -11, '245' => -11, '246' => -11, '249' => -10, '250' => -10, '251' => -10, '252' => -10, '253' => -10, '255' => -10, },  # T
    '85' => { '90' => -1, },  # U
    '86' => { '45' => -4, '46' => -8, '58' => -5, '65' => -4, '79' => -1, '97' => -5, '101' => -5, '105' => -1, '111' => -5, '117' => -4, '121' => -2, '171' => -6, '187' => -3, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '224' => -5, '225' => -5, '226' => -5, '227' => -5, '228' => -5, '229' => -5, '232' => -5, '233' => -5, '234' => -5, '235' => -5, '242' => -5, '243' => -5, '244' => -5, '245' => -5, '246' => -5, '249' => -4, '250' => -4, '251' => -4, '252' => -4, '253' => -2, '255' => -2, },  # V
    '87' => { '45' => -3, '46' => -7, '58' => -4, '65' => -3, '97' => -4, '101' => -4, '105' => -1, '111' => -4, '114' => -3, '117' => -2, '121' => -1, '171' => -3, '187' => -1, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '224' => -4, '225' => -4, '226' => -4, '227' => -4, '228' => -4, '229' => -4, '232' => -4, '233' => -4, '234' => -4, '235' => -4, '242' => -4, '243' => -4, '244' => -4, '245' => -4, '246' => -4, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -1, '255' => -1, },  # W
    '88' => { '45' => -3, '67' => -5, '79' => -4, '84' => -1, '101' => -3, '171' => -3, '199' => -5, '210' => -4, '211' => -4, '212' => -4, '213' => -4, '214' => -4, '232' => -3, '233' => -3, '234' => -3, '235' => -3, },  # X
    '89' => { '45' => -8, '46' => -13, '58' => -8, '65' => -5, '67' => -3, '79' => -3, '97' => -9, '101' => -8, '105' => -2, '111' => -8, '117' => -7, '171' => -7, '187' => -5, '192' => -5, '193' => -5, '194' => -5, '195' => -5, '196' => -5, '199' => -3, '210' => -3, '211' => -3, '212' => -3, '213' => -3, '214' => -3, '224' => -9, '225' => -9, '226' => -9, '227' => -9, '228' => -9, '229' => -9, '232' => -8, '233' => -8, '234' => -8, '235' => -8, '242' => -8, '243' => -8, '244' => -8, '245' => -8, '246' => -8, '249' => -7, '250' => -7, '251' => -7, '252' => -7, },  # Y
    '90' => { '45' => -1, },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { '120' => -1, },  # e
    '102' => { '45' => -3, '46' => -5, '58' => -2, '116' => -1, '119' => -1, '121' => -1, '171' => -2, '187' => -1, '253' => -1, '255' => -1, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '97' => -1, '101' => -2, '111' => -2, '117' => -2, '121' => -2, '224' => -1, '225' => -1, '226' => -1, '227' => -1, '228' => -1, '229' => -1, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -2, '255' => -2, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '45' => 1, '46' => -1, '120' => -2, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '45' => -4, '46' => -6, '58' => -1, '99' => -1, '100' => -1, '101' => -1, '103' => -1, '104' => -1, '109' => -1, '110' => -1, '111' => -1, '113' => -1, '120' => -2, '171' => -2, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '241' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '45' => -2, '46' => -5, '58' => -3, '171' => -1, '187' => -1, },  # v
    '119' => { '46' => -6, '58' => -3, '171' => -1, '187' => -1, },  # w
    '120' => { '99' => -1, '101' => -2, '111' => -2, '231' => -1, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, },  # x
    '121' => { '45' => -1, '46' => -9, '58' => -5, '171' => -1, '187' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { '66' => -1, '67' => -1, '68' => -1, '71' => -1, '74' => -1, '84' => -3, '86' => -3, '87' => -1, '89' => -5, '118' => -1, '119' => -1, '121' => -1, '198' => 5, '199' => -1, '221' => -5, '253' => -1, '255' => -1, },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { '65' => -2, '66' => -2, '67' => -1, '68' => -1, '74' => -1, '79' => -1, '84' => -6, '86' => -6, '87' => -3, '88' => -3, '89' => -7, '118' => -1, '119' => -1, '121' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -7, '253' => -1, '255' => -1, },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '45' => -1, '46' => -1, '58' => -1, '65' => 2, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '193' => 2, '194' => 2, '195' => 2, '196' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # À
    '193' => { '45' => -1, '46' => -1, '58' => -1, '65' => 2, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '192' => 2, '194' => 2, '195' => 2, '196' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # Á
    '194' => { '45' => -1, '46' => -1, '58' => -1, '65' => 2, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '192' => 2, '193' => 2, '195' => 2, '196' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # Â
    '195' => { '45' => -1, '46' => -1, '58' => -1, '65' => 2, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '192' => 2, '193' => 2, '194' => 2, '196' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # Ã
    '196' => { '45' => -1, '46' => -1, '58' => -1, '65' => 2, '67' => -1, '71' => -1, '79' => -1, '81' => -1, '84' => -5, '86' => -4, '87' => -3, '89' => -5, '99' => -1, '100' => -1, '101' => -1, '102' => -2, '111' => -1, '113' => -1, '116' => -1, '118' => -4, '119' => -3, '121' => -4, '171' => -2, '192' => 2, '193' => 2, '194' => 2, '195' => 2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '221' => -5, '231' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '253' => -4, '255' => -4, },  # Ä
    '197' => { },  # Å
    '198' => { },  # Æ
    '199' => { '89' => -1, '171' => -1, '187' => -1, '221' => -1, },  # Ç
    '200' => { },  # È
    '201' => { },  # É
    '202' => { },  # Ê
    '203' => { },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { },  # Ð
    '209' => { },  # Ñ
    '210' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # Ò
    '211' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # Ó
    '212' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # Ô
    '213' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # Õ
    '214' => { '45' => 2, '46' => -3, '58' => -1, '65' => -1, '86' => -1, '88' => -4, '89' => -3, '171' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -3, },  # Ö
    '215' => { },  # ×
    '216' => { },  # Ø
    '217' => { '90' => -1, },  # Ù
    '218' => { '90' => -1, },  # Ú
    '219' => { '90' => -1, },  # Û
    '220' => { '90' => -1, },  # Ü
    '221' => { '45' => -8, '46' => -13, '58' => -8, '65' => -5, '67' => -3, '79' => -3, '97' => -9, '101' => -8, '105' => -2, '111' => -8, '117' => -7, '171' => -7, '187' => -5, '192' => -5, '193' => -5, '194' => -5, '195' => -5, '196' => -5, '199' => -3, '210' => -3, '211' => -3, '212' => -3, '213' => -3, '214' => -3, '224' => -9, '225' => -9, '226' => -9, '227' => -9, '228' => -9, '229' => -9, '232' => -8, '233' => -8, '234' => -8, '235' => -8, '242' => -8, '243' => -8, '244' => -8, '245' => -8, '246' => -8, '249' => -7, '250' => -7, '251' => -7, '252' => -7, },  # Ý
    '222' => { '46' => -5, '58' => -2, },  # Þ
    '223' => { '45' => 1, },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { '120' => -1, },  # è
    '233' => { '120' => -1, },  # é
    '234' => { '120' => -1, },  # ê
    '235' => { '120' => -1, },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { },  # ð
    '241' => { },  # ñ
    '242' => { '45' => 1, '46' => -1, '120' => -2, },  # ò
    '243' => { '45' => 1, '46' => -1, '120' => -2, },  # ó
    '244' => { '45' => 1, '46' => -1, '120' => -2, },  # ô
    '245' => { '45' => 1, '46' => -1, '120' => -2, },  # õ
    '246' => { '45' => 1, '46' => -1, '120' => -2, },  # ö
    '247' => { },  # ÷
    '248' => { },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '45' => -1, '46' => -9, '58' => -5, '171' => -1, '187' => -1, },  # ý
    '254' => { },  # þ
    '255' => { '45' => -1, '46' => -9, '58' => -5, '171' => -1, '187' => -1, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
