# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250913135857;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '2277',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              3[13]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          1(?:
            (?:
              5(?:
                [0-25-9]\\d\\d|
                3(?:
                  10|
                  33
                )
              )|
              7[26-9]\\d\\d
            )\\d{6}|
            6[023]\\d{7,8}
          )|
          17\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"492203", "Köln\-Porz",
"499242", "Gößweinstein",
"498536", "Kößlarn",
"4935240", "Tauscha\ bei\ Großenhain",
"496663", "Steinau\ an\ der\ Straße",
"495053", "Faßberg\-Müden",
"495384", "Seesen\-Groß\ Rhüden",
"4939976", "Groß\ Bützin",
"4934445", "Stößen",
"498170", "Straßlach\-Dingharting",
"49911", "Nürnberg",
"496321", "Neustadt\ an\ der\ Weinstraße",
"499141", "Weißenburg\ in\ Bayern",
"497162", "Süßen",
"4936484", "Knau\ bei\ Pößneck",
"4939883", "Groß\ Dölln",
"4935952", "Großröhrsdorf\ OL",
"493647", "Pößneck",
"497355", "Hochdorf\ Riß",
"4935248", "Schönfeld\ bei\ Großenhain",
"495827", "Unterlüß",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4938234", "Born\ Darß",
"4936072", "Weißenborn\-Lüderode",
"496252", "Heppenheim\ Bergstraße",
"49221", "Köln",
"499656", "Moosbach\ bei\ Vohenstrauß",
"494497", "Barßel\-Harkebrügge",
"4936949", "Obermaßfeld\-Grimmenthal",
"498807", "Dießen\ am\ Ammersee",
"4934901", "Roßlau\ Elbe",
"4935726", "Groß\ Särchen",
"4934493", "Gößnitz\ Thüringen",
"499636", "Plößberg",
"495064", "Groß\ Düngen",
"4935841", "Großschönau\ Sachsen",
"497351", "Biberach\ an\ der\ Riß",
"498633", "Tüßling",
"4989", "München",
"494509", "Groß\ Grönau",
"4935938", "Großpostwitz\ OL",
"499567", "Seßlach\-Gemünda",
"494684", "Langeneß\ Hallig",
"4939934", "Groß\ Plasten",
"4935753", "Großräschen",
"492339", "Sprockhövel\-Haßlinghausen",
"496364", "Nußbach\ Pfalz",
"498367", "Roßhaupten\ Forggensee",
"494483", "Ovelgönne\-Großenmeer",};
$areanames{en} = {"495044", "Springe\-Eldagsen",
"494825", "Burg\ Dithmarschen",
"4936484", "Knau\ bei\ Pössneck",
"497582", "Bad\ Buchau",
"497972", "Gschwend\ bei\ Gaildorf",
"4936043", "Kirchheilingen",
"497808", "Hohberg\ bei\ Offenburg",
"498249", "Ettringen\ Wertach",
"499434", "Bodenwöhr",
"495034", "Neustadt\-Hagen",
"498276", "Baar\ Schwaben",
"496723", "Oestrich\-Winkel",
"4939859", "Fürstenwerder",
"495374", "Isenbüttel",
"498324", "Hindelang",
"498239", "Langenneufnach",
"4935474", "Schönwalde\ bei\ Lübben",
"4936964", "Dermbach\ Rhön",
"495226", "Bruchmühlen\ Westfalen",
"497166", "Adelberg",
"499444", "Siegenburg",
"493902", "Diesdorf\ Altm",
"4935822", "Hagenwerder",
"4939722", "Sarnow\ bei\ Anklam",
"496747", "Emmelshausen",
"498055", "Halfing",
"497933", "Creglingen",
"4934348", "Frohburg",
"496484", "Beselich",
"497943", "Schöntal\ Jagst",
"494767", "Bremervörde\-Bevern",
"499624", "Ensdorf\ Oberpfalz",
"496737", "Köngernheim",
"4933877", "Nitzahn",
"4937465", "Tannenbergsthal\ Vogtland",
"497427", "Schömberg\ bei\ Balingen",
"497472", "Rottenburg\ am\ Neckar",
"498403", "Pförring",
"4933206", "Fichtenwalde",
"496275", "Rothenberg\ Odenwald",
"4937756", "Breitenbrunn\ Erzgebirge",
"4936372", "Kleinneuhausen",
"4937365", "Sayda",
"496155", "Griesheim\ Hessen",
"499944", "Miltach",
"495602", "Hessisch\ Lichtenau",
"497623", "Rheinfelden\ Baden",
"494793", "Hambergen",
"494105", "Seevetal",
"4933333", "Tantow",
"497128", "Sonnenbühl",
"493883", "Hagenow",
"4934722", "Preusslitz",
"497433", "Balingen",
"492377", "Wickede\ Ruhr",
"496574", "Hasborn",
"499271", "Thurnau\-Alladorf",
"4939348", "Klitsche",
"4937361", "Neuhausen\ Erzgebirge",
"499151", "Hersbruck",
"4933433", "Buckow\ Märkische\ Schweiz",
"499307", "Altertheim",
"493761", "Werdau\ Sachsen",
"496056", "Bad\ Soden\-Salmünster",
"496359", "Grünstadt",
"497443", "Dornstetten",
"496851", "St\ Wendel",
"493966", "Cölpin",
"495147", "Uetze\-Hänigsen",
"4935751", "Welzow",
"4939851", "Göritz\ bei\ Prenzlau",
"499195", "Adelsdorf\ Mittelfranken",
"497384", "Schelklingen\-Hütten",
"498678", "Marktl",
"498142", "Olching",
"493537", "Jessen\ Elster",
"494260", "Visselhövede\-Wittorf",
"495137", "Seelze",
"492451", "Geilenkirchen",
"494475", "Molbergen",
"495572", "Bodenfelde",
"495527", "Duderstadt",
"497959", "Frankenhardt",
"492773", "Haiger",
"495448", "Barver",
"492742", "Wissen",
"4935755", "Ortrand",
"4939855", "Parmen\-Weggun",
"499855", "Dentlein\ am\ Forst",
"495361", "Wolfsburg",
"495543", "Staufenberg\ Niedersachsen",
"499378", "Eichenbühl\-Riedern",
"4939603", "Burg\ Stargard",
"498253", "Pöttmes",
"4939050", "Bartensleben",
"499280", "Selbitz\ Oberfranken",
"495438", "Bakum\-Lüsche",
"4939247", "Güterglück",
"492732", "Kreuztal",
"492308", "Unna\-Hemmerde",
"4935796", "Panschwitz\-Kuckau",
"495533", "Bodenwerder",
"4938784", "Kleinow\ Kreis\ Prignitz",
"497263", "Waibstadt",
"495123", "Schellerten",
"493523", "Coswig\ bei\ Dresden",
"4933602", "Alt\ Zeschdorf",
"498734", "Reisbach\ Niederbayern",
"493466", "Artern\ Unstrut",
"499082", "Oettingen\ in\ Bayern",
"493774", "Schwarzenberg",
"492225", "Meckenheim\ Rheinland",
"496073", "Babenhausen\ Hessen",
"494541", "Ratzeburg",
"496216", "Ludwigshafen",
"4933838", "Päwesin",
"494363", "Lensahn",
"498469", "Freystadt\-Burggriesbach",
"498683", "Tittmoning",
"496333", "Waldfischbach\-Burgalben",
"498744", "Gerzen",
"494121", "Elmshorn",
"492951", "Büren",
"49375", "Zwickau",
"495482", "Tecklenburg",
"499264", "Küps",
"496561", "Bitburg",
"494975", "Westerholt\ Ostfriesland",
"494531", "Bad\ Oldesloe",
"496343", "Bad\ Bergzabern",
"497822", "Ettenheim",
"498091", "Kirchseeon",
"4935200", "Arnsdorf\ bei\ Dresden",
"495803", "Rosche",
"497459", "Nagold\-Hochdorf",
"493391", "Neuruppin",
"496372", "Bruchmühlbach\-Miesau",
"496327", "Neustadt\-Lachen",
"497704", "Geisingen\ Baden",
"495948", "Itterbeck",
"492524", "Ennigerloh",
"493682", "Zella\-Mehlis",
"4937369", "Wolkenstein",
"496032", "Bad\ Nauheim",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"499383", "Wiesentheid",
"496042", "Büdingen\ Hessen",
"494284", "Selsingen",
"495755", "Kalletal\-Varenholz",
"499565", "Untersiemau",
"493928", "Schönebeck\ Elbe",
"4938222", "Semlow",
"497235", "Unterreichenbach\ Kreis\ Calw",
"498504", "Tittling",
"499938", "Moos\ Niederbayern",
"4935342", "Mühlberg\ Elbe",
"499666", "Illschwang",
"492293", "Nümbrecht",
"4939291", "Calbe\ Saale",
"496432", "Diez",
"495565", "Einbeck\-Wenzen",
"492842", "Kamp\-Lintfort",
"494462", "Wittmund",
"499948", "Eschlkam",
"4938233", "Prerow\ Ostseebad",
"497245", "Durmersheim",
"495383", "Lutter\ am\ Barenberge",
"492832", "Kevelaer",
"496442", "Braunfels",
"496599", "Weidenbach\ bei\ Gerolstein",
"496473", "Leun",
"4938787", "Glöwen",
"498205", "Dasing",
"495650", "Cornberg",
"496578", "Salmtal",
"497534", "Reichenau\ Baden",
"4939388", "Goldbeck\ Altm",
"498366", "Oy\-Mittelberg",
"499803", "Colmberg",
"497124", "Trochtelfingen\ Hohenz",
"496751", "Bad\ Sobernheim",
"4939244", "Steutz",
"495264", "Kalletal",
"499482", "Wörth\ an\ der\ Donau",
"4939295", "Zuchau",
"492873", "Isselburg\-Werth",
"495082", "Langlingen",
"4939488", "Güntersberge",
"497544", "Markdorf",
"496677", "Neuenstein\ Hessen",
"497356", "Schemmerhofen",
"4938373", "Katzow",
"496622", "Bebra",
"4938306", "Samtens",
"499533", "Untermerzbach",
"499438", "Fensterbach",
"496187", "Schöneck",
"499123", "Lauf\ an\ der\ Pegnitz",
"494256", "Hilgermissen",
"494962", "Papenburg\-Aschendorf",
"494149", "Fredenbeck",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4935728", "Uhyst\ Spree",
"4936083", "Uder",
"4934291", "Borsdorf",
"497804", "Oppenau",
"499543", "Hirschaid",
"492267", "Wipperfürth",
"498328", "Balderschwang",
"495855", "Nahrendorf",
"494529", "Süsel\-Bujendorf",
"499448", "Hausen\ Niederbayern",
"494176", "Marschacht",
"495378", "Sassenburg\-Platendorf",
"494139", "Hohnstorf\ Elbe",
"496583", "Palzem",
"497651", "Titisee\-Neustadt",
"493874", "Ludwigslust",
"499572", "Burgkunstadt",
"4934295", "Krensitz",
"499527", "Knetzgau",
"4934244", "Mockrehna",
"497777", "Sauldorf",
"495703", "Hille",
"495195", "Neuenkirchen\ bei\ Soltau",
"497722", "Triberg\ im\ Schwarzwald",
"4936761", "Heubisch",
"499628", "Ursensollen",
"4933926", "Herzberg\ Mark",
"499147", "Nennslingen",
"494335", "Hohn\ bei\ Rendsburg",
"494381", "Lütjenburg",
"492502", "Nottuln",
"498661", "Grabenstätt\ Chiemsee",
"492051", "Velbert",
"496206", "Lampertheim",
"49385", "Schwerin",
"4936967", "Geisa",
"4935477", "Rietzneuendorf\-Friedrichshof",
"497033", "Weil\ Der\ Stadt",
"495307", "Braunschweig\-Wenden",
"497373", "Zwiefalten",
"495151", "Hameln",
"4939883", "Gross\ Dölln",
"4936028", "Kammerforst\ Thüringen",
"498302", "Görisried",
"492856", "Hamminkeln\-Brünen",
"4939390", "Iden",
"492643", "Altenahr",
"497043", "Maulbronn",
"499268", "Teuschnitz",
"497965", "Ellwangen\-Röhlingen",
"498221", "Günzburg",
"496837", "Wallerfangen",
"492447", "Dahlem\ bei\ Kall",
"495271", "Höxter",
"492633", "Brohl\-Lützing",
"496456", "Haina\ Kloster",
"4933874", "Stechow\ Brandenburg",
"493303", "Birkenwerder",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"499602", "Neustadt\ an\ der\ Waldnaab",
"497708", "Geisingen\-Leipferdingen",
"492423", "Langerwehe",
"497332", "Lauterstein",
"495944", "Hoogstede",
"492196", "Wermelskirchen",
"499869", "Wettringen\ Mittelfranken",
"492528", "Ennigerloh\-Enniger",
"497072", "Gomaringen",
"494725", "Helgoland",
"494406", "Berne",
"494288", "Horstedt\ Kreis\ Rotenburg",
"4934423", "Heuckewalde",
"492627", "Braubach",
"492672", "Treis\-Karden",
"495934", "Haren\-Rütenbrock",
"497388", "Pfronstetten",
"4933748", "Treuenbrietzen",
"497150", "Korntal\-Münchingen",
"496084", "Schmitten\ Taunus",
"492937", "Arnsberg\-Oeventrop",
"493634", "Sömmerda",
"494242", "Syke",
"494893", "Hohenaspe",
"492182", "Grevenbroich\-Kapellen",
"495624", "Bad\ Emstal",
"494557", "Blunk",
"4938461", "Bützow",
"497465", "Emmingen\-Liptingen",
"493644", "Apolda",
"492947", "Anröchte",
"4938791", "Bad\ Wilsnack",
"492566", "Legden",
"496262", "Aglasterhausen",
"494232", "Langwedel\ Kreis\ Verden",
"496103", "Langen\ Hessen",
"4934299", "Gaschwitz",
"4933653", "Ziltendorf",
"493861", "Plate",
"499374", "Eschau",
"498782", "Pfeffenhausen",
"4939323", "Schönhausen\ Elbe",
"4938756", "Grabow",
"495444", "Wagenfeld",
"494153", "Lauenburg\ Elbe",
"492923", "Lippetal\-Herzfeld",
"4935954", "Grossharthau",
"4939423", "Wegeleben",
"4934652", "Allstedt",
"494273", "Kirchdorf\ bei\ Sulingen",
"495769", "Steyerberg\-Voigtei",
"495434", "Essen\ Oldenburg",
"492304", "Schwerte",
"496507", "Neumagen\-Dhron",
"49451", "Lübeck",
"496215", "Ludwigshafen",
"496522", "Mettendorf",
"492374", "Iserlohn\-Letmathe",
"498230", "Gablingen",
"4938227", "Lüdershagen\ bei\ Barth",
"494162", "Jork",
"4934242", "Hohenpriessnitz",
"496132", "Ingelheim\ am\ Rhein",
"494203", "Weyhe\ bei\ Bremen",
"4936625", "Langenwetzendorf",
"499923", "Teisnach",
"4938483", "Brüel",
"497644", "Kenzingen",
"4939925", "Wredenhagen",
"492226", "Rheinbach",
"494976", "Spiekeroog",
"498851", "Kochel\ am\ See",
"496142", "Rüsselsheim",
"494939", "Baltrum",
"497634", "Sulzburg",
"496678", "Wildeck\-Hönebach",
"499937", "Oberpöring",
"496173", "Kronberg\ im\ Taunus",
"499182", "Velburg",
"497424", "Spaichingen",
"4939921", "Ankershagen",
"4936621", "Elsterberg\ bei\ Plauen",
"498191", "Landsberg\ am\ Lech",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4939033", "Wallstawe",
"499566", "Meeder",
"495665", "Guxhagen",
"496253", "Fürth\ Odenwald",
"49906", "Donauwörth",
"4933607", "Briesen\ Mark",
"4937608", "Waldenburg\ Sachsen",
"496744", "Oberwesel",
"499528", "Donnersdorf",
"493965", "Burow\ bei\ Altentreptow",
"4939242", "Prödel",
"498343", "Aitrang",
"4939861", "Gramzow\ bei\ Prenzlau",
"493695", "Bad\ Salzungen",
"492602", "Montabaur",
"498561", "Pfarrkirchen\ Niederbayern",
"4934925", "Bad\ Schmiedeberg",
"499423", "Geiselhöring",
"499196", "Wiesenttal",
"499148", "Ettenstatt",
"4933847", "Görzke",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"494764", "Gnarrenburg\-Klenkendorf",
"496734", "Flonheim",
"499627", "Freudenberg\ Oberpfalz",
"499672", "Neunburg\ vorm\ Wald",
"4936338", "Bleicherode",
"496683", "Ehrenberg\ Rhön",
"498333", "Babenhausen\ Schwaben",
"497551", "Überlingen\ Bodensee",
"498073", "Gars\ am\ Inn",
"496188", "Kahl\ am\ Main",
"498042", "Lenggries",
"493342", "Neuenhagen\ bei\ Berlin",
"495201", "Halle\ Westfalen",
"4935456", "Terpt",
"499856", "Dürrwangen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"4934921", "Kemberg",
"493332", "Schwedt\/Oder",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"499447", "Essing",
"498327", "Rettenberg",
"4938823", "Selmsdorf",
"492268", "Kürten",
"498372", "Obergünzburg",
"495495", "Vörden\ Kreis\ Vechta",
"499633", "Mitterteich",
"495322", "Bad\ Harzburg",
"495377", "Ehra\-Lessien",
"497303", "Illertissen",
"495037", "Bad\ Rehburg",
"498723", "Arnstorf",
"497950", "Schnelldorf",
"495451", "Ibbenbüren",
"492137", "Neuss\-Norf",
"496276", "Hesseneck",
"492572", "Emsdetten",
"492982", "Medebach",
"492527", "Lippetal\-Lippborg",
"4935952", "Grossröhrsdorf\ OL",
"496324", "Hassloch",
"494269", "Ahausen\-Kirchwalsede",
"497707", "Bräunlingen",
"496239", "Bobenheim\-Roxheim",
"495773", "Stemwede\-Wehdem",
"499502", "Frensdorf",
"4934654", "Stolberg\ Harz",
"494287", "Heeslingen\-Boitzen",
"492628", "Rhens",
"496249", "Guntersblum",
"495732", "Löhne",
"496848", "Homburg\-Einöd",
"495308", "Lehre",
"492533", "Münster\-Nienberge",
"494106", "Quickborn\ Kreis\ Pinneberg",
"493722", "Limbach\-Oberfrohna",
"4936377", "Rastenberg",
"4935773", "Schleife",
"494953", "Bunde",
"499289", "Schwarzenbach\ am\ Wald",
"492361", "Recklinghausen",
"4936783", "Gehren\ Thüringen",
"4935028", "Krippen",
"492448", "Hellenthal\-Rescheid",
"496838", "Saarwellingen",
"495742", "Preussisch\ Oldendorf",
"4935387", "Seyda",
"492543", "Billerbeck\ Westfalen",
"499267", "Nordhalben",
"4939929", "Jabel\ bei\ Waren",
"496055", "Freigericht",
"4933734", "Felgentreu",
"495951", "Werlte",
"4936946", "Erbenhausen\ Thüringen",
"4933872", "Hohennauen",
"49461", "Flensburg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494826", "Hohenlockstedt",
"492482", "Hellenthal",
"499659", "Leuchtenberg",
"492803", "Wesel\-Büderich",
"498460", "Berching\-Holnstein",
"495225", "Spenge",
"499873", "Abenberg\-Wassermungenau",
"497165", "Göppingen\-Hohenstaufen",
"4938328", "Miltzow",
"496508", "Hetzerath\ Mosel",
"4936920", "Grossenlupnitz",
"496403", "Linden\ Hessen",
"4935827", "Nieder\-Seifersdorf",
"4939727", "Spantekow",
"494771", "Hemmoor",
"492938", "Ense",
"498056", "Eggstätt",
"497387", "Hohenstein\ Württemberg",
"499842", "Uffenheim",
"494558", "Todesfelde",
"492755", "Bad\ Berleburg\-Schwarzenau",
"492666", "Freilingen\ Westerwald",
"499293", "Berg\ Oberfranken",
"494453", "Zetel",
"495144", "Wathlingen",
"493544", "Luckau\ Brandenburg",
"492948", "Lippstadt\-Rebbeke",
"497066", "Bad\ Rappenau\-Bonfeld",
"4938738", "Karow\ bei\ Lübz",
"495524", "Bad\ Lauterberg\ im\ Harz",
"494394", "Bokhorst",
"498574", "Wittibreut",
"4934929", "Straach",
"499832", "Wassertrüdingen",
"4937343", "Jöhstadt",
"499524", "Zeil\ am\ Main",
"4933970", "Neustadt\ Dosse",
"496221", "Heidelberg",
"497391", "Ehingen\ Donau",
"493877", "Wittenberge",
"4938451", "Hoppenrade\ bei\ Güstrow",
"498456", "Lenting",
"492383", "Bönen",
"499134", "Neunkirchen\ am\ Brand",
"495832", "Hankensbüttel",
"498847", "Obersöchering",
"4939201", "Wolmirstedt",
"4938351", "Mesekenhagen",
"497466", "Beuron",
"499144", "Pleinfeld",
"495293", "Paderborn\-Dahl",
"494768", "Hipstedt",
"497774", "Eigeltingen",
"495842", "Schnega",
"492565", "Gronau\-Epe",
"496302", "Winnweiler",
"4935248", "Schönfeld\ bei\ Grossenhain",
"495873", "Eimke",
"499225", "Stadtsteinach",
"497807", "Neuried\ Ortenaukreis",
"4938455", "Plaaz",
"496184", "Langenselbold",
"4935384", "Steinsdorf\ bei\ Jessen",
"494352", "Damp",
"498823", "Mittenwald",
"4939205", "Langenweddingen",
"4936374", "Weissensee",
"499951", "Landau\ an\ der\ Isar",
"4938355", "Züssow",
"496003", "Rosbach\ von\ der\ Höhe",
"495659", "Ringgau",
"492264", "Marienheide",
"497682", "Elzach",
"497127", "Neckartenzlingen",
"497172", "Lorch\ Württemberg",
"4939724", "Klein\ Bünzow",
"499742", "Kalbach\ Rhön",
"492855", "Voerde\ Niederrhein",
"494871", "Hohenwestedt",
"492378", "Fröndenberg\-Langschede",
"498262", "Mittelneufnach",
"498084", "Taufkirchen\ Vils",
"494140", "Estorf\ Kreis\ Stade",
"496455", "Frankenau\ Hessen",
"499732", "Hammelburg",
"496674", "Friedewald\ Hessen",
"497966", "Unterschneidheim",
"497252", "Bretten",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4933679", "Wendisch\ Rietz",
"492195", "Radevormwald",
"497428", "Rosenfeld",
"495502", "Dransfeld",
"4936482", "Triptis",
"494405", "Edewecht",
"495051", "Bergen\ Kreis\ Celle",
"498507", "Neuburg\ am\ Inn",
"497133", "Lauffen\ am\ Neckar",
"4934205", "Markranstädt",
"496782", "Birkenfeld\ Nahe",
"4933088", "Falkenthal",
"4937328", "Grossschirma",
"499451", "Schierling",
"4935472", "Schlepzig",
"4936962", "Vacha",
"499773", "Unsleben",
"497143", "Besigheim",
"4939400", "Wefensleben",
"499495", "Breitenbrunn\ Oberpfalz",
"494255", "Martfeld",
"493623", "Friedrichroda",
"495447", "Lembruch",
"4939209", "Wanzleben",
"492271", "Bergheim\ Erft",
"498442", "Wolnzach",
"499377", "Freudenberg\-Boxtal",
"495633", "Diemelsee",
"4938459", "Laage",
"499201", "Gesees",
"496504", "Thalfang",
"492151", "Krefeld",
"494921", "Emden\ Stadt",
"492307", "Kamen",
"495437", "Menslage",
"4938224", "Gresenhorst",
"498432", "Burgheim",
"495643", "Borgentreich",
"494175", "Egestorf\ Nordheide",
"494554", "Wahlstedt",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"495672", "Bad\ Karlshafen",
"4933604", "Lebus",
"495148", "Steinhorst\ Niedersachsen",
"497761", "Bad\ Säckingen",
"496087", "Waldems",
"492934", "Sundern\-Altenhellefeld",
"4933931", "Rheinsberg\ Mark",
"498622", "Tacherting\-Peterskirchen",
"494346", "Gettorf",
"498677", "Burghausen\ Salzach",
"496205", "Hockenheim",
"493433", "Borna\ Stadt",
"4937383", "Lunzenau",
"495138", "Sehnde",
"497402", "Fluorn\-Winzeln",
"498751", "Mainburg",
"495423", "Versmold",
"495196", "Wietzendorf",
"492944", "Rietberg\-Mastholte",
"493596", "Neustadt\ in\ Sachsen",
"493647", "Pössneck",
"494336", "Owschlag",
"495528", "Gieboldehausen",
"497024", "Wendlingen\ am\ Neckar",
"499665", "Königstein\ Oberpfalz",
"496328", "Elmstein",
"495947", "Laar\ Vechte",
"497236", "Keltern",
"4933844", "Brück\ Brandenburg",
"495937", "Geeste\-Gross\ Hesepe",
"4933675", "Tauche",
"494421", "Wilhelmshaven",
"497159", "Renningen",
"4938782", "Reetz\ bei\ Perleberg",
"495182", "Gronau\ Leine",
"492624", "Höhr\-Grenzhausen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"494631", "Glücksburg\ Ostsee",
"496661", "Schlüchtern",
"493943", "Wernigerode",
"498365", "Wertach",
"4936200", "Elxleben\ bei\ Arnstadt",
"492434", "Wegberg",
"496844", "Blieskastel\-Altheim",
"495304", "Meine",
"498206", "Egling\ an\ der\ Paar",
"493933", "Genthin",
"497355", "Hochdorf\ Riss",
"4939266", "Förderstedt",
"494641", "Süderbrarup",
"498583", "Neureichenau",
"4933671", "Lieberose",
"4938848", "Vellahn",
"494864", "Oldenswort",
"4936743", "Teichel",
"492444", "Schleiden\-Gemünd",
"496834", "Bous",
"495923", "Schüttorf",
"496580", "Zemmer",
"497962", "Fichtenau",
"494804", "Nordhastedt",
"499779", "Nordheim\ von\ der\ Rhön",
"4933839", "Wusterwitz",
"4936253", "Georgenthal\ Thüringer\ Wald",
"497256", "Philippsburg",
"4933452", "Neulewin",
"499736", "Oberthulba",
"4939345", "Parchen",
"497139", "Neuenstadt\ am\ Kocher",
"495364", "Velpke",
"4939394", "Hohenberg\-Krusemark",
"498266", "Kirchheim\ in\ Schwaben",
"497529", "Waldburg\ Württemberg",
"497176", "Spraitbach",
"495957", "Lindern\ Oldenburg",
"499746", "Zeitlofs",
"492675", "Ediger\-Eller",
"4936922", "Gerstungen",
"492454", "Gangelt",
"495283", "Lügde\-Rischenau",
"493868", "Rastow",
"499120", "Leinburg",
"4933367", "Friedrichswalde\ Brandenburg",
"497345", "Langenau\ Württemberg",
"4937368", "Deutschneudorf",
"49591", "Lingen\ \(Ems\)",
"496786", "Kempfeld",
"496854", "Oberthal\ Saar",
"4939341", "Redekin",
"492393", "Sundern\-Allendorf",
"497335", "Wiesensteig",
"497381", "Münsingen",
"499605", "Weiherhammer",
"4933870", "Zollchow\ bei\ Rathenow",
"494777", "Cadenberge",
"494722", "Cuxhaven\-Altenbruch",
"4937468", "Treuen\ Vogtland",
"495506", "Adelebsen",
"4934445", "Stössen",
"4934494", "Ehrenhain",
"497462", "Immendingen",
"495846", "Gartow\ Niedersachsen",
"496306", "Trippstadt",
"495653", "Sontra",
"494281", "Zeven",
"494235", "Langwedel\-Etelsen",
"496265", "Billigheim\ Baden",
"498452", "Geisenfeld",
"49361", "Erfurt",
"4934345", "Bad\ Lausick",
"492521", "Beckum",
"495836", "Wittingen\-Radenbeck",
"494245", "Neuenkirchen\ bei\ Bassum",
"495457", "Hopsten\-Schale",
"492131", "Neuss",
"498741", "Vilsbiburg",
"494124", "Glückstadt",
"492954", "Rüthen\-Oestereiden",
"495278", "Höxter\-Ovenhausen",
"4934441", "Hohenmölsen",
"4939453", "Derenburg",
"499261", "Kronach",
"496564", "Neuerburg\ Eifel",
"494534", "Steinburg\ Kreis\ Storman",
"492367", "Henrichenburg",
"498094", "Steinhöring",
"493394", "Wittstock\ Dosse",
"49541", "Osnabrück",
"4934341", "Geithain",
"4938726", "Spornitz",
"498785", "Rottenburg\-Oberroning",
"4939086", "Jävenitz",
"498731", "Dingolfing",
"492389", "Werne",
"4938203", "Bad\ Doberan",
"494356", "Gross\ Wittensee",
"493771", "Aue\ Sachsen",
"494544", "Berkenthin",
"495158", "Hemeringen",
"492058", "Wülfrath",
"4939062", "Bebertal",
"497557", "Herdwangen\-Schönach",
"495186", "Salzhemmendorf\-Wallensen",
"493586", "Neugersdorf\ Sachsen",
"493976", "Torgelow\ bei\ Ueckermünde",
"497242", "Rheinstetten",
"499621", "Amberg\ Oberpfalz",
"492835", "Issum",
"496445", "Schöffengrund",
"4933831", "Weseram",
"497232", "Königsbach\-Stein",
"492763", "Drolshagen\-Bleche",
"494465", "Friedeburg\ Ostfriesland",
"493949", "Oschersleben\ Bode",
"496435", "Wallmerod",
"495562", "Dassel\-Markoldendorf",
"492845", "Neukirchen\-Vluyn",
"497906", "Braunsbach",
"495085", "Burgdorf\-Ehlershausen",
"495031", "Wunstorf",
"497153", "Plochingen",
"495371", "Gifhorn",
"4939349", "Parey\ Elbe",
"496625", "Niederaula",
"4939776", "Hintersee",
"4935876", "Weissenberg\ Sachsen",
"4939226", "Hohenziatz",
"498321", "Sonthofen",
"499441", "Kelheim",
"4935696", "Briesnig",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"49751", "Ravensburg",
"495041", "Springe\ Deister",
"4933835", "Golzow\ bei\ Brandenburg",
"498202", "Althegnenberg",
"495207", "Schloss\ Holte\-Stukenbrock",
"497273", "Hagenbach\ Pfalz",
"499431", "Schwandorf",
"499154", "Pommelsbrunn",
"493764", "Meerane",
"495429", "Melle\-Wellingholzhausen",
"4933702", "Wünsdorf",
"495852", "Bleckede",
"492204", "Bensberg",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"498857", "Benediktbeuern",
"498593", "Untergriesbach",
"496063", "Bad\ König",
"4936426", "Ottendorf\ bei\ Stadtroda",
"498446", "Pörnbach",
"496758", "Waldböckelheim",
"499326", "Markt\ Einersheim",
"496571", "Wittlich",
"499274", "Hollfeld",
"4935207", "Moritzburg",
"4939858", "Bietikow",
"494965", "Surwold",
"497725", "Königsfeld\ im\ Schwarzwald",
"495192", "Munster",
"493592", "Kirschau",
"492505", "Altenberge\ Westfalen",
"496362", "Alsenz",
"494708", "Ringstedt",
"494332", "Hamdorf\ bei\ Rendsburg",
"4934776", "Rothenschirmbach",
"499941", "Kötzting",
"4936736", "Arnsgereuth",
"494342", "Preetz\ Kreis\ Plön",
"493629", "Stadtilm",
"495676", "Liebenau\ Hessen",
"49881", "Weilheim\ in\ Oberbayern",
"492630", "Mülheim\-Kärlich",
"499931", "Plattling",
"499575", "Weismain",
"493921", "Burg\ bei\ Magdeburg",
"499639", "Mähring",
"497309", "Weissenhorn",
"495931", "Meppen",
"494472", "Lastrup",
"498135", "Sulzemoos",
"499676", "Winklarn",
"4935435", "Gollmitz\ bei\ Calau",
"4939821", "Carpin",
"4934298", "Taucha\ bei\ Leipzig",
"494623", "Böklund",
"499192", "Gräfenberg",
"4933476", "Neuhardenberg",
"492606", "Winningen\ Mosel",
"497440", "Bad\ Rippoldsau",
"4934385", "Mutzschen",
"495941", "Neuenhaus\ Dinkel",
"498145", "Mammendorf",
"4936202", "Neudietendorf",
"4938780", "Lanz\ Brandenburg",
"495326", "Langelsheim",
"492735", "Neunkirchen\ Siegerl",
"496568", "Wolsfeld",
"493379", "Mahlow",
"498224", "Offingen\ Donau",
"494433", "Dötlingen",
"498036", "Stephanskirchen\ Simssee",
"494128", "Kollmar",
"492958", "Büren\-Harth",
"495274", "Nieheim",
"4939054", "Flechtingen",
"498376", "Sulzberg\ Allgäu",
"499852", "Feuchtwangen",
"4935725", "Wittichenau",
"499429", "Rain\ Niederbayern",
"492745", "Brachbach\ Sieg",
"4939825", "Wokuhl",
"498349", "Stötten\ am\ Auerberg",
"492863", "Velen",
"494443", "Dinklage",
"495154", "Aerzen",
"4934381", "Colditz",
"493346", "Seelow",
"498046", "Bad\ Heilbrunn",
"494637", "Sterup",
"497620", "Schopfheim\-Gersbach",
"496667", "Steinau\-Ulmbach",
"493421", "Torgau",
"4936029", "Menteroda",
"4935204", "Wilsdruff",
"496146", "Hochheim\ am\ Main",
"492157", "Nettetal\-Kaldenkirchen",
"494927", "Krummhörn\-Loquard",
"494972", "Langeoog",
"495431", "Quakenbrück",
"4939485", "Gernrode\ Harz",
"497930", "Boxberg\ Baden",
"495485", "Ladbergen",
"492301", "Holzwickede",
"499207", "Königsfeld\ Oberfranken",
"497825", "Kippenheim",
"499371", "Miltenberg",
"496136", "Nieder\-Olm",
"4939298", "Barby\ Elbe",
"494166", "Ahlerstedt",
"492222", "Bornheim\ Rheinland",
"49871", "Landshut",
"499085", "Alerheim",
"497940", "Künzelsau",
"495441", "Diepholz",
"496526", "Bollendorf",
"495368", "Parsau",
"496198", "Eppstein",
"493641", "Jena",
"494933", "Dornum\ Ostfriesland",
"496045", "Gedern",
"496693", "Neuental",
"4939481", "Hedersleben\ bei\ Aschersleben",
"499562", "Sonnefeld",
"495752", "Auetal\-Hattendorf",
"492553", "Ochtrup",
"499929", "Ruhmannsfelden",
"499186", "Lauterhofen\ Oberpfalz",
"498671", "Altötting",
"496375", "Wallhalben",
"496035", "Reichelsheim\ Wetterau",
"496081", "Usingen",
"494943", "Grossefehn",
"493685", "Hildburghausen",
"493631", "Nordhausen\ Thüringen",
"494209", "Schwanewede",
"496858", "Ottweiler\-Fürth",
"4939402", "Völpke",
"49211", "Düsseldorf",
"495621", "Bad\ Wildungen",
"497363", "Lauchheim",
"497541", "Friedrichshafen",
"4939829", "Blankenförde",
"499158", "Offenhausen\ Mittelfranken",
"4934633", "Braunsbedra",
"4939397", "Geestgottberg",
"492208", "Niederkassel",
"492486", "Nettersheim",
"494822", "Kellinghusen",
"4939973", "Altkalen",
"494877", "Hennstedt\ bei\ Itzehoe",
"499278", "Weidenberg",
"497975", "Untergröningen",
"497585", "Ostrach",
"4936606", "Kraftsdorf",
"497531", "Konstanz",
"49941", "Regensburg",
"4933741", "Niedergörsdorf",
"496754", "Martinstein",
"497121", "Reutlingen",
"495261", "Lemgo",
"4933632", "Hangelsberg",
"499836", "Gunzenhausen\-Cronheim",
"496409", "Biebertal",
"494297", "Ottersberg\-Posthausen",
"497062", "Beilstein\ Württemberg",
"494704", "Drangstedt",
"499846", "Ipsheim",
"499653", "Eslarn",
"492992", "Marsberg",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"492662", "Hachenburg",
"498501", "Thyrnau",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"4935439", "Zinnitz",
"498052", "Aschau\ im\ Chiemgau",
"496340", "Wörth\-Schaidt",
"4933745", "Petkus",
"496152", "Gross\-Gerau",
"494384", "Selent",
"498664", "Chieming",
"4938871", "Mühlen\ Eichsen",
"492054", "Essen\-Kettwig",
"49234", "Bochum",
"495605", "Kaufungen\ Hessen",
"498841", "Murnau\ am\ Staffelsee",
"498250", "Hilgertshausen\-Tandern",
"494959", "Dollart",
"499283", "Rehau",
"492129", "Haan\ Rheinland",
"498170", "Strasslach\-Dingharting",
"4934973", "Osternienburg",
"497475", "Burladingen",
"4936021", "Schlotheim",
"4934906", "Raguhn",
"497654", "Löffingen",
"4937203", "Gersdorf\ bei\ Chemnitz",
"49991", "Deggendorf",
"493871", "Parchim",
"496227", "Walldorf\ Baden",
"4934497", "Langenleuba\-Niederhain",
"497260", "Sinsheim\-Hilsbach",
"496272", "Hirschhorn\ Neckar",
"496243", "Monsheim",
"4937436", "Weischlitz",
"499364", "Zellingen",
"495746", "Rödinghausen",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4939389", "Schollene",
"493726", "Flöha",
"494263", "Scheessel",
"496233", "Frankenthal\ Pfalz",
"494102", "Ahrensburg",
"4936025", "Körner",
"4935263", "Gröditz\ bei\ Riesa",
"4933972", "Breddin",
"492325", "Wanne\-Eickel",
"492770", "Eschenburg",
"4939489", "Strassberg\ Harz",
"4936846", "Suhl\-Dietzhausen",
"4938429", "Glasin",
"492364", "Haltern\ Westfalen",
"4938220", "Wustrow\ Ostseebad",
"496567", "Oberkail",
"4936331", "Ilfeld",
"497520", "Bodnegg",
"494537", "Sülfeld\ Holstein",
"498435", "Ehekirchen",
"494127", "Westerhorn",
"492957", "Wünnenberg\-Haaren",
"494172", "Salzhausen",
"493475", "Lutherstadt\ Eisleben",
"497130", "Löwenstein\ Württemberg",
"494252", "Bruchhausen\-Vilsen",
"499492", "Parsberg",
"494547", "Gudow\ Lauenburg",
"494966", "Neubörger",
"494638", "Tarp",
"498445", "Gerolsbach",
"496668", "Birstein\-Lichenroth",
"4939404", "Ausleben",
"496589", "Kell\ am\ See",
"499325", "Kleinlangheim",
"496163", "Höchst\ im\ Odenwald",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"496202", "Schwetzingen",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4935202", "Klingenberg\ Sachsen",
"4936335", "Grosswechsungen",
"494523", "Malente",
"497726", "Bad\ Dürrheim",
"492506", "Münster\-Wolbeck",
"499549", "Lisberg",
"4933966", "Dranse",
"494143", "Drochtersen",
"495454", "Hörstel\-Riesenbeck",
"495675", "Trendelburg",
"4934928", "Seegrehna",
"499129", "Wendelstein",
"499576", "Lichtenfels\-Isling",
"49760", "Oberried\ Breisgau",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"49291", "Meschede",
"4933094", "Löwenberg",
"4937605", "Hartenstein\ Sachsen",
"496446", "Hohenahr",
"492836", "Wachtendonk",
"495521", "Herzberg\ am\ Harz",
"4939052", "Erxleben\ bei\ Haldensleben",
"497053", "Bad\ Teinach\-Zavelstein",
"498571", "Simbach\ am\ Inn",
"495131", "Garbsen",
"493531", "Finsterwalde",
"495185", "Duingen",
"493585", "Löbau",
"494774", "Hechthausen",
"499662", "Vilseck",
"494466", "Wittmund\-Ardorf",
"496436", "Dornburg\ Hessen",
"492653", "Kaisersesch",
"498063", "Feldkirchen\-Westerham",
"496593", "Hillesheim\ Eifel",
"496857", "Namborn",
"496479", "Waldbrunn\ Westerwald",
"493541", "Calau",
"495141", "Celle",
"497352", "Ochsenhausen",
"4937601", "Mülsen\ Skt\ Jacob",
"496626", "Wildeck\-Obersuhl",
"4938293", "Kühlungsborn\ Ostseebad",
"497905", "Langenburg",
"495086", "Celle\-Scheuen",
"499208", "Bindlach",
"494928", "Ihlow\-Riepe",
"492158", "Grefrath\ bei\ Krefeld",
"49681", "Saarbrücken",
"498362", "Füssen",
"4939928", "Möllenhagen",
"494682", "Amrum",
"4936628", "Zeulenroda",
"495954", "Lorup",
"4936204", "Stotternheim",
"49241", "Aachen",
"495367", "Rühen",
"494236", "Kirchlinteln",
"498194", "Vilgertshofen",
"496266", "Hassmersheim",
"4938321", "Martensdorf\ bei\ Stralsund",
"4934746", "Giersleben",
"499553", "Ebrach\ Oberfranken",
"495763", "Uchte",
"4938735", "Plau\ am\ See",
"496305", "Hochspeyer",
"494298", "Lilienthal",
"495845", "Bergen\ Dumme",
"492562", "Gronau\ Westfalen",
"494246", "Twistringen\-Heiligenloh",
"494159", "Basthorst",
"4933974", "Dessow",
"495835", "Wahrenholz",
"49911", "Nuremberg",
"492041", "Bottrop",
"4938325", "Rolofshagen",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4938731", "Lübz",
"4936370", "Grossenehrich",
"492207", "Kürten\-Dürscheid",
"499157", "Alfeld\ Mittelfranken",
"4935606", "Briesen\ bei\ Cottbus",
"497631", "Müllheim\ Baden",
"497685", "Gutach\-Bleibach",
"499277", "Warmensteinach",
"499222", "Presseck",
"4935893", "Mücka",
"492371", "Iserlohn",
"494902", "Jemgum\-Ditzum",
"4938425", "Kirchdorf\ Poel",
"4939363", "Angern",
"494355", "Rieseby",
"497641", "Emmendingen",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499735", "Massbach",
"4939746", "Krackow",
"496452", "Battenberg\ Eder",
"4935025", "Liebstadt",
"497255", "Graben\-Neudorf",
"4933362", "Liepe\ Kreis\ Barnim",
"498306", "Ronsberg",
"497175", "Leinzell",
"4939754", "Löcknitz\ Vorpom",
"492852", "Hamminkeln",
"495204", "Steinhagen\ Westfalen",
"492429", "Hürtgenwald",
"499745", "Wildflecken",
"4936927", "Unterellen",
"4935820", "Zodel",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"498265", "Pfaffenhausen\ Schwaben",
"492639", "Anhausen\ Kreis\ Neuwied",
"497346", "Illerkirchberg",
"494761", "Bremervörde",
"496731", "Alzey",
"496785", "Herrstein",
"4934463", "Bad\ Kösen",
"492676", "Ulmen",
"497554", "Heiligenberg\ Baden",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4933457", "Altreetz",
"497336", "Lonsee",
"4935933", "Neschwitz",
"492192", "Hückeswagen",
"494883", "Süderstapel",
"499606", "Pfreimd",
"494402", "Rastede",
"4937609", "Wolkenburg\ Mulde",
"496741", "St\ Goar",
"495505", "Hardegsen",
"496094", "Weibersbrunn",
"496228", "Schönau\ Odenwald",
"4934363", "Cavertitz",
"498564", "Johanniskirchen",
"499505", "Litzendorf",
"4933977", "Gumtow",
"493867", "Lübstorf",
"496353", "Freinsheim",
"495606", "Zierenberg",
"497449", "Baiersbronn\-Obertal",
"498754", "Volkenschwand",
"4937325", "Niederbobritzsch",
"4933085", "Seilershof",
"492941", "Lippstadt",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494551", "Bad\ Segeberg",
"4933763", "Bestensee",
"497764", "Herrischried",
"494778", "Wingst",
"497300", "Roggenburg",
"492931", "Arnsberg",
"492575", "Greven\-Reckenfeld",
"492985", "Winterberg\-Niedersfeld",
"497476", "Bisingen",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"495745", "Stemwede\-Levern",
"4935058", "Pretzschendorf",
"499204", "Plankenfels",
"497629", "Tegernau\ Baden",
"496501", "Konz",
"492154", "Willich",
"494924", "Moormerland\-Oldersum",
"4934492", "Lucka",
"495863", "Zernien",
"498340", "Baisweil",
"4937321", "Frankenstein\ Sachsen",
"4939959", "Dargun",
"496052", "Bad\ Orb",
"499420", "Feldkirchen\ Niederbayern",
"494303", "Schlesen",
"4937421", "Oelsnitz\ Vogtland",
"493725", "Zschopau",
"492274", "Elsdorf\ Rheinland",
"498330", "Legau",
"494644", "Karby",
"497949", "Pfedelbach\-Untersteinbach",
"497162", "Süssen",
"497203", "Walzbachtal",
"495277", "Höxter\-Fürstenau",
"495222", "Bad\ Salzuflen",
"4936924", "Mihla",
"498272", "Wertingen",
"494861", "Tönning",
"492368", "Oer\-Erkenschwick",
"492441", "Kall",
"496831", "Saarlouis",
"4939208", "Loitsche",
"494634", "Husby",
"496664", "Sinntal\-Sterbfritz",
"4939003", "Jübar",
"498152", "Herrsching\ am\ Ammersee",
"497939", "Schrozberg\-Spielbach",
"492431", "Erkelenz",
"496841", "Homburg\ Saar",
"492485", "Schleiden\-Dreiborn",
"495301", "Lehre\-Essenrode",
"4933637", "Beerfelde",
"4938458", "Zehna",
"495157", "Emmerthal\-Börry",
"4935245", "Burkhardswalde\-Munzig",
"497586", "Herbertingen",
"497976", "Sulzbach\-Laufen",
"498233", "Kissing",
"499835", "Ehingen\ Mittelfranken",
"49351", "Dresden",
"49511", "Hannover",
"499920", "Bischofsmais",
"492621", "Lahnstein",
"4933454", "Wölsickendorf\/Wollenberg",
"497021", "Kirchheim\ unter\ Teck",
"498243", "Fuchstal",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"492752", "Bad\ Laasphe",
"495458", "Hopsten",
"499845", "Oberdachstetten",
"4935241", "Lommatzsch",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"495553", "Kalefeld",
"4939407", "Seehausen\ Börde",
"499954", "Simbach\ Niederbayern",
"497826", "Schuttertal",
"4938845", "Kaarssen",
"499367", "Unterpleichfeld",
"4939996", "Törpin",
"49761", "Freiburg\ im\ Breisgau",
"496145", "Flörsheim\ am\ Main",
"492261", "Gummersbach",
"496525", "Irrel",
"49201", "Essen",
"496181", "Hanau",
"493462", "Bad\ Dürrenberg",
"496135", "Bodenheim\ Rhein",
"494165", "Hollenstedt\ Nordheide",
"4939955", "Jürgenstorf",
"495208", "Leopoldshöhe",
"499086", "Fremdingen",
"4933704", "Baruth\ Mark",
"496349", "Billigheim\-Ingenheim",
"497453", "Altensteig\ Württemberg",
"497558", "Illmensee",
"495662", "Felsberg\ Hessen",
"4938841", "Neuhaus\ Elbe",
"4933678", "Storkow\ Mark",
"499141", "Weissenburg\ in\ Bayern",
"498667", "Seeon\-Seebruck",
"497771", "Stockach",
"496046", "Ortenberg\ Hessen",
"499521", "Hassfurt",
"496224", "Sandhausen\ Baden",
"496339", "Grosssteinhausen",
"498463", "Greding",
"497394", "Schelklingen",
"499131", "Erlangen",
"497657", "Eisenbach\ Hochschwarzwald",
"499185", "Mühlhausen\ Oberpfalz",
"496400", "Mücke",
"496036", "Wölfersheim",
"4936651", "Lobenstein",
"4939951", "Faulenrost",
"4933089", "Himmelpfort",
"493686", "Eisfeld",
"4937329", "Grosshartmannsdorf",
"497269", "Sulzfeld\ Baden",
"495129", "Söhlde",
"493529", "Heidenau\ Sachsen",
"49671", "Bad\ Kreuznach",
"494707", "Langen\-Neuenwalde",
"499675", "Altendorf\ am\ Nabburg",
"498136", "Markt\ Indersdorf",
"494294", "Riede\ Kreis\ Verden",
"4937293", "Eppendorf\ Sachsen",
"499454", "Aufhausen\ Oberpfalz",
"494950", "Holtland",
"498179", "Eurasburg\ an\ der\ Loisach",
"499393", "Rothenfels\ Unterfranken",
"498259", "Schiltberg",
"498146", "Moorenweis",
"495054", "Bergen\-Sülze",
"493962", "Penzlin\ bei\ Waren",
"4934955", "Gossa",
"492605", "Löf",
"492779", "Greifenstein\-Beilstein",
"498081", "Dorfen\ Stadt",
"497953", "Blaufelden",
"498035", "Raubling",
"493381", "Brandenburg\ an\ der\ Havel",
"493335", "Finowfurt",
"495492", "Steinfeld\ Oldenburg",
"4936207", "Plaue\ Thüringen",
"498375", "Weitnau",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"492736", "Burbach\ Siegerl",
"4935249", "Basslitz",
"495325", "Goslar\-Hahnenklee",
"498858", "Kochel\-Walchensee",
"496757", "Becherbach\ bei\ Kirn",
"498045", "Lenggries\-Fall",
"499092", "Wemding",
"494874", "Todenbüttel",
"4936643", "Thimmendorf",
"496074", "Rödermark",
"4933848", "Raben",
"496229", "Neckarsteinach",
"4937296", "Stollberg\ Erzgebirge",
"494364", "Dahme\ Kreis\ Ostholstein",
"498684", "Fridolfing",
"496334", "Thaleischweiler\-Fröschen",
"494957", "Detern",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"498733", "Mengkofen",
"4934783", "Gerbstedt",
"493773", "Johanngeorgenstadt",
"4936337", "Schiedungen",
"499263", "Ludwigsstadt",
"492547", "Rosendahl\-Osterwick",
"492696", "Nohn\ Eifel",
"499102", "Wilhermsdorf",
"496344", "Schwegenheim",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"492252", "Zülpich",
"498743", "Geisenhausen",
"496556", "Pronsfeld",
"492638", "Waldbreitbach",
"498772", "Mallersdorf\-Pfaffenberg",
"499384", "Schwanfeld",
"498727", "Falkenberg\ Niederbayern",
"492133", "Dormagen",
"4938856", "Pritzier\ bei\ Hagenow",
"4935323", "Sonnewalde",
"494506", "Stockelsdorf\-Krumbeck",
"497703", "Bonndorf\ im\ Schwarzwald",
"497195", "Winnenden",
"4939954", "Stavenhagen\ Reuterstadt",
"495777", "Diepenau\-Essern",
"492428", "Niederzier",
"495722", "Bückeburg",
"492523", "Wadersloh",
"494283", "Tarmstedt",
"4938844", "Gülze",
"4933701", "Grossbeeren",
"49491", "Leer\ Ostfriesland",
"495651", "Eschwege",
"4936646", "Tanna\ bei\ Schleiz",
"494836", "Hennstedt\ Dithmarschen",
"497383", "Münsingen\-Buttenhausen",
"496866", "Perl\-Nennig",
"498555", "Perlesreut",
"4936929", "Ruhla",
"4939993", "Hohenmocker",
"4936693", "Crossen\ an\ der\ Elster",
"499360", "Thüngen",
"495245", "Herzebrock\-Clarholz",
"492391", "Plettenberg",
"499704", "Euerdorf",
"4938228", "Dettmannsdorf\-Kölzow",
"494846", "Hattstedt",
"4936873", "Themar",
"492774", "Dietzhölztal",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"496108", "Mühlheim\ am\ Main",
"495281", "Bad\ Pyrmont",
"495235", "Blomberg\ Lippe",
"495356", "Helmstedt\-Barmke",
"4933832", "Rogäsen",
"498254", "Altomünster",
"4934920", "Kropstädt",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"492928", "Soest\-Ostönnen",
"497082", "Neuenbürg\ Württemberg",
"494158", "Roseburg",
"4937607", "Ebersbrunn\ Sachsen",
"4933608", "Jacobsdorf\ Mark",
"495544", "Reinhardshagen",
"4939061", "Weferlingen",
"499822", "Bechhofen\ an\ der\ Heide",
"497264", "Bad\ Rappenau",
"492682", "Hamm\ Sieg",
"49441", "Oldenburg",
"496407", "Rabenau\ Hessen",
"495534", "Eschershausen\ an\ der\ Lenne",
"4934342", "Neukieritzsch",
"498404", "Oberdolling",
"496122", "Hofheim\-Wallau",
"492236", "Wesseling\ Rheinland",
"499933", "Wallersdorf",
"4939728", "Medow\ bei\ Anklam",
"4935828", "Reichenbach\ OL",
"494562", "Grömitz",
"4930", "Berlin",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496532", "Zeltingen\-Rachtig",
"4938327", "Elmenhorst\ Vorpom",
"494929", "Ihlow\ Kreis\ Aurich",
"492159", "Meerbusch\-Osterath",
"494186", "Buchholz\-Trelde",
"4939006", "Miesterhorst",
"499943", "Lam\ Oberpfalz",
"497624", "Grenzach\-Wyhlen",
"499209", "Emtmannsberg",
"492246", "Lohmar\ Rheinland",
"496542", "Bullay",
"496257", "Seeheim\-Jugenheim",
"4938427", "Blowatz",
"497434", "Winterlingen",
"4938737", "Ganzlin",
"496478", "Greifenstein\-Ulm",
"496573", "Gillenfeld",
"499927", "Kirchberg\ Wald",
"499972", "Waldmünchen",
"494794", "Worpswede\-Ostersode",
"494207", "Oyten",
"49621", "Mannheim",
"494371", "Burg\ auf\ Fehmarn",
"498591", "Obernzell",
"492902", "Warstein",
"499166", "Münchsteinach",
"497444", "Alpirsbach",
"496061", "Michelstadt",
"492355", "Schalksmühle",
"4937324", "Reinsberg\ Sachsen",
"4933084", "Gutengermendorf",
"497271", "Wörth\ am\ Rhein",
"4939342", "Gladau",
"499433", "Nabburg",
"493860", "Raben\ Steinfeld",
"499128", "Feucht",
"495965", "Klein\ Berssen",
"495695", "Twistetal",
"495043", "Lauenau",
"498161", "Freising",
"499647", "Kirchenthumbach",
"499548", "Mühlhausen\ Mittelfranken",
"494852", "Brunsbüttel",
"498323", "Immenstadt\ im\ Allgäu",
"4936921", "Wutha\-Farnroda",
"4933766", "Teupitz",
"499443", "Abensberg",
"495033", "Wunstorf\-Grossenheidorn",
"499637", "Falkenberg\ Oberpfalz",
"496724", "Stromberg\ Hunsrück",
"497151", "Waiblingen",
"495373", "Hillerse\ Kreis\ Gifhorn",
"497307", "Senden\ Iller",
"4933396", "Klosterfelde",
"492761", "Olpe\ Biggesee",
"496588", "Pluwig",
"497934", "Weikersheim",
"4935388", "Klöden",
"496802", "Völklingen\-Lauterbach",
"4935027", "Weesenstein",
"494639", "Schafflund",
"496483", "Selters\ Taunus",
"496669", "Neuhof\-Hauswurz",
"4935244", "Krögis",
"499427", "Leiblfing",
"499472", "Hohenfels\ Oberpfalz",
"498347", "Friesenried",
"492402", "Stolberg\ Rheinland",
"497944", "Kupferzell",
"495332", "Schöppenstedt",
"4936925", "Marksuhl",
"494192", "Bad\ Bramstedt",
"495072", "Neustadt\-Mandelsloh",
"495027", "Linsburg",
"498022", "Tegernsee",
"493377", "Zossen\ Brandenburg",
"4933451", "Heckelberg",
"493322", "Falkensee",
"4936378", "Ostramondra",
"498337", "Altenstadt\ Iller",
"4938424", "Bobitz",
"499072", "Lauingen\ Donau",
"4935843", "Hirschfelde\ bei\ Zittau",
"4939743", "Zerrenthin",
"493447", "Altenburg\ Thüringen",
"495623", "Edertal",
"499708", "Bad\ Bocklet",
"499332", "Marktbreit",
"4933971", "Kyritz\ Brandenburg",
"496083", "Weilrod",
"494941", "Aurich",
"4938450", "Tarnow\ bei\ Bützow",
"496104", "Heusenstamm",
"498422", "Dollnstein",
"4938324", "Velgast",
"499342", "Wertheim",
"492551", "Steinfurt\-Burgsteinfurt",
"493437", "Grimma",
"4939200", "Gommern",
"495427", "Melle\-Buer",
"493643", "Weimar\ Thüringen",
"492778", "Siegbach",
"495472", "Bad\ Essen",
"4939409", "Eilsleben",
"498395", "Tannheim\ Württemberg",
"494931", "Norden",
"496691", "Schwalmstadt",
"4933087", "Bredereiche",
"493672", "Rudolstadt",
"495443", "Lemförde",
"4937327", "Rechenberg\-Bienenmühle",
"492924", "Möhnesee",
"494154", "Trittau",
"496382", "Lauterecken",
"4936022", "Grossengottern",
"499373", "Amorbach",
"4934466", "Janisroda",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"498258", "Sielenbach",
"498178", "Icking",
"4935936", "Sohland\ Spree",
"495433", "Badbergen",
"492303", "Unna",
"498642", "Übersee",
"494326", "Wankendorf",
"493423", "Eilenburg",
"495647", "Lichtenau\-Kleinenberg",
"4938872", "Rehna",
"497268", "Bad\ Rappenau\-Obergimpern",
"494274", "Varrel\ bei\ Sulingen",
"493528", "Radeberg",
"499965", "Sankt\ Englmar",
"495128", "Hohenhameln",
"496396", "Hinterweidenthal",
"495166", "Walsrode\-Kirchboitzen",
"4934743", "Ermsleben",
"4939751", "Penkun",
"497226", "Bühl\-Sand",
"492644", "Linz\ am\ Rhein",
"493947", "Thale",
"496078", "Gross\-Umstadt",
"497034", "Ehningen",
"497374", "Uttenweiler",
"492861", "Borken\ Westfalen",
"494441", "Vechta",
"496338", "Hornbach\ Pfalz",
"4933631", "Bad\ Saarow\-Pieskow",
"493937", "Osterburg\ Altmark",
"492634", "Rengsdorf",
"497044", "Mönsheim",
"496348", "Offenbach\ an\ der\ Queich",
"494431", "Wildeshausen",
"4934658", "Hayn\ Harz",
"495808", "Gerdau",
"494485", "Elsfleth\-Huntorf",
"496461", "Biedenkopf",
"495582", "Sankt\ Andreasberg",
"495065", "Sibbesse",
"495209", "Gütersloh\-Friedrichsdorf",
"495943", "Emlichheim",
"492424", "Vettweiss",
"493304", "Velten",
"494621", "Schleswig",
"4935603", "Burg\ Spreewald",
"4933742", "Oehna\ Brandenburg",
"495933", "Lathen",
"496824", "Ottweiler",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"499270", "Creussen",
"4935247", "Zehren\ Sachsen",
"4939366", "Kehnert",
"493923", "Zerbst",
"4935024", "Stadt\ Wehlen",
"4936209", "Klettbach",
"499465", "Neukirchen\-Balbini",
"494752", "Neuhaus\ Oste",
"497482", "Horb\-Dettingen",
"495459", "Hörstel",
"495822", "Ebstorf",
"497803", "Gengenbach",
"4939401", "Neuwegersleben",
"494261", "Rotenburg\ Wümme",
"496231", "Hochdorf\-Assenheim",
"499534", "Burgpreppach",
"496285", "Walldürn\-Altheim",
"4939382", "Kamern",
"4936334", "Wolkramshausen",
"496007", "Rosbach\-Rodheim",
"496728", "Ober\-Hilbersheim",
"499356", "Burgsinn",
"4939482", "Gatersleben",
"499544", "Baunach",
"496241", "Worms",
"4933979", "Wusterhausen\ Dosse",
"492165", "Jüchen",
"497755", "Weilheim\ Kreis\ Waldshut",
"497666", "Denzlingen",
"499281", "Hof\ Saale",
"496584", "Wellen\ Mosel",
"499235", "Thierstein",
"4938296", "Rerik\ Ostseebad",
"4939405", "Hötensleben",
"497938", "Mulfingen\ Jagst",
"492387", "Drensteinfurt\-Walstedde",
"4938847", "Boizenburg\ Elbe",
"498292", "Dinkelscherben",
"498765", "Bruckberg\ Niederbayern",
"498656", "Anger",
"492369", "Dorsten\-Wulfen",
"4939957", "Gielow",
"495704", "Petershagen\-Friedewalde",
"497948", "Öhringen\-Ohrnberg",
"499245", "Obertrubach",
"492066", "Duisburg\-Homberg",
"496190", "Hattersheim\ am\ Main",
"497572", "Mengen\ Württemberg",
"497527", "Wolfegg",
"492294", "Morsbach\ Sieg",
"494120", "Ellerhoop",
"4934382", "Nerchau",
"499651", "Vohenstrauss",
"4936205", "Gräfenroda",
"498503", "Neuhaus\ am\ Inn",
"495384", "Seesen\-Gross\ Rhüden",
"497147", "Sachsenheim\ Württemberg",
"494605", "Medelby",
"499777", "Ostheim\ von\ der\ Rhön",
"499722", "Werneck",
"497628", "Efringen\-Kirchen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4935722", "Lauta\ bei\ Hoyerswerda",
"4939822", "Kratzeburg",
"499804", "Aurach",
"492595", "Olfen",
"495102", "Laatzen",
"494779", "Freiburg\ Elbe",
"497123", "Metzingen\ Württemberg",
"495263", "Barntrup",
"496655", "Neuhof\ Kreis\ Fulda",
"496474", "Villmar\-Aumenau",
"494736", "Butjadingen\-Tossens",
"496766", "Kisselbach",
"4936201", "Walschleben",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"497533", "Allensbach",
"4937604", "Mosel",
"492874", "Isselburg",
"497361", "Aalen",
"497448", "Seewald",
"497543", "Kressbronn\ am\ Bodensee",
"494746", "Hagen\ bei\ Bremerhaven",
"495966", "Meppen\-Apeldorn",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"495696", "Bad\ Arolsen\-Landau",
"493628", "Arnstadt",
"495252", "Bad\ Lippspringe",
"492804", "Xanten\-Marienbaum",
"4933744", "Hohenseefeld",
"498257", "Inchenhofen",
"498542", "Ortenburg",
"4934976", "Gröbzig",
"498122", "Erding",
"496404", "Lich\ Hessen",
"498177", "Münsing\ Starnberger\ See",
"4934903", "Coswig\ Anhalt",
"4937206", "Frankenberg\ Sachsen",
"496220", "Wilhelmsfeld",
"497267", "Gemmingen",
"495127", "Harsum",
"495172", "Ilsede",
"499874", "Neuendettelsau",
"495648", "Brakel\-Gehrden",
"4935022", "Bad\ Schandau",
"498532", "Griesbach\ im\ Rottal",
"498061", "Bad\ Aibling",
"493448", "Meuselwitz\ Thüringen",
"4937433", "Gutenfürst",
"4933361", "Joachimsthal",
"493361", "Fürstenwalde\ Spree",
"496591", "Gerolstein",
"499294", "Regnitzlosau",
"494454", "Jade",
"495143", "Winsen\ Aller",
"4939059", "Wegenstedt",
"4933981", "Putlitz",
"492651", "Mayen",
"497051", "Calw",
"494393", "Boostedt",
"498573", "Ering",
"493533", "Elsterwerda",
"4935266", "Heyda\ bei\ Riesa",
"492777", "Breitscheid\ Hessen",
"492722", "Attendorn",
"495428", "Melle\-Neuenkirchen",
"4939347", "Kade",
"49821", "Augsburg",
"493496", "Köthen\ Anhalt",
"495523", "Bad\ Sachsa",
"4936843", "Benshausen",
"497502", "Wolpertswende",
"4936024", "Diedorf\ bei\ Mühlhausen",
"4935209", "Mohorn",
"495466", "Merzen",
"496323", "Edenkoben",
"497842", "Kappelrodeck",
"495774", "Wagenfeld\-Ströhen",
"498724", "Massing",
"494141", "Stade",
"4934636", "Schafstädt",
"492235", "Erftstadt",
"4939976", "Gross\ Bützin",
"499369", "Uettingen",
"494521", "Eutin",
"4936603", "Weida",
"497832", "Haslach\ im\ Kinzigtal",
"496161", "Brensbach",
"4938732", "Gallin\ bei\ Lübz",
"494131", "Lüneburg",
"494185", "Marxen\ Auetal",
"4938874", "Lützow",
"492245", "Much",
"495682", "Borken\ Hessen",
"494954", "Moormerland",
"4938422", "Neukloster",
"494367", "Grossenbrode",
"4933878", "Nennhausen",
"496337", "Grossbundenbach",
"498687", "Taching\-Tengling",
"496022", "Obernburg\ am\ Main",
"492534", "Münster\-Roxel",
"498669", "Traunreut",
"4938322", "Richtenberg",
"498802", "Huglfing",
"495807", "Altenmedingen",
"4937360", "Olbernhau",
"496347", "Hochstadt\ Pfalz",
"499165", "Sugenheim",
"4934347", "Oelzschau\ bei\ Borna",
"493996", "Teterow",
"498344", "Westendorf\ bei\ Kaufbeuren",
"495159", "Coppenbrügge\-Bisperode",
"4935724", "Lohsa",
"497182", "Welzheim",
"4939824", "Hohenzieritz",
"495246", "Verl",
"499424", "Strasskirchen",
"49335", "Frankfurt\ \(Oder\)",
"494835", "Albersdorf\ Holstein",
"494881", "Friedrichstadt",
"492388", "Hamm\-Uentrop",
"496865", "Mettlach\-Orscholz",
"494920", "Wirdum",
"492150", "Meerbusch\-Lank",
"496743", "Bacharach",
"497937", "Dörzbach",
"498556", "Haidmühle",
"4937602", "Kirchberg\ Sachsen",
"498334", "Bad\ Grönenbach",
"496684", "Hofbieber\-Schwarzbach",
"498074", "Schnaitsee",
"495236", "Blomberg\-Grossenmarpe",
"492465", "Inden",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4933837", "Brielow",
"494845", "Ostenfeld\ Husum",
"4939055", "Hörsingen",
"497947", "Forchtenberg",
"494763", "Gnarrenburg",
"496733", "Gau\-Odernheim",
"497566", "Argenbühl",
"495902", "Freren",
"499644", "Pressath",
"495355", "Frellstedt",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4934384", "Grossbothen",
"496727", "Gensingen",
"499634", "Wiesau",
"496772", "Nastätten",
"497304", "Blaustein\ Württemberg",
"4933369", "Oderberg",
"496008", "Echzell",
"4935434", "Altdöbern",
"4933989", "Sadenbeck",
"4939051", "Calvörde",
"494204", "Thedinghausen",
"499924", "Bodenmais",
"497643", "Herbolzheim\ Breisgau",
"492373", "Menden\ Sauerland",
"496555", "Bleialf",
"4933473", "Zechin",
"497633", "Staufen\ im\ Breisgau",
"4935201", "Langebrück",
"499303", "Eibelstadt",
"492043", "Gladbeck",
"492695", "Insul",
"493869", "Dümmer",
"497447", "Baiersbronn\-Schwarzenberg",
"494505", "Stockelsdorf\-Curau",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"497423", "Oberndorf\ am\ Neckar",
"492332", "Gevelsberg",
"497528", "Neukirch\ bei\ Tettnang",
"4939248", "Dobritz",
"495883", "Lemgow",
"4933233", "Ketzin",
"498407", "Grossmehring",
"496174", "Königstein\ im\ Taunus",
"497138", "Schwaigern",
"4939384", "Arendsee\ Altmark",
"499551", "Burgwindheim",
"496254", "Lautertal\ Odenwald",
"495761", "Stolzenau",
"4936332", "Ellrich",
"4935205", "Ottendorf\-Okrilla",
"494630", "Barderup",
"499778", "Fladungen",
"497627", "Steinen\ Kreis\ Lörrach",
"496660", "Steinau\-Marjoss",
"497672", "St\ Blasien",
"4939484", "Harzgerode",
"497148", "Grossbottwar",
"498728", "Geratskirchen",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"493307", "Zehdenick",
"4933834", "Pritzerbe",
"495551", "Northeim",
"497023", "Weilheim\ an\ der\ Teck",
"498241", "Buchloe",
"492427", "Nideggen",
"4936423", "Orlamünde",
"492472", "Monschau",
"494606", "Wanderup",
"4939399", "Kleinau",
"499402", "Regenstauf",
"492623", "Ransbach\-Baumbach",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4935727", "Burghammer",
"496872", "Losheim\ am\ See",
"496827", "Eppelborn",
"498285", "Burtenbach",
"498231", "Königsbrunn\ bei\ Augsburg",
"497322", "Giengen\ an\ der\ Brenz",
"492433", "Hückelhoven",
"496843", "Gersheim",
"49209", "Gelsenkirchen",
"495303", "Wendeburg",
"496656", "Ebersburg",
"496292", "Seckach",
"494735", "Butjadingen\-Stollhamm",
"496765", "Gemünden\ Hunsrück",
"492538", "Drensteinfurt\-Rinkerode",
"4934223", "Dommitzsch",
"492647", "Kesseling",
"492596", "Nordkirchen",
"493944", "Blankenburg\ Harz",
"4934773", "Schwittersdorf",
"494958", "Jemgum",
"494863", "Sankt\ Peter\-Ording",
"4936733", "Kaulsdorf",
"492443", "Mechernich",
"496833", "Rehlingen\-Siersburg",
"495924", "Bad\ Bentheim\-Gildehaus",
"492548", "Dülmen\-Rorup",
"494745", "Bad\ Bederkesa",
"492637", "Weissenthurm",
"498584", "Breitenberg\ Niederbayern",
"496286", "Walldürn\-Rippberg",
"495634", "Waldeck\-Sachsenhausen",
"492927", "Neuengeseke",
"4936652", "Wurzbach",
"493624", "Ohrdruf",
"492582", "Everswinkel",
"492972", "Schmallenberg",
"4939952", "Grammentin",
"494277", "Schwaförden",
"494222", "Ganderkesee",
"4938842", "Lüttenmark",
"495644", "Willebadessen\-Peckelsheim",
"492166", "Mönchengladbach\-Rheydt",
"496503", "Hermeskeil",
"496408", "Buseck",
"495861", "Dannenberg\ Elbe",
"499355", "Frammersbach",
"499236", "Nagel",
"4939487", "Friedrichsbrunn",
"492933", "Sundern\ Sauerland",
"494553", "Geschendorf",
"499279", "Mistelgau",
"4939223", "Theessen",
"4935873", "Herrnhut",
"4939773", "Altwarp",
"497665", "March\ Breisgau",
"494458", "Wiefelstede\-Spohle",
"4935693", "Lauschütz",
"495424", "Bad\ Rothenfelde",
"4939387", "Havelberg",
"492943", "Erwitte",
"492065", "Duisburg\-Rheinhausen",
"499246", "Pegnitz\-Trockau",
"4938788", "Gross\ Warnow",
"498766", "Gammelsdorf",
"496351", "Eisenberg\ Pfalz",
"496107", "Kelsterbach",
"496477", "Greifenstein\-Nenderoth",
"498104", "Sauerlach",
"496422", "Kirchhain",
"4939391", "Lückstedt",
"494208", "Grasberg",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499928", "Kirchdorf\ im\ Wald",
"4935242", "Nossen",
"495165", "Rethem\ Aller",
"497225", "Gaggenau",
"499682", "Erbendorf",
"494486", "Edewecht\-Friedrichsfehn",
"492822", "Emmerich",
"4933747", "Marzahna",
"498083", "Isen",
"497951", "Crailsheim",
"4938333", "Horst\ bei\ Grimmen",
"496673", "Haunetal",
"4939456", "Altenbrak",
"496642", "Schlitz",
"4939395", "Wanzer",
"497134", "Weinsberg",
"4939344", "Güsen",
"499391", "Marktheidenfeld",
"492360", "Haltern\-Lippramsdorf",
"495066", "Sarstedt",
"497524", "Bad\ Waldsee",
"492297", "Wildbergerhütte",
"498382", "Lindau\ Bodensee",
"499774", "Oberelsbach",
"4938723", "Kladrum",
"494662", "Leck",
"4939083", "Messdorf",
"499466", "Stamsried",
"497144", "Marbach\ am\ Neckar",
"4938206", "Graal\-Müritz\ Seeheilbad",
"496258", "Gernsheim",
"492384", "Welver",
"499133", "Baiersdorf\ Mittelfranken",
"496587", "Zerf",
"4936256", "Wechmar",
"499523", "Hofheim\ in\ Unterfranken",
"4937422", "Markneukirchen",
"498348", "Bidingen",
"498461", "Beilngries",
"499428", "Kirchroth",
"499143", "Pappenheim\ Mittelfranken",
"495028", "Pennigsehl",
"495294", "Hövelhof\-Espeln",
"4936968", "Rossdorf\ Rhön",
"4935478", "Goyatz",
"494129", "Haseldorf",
"495707", "Petershagen\ Weser",
"497773", "Bodman\-Ludwigshafen",
"4934491", "Schmölln\ Thüringen",
"498338", "Böhen",
"4933082", "Menz\ Kreis\ Oberhavel",
"498702", "Wörth\ an\ der\ Isar",
"4937322", "Brand\-Erbisdorf",
"497451", "Horb\ am\ Neckar",
"496569", "Bickendorf",
"494539", "Westerau",
"493378", "Ludwigsfelde",
"4936027", "Lengenfeld\ Unterm\ Stein",
"496183", "Erlensee",
"4934344", "Kohren\-Sahlis",
"498824", "Oberau\ Loisach",
"497742", "Klettgau",
"495874", "Soltendieck",
"499648", "Neustadt\ am\ Kulm",
"499127", "Rosstal\ Mittelfranken",
"499172", "Georgensgmünd",
"499252", "Helmbrechts",
"494492", "Saterland",
"492263", "Engelskirchen",
"4934495", "Dobitschen",
"499547", "Zapfendorf",
"499966", "Wiesenfelden",
"492102", "Ratingen",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4934444", "Lützen",
"494770", "Wischhafen",
"499638", "Neualbenreuth",
"497732", "Radolfzell\ am\ Bodensee",
"497308", "Nersingen",
"496004", "Lich\-Eberstadt",
"497441", "Freudenstadt",
"499153", "Schnaittach",
"493763", "Glauchau",
"499906", "Mariaposching",
"4936330", "Grossberndten",
"4938221", "Marlow",
"492162", "Viersen",
"492203", "Cologne\-Porz",
"497431", "Albstadt\-Ebingen",
"497485", "Empfingen",
"4933605", "Boossen",
"495825", "Wieren",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"494559", "Wensin",
"492586", "Beelen",
"496282", "Walldürn",
"494791", "Osterholz\-Scharmbeck",
"49208", "Oberhausen\ Rheinland",
"49951", "Bamberg",
"493881", "Grevesmühlen",
"498762", "Wartenberg\ Oberbayern",
"498295", "Altenmünster\ Schwaben",
"496509", "Büdlich",
"4939927", "Nossentiner\ Hütte",
"497621", "Lörrach",
"499242", "Gössweinstein",
"4935389", "Holzdorf\ Elster",
"4938225", "Trinwillershagen",
"495767", "Warmsen",
"4933601", "Podelzig",
"4939263", "Unseburg",
"499658", "Georgenberg",
"4936379", "Holzengel",
"499232", "Wunsiedel",
"4935829", "Gersdorf\ bei\ Görlitz",
"497941", "Öhringen",
"496876", "Weiskirchen\ Saar",
"494602", "Freienwill",
"499406", "Mintraching",
"499725", "Poppenhausen\ Unterfranken",
"492449", "Blankenheim\ Ahr",
"492764", "Welschen\ Ennest",
"499288", "Bad\ Steben",
"497931", "Bad\ Mergentheim",
"497575", "Messkirch",
"4935973", "Stolpen",
"4936463", "Gebstedt",
"4933841", "Belzig",
"495309", "Lehre\-Wendhausen",
"496849", "Kirkel",
"4933674", "Trebatsch",
"4934927", "Globig\-Bleddin",
"4933708", "Rangsdorf",
"4937600", "Neumark\ Sachsen",
"498670", "Reischach\ Kreis\ Altötting",
"496721", "Bingen\ am\ Rhein",
"497154", "Kornwestheim",
"4934263", "Hohburg",
"492592", "Selm",
"494268", "Bötersen",
"497274", "Germersheim",
"496238", "Dirmstein",
"4935752", "Ruhland",
"4939852", "Schönermark\ bei\ Prenzlau",
"499867", "Geslau",
"495105", "Barsinghausen",
"497326", "Neresheim",
"4933845", "Borkheide",
"496652", "Hünfeld",
"496296", "Ahorn\ Baden",
"4938354", "Wusterhusen",
"498706", "Vilsheim",
"4937362", "Seiffen\ Erzgebirge",
"4936375", "Kindelbrück",
"4939204", "Niederndodeleben",
"496167", "Modautal",
"499345", "Külsheim\ Baden",
"494137", "Barendorf",
"492269", "Kierspe\-Rönsahl",
"495654", "Herleshausen",
"498392", "Markt\ Rettenbach",
"494527", "Bosau",
"4936928", "Neuenhof\ Thüringen",
"495475", "Bohmte\-Hunteburg",
"4938320", "Tribsees",
"4937462", "Rothenkirchen\ Vogtland",
"499075", "Glött",
"4938454", "Kritzkow",
"499335", "Aub\ Kreis\ Würzburg",
"499381", "Volkach",
"4934721", "Nienburg\ Saale",
"4938229", "Bad\ Sülze",
"4935385", "Annaburg",
"497736", "Tengen",
"496563", "Kyllburg",
"4936371", "Schlossvippach",
"494533", "Reinfeld\ Holstein",
"496341", "Landau\ in\ der\ Pfalz",
"4933609", "Brieskow\-Finkenheerd",
"498093", "Glonn\ Kreis\ Ebersberg",
"4933458", "Falkenberg\ Mark",
"496468", "Dautphetal\-Mornshausen",
"494496", "Friesoythe\-Markhausen",
"494123", "Barmstedt",
"492953", "Wünnenberg",
"499256", "Stammbach",
"499962", "Schwarzach\ Niederbayern",
"499149", "Weissenburg\-Suffersheim",
"494543", "Nusse",
"496071", "Dieburg",
"493675", "Sonneberg\ Thüringen",
"497746", "Wutöschingen",
"494361", "Oldenburg\ in\ Holstein",
"499529", "Oberaurach",
"498635", "Pleiskirchen",
"496385", "Reichenbach\-Steegen",
"499176", "Allersberg",
"498681", "Waging\ am\ See",
"496331", "Pirmasens",
"49261", "Koblenz\ am\ Rhein",
"497261", "Sinsheim",
"4934204", "Schkeuditz",
"495121", "Hildesheim",
"493521", "Meissen",
"498171", "Wolfratshausen",
"494803", "Pahlen",
"495585", "Herzberg\-Sieber",
"495975", "Rheine\-Mesum",
"4933849", "Wiesenburg\ Mark",
"495531", "Holzminden",
"494482", "Hatten",
"492826", "Kranenburg\ Niederrhein",
"498251", "Aichach",
"4939721", "Liepen\ bei\ Anklam",
"495363", "Wolfsburg\-Vorsfelde",
"496426", "Fronhausen",
"495541", "Hann\.\ Münden",
"4938393", "Binz\ Ostseebad",
"492771", "Dillenburg",
"494938", "Hagermarsch",
"496698", "Schrecksbach",
"4935020", "Struppen",
"494666", "Ladelund",
"4935054", "Lauenstein\ Sachsen",
"498386", "Oberstaufen",
"496636", "Romrod",
"492453", "Heinsberg\-Randerath",
"492558", "Horstmar",
"494755", "Ihlienworth",
"499462", "Falkenstein\ Oberpfalz",
"495284", "Schwalenberg",
"492657", "Uersfeld",
"495062", "Holle\ bei\ Hildesheim",
"494948", "Wiesmoor\-Marcardsmoor",
"4935825", "Kodersdorf",
"496853", "Marpingen",
"496597", "Jünkerath",
"496646", "Grebenau",
"492394", "Neuenrade\-Affeln",
"498067", "Tuntenhausen",
"499701", "Sandberg\ Unterfranken",
"492053", "Velbert\-Neviges",
"4934651", "Rossla",
"4936943", "Bettenhausen\ Thüringen",
"497457", "Rottenburg\-Ergenzingen",
"496545", "Blankenrath",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4938457", "Krakow\ am\ See",
"497836", "Schiltach",
"494383", "Grebin",
"498663", "Ruhpolding",
"498467", "Kinding",
"495462", "Ankum",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496535", "Osann\-Monzel",
"496581", "Saarburg",
"4939207", "Colbitz",
"497653", "Lenzkirch",
"492905", "Bestwig\-Ramsbeck",
"4937320", "Mulda\ Sachsen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4938792", "Lenzen\ \(Elbe\)",
"497158", "Neuhausen\ auf\ den\ Fildern",
"492352", "Altena\ Westfalen",
"496244", "Westhofen\ Rheinhessenen",
"498806", "Utting\ am\ Ammersee",
"499363", "Arnstein\ Unterfranken",
"49741", "Rottweil",
"498168", "Attenkirchen",
"496026", "Grossostheim",
"494264", "Sottrum\ Kreis\ Rotenburg",
"496329", "Weidenthal\ Pfalz",
"496234", "Mutterstadt",
"499975", "Waldmünchen\-Geigant",
"4937346", "Geyer",
"499531", "Ebern",
"4962196", "Ludwigshafen",
"495686", "Schwarzenborn\ Knüll",
"4938462", "Baumgarten",
"493576", "Weisswasser",
"495176", "Edemissen",
"495529", "Rhumspringe",
"494855", "Eddelak",
"498536", "Kösslarn",
"497957", "Kressberg",
"492871", "Bocholt",
"497364", "Oberkochen",
"495139", "Burgwedel",
"492520", "Wadersloh\-Diestedde",
"496068", "Beerfelden",
"4933978", "Segeletz",
"4933731", "Trebbin",
"496753", "Meisenheim",
"498546", "Windorf\-Otterskirchen",
"4934207", "Zwochau",
"495692", "Wolfhagen",
"495962", "Herzlake",
"495149", "Wienhausen",
"496471", "Weilburg",
"495335", "Schladen",
"492405", "Würselen",
"495381", "Seesen",
"497506", "Wangen\-Leupolz",
"494703", "Loxstedt\-Donnern",
"494195", "Hartenholm",
"498025", "Miesbach",
"496805", "Kleinblittersdorf",
"499260", "Wilhelmsthal\ Oberfranken",
"495345", "Baddeckenstedt",
"492291", "Waldbröl",
"4935240", "Tauscha\ bei\ Grossenhain",
"499397", "Wertheim\-Dertingen",
"4935057", "Hermsdorf\ Erzgebirge",
"49791", "Schwäbisch\ Hall",
"499654", "Pleystein",
"4936762", "Steinach\ Thüringen",
"499105", "Grosshabersdorf",
"493606", "Heiligenstadt\ Heilbad",
"492255", "Euskirchen\-Flamersheim",
"498862", "Steingaden\ Oberbayern",
"494271", "Sulingen",
"492921", "Soest",
"494151", "Schwarzenbek",
"49631", "Kaiserslautern",
"494307", "Raisdorf",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"492175", "Leichlingen\ Rheinland",
"497852", "Willstätt",
"497429", "Egesheim",
"497676", "Feldberg\ Schwarzwald",
"496357", "Standenbühl",
"493745", "Falkenstein\ Vogtland",
"496101", "Bad\ Vilbel",
"492554", "Laer\ Kreis\ Steinfurt",
"493863", "Crivitz",
"4935453", "Drahnsdorf",
"4936076", "Niederorschel",
"494934", "Marienhafe",
"496694", "Neukirchen\ Knüll",
"498320", "Missen\-Wilhams",
"492379", "Menden\-Asbeck",
"493735", "Marienberg\ Sachsen",
"4936208", "Ermstedt",
"4938826", "Dassow",
"495406", "Belm",
"495725", "Lindhorst\ bei\ Stadthagen",
"497192", "Murrhardt",
"4939924", "Stuer",
"492336", "Schwelm",
"4936624", "Teichwolframsdorf",
"494944", "Wiesmoor",
"4934292", "Brandis\ bei\ Wurzen",
"496821", "Neunkirchen\ Saar",
"498237", "Aindling",
"495658", "Wehretal",
"497562", "Isny\ im\ Allgäu",
"4938486", "Gustävel",
"495232", "Lage\ Lippe",
"498247", "Bad\ Wörishofen",
"492421", "Düren",
"498552", "Grafenau\ Niederbayern",
"4939408", "Hadmersleben",
"493301", "Oranienburg",
"494624", "Kropp",
"495242", "Rheda\-Wiedenbrück",
"494769", "Bremervörde\-Iselersheim",
"495273", "Beverungen",
"499825", "Herrieden",
"492631", "Neuwied",
"492685", "Flammersfeld",
"49551", "Göttingen",
"497041", "Mühlacker",
"496776", "Dachsenhausen",
"494434", "Colnrade",
"498223", "Ichenhausen",
"496464", "Angelburg",
"4939036", "Binde",
"4935341", "Bad\ Liebenwerda",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"497085", "Enzklösterle",
"495906", "Lünne",
"4934924", "Zahna",
"497031", "Böblingen",
"497371", "Riedlingen\ Württemberg",
"492864", "Reken",
"4939292", "Biederitz",
"4933677", "Glienicke\ bei\ Beeskow",
"494444", "Goldenstedt",
"495153", "Salzhemmendorf",
"499631", "Tirschenreuth",
"497157", "Waldenbuch",
"495976", "Salzbergen",
"495586", "Wieda",
"492825", "Uedem",
"494550", "Bühnsdorf",
"495939", "Sustrum",
"498167", "Zolling",
"499641", "Grafenwöhr",
"496706", "Wallhausen\ Nahe",
"496425", "Rauschenberg\ Hessen",
"4933875", "Rhinow",
"496392", "Hauenstein\ Pfalz",
"4933656", "Bahro",
"495203", "Werther\ Westfalen",
"497277", "Wörth\-Büchelberg",
"497222", "Rastatt",
"493562", "Forst\ Lausitz",
"4940", "Hamburg",
"495162", "Fallingbostel",
"494665", "Emmelsbüll\-Horsbüll",
"4938753", "Wöbbelin",
"498331", "Memmingen",
"496681", "Hilders",
"497458", "Ebhausen",
"498385", "Hergatz",
"496635", "Kirtorf",
"497553", "Salem\ Baden",
"498071", "Wasserburg\ am\ Inn",
"493371", "Luckenwalde",
"494756", "Odisheim",
"495021", "Nienburg\ Weser",
"496645", "Ulrichstein",
"496093", "Laufach",
"4939426", "Hessen",
"498341", "Kaufbeuren",
"49711", "Stuttgart",
"498468", "Altmannstein\-Pondorf",
"498563", "Bad\ Birnbach\ Rottal",
"499421", "Straubing",
"494884", "Schwabstedt",
"496500", "Waldrach",
"495300", "Salzgitter\-Üfingen",
"499554", "Untersteinbach\ Unterfranken",
"4938794", "Cumlosen",
"496251", "Bensheim",
"495764", "Steyerberg",
"495476", "Ostercappeln\-Venne",
"498705", "Altfraunhofen",
"498426", "Walting\ Kreis\ Eichstätt",
"498193", "Geltendorf",
"4939886", "Milmersdorf",
"492309", "Waltrop",
"499346", "Grünsfeld",
"495439", "Bersenbrück",
"499398", "Birkenfeld\ bei\ Würzburg",
"492440", "Nettersheim\-Tondorf",
"4936703", "Gräfenthal",
"4935955", "Pulsnitz",
"499076", "Wittislingen",
"4938464", "Bernitt",
"496171", "Oberursel\ Taunus",
"499336", "Bütthard",
"494495", "Friesoythe\-Thüle",
"497958", "Rot\ Am\ See\-Brettheim",
"499255", "Marktleugast",
"495592", "Gleichen\-Bremke",
"4937467", "Klingenthal\ Sachsen",
"497735", "Öhningen",
"494322", "Bordesholm",
"4934426", "Kayna",
"499921", "Regen",
"492620", "Neuhäusel\ Westerwald",
"498679", "Burgkirchen\ an\ der\ Alz",
"497745", "Jestetten",
"4935951", "Neukirch\ Lausitz",
"4937367", "Lengefeld\ Erzgebirge",
"4933368", "Hohensaaten",
"499175", "Spalt",
"496386", "Altenkirchen\ Pfalz",
"498636", "Ampfing",
"497054", "Wildberg\ Württemberg",
"496358", "Kriegsfeld",
"499405", "Bad\ Abbach",
"499726", "Euerbach",
"4939857", "Drense",
"4935208", "Radeburg",
"498282", "Krumbach\ Schwaben",
"496875", "Nonnweiler\-Primstal",
"498064", "Au\ bei\ Bad\ Aibling",
"493364", "Eisenhüttenstadt",
"496594", "Birresborn",
"494451", "Varel\ Jadebusen",
"497129", "Lichtenstein\ Württemberg",
"4939294", "Gross\ Rosenburg",
"494773", "Lamstedt",
"4933830", "Ziesar",
"497576", "Krauchenwies",
"4939245", "Loburg",
"4936453", "Mellingen",
"4934922", "Mühlanger",
"492654", "Polch",
"496401", "Grünberg\ Hessen",
"494742", "Dorum",
"49391", "Magdeburg",
"499871", "Windsbach",
"498509", "Ruderting",
"497325", "Sontheim\ an\ der\ Brenz",
"496762", "Kastellaun",
"4933923", "Flecken\ Zechlin",
"494732", "Stadland\-Rodenkirchen",
"496295", "Rosenberg\ Baden",
"494308", "Schwedeneck",
"492801", "Xanten",
"4939241", "Leitzkau",
"495953", "Börger",
"4939862", "Schmölln\ bei\ Prenzlau",
"499905", "Bernried\ Niederbayern",
"492363", "Datteln",
"492541", "Coesfeld",
"499352", "Lohr\ am\ Main",
"49561", "Kassel",
"494951", "Weener",
"493836", "Wolgast",
"497486", "Horb\-Altheim",
"4934294", "Rackwitz",
"495826", "Suderburg",
"4939922", "Dambeck\ bei\ Röbel",
"492585", "Warendorf\-Hoetmar",
"492975", "Schmallenberg\-Oberkirchen",
"4936622", "Triebes",
"495657", "Meissner",
"494524", "Scharbeutz\-Pönitz",
"4939058", "Uthmöden",
"4936764", "Neuhaus\-Schierschnitz",
"498238", "Gessertshausen",
"496164", "Reichelsheim\ Odenwald",
"494134", "Embsen\ Kreis\ Lüneburg",
"498296", "Villenbach",
"49341", "Leipzig",
"498652", "Berchtesgaden",
"498248", "Lamerdingen",
"495771", "Rahden\ Westfalen",
"498721", "Eggenfelden",
"494144", "Himmelpforten",
"495453", "Recke",
"4938376", "Zirchow",
"4934241", "Jesewitz",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"496670", "Ludwigsau\ Hessen",
"4938303", "Sellin\ Ostseebad",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"497141", "Ludwigsburg\ Württemberg",
"4933672", "Pfaffendorfb\ Beeskow",
"49831", "Kempten\ Allgäu",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"494842", "Nordstrand",
"4938785", "Berge\ bei\ Perleberg",
"495768", "Petershagen\-Heimsen",
"492462", "Linnich",
"494293", "Ottersberg\-Fischerhude",
"499453", "Thalmassing",
"495053", "Fassberg\-Müden",
"499657", "Waldthurn",
"497131", "Heilbronn\ Neckar",
"4939854", "Kleptow",
"4935754", "Klettwitz",
"4939820", "Triepkendorf",
"499394", "Esselbach",
"494832", "Meldorf",
"4936969", "Merkers",
"496775", "Strüth\ Taunus",
"497367", "Aalen\-Ebnat",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4938781", "Mellen",
"497954", "Kirchberg\ an\ der\ Jagst",
"499826", "Weidenbach\ Mittelfranken",
"4934606", "Teicha\ Sachsen\-Anhalt",
"492686", "Weyerbusch",
"4934673", "Heldrungen",
"495905", "Beesten",
"494873", "Aukrug",
"4939933", "Vollrathsruhe",
"495352", "Schöningen",
"497389", "Heroldstatt",
"496552", "Olzheim",
"496247", "Worms\-Pfeddersheim",
"4934297", "Liebertwolkwitz",
"492962", "Olsberg",
"499106", "Markt\ Erlbach",
"492692", "Kelberg",
"493605", "Leinefelde",
"494289", "Kirchtimke",
"499953", "Pilsting",
"492256", "Mechernich\-Satzvey",
"492529", "Oelde\-Stromberg",
"499868", "Schillingsfürst",
"494267", "Lauenbrück",
"498821", "Garmisch\-Partenkirchen",
"495130", "Wedemark",
"496237", "Maxdorf",
"497709", "Wutach",
"4933932", "Fehrbellin",
"495520", "Braunlage",
"49340", "Dessau\ Anh",
"497675", "Bernau\ Baden",
"4939606", "Glienke",
"497454", "Sulz\ am\ Neckar",
"499269", "Tettau\ Kreis\ Kronach",
"492335", "Wetter\ Ruhr",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"495726", "Wiedensahl",
"492381", "Hamm\ Westfalen",
"494502", "Lübeck\-Travemünde",
"4935793", "Elstra",
"499287", "Selb",
"496223", "Neckargemünd",
"498464", "Dietfurt\ an\ der\ Altmühl",
"4935363", "Fermerswalde",
"497393", "Munderkingen",
"497420", "Deisslingen",
"495921", "Nordhorn",
"496467", "Hatzfeld\ Eder",
"495175", "Lehrte\-Arpke",
"4933203", "Kleinmachnow",
"4935471", "Birkenhainchen",
"493931", "Stendal",
"4936961", "Bad\ Liebenstein",
"494856", "Kronprinzenkoog",
"494643", "Gelting\ Angeln",
"4934498", "Rositz",
"498581", "Waldkirchen\ Niederbayern",
"498535", "Haarbach",
"4935052", "Kipsdorf\ Kurort",
"497204", "Malsch\-Völkersbach",
"492867", "Heiden\ Kreis\ Borken",
"494447", "Vechta\-Langförden",
"495255", "Altenbeken",
"4936481", "Neustadt\ an\ der\ Orla",
"494633", "Satrup",
"496663", "Steinau\ an\ der\ Strasse",
"493941", "Halberstadt",
"498545", "Hofkirchen\ Bayern",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"4934202", "Delitzsch",
"498026", "Hausham",
"495379", "Sassenburg\-Grussendorf",
"4933336", "Passow\ Kreis\ Uckermark",
"494528", "Schönwalde\ am\ Bungsberg",
"492406", "Herzogenrath",
"492725", "Lennestadt\-Oedingen",
"495336", "Semmenstedt",
"4936965", "Stadtlengsfeld",
"4935475", "Straupitz",
"497505", "Fronreute",
"498234", "Bobingen",
"494423", "Fedderwarden",
"4933436", "Prötzel",
"494148", "Drochtersen\-Assel",
"499764", "Höchheim",
"494627", "Dörpstedt",
"495554", "Moringen",
"494672", "Langenhorn",
"495346", "Liebenburg",
"496806", "Heusweiler",
"499439", "Neunburg\-Kemnath",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498753", "Elsendorf\ Niederbayern",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"496697", "Willingshausen",
"497835", "Zell\ am\ Harmersbach",
"494182", "Tostedt",
"492557", "Wettringen\ Kreis\ Steinfurt",
"493431", "Döbeln",
"492242", "Hennef\ Sieg",
"497763", "Murg",
"494947", "Aurich\-Ogenbargen",
"496536", "Kleinich",
"493441", "Zeitz",
"4939398", "Gross\ Garz",
"496126", "Idstein",
"4936020", "Ebeleben",
"4938797", "Karstädt\ Kreis\ Prignitz",
"492232", "Brühl\ Rheinland",
"4939202", "Gross\ Ammensleben",
"4937364", "Reitzenhain\ Erzgebirge",
"4938352", "Kemnitz\ bei\ Greifswald",
"498805", "Hohenpeissenberg",
"495641", "Warburg",
"499162", "Scheinfeld",
"499203", "Neudrossenfeld",
"494923", "Krummhörn\-Pewsum",
"492153", "Nettetal\-Lobberich",
"495864", "Jameln",
"492273", "Kerpen\-Horrem",
"499976", "Rötz",
"495631", "Korbach",
"4938452", "Lalendorf",
"4937464", "Schöneck\ Vogtland",
"495685", "Knüllwald",
"49251", "Münster",
"493621", "Gotha\ Thüringen",
"4936781", "Grossbreitenbach",
"499626", "Hohenburg",
"494422", "Sande\ Kreis\ Friesl",
"494477", "Lastrup\-Hemmelte",
"495525", "Walkenried",
"494859", "Windbergen",
"493535", "Herzberg\ Elster",
"495135", "Burgwedel\-Fuhrberg",
"49981", "Ansbach",
"493971", "Anklam",
"495181", "Alfeld\ Leine",
"493581", "Görlitz",
"4936702", "Lauscha",
"4939039", "Bonese",
"496486", "Katzenelnbogen",
"492754", "Bad\ Laasphe\-Feudingen",
"499197", "Egloffstein",
"494673", "Joldelund",
"4935771", "Bad\ Muskau",
"4935938", "Grosspostwitz\ OL",
"495145", "Beedenbostel",
"498326", "Fischen\ im\ Allgäu",
"494642", "Kappeln\ Schlei",
"4936785", "Gräfinau\-Angstedt",
"495224", "Enger\ Westfalen",
"4936944", "Rentwertshausen",
"492409", "Stolberg\-Gressenich",
"499446", "Altmannstein",
"494178", "Radbruch",
"497164", "Boll\ Kreis\ Göppingen",
"495339", "Gielde",
"495036", "Neustadt\-Schneeren",
"492330", "Herdecke",
"498274", "Buttenwiesen",
"493329", "Stahnsdorf",
"498029", "Kreuth\ bei\ Tegernsee",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"494632", "Steinbergkirche",
"499436", "Nittenau",
"496809", "Grossrosseln",
"499498", "Laaber",
"494258", "Schwarme",
"4935775", "Pechern",
"499857", "Schopfloch\ Mittelfranken",
"499202", "Waischenfeld",
"499163", "Dachsbach",
"4934691", "Könnern",
"492152", "Kempen",
"494922", "Borkum",
"494977", "Blomberg\ Ostfriesland",
"4937341", "Ehrenfriedersdorf",
"498431", "Neuburg\ an\ der\ Donau",
"497358", "Eberhardzell\-Füramoos",
"493471", "Bernburg\ Saale",
"496054", "Birstein",
"49571", "Minden\ Westfalen",
"496129", "Schlangenbad",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"492272", "Bedburg\ Erft",
"498368", "Halblech",
"492227", "Bornheim\-Merten",
"499321", "Kitzingen",
"4938752", "Zierzow\ bei\ Ludwigslust",
"494183", "Jesteburg",
"499946", "Hohenwarth\ bei\ Kötzing",
"492243", "Eitorf",
"499567", "Sesslach\-Gemünda",
"498752", "Au\ in\ der\ Hallertau",
"4962195", "Ludwigshafen",
"495671", "Hofgeismar",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"492233", "Hürth\ Rheinland",
"499936", "Wallerfing",
"497762", "Wehr\ Baden",
"496325", "Lambrecht\ Pfalz",
"498621", "Trostberg",
"4935454", "Uckro",
"4939031", "Dähre",
"495494", "Holdorf\ Niedersachsen",
"49331", "Potsdam",
"4939267", "Schneidlingen",
"497251", "Bruchsal",
"495353", "Königslutter\ am\ Elm",
"497171", "Schwäbisch\ Gmünd",
"499741", "Bad\ Brückenau",
"499228", "Thurnau",
"499094", "Tagmersheim",
"4936623", "Berga\ Elster",
"4938485", "Dabel",
"494827", "Wacken",
"498261", "Mindelheim",
"494872", "Hanerau\-Hademarschen",
"4939923", "Priborn",
"492689", "Dierdorf",
"492463", "Titz",
"494843", "Viöl",
"4939035", "Kuhfelde",
"499452", "Langquaid",
"494765", "Ebersdorf\ bei\ Bremervörde",
"496020", "Heigenbrücken",
"499829", "Flachslanden",
"496735", "Eppelsheim",
"492568", "Heek",
"494292", "Ritterhude",
"496781", "Idar\-Oberstein",
"497386", "Hayingen",
"494833", "Wesselburen",
"496745", "Gondershausen",
"498057", "Aschau\-Sachrang",
"493964", "Bredenfelde\ bei\ Strasburg",
"492667", "Stein\-Neukirch",
"495052", "Hermannsburg",
"4938302", "Sagard",
"4938481", "Witzin",
"494286", "Gyhum",
"4938821", "Lüdersdorf",
"495664", "Morschen",
"496301", "Otterbach\ Pfalz",
"495250", "Delbrück\ Westfalen",
"495841", "Lüchow\ Wendland",
"496157", "Pfungstadt",
"496222", "Wiesloch",
"493821", "Ribnitz\-Damgarten",
"49202", "Wuppertal",
"497392", "Laupheim",
"494503", "Timmendorfer\ Strand",
"4936071", "Teistungen",
"497706", "Oberbaldingen",
"497425", "Trossingen",
"4962199", "Ludwigshafen",
"4937349", "Scheibenberg",
"4934923", "Cobbelsdorf",
"492526", "Sendenhorst",
"4936452", "Berlstedt",
"495831", "Wittingen",
"494408", "Hude\ Oldenburg",
"492693", "Antweiler",
"492045", "Bottrop\-Kirchhellen",
"499266", "Mitwitz",
"492963", "Brilon\-Messinghausen",
"4938825", "Klütz",
"499952", "Eichendorf",
"4936870", "Masserberg",
"496897", "Sulzbach\ Saar",
"496553", "Schönecken",
"497635", "Schliengen",
"496458", "Rosenthal\ Hessen",
"497681", "Waldkirch\ Breisgau",
"499305", "Estenfeld",
"492375", "Balve",
"4933922", "Karwesee",
"4936075", "Dingelstädt\ Eichsfeld",
"4939863", "Seehausen\ bei\ Prenzlau",
"493464", "Sangerhausen",
"49611", "Wiesbaden",
"494107", "Siek\ Kreis\ Stormarn",
"494351", "Eckernförde",
"497645", "Freiamt",
"492858", "Hünxe",
"4937381", "Penig",
"497354", "Erolzheim",
"496058", "Gründau",
"4938858", "Lassahn",
"494865", "Osterhever",
"496881", "Lebach",
"499729", "Grettstadt",
"492445", "Schleiden\ Eifel",
"496835", "Beckingen",
"497546", "Oberteuringen",
"494743", "Langen\ bei\ Bremerhaven",
"497967", "Jagstzell",
"4936648", "Dittersdorf\ bei\ Schleiz",
"495952", "Sögel",
"494684", "Langeness\ Hallig",
"498364", "Seeg",
"497126", "Burladingen\-Melchingen",
"4939264", "Kroppenstedt",
"497579", "Schwenningen\ Baden",
"495266", "Lemgo\-Kirchheide",
"492435", "Erkelenz\-Lövenich",
"495305", "Sickte",
"494733", "Butjadingen\-Burhave",
"4933933", "Lindow\ Mark",
"496763", "Kirchberg\ Hunsrück",
"498283", "Neuburg\ an\ der\ Kammel",
"499170", "Schwanstetten",
"499831", "Gunzenhausen",
"4937298", "Oelsnitz\ Erzgebirge",
"4933846", "Dippmannsdorf",
"492625", "Ochtendung",
"497025", "Neuffen",
"499664", "Hahnbach",
"495109", "Ronnenberg",
"494772", "Oberndorf\ Oste",
"4935792", "Ossling",
"499841", "Bad\ Windsheim",
"4935362", "Schönewalde\ bei\ Herzberg",
"498506", "Bad\ Höhenstadt",
"496204", "Viernheim",
"4933606", "Müllrose",
"498846", "Uffing\ am\ Staffelsee",
"4933673", "Weichensdorf",
"4936741", "Bad\ Blankenburg",
"492945", "Lippstadt\-Benninghausen",
"497467", "Neuhausen\ ob\ Eck",
"496420", "Lahntal",
"495829", "Wriedel",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"495452", "Mettingen\ Westfalen",
"493876", "Perleberg",
"492758", "Bad\ Berleburg\-Girkhausen",
"497663", "Eichstetten",
"492935", "Sundern\-Hachen",
"492571", "Greven\ Westfalen",
"492981", "Winterberg\ Westfalen",
"498457", "Vohburg\ an\ der\ Donau",
"495741", "Lübbecke",
"492362", "Dorsten",
"496505", "Kordel",
"499353", "Karlstadt",
"495228", "Vlotho\-Exter",
"4934672", "Rossleben",
"494174", "Stelle\ Kreis\ Harburg",
"49841", "Ingolstadt\ Donau",
"4935974", "Hinterhermsdorf",
"494254", "Eystrup",
"4936464", "Wormstedt",
"495731", "Bad\ Oeynhausen",
"497806", "Bad\ Peterstal\-Griesbach",
"4939932", "Malchow\ bei\ Waren",
"493721", "Meinersdorf",
"498380", "Achberg",
"496630", "Schwalmtal\-Storndorf",
"4938226", "Dierhagen\ Ostseebad",
"498158", "Tutzing",
"495936", "Twist",
"499671", "Oberviechtach",
"497247", "Linkenheim\-Hochstetten",
"497552", "Pfullendorf",
"495946", "Georgsdorf",
"494404", "Elsfleth",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"497237", "Neulingen\ Enzkreis",
"496092", "Heimbuchenthal",
"492601", "Nauort",
"498562", "Triftern",
"49971", "Bad\ Kissingen",
"498085", "Sankt\ Wolfgang",
"498031", "Rosenheim\ Oberbayern",
"4939203", "Barleben",
"493385", "Rathenow",
"493331", "Angermünde",
"496454", "Lichtenfels\-Sachsenberg",
"4935826", "Königshain\ bei\ Görlitz",
"4939726", "Ducherow",
"4938353", "Gützkow\ bei\ Greifswald",
"496675", "Breitenbach\ am\ Herzberg",
"495321", "Goslar",
"493341", "Strausberg",
"498041", "Bad\ Tölz",
"496393", "Fischbach\ bei\ Dahn",
"495163", "Fallingbostel\-Dorfmark",
"4938453", "Mistorf",
"493563", "Spremberg",
"497223", "Bühl\ Baden",
"495202", "Oerlinghausen",
"498207", "Affing",
"4936947", "Jüchsen",
"4939008", "Kunrau",
"4939740", "Nechlin",
"499349", "Werbach\-Wenkheim",
"492306", "Lünen",
"495436", "Nortrup",
"494323", "Bornhöved",
"495857", "Bleckede\-Brackede",
"495593", "Bovenden\-Lenglern",
"4933202", "Töplitz",
"4937752", "Eibenstock",
"492265", "Reichshof\-Eckenhagen",
"4935386", "Prettin",
"4935053", "Glashütte\ Sachsen",
"495446", "Rehden",
"499339", "Ippesheim",
"4936376", "Straussfurt",
"4935600", "Döbern\ NL",
"496185", "Hammersbach\ Hessen",
"499376", "Collenberg",
"496131", "Mainz",
"494161", "Buxtehude",
"498649", "Schleching",
"4934203", "Zwenkau",
"498192", "Schondorf\ am\ Ammersee",
"499145", "Solnhofen",
"494337", "Jevenstedt",
"497775", "Mühlingen",
"495197", "Soltau\-Frielingen",
"492564", "Vreden",
"4933398", "Werneuchen",
"499525", "Königsberg\ in\ Bayern",
"493968", "Schönbeck",
"498639", "Neumarkt\-Sankt\ Veit",
"495626", "Bad\ Zwesten",
"493679", "Neuhaus\ am\ Rennweg",
"4933768", "Prieros",
"494347", "Flintbek",
"499135", "Hessdorf\ Mittelfranken",
"49581", "Uelzen",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496086", "Grävenwiesbach",
"493636", "Greussen",
"495754", "Extertal\-Bremke",
"494285", "Rhade\ bei\ Zeven",
"494231", "Verden\ Aller",
"499564", "Bad\ Rodach",
"496261", "Mosbach\ Baden",
"4933927", "Linum",
"497705", "Wolterdingen\ Schwarzw",
"4939934", "Gross\ Plasten",
"497426", "Gosheim",
"497193", "Sulzbach\ an\ der\ Murr",
"492525", "Beckum\-Neubeckum",
"4936462", "Ossmannstedt",
"494241", "Bassum",
"4939601", "Friedland",
"492181", "Grevenbroich",
"498745", "Bodenkirchen",
"496057", "Flörsbachtal",
"497636", "Münstertal\ Schwarzwald",
"499306", "Kist",
"499265", "Pressig",
"494974", "Neuharlingersiel",
"4935753", "Grossräschen",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498781", "Rottenburg\ an\ der\ Laaber",
"498020", "Weyarn",
"498735", "Gangkofen\-Kollbach",
"4934262", "Falkenhain\ bei\ Wurzen",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"492339", "Sprockhövel\-Hasslinghausen",
"492224", "Bad\ Honnef",
"497646", "Weisweil\ Breisgau",
"497853", "Kehl\-Bodersweier",
"4939605", "Gross\ Nemerow",
"49212", "Solingen",
"49271", "Siegen",
"4938307", "Poseritz",
"498222", "Burgau\ Schwaben",
"495272", "Brakel\ Westfalen",
"496120", "Aarbergen",
"499854", "Wittelshofen",
"4933230", "Börnicke\ Kreis\ Havelland",
"495152", "Hessisch\ Oldendorf",
"4933439", "Fredersdorf\-Vogelsdorf",
"4934601", "Teutschenthal",
"4935364", "Lebusa",
"498157", "Feldafing",
"492671", "Cochem",
"495233", "Steinheim\ Westfalen",
"494474", "Garrel",
"49811", "Hallbergmoos",
"494766", "Basdahl",
"497563", "Kisslegg",
"4933470", "Lietzen",
"496736", "Bechenheim",
"4939262", "Güsten\ Anh",
"499194", "Ebermannstadt",
"495909", "Wettrup",
"497331", "Geislingen\ an\ der\ Steige",
"498458", "Gaimersheim",
"497385", "Gomadingen",
"4934605", "Gröbers",
"496746", "Pfalzfeld",
"498553", "Spiegelau",
"497071", "Tübingen",
"497839", "Schapbach",
"492353", "Halver",
"4936840", "Trusetal",
"496894", "St\ Ingbert",
"4939458", "Heudeber",
"493663", "Schleiz",
"494104", "Aumühle\ bei\ Hamburg",
"4937430", "Eichigt",
"4938757", "Neustadt\-Glewe",
"4938208", "Kavelstorf",
"498208", "Eurasburg\ bei\ Augsburg",
"496575", "Landscheid",
"494961", "Papenburg",
"498809", "Wessobrunn",
"4938392", "Sassnitz",
"496154", "Ober\-Ramstadt",
"497721", "Villingen\ im\ Schwarzwald",
"492501", "Münster\-Hiltrup",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"494382", "Wangels",
"4937754", "Zwönitz",
"492052", "Velbert\-Langenberg",
"499945", "Arnbruck",
"497248", "Marxzell",
"4933204", "Beelitz\ Mark",
"497652", "Hinterzarten",
"496326", "Deidesheim",
"4936041", "Bad\ Tennstedt",
"499820", "Lehrberg",
"496029", "Mömbris",
"492680", "Mündersbach",
"499935", "Stephansposching",
"496274", "Waldbrunn\ Odenwald",
"499571", "Lichtenfels\ Bayern",
"4937363", "Zöblitz",
"495136", "Burgdorf\ Kreis\ Hannover",
"495198", "Schneverdingen\-Wintermoor",
"499625", "Kastl\ bei\ Amberg",
"496441", "Wetzlar",
"492831", "Geldern",
"494338", "Alt\ Duvenstedt",
"494702", "Sandstedt",
"4934609", "Salzmünde",
"493493", "Bitterfeld",
"4933331", "Casekow",
"4937463", "Bergen\ Vogtland",
"495259", "Bad\ Driburg\-Neuenheerse",
"493967", "Oertzenhof\ bei\ Strasburg",
"492664", "Rennerod",
"493546", "Lübben\ Spreewald",
"495146", "Wietze",
"492994", "Marsberg\-Westheim",
"498054", "Breitbrunn\ am\ Chiemsee",
"498549", "Vilshofen\-Pleinting",
"494461", "Jever",
"496485", "Nentershausen\ Westerwald",
"496431", "Limburg\ an\ der\ Lahn",
"492841", "Moers",
"494348", "Schönkirchen",
"495035", "Gross\ Munzel",
"4933435", "Rehfelde",
"495375", "Müden\ Aller",
"496621", "Bad\ Hersfeld",
"498325", "Oberstaufen\-Thalkirchdorf",
"4936258", "Friemar",
"495858", "Hitzacker\-Wietzetze",
"499445", "Neustadt\ an\ der\ Donau",
"495963", "Bawinkel",
"495693", "Volkmarsen",
"4933335", "Pinnow\ Kreis\ Uckermark",
"495045", "Springe\-Bennigsen",
"494824", "Krempe",
"499097", "Marxheim",
"4935476", "Wittmannsdorf\-Bückchen",
"4936966", "Kaltennordheim",
"499435", "Schwarzenfeld",
"499481", "Pfatter",
"496752", "Kirn\ Nahe",
"493425", "Wurzen",
"494122", "Uetersen",
"492952", "Rüthen",
"494177", "Drage\ Elbe",
"4938754", "Leussow\ bei\ Ludwigslust",
"492266", "Lindlar",
"499963", "Konzell",
"494532", "Bargteheide",
"4939080", "Kalbe\ Milde",
"497570", "Sigmaringen\-Gutenstein",
"496562", "Speicher",
"495435", "Berge\ bei\ Quakenbrück",
"495481", "Lengerich\ Westfalen",
"4938720", "Grebbin",
"492305", "Castrop\-Rauxel",
"498709", "Eching\ Niederbayern",
"498092", "Grafing\ bei\ München",
"497821", "Lahr\ Schwarzwald",
"499375", "Freudenberg\ Baden",
"496186", "Grosskrotzenburg",
"4934321", "Leisnig",
"499081", "Nördlingen",
"499720", "Üchtelhausen",
"4935268", "Stauchitz",
"495445", "Drebber",
"4939885", "Jakobshagen",
"494542", "Mölln\ Lauenburg",
"4938379", "Benz\ Usedom",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"494257", "Schweringen",
"499146", "Markt\ Berolzheim",
"494478", "Cappeln\ Oldenburg",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4934425", "Droyssig",
"494499", "Barssel",
"498393", "Holzgünz",
"496041", "Glauburg",
"497739", "Hilzingen",
"49421", "Bremen",
"496207", "Wald\-Michelbach",
"4933207", "Gross\ Kreutz",
"498454", "Karlshuld",
"4934325", "Mochau\-Lüttewitz",
"496371", "Landstuhl",
"496031", "Friedberg\ Hessen",
"496085", "Waldsolms",
"493681", "Suhl",
"4937757", "Rittersgrün",
"4937208", "Auerswalde",
"493635", "Kölleda",
"499526", "Riedbach",
"499179", "Freystadt",
"4939881", "Ringenwalde\ bei\ Templin",
"4934978", "Radegast\ Kreis\ Köthen",
"495625", "Naumburg\ Hessen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"492452", "Heinsberg\ Rheinland",
"4939421", "Osterwieck",
"499568", "Neustadt\ bei\ Coburg",
"493925", "Stassfurt",
"499463", "Wald\ Oberpfalz",
"4933876", "Buschow",
"495935", "Twist\-Schöninghsdorf",
"495571", "Uslar",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"495820", "Suhlendorf",
"498131", "Dachau",
"4939321", "Arneburg",
"496429", "Schweinsberg\ Hessen",
"496852", "Nohfelden",
"495063", "Bad\ Salzdetfurth",
"495945", "Wilsum",
"49731", "Ulm\ Donau",
"494724", "Cuxhaven\-Lüdingworth",
"498141", "Fürstenfeldbruck",
"4939425", "Dingelstedt\ am\ Huy",
"494802", "Wrohm",
"497964", "Stödtlen",
"4934638", "Zöschen",
"494483", "Ovelgönne\-Grossenmeer",
"498389", "Weissensberg",
"496639", "Ottrau",
"4938793", "Dergenthin",
"498086", "Buchbach\ Oberbayern",
"493386", "Premnitz",
"497357", "Attenweiler",
"496676", "Hohenroda\ Hessen",
"495362", "Wolfsburg\-Fallersleben",
"492741", "Betzdorf",
"4939325", "Vinzelberg",
"4936704", "Steinheid",
"496192", "Hofheim\ am\ Taunus",
"4939978", "Gross\ Roge",
"498367", "Rosshaupten\ Forggensee",
"492228", "Remagen\-Rolandseck",
"493594", "Bischofswerda",
"495194", "Bispingen",
"499243", "Pottenstein",
"492567", "Ahaus\-Alstätte",
"494334", "Bredenbek\ bei\ Rendsburg",
"496364", "Nussbach\ Pfalz",
"4936730", "Sitzendorf",
"4938371", "Karlshagen",
"495601", "Schauenburg",
"498845", "Bad\ Kohlgrub",
"499233", "Arzberg\ Oberfranken",
"4933924", "Rägelin",
"497471", "Hechingen",
"494344", "Schönberg\ Holstein",
"494556", "Ahrensbök\-Gnissau",
"497753", "Albbruck",
"493762", "Crimmitschau",
"499152", "Hartenstein\ Mittelfranken",
"495854", "Bleckede\-Barskamp",
"492202", "Bergisch\ Gladbach",
"4938231", "Barth",
"492163", "Schwalmtal\ Niederrhein",
"496506", "Welschbillig",
"4938375", "Koserow",
"4939889", "Boitzenburg",
"496283", "Hardheim\ Odenwald",
"4936454", "Magdala",
"494828", "Lägerdorf",
"4939293", "Dreileben",
"499272", "Fichtelberg",
"499227", "Neuenmarkt",
"497805", "Appenweier",
"496836", "Überherrn",
"499409", "Pielenhofen",
"492446", "Heimbach\ Eifel",
"4939329", "Möringen",
"497545", "Immenstaad\ am\ Bodensee",
"496457", "Burgwald\ Eder",
"499070", "Tapfheim",
"4939246", "Lindau\ Anh",
"4935797", "Schwepnitz",
"496898", "Völklingen",
"496653", "Burghaun",
"495306", "Cremlingen",
"492436", "Wegberg\-Rödgen",
"498204", "Mickhausen",
"497971", "Gaildorf",
"497581", "Saulgau",
"494108", "Rosengarten\ Kreis\ Harburg",
"4938304", "Garz\ Rügen",
"492857", "Rees\-Mehr",
"492593", "Ascheberg\ Westfalen",
"497125", "Bad\ Urach",
"4936085", "Reinholterode",
"495265", "Dörentrup",
"499340", "Königheim\-Brehmen",
"494603", "Havetoft",
"4935452", "Golssen",
"492626", "Selters\ Westerwald",
"497244", "Weingarten\ Baden",
"49281", "Wesel",
"496158", "Riedstadt",
"498630", "Oberneukirchen",
"493901", "Salzwedel",
"497234", "Tiefenbronn",
"497329", "Steinheim\ am\ Albuch",
"498505", "Hutthurm",
"497026", "Lenningen",
"49641", "Giessen",
"494407", "Wardenburg",
"4934293", "Naunhof\ bei\ Grimma",
"498640", "Reit\ Im\ Winkl",
"495564", "Dassel",
"4936081", "Arenshausen",
"494467", "Wittmund\-Funnix",
"4935891", "Rothenburg\ OL",
"499188", "Postbauer\-Heng",
"499350", "Eussenheim\-Hundsbach",
"495504", "Friedland\ Kreis\ Göttingen",
"496643", "Herbstein",
"493961", "Altentreptow",
"496095", "Bessenbach",
"496856", "St\ Wendel\-Niederkirchen",
"4939361", "Lüderitz",
"493691", "Eisenach\ Thüringen",
"498565", "Dietersburg\-Baumgarten",
"492837", "Weeze",
"496447", "Langgöns\-Niederkleen",
"4937348", "Oberwiesenthal\ Kurort",
"4936602", "Ronneburg\ Thüringen",
"496784", "Weierbach",
"494489", "Apen",
"494663", "Süderlügum",
"492456", "Selfkant",
"4938733", "Karbow\-Vietlübbe",
"498383", "Grünenbach\ Allgäu",
"496633", "Homberg\ Ohm",
"497555", "Deggenhausertal",
"4935895", "Klitten",
"496138", "Mommenheim",
"4939744", "Rothenklempenow",
"497174", "Mögglingen",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4935844", "Oybin\ Kurort",
"494168", "Neu\ Wulmstorf\-Elstorf",
"495205", "Bielefeld\-Sennestadt",
"498650", "Marktschellenberg",
"495069", "Nordstemmen",
"4938423", "Bad\ Kleinen",
"499744", "Zeitlofs\-Detter",
"4939365", "Bellingen\ bei\ Stendal",
"495366", "Jembke",
"499091", "Monheim\ Schwaben",
"496423", "Wetter\ Hessen",
"496196", "Bad\ Soden\ am\ Taunus",
"493382", "Lehnin",
"498082", "Schwindegg",
"496672", "Eiterfeld",
"497660", "St\ Peter\ Schwarzwald",
"4969", "Frankfurt\ am\ Main",
"499734", "Burkardroth",
"4938323", "Prohn",
"496627", "Nentershausen\ Hessen",
"495491", "Damme\ Dümmer",
"499469", "Roding\-Neubäu",
"499683", "Friedenfels",
"494806", "Sarzbüttel",
"497254", "Waghäusel",
"492823", "Goch",
"494546", "Mustin\ Lauenburg",
"494967", "Rhauderfehn\-Burlage",
"497743", "Ühlingen\-Birkendorf",
"4935931", "Königswartha",
"499173", "Thalmässing",
"4934361", "Dahlen\ Sachsen",
"493461", "Merseburg\ Saale",
"496182", "Seligenstadt",
"4935604", "Krieschow",
"494354", "Fleckeby",
"496566", "Körperich",
"495328", "Altenau\ Harz",
"497733", "Engen\ Hegau",
"494536", "Steinhorst\ Lauenburg",
"494126", "Horst\ Holstein",
"494493", "Friesoythe\-Gehlenberg",
"498038", "Vogtareuth",
"499253", "Weissenstadt",
"4934461", "Nebra\ Unstrut",
"493338", "Bernau\ Brandenburg",
"497684", "Glottertal",
"4935023", "Bad\ Gottleuba",
"492103", "Hilden",
"498378", "Buchenberg\ bei\ Kempten",
"492262", "Wiehl",
"4935935", "Kleinwelka",
"4937432", "Pausa\ Vogtland",
"499522", "Eltmann",
"492608", "Welschneudorf",
"499132", "Herzogenaurach",
"495834", "Wittingen\-Knesebeck",
"494740", "Loxstedt\-Dedesdorf",
"498703", "Essenbach",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"495661", "Melsungen",
"4934465", "Bad\ Bibra",
"492507", "Havixbeck",
"4933976", "Wutike",
"499142", "Treuchtlingen",
"496304", "Wolfstein\ Pfalz",
"4936842", "Oberhof\ Thüringen",
"495844", "Clenze",
"497727", "Vöhrenbach",
"495955", "Esterwegen",
"498151", "Starnberg",
"495302", "Vechelde",
"496842", "Blieskastel",
"497323", "Gerstetten",
"492432", "Wassenberg",
"496293", "Schefflenz",
"4933051", "Nassenheide",
"495221", "Herford",
"497161", "Göppingen",
"4933472", "Golzow\ bei\ Seelow",
"496832", "Beckingen\-Reimsbach",
"497904", "Ilshofen",
"494862", "Garding",
"498271", "Meitingen",
"4938828", "Schönberg",
"4936206", "Grossfahner",
"494609", "Eggebek",
"4935327", "Priessen",
"494775", "Grossenwörden",
"497022", "Nürtingen",
"492473", "Simmerath",
"497337", "Nellingen\ Alb",
"492599", "Ascheberg\-Herbern",
"499607", "Luhe\-Wildenau",
"494320", "Heidmühlen",
"4933232", "Brieselang",
"492751", "Bad\ Berleburg",
"496659", "Eichenzell",
"49395", "Neubrandenburg",
"4933055", "Kremmen",
"4936333", "Heringen\ Helme",
"497347", "Dietenheim",
"496873", "Nonnweiler",
"492622", "Bendorf\ am\ Rhein",
"495184", "Freden\ Leine",
"492677", "Lutzerath",
"499403", "Donaustauf",
"495455", "Tecklenburg\-Brochterbeck",
"495674", "Grebenstein",
"499848", "Simmershofen",
"494552", "Leezen",
"494247", "Affinghausen",
"4933964", "Fretzdorf",
"492932", "Neheim\-Hüsten",
"498624", "Obing",
"4937603", "Wildenfels",
"494237", "Bendingbostel",
"4935939", "Hochkirch",
"496267", "Fahrenbach\ Baden",
"497220", "Forbach\-Hundsbach",
"492942", "Geseke",
"497404", "Epfendorf",
"4939038", "Henningen",
"4938488", "Demen",
"499276", "Bischofsgrün",
"492583", "Sassenberg",
"492973", "Eslohe\ Sauerland",
"498444", "Schweitenkirchen",
"49345", "Halle\ Saale",
"499324", "Dettelbach",
"496502", "Schweich",
"4939997", "Jarmen",
"492365", "Marl",
"496888", "Lebach\-Steinbach",
"4938295", "Satow\ bei\ Bad\ Doberan",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"494223", "Ganderkesee\-Bookholzberg",
"498434", "Rennertshofen",
"4939406", "Harbke",
"499903", "Schöllnach",
"496051", "Gelnhausen",
"492206", "Overath",
"493344", "Bad\ Freienwalde",
"4935324", "Crinitz",
"494180", "Königsmoor",
"492851", "Rees",
"494358", "Loose\ bei\ Eckernförde",
"497977", "Oberrot\ bei\ Gaildorf",
"497587", "Hosskirch",
"495903", "Emsbüren",
"494875", "Stafstedt",
"4939953", "Schwinkendorf",
"495156", "Coppenbrügge",
"4936653", "Lehesten\ Thüringer\ Wald",
"498034", "Brannenburg",
"495276", "Marienmünster",
"497569", "Isny\-Eisenbach",
"493334", "Eberswalde",
"496451", "Frankenberg\ Eder",
"498374", "Dietmannsried",
"4938843", "Bennin",
"495324", "Vienenburg",
"496773", "Kamp\-Bornhofen",
"498226", "Bibertal",
"492191", "Remscheid",
"495838", "Gross\ Oesingen",
"496742", "Boppard",
"494401", "Brake\ Unterweser",
"4935872", "Neusalza\-Spremberg",
"495055", "Fassberg",
"4939772", "Rothemühl",
"4939222", "Möser",
"493907", "Gardelegen",
"497183", "Rudersberg\ Württemberg",
"492604", "Nassau\ Lahn",
"4933769", "Töpchin",
"4935692", "Kerkwitz",
"496308", "Olsbrücken",
"499674", "Schönsee",
"494295", "Emtinghausen",
"496732", "Wörrstadt",
"495848", "Trebel",
"494762", "Kutenholz",
"497395", "Ehingen\-Dächingen",
"497422", "Schramberg",
"492333", "Ennepetal",
"495403", "Bad\ Iburg",
"497477", "Jungingen\ bei\ Hechingen",
"499184", "Deining\ Oberpfalz",
"495882", "Gorleben",
"4936422", "Reinstädt\ Thüringen",
"4934953", "Gräfenhainichen",
"495508", "Gleichen\-Rittmarshausen",
"495607", "Fuldatal",
"497673", "Schönau\ im\ Schwarzwald",
"4937295", "Lugau\ Erzgebirge",
"4938851", "Zarrentin",
"4933967", "Freyenstein",
"493866", "Cambs",
"498869", "Kinsau",
"492561", "Ahaus",
"496788", "Sien",
"499221", "Kulmbach",
"496524", "Rodershausen",
"492327", "Bochum\-Wattenscheid",
"498268", "Tussenhausen",
"492372", "Hemer",
"4934772", "Helbra",
"4934222", "Arzberg\ bei\ Torgau",
"496134", "Mainz\-Kastel",
"494164", "Harsefeld",
"497642", "Endingen\ Kaiserstuhl",
"4936694", "Schkölen\ Thüringen",
"499748", "Motten",
"4939994", "Metschow",
"4936645", "Mühltroff",
"4936732", "Könitz",
"493603", "Bad\ Langensalza",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4939009", "Badel",
"499955", "Mamming",
"497258", "Oberderdingen\-Flehingen",
"4937291", "Augustusburg",
"4938855", "Lübtheen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499302", "Rottendorf\ Unterfranken",
"499738", "Rottershausen",
"497632", "Badenweiler",
"499661", "Sulzbach\-Rosenberg",
"498628", "Kienberg\ Oberbayern",
"4933765", "Märkisch\ Buchholz",
"4933456", "Wriezen",
"496550", "Irrhausen",
"4937423", "Adorf\ Vogtland",
"499844", "Obernzenn",
"495142", "Eschede",
"493542", "Lübbenau\ Spreewald",
"4933395", "Zerpenschleuse",
"498137", "Petershausen",
"492723", "Kirchhundem",
"497503", "Wilhelmsdorf\ Württemberg",
"495522", "Osterode\ am\ Harz",
"494706", "Schiffdorf",
"494425", "Wangerland\-Hooksiel",
"4937323", "Lichtenberg\ Erzgebirge",
"499834", "Theilenhofen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"498572", "Tann\ Niederbayern",
"494392", "Nortorf\ bei\ Neumünster",
"495132", "Lehrte",
"4936926", "Creuzburg",
"494635", "Sörup",
"494681", "Wyk\ auf\ Föhr",
"496665", "Sinntal\-Altengronau",
"498361", "Nesselwang",
"496756", "Winterbach\ Soonwald",
"498543", "Aidenbach",
"492484", "Mechernich\-Eiserfey",
"495253", "Bad\ Driburg",
"492747", "Molzhain",
"493573", "Senftenberg",
"495173", "Uetze",
"497351", "Biberach\ an\ der\ Riss",
"498533", "Rotthalmünster",
"4935032", "Langenhennersdorf",
"4936940", "Oepfershausen",
"492737", "Netphen\-Deuz",
"4939747", "Züsedom",
"498123", "Moosinning",
"4938859", "Alt\ Zachun",
"499491", "Hemau",
"4939005", "Kusey",
"494251", "Hoya",
"495734", "Bergkirchen\ Westfalen",
"496023", "Alzenau\ in\ Unterfranken",
"492275", "Kerpen\-Buir",
"493724", "Burgstädt",
"499087", "Marktoffingen",
"4935243", "Weinböhla",
"495683", "Wabern\ Hessen",
"495744", "Hüllhorst",
"494830", "Süderhastedt",
"499205", "Vorbach",
"4935607", "Jänschwalde",
"494925", "Hinte",
"4936649", "Gefell\ bei\ Schleiz",
"499366", "Geroldshausen\ Unterfranken",
"4938332", "Gross\ Bisdorf",
"498803", "Peissenberg",
"494171", "Winsen\ Luhe",
"4939001", "Apenburg",
"497765", "Rickenbach\ Hotzenwald",
"492984", "Hallenberg",
"492574", "Saerbeck",
"497656", "Schluchsee",
"496322", "Bad\ Dürkheim",
"497843", "Renchen",
"4939082", "Mieste",
"499504", "Stadelhofen",
"492056", "Heiligenhaus",
"496201", "Weinheim\ Bergstr",
"4938722", "Raduhn",
"493588", "Niesky",
"496047", "Altenstadt\ Hessen",
"497833", "Hornberg\ Schwarzwaldbahn",
"492359", "Kierspe",
"498666", "Teisendorf",
"495837", "Sprakensehl",
"494480", "Ovelgönne\-Strückhausen",
"495456", "Westerkappeln\-Velpe",
"4936692", "Bürgel",
"4939992", "Görmin",
"4934224", "Belgern\ Sachsen",
"4934774", "Röblingen\ am\ See",
"496271", "Eberbach\ Baden",
"4933920", "Walsleben\ bei\ Neuruppin",
"499574", "Marktzeuln",
"49431", "Kiel",
"496307", "Schopp",
"496151", "Darmstadt",
"497724", "St\ Georgen\ im\ Schwarzwald",
"492504", "Telgte",
"4936734", "Leutenberg",
"499359", "Karlstadt\-Wiesenfeld",
"498293", "Welden\ bei\ Augsburg",
"494101", "Pinneberg",
"4936259", "Tabarz\ Thüringer\ Wald",
"494357", "Sehestedt\ Eider",
"4933833", "Wollin\ bei\ Brandenburg",
"4936450", "Kranichfeld",
"497669", "St\ Märgen",
"4936424", "Kahla\ Thüringen",
"497483", "Horb\-Mühringen",
"497802", "Oberkirch\ Baden",
"495823", "Bienenbüttel",
"499275", "Speichersdorf",
"494964", "Rhede\ Ems",
"499155", "Simmelsdorf",
"493765", "Reichenbach\ Vogtland",
"493843", "Güstrow",
"492205", "Rösrath",
"492366", "Herten\ Westfalen",
"495060", "Bodenburg",
"498267", "Dirlewang",
"494821", "Itzehoe",
"4939459", "Hasselfelde",
"497532", "Meersburg",
"4938300", "Insel\ Hiddensee",
"4939608", "Staven",
"495956", "Rastdorf",
"4939832", "Wesenberg",
"499747", "Geroda\ Bayern",
"4934782", "Mansfeld\ Südharz",
"499484", "Brennberg",
"495262", "Extertal",
"497122", "St\ Johann\ Württemberg",
"4939224", "Büden",
"4939774", "Mönkebude",
"495103", "Wennigsen\ Deister",
"4935874", "Bernstadt\ an\ der\ Eigen",
"495084", "Hambühren",
"4933237", "Paulinenaue",
"497257", "Bruchsal\-Untergrombach",
"4938209", "Sanitz\ bei\ Rostock",
"497542", "Tettnang",
"4935694", "Gosda\ bei\ Klinge",
"499737", "Wartmannsroth",
"496624", "Heringen\ Werra",
"49721", "Karlsruhe",
"498502", "Fürstenzell",
"492661", "Bad\ Marienberg\ Westerwald",
"4935322", "Doberlug\-Kirchhain",
"492991", "Marsberg\-Bredelar",
"494776", "Osten\-Altendorf",
"498051", "Prien\ am\ Chiemsee",
"497573", "Stetten\ am\ kalten\ Markt",
"495507", "Ebergötzen",
"497478", "Hirrlingen",
"4933477", "Trebnitz\ bei\ Müncheberg",
"494464", "Wittmund\-Carolinensiel",
"496434", "Bad\ Camberg",
"492844", "Rheinberg\-Orsoy",
"494749", "Schiffdorf\-Geestenseth",
"495608", "Söhrewald",
"499723", "Röthlein",
"496787", "Niederbrombach",
"492834", "Straelen",
"496444", "Bischoffen",
"4939343", "Jerichow",
"498784", "Hohenthann",
"499372", "Klingenberg\ am\ Main",
"4936847", "Steinbach\-Hallenberg",
"494545", "Seedorf\ Lauenburg",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4933338", "Stolpe\/Oder",
"498633", "Tüssling",
"496383", "Glan\-Münchweiler",
"494125", "Seestermühe",
"492955", "Büren\-Wewelsburg",
"4936255", "Goldbach\ bei\ Gotha",
"4939084", "Lindstedt",
"4938724", "Siggelkow",
"4938750", "Malliss",
"492302", "Witten",
"496565", "Dudeldorf",
"492738", "Netphen",
"495432", "Löningen",
"4937437", "Bad\ Elster",
"494971", "Esens",
"494535", "Nahe",
"498856", "Penzberg",
"498095", "Aying",
"4933438", "Altlandsberg",
"493395", "Pritzwalk",
"4989", "Munich",
"49228", "Bonn",
"493632", "Sondershausen",
"4934496", "Nöbdenitz",
"496082", "Niederreifenberg",
"494244", "Harpstedt",
"499073", "Gundelfingen\ an\ der\ Donau",
"499333", "Sommerhausen",
"495622", "Fritzlar",
"4934907", "Jeber\-Bergfrieden",
"495677", "Calden\-Westuffeln",
"496650", "Hosenfeld",
"498138", "Schwabhausen\ bei\ Dachau",
"495473", "Ostercappeln",
"4938334", "Grammendorf",
"495751", "Rinteln",
"498423", "Titting",
"494234", "Dörverden",
"498196", "Pürgen",
"494329", "Langwedel\ Holstein",
"499561", "Coburg",
"492590", "Dülmen\-Buldern",
"496264", "Neudenau",
"499343", "Lauda\-Königshofen",
"496855", "Freisen",
"496096", "Wiesen\ Unterfranken",
"4934343", "Regis\-Breitingen",
"499191", "Forchheim\ Oberfranken",
"4938201", "Gelbensande",
"495942", "Uelsen",
"497334", "Deggingen",
"497229", "Iffezheim",
"499604", "Wernberg\-Köblitz",
"492674", "Bad\ Bertrich",
"495187", "Delligsen",
"4934443", "Teuchern",
"4939451", "Wasserleben",
"492455", "Waldfeucht",
"497556", "Uhldingen\-Mühlhofen",
"494753", "Balje",
"494471", "Cloppenburg",
"497344", "Blaubeuren",
"495932", "Haren\ Ems",
"496048", "Büdingen\-Eckartshausen",
"499851", "Dinkelsbühl",
"495365", "Wolfsburg\-Neindorf",
"4938205", "Tessin\ bei\ Rostock",
"496195", "Kelkheim\ Taunus",
"496703", "Wöllstein\ Rheinhessen",
"498304", "Wildpoldsried",
"495206", "Bielefeld\-Jöllenbeck",
"499088", "Mönchsdeggingen",
"4936607", "Niederpöllnitz",
"4939455", "Schierke",
"494805", "Schafstedt",
"4939396", "Neukirchen\ Altmark",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495583", "Braunlage\-Hohegeiss",
"4939975", "Thürkow",
"499973", "Furth\ im\ Wald",
"4934742", "Sylda",
"4937434", "Bobenneukirchen",
"494167", "Apensen",
"4938727", "Mestlin",
"4939087", "Jerchel\ Altmark",
"492324", "Hattingen\ Ruhr",
"4939328", "Rochau",
"496527", "Oberweis",
"496572", "Manderscheid\ Eifel",
"496628", "Oberaula",
"495851", "Dahlenburg",
"499365", "Rimpar",
"496147", "Trebur",
"4936844", "Rohr\ Thüringen",
"492903", "Meschede\-Freienohl",
"499206", "Mistelgau\-Obernsees",
"4934635", "Bad\ Lauchstädt",
"494926", "Krummhörn\-Greetsiel",
"492156", "Willich\-Anrath",
"494189", "Undeloh",
"498550", "Philippsreut",
"4939428", "Pabstorf",
"496533", "Morbach\ Hunsrück",
"494563", "Scharbeutz\-Haffkrug",
"4939971", "Gnoien",
"497474", "Haigerloch",
"494468", "Friedeburg\-Reepsholt",
"499187", "Altdorf\ bei\ Nürnberg",
"496438", "Hünfelden",
"497655", "Feldberg\-Altglashütten",
"496123", "Eltville\ am\ Rhein",
"499932", "Osterhofen",
"4935602", "Drebkau",
"4933743", "Blönsdorf",
"495191", "Soltau",
"493591", "Bautzen",
"4934904", "Oranienbaum",
"498756", "Nandlstadt",
"4933200", "Bergholz\-Rehbrücke",
"496543", "Büchenbeuren",
"492838", "Sonsbeck",
"494331", "Rendsburg",
"494385", "Hohenfelde\ bei\ Kiel",
"496361", "Rockenhausen",
"498665", "Inzell",
"495604", "Grossalmerode",
"499942", "Viechtach",
"499473", "Kallmünz",
"492607", "Kobern\-Gondorf",
"493904", "Haldensleben",
"4934975", "Görzig\ Kreis\ Köthen",
"497231", "Pforzheim",
"498860", "Bernbeuren",
"4935842", "Oderwitz",
"4939742", "Brüssow\ bei\ Pasewalk",
"496803", "Mandelbachtal\-Ommersheim",
"495561", "Einbeck",
"496482", "Runkel",
"4934328", "Hartha\ bei\ Döbeln",
"498023", "Bayrischzell",
"4933366", "Chorin",
"499622", "Hirschau\ Oberpfalz",
"499677", "Oberviechtach\-Pullenried",
"495333", "Dettum",
"497728", "Niedereschach",
"492403", "Eschweiler\ Rheinland",
"492508", "Drensteinfurt",
"495073", "Neustadt\-Esperke",
"494193", "Henstedt\-Ulzburg",
"494705", "Wremen",
"494426", "Wangerland\-Horumersiel",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"495042", "Bad\ Münder\ am\ Deister",
"497974", "Bühlerzell",
"4936023", "Horsmar",
"497584", "Altshausen",
"4939888", "Lychen",
"494968", "Neulehe",
"4935265", "Glaubitz",
"494636", "Langballig",
"496666", "Freiensteinau",
"496755", "Odernheim\ am\ Glan",
"4936604", "Münchenbernsdorf",
"495032", "Neustadt\ am\ Rübenberge",
"495327", "Bad\ Grund\ Harz",
"495372", "Meinersen",
"498322", "Oberstdorf",
"494646", "Mohrkirch",
"4938873", "Carlow",
"498377", "Unterthingau",
"494853", "Sankt\ Michaelisdonn",
"499442", "Riedenburg",
"493337", "Biesenthal\ Brandenburg",
"495723", "Bad\ Nenndorf",
"497702", "Blumberg\ Baden",
"496374", "Weilerbach",
"499608", "Kohlberg\ Oberpfalz",
"496034", "Wöllstadt",
"492522", "Oelde",
"496226", "Meckesheim",
"493733", "Annaberg\-Buchholz",
"4934383", "Trebsen\ Mulde",
"4936737", "Drognitz",
"492132", "Meerbusch\-Büderich",
"498773", "Neufahrn\ in\ Niederbayern",
"497461", "Tuttlingen",
"497348", "Beimerstetten",
"496559", "Leidenborn",
"496044", "Schotten\ Hessen",
"492678", "Büchel\ bei\ Cochem",
"494282", "Sittensen",
"4935433", "Vetschau",
"493865", "Holthusen",
"498732", "Frontenhausen",
"4935723", "Bernsdorf\ OL",
"4939823", "Rechlin",
"492173", "Langenfeld\ Rheinland",
"493727", "Mittweida",
"493772", "Schneeberg\ Erzgebirge",
"494509", "Gross\ Grönau",
"4935206", "Kreischa\ bei\ Dresden",
"499084", "Bissingen\ Schwaben",
"4934639", "Wallendorf\ Luppe",
"4933962", "Heiligengrabe",
"498742", "Velden\ Vils",
"4936427", "Dornburg\ Saale",
"499103", "Cadolzburg",
"499262", "Wallenfels",
"495484", "Lienen\-Kattenvenne",
"499956", "Eichendorf\-Aufhausen",
"492253", "Bad\ Münstereifel",
"497824", "Schwanau",
"497083", "Bad\ Herrenalb",
"492744", "Herdorf",
"494876", "Reher\ Holstein",
"495155", "Emmerthal",
"4935697", "Bagenz",
"4939383", "Sandau\ Elbe",
"4939056", "Klüden",
"494839", "Wöhrden\ Dithmarschen",
"496869", "Merzig\-Silwingen",
"4933234", "Wustermark",
"4935877", "Cunewalde",
"4939777", "Borkenfriede",
"492734", "Freudenberg\ Westfalen",
"497961", "Ellwangen\ Jagst",
"4938378", "Heringsdorf\ Seebad",
"498225", "Jettingen\-Scheppach",
"496887", "Schmelz\ Saar",
"4939483", "Ballenstedt",
"499823", "Leutershausen",
"495275", "Höxter\-Ottbergen",
"492683", "Asbach\ Westerwald",
"494849", "Hooge",
"494248", "Bassum\-Neubruchhausen",
"495056", "Winsen\-Meissendorf",
"499847", "Ergersheim",
"497382", "Römerstein",
"494721", "Cuxhaven",
"498144", "Grafrath",
"494238", "Neddenaverbergen",
"4933474", "Neutrebbin",
"496268", "Hüffenhardt",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"499837", "Haundorf",
"495574", "Oberweser",
"498134", "Odelzhausen",
"494296", "Schwanewede\-Aschwarden",
"4937209", "Einsiedel\ bei\ Chemnitz",
"496255", "Lindenfels",
"4937439", "Jocketa",
"497452", "Nagold",
"4939386", "Seehausen\ Altmark",
"4939053", "Süplingen",
"495663", "Spangenberg",
"494504", "Ratekau",
"4938308", "Göhren\ Rügen",
"4939600", "Zwiedorf",
"499089", "Bissingen\-Unterringingen",
"49231", "Dortmund",
"495467", "Voltlage",
"498462", "Berching",
"4936849", "Kleinschmalkalden",
"499386", "Prosselsheim",
"496175", "Friedrichsdorf\ Taunus",
"494491", "Friesoythe",
"499251", "Münchberg",
"496049", "Kefenrod",
"496554", "Waxweiler",
"492357", "Herscheid\ Westfalen",
"492694", "Wershofen",
"497731", "Singen\ Hohentwiel",
"4938292", "Kröpelin",
"492964", "Brilon\-Alme",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496346", "Annweiler\ am\ Trifels",
"4934909", "Aken\ Elbe",
"496039", "Karben",
"494205", "Ottersberg",
"496398", "Vorderweidenthal",
"499925", "Bayerisch\ Eisenstein",
"495168", "Walsrode\-Stellichte",
"497228", "Forbach",
"497741", "Tiengen\ Hochrhein",
"494366", "Grömitz\-Cismar",
"498686", "Petting",
"499171", "Roth\ Mittelfranken",
"496336", "Dellfeld",
"499635", "Bärnau",
"498176", "Egling\ bei\ Wolfratshausen",
"499681", "Windischeschenbach",
"497305", "Erbach\ Donau",
"495536", "Holzminden\-Neuhaus",
"4933475", "Letschin",
"492821", "Kleve\ Niederrhein",
"494328", "Rickling",
"498139", "Röhrmoos",
"497952", "Gerabronn",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"497266", "Kirchardt",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495126", "Algermissen",
"4934600", "Ostrau\ Saalkreis",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"499093", "Polsingen",
"496421", "Marburg",
"495546", "Scheden",
"495354", "Jerxheim",
"4933928", "Wildberg\ Brandenburg",
"4933231", "Pausin",
"4935436", "Laasow\ bei\ Calau",
"494661", "Niebüll",
"4933052", "Leegebruch",
"498335", "Fellheim",
"498381", "Lindenberg\ im\ Allgäu",
"496631", "Alsfeld",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4935726", "Gross\ Särchen",
"492739", "Wilnsdorf",
"498075", "Amerang",
"4935203", "Tharandt",
"493375", "Königs\ Wusterhausen",
"492464", "Aldenhoven\ bei\ Jülich",
"495025", "Estorf\ Weser",
"494844", "Pellworm",
"492776", "Bad\ Endbach\-Hartenrod",
"496641", "Lauterbach\ Hessen",
"493963", "Woldegk",
"498345", "Stöttwang",
"4936458", "Bad\ Berka",
"493693", "Meiningen",
"494834", "Büsum",
"4933235", "Friesack",
"496864", "Mettlach",
"499392", "Faulbach\ Unterfranken",
"498867", "Rottenbuch\ Oberbayern",
"494221", "Delmenhorst",
"499901", "Hengersberg\ Bayern",
"4934905", "Wörlitz",
"496053", "Wächtersbach",
"495609", "Ahnatal",
"497446", "Lossburg",
"499164", "Langenfeld\ Mittelfranken",
"492545", "Rosendahl\-Darfeld",
"495862", "Hitzacker\ Elbe",
"4936841", "Schleusingen",
"494748", "Stubben\ bei\ Bremerhaven",
"494796", "Teufelsmoor",
"4937431", "Mehltheuer\ Vogtland",
"4933363", "Altenhof\ Kreis\ Barnim",
"494955", "Westoverledingen",
"493886", "Gadebusch",
"497436", "Messstetten\-Oberdigisheim",
"494302", "Kirchbarkau",
"492581", "Warendorf",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"492971", "Schmallenberg\-Dorlar",
"492535", "Sendenhorst\-Albersloh",
"49781", "Offenburg",
"49214", "Leverkusen",
"4934901", "Rosslau\ Elbe",
"4936026", "Struth\ bei\ Mühlhausen",
"494184", "Hanstedt\ Nordheide",
"4934462", "Laucha\ Unstrut",
"492244", "Königswinter\-Oberpleis",
"497626", "Kandern",
"496352", "Kirchheimbolanden",
"4936845", "Gehlberg",
"495320", "Torfhaus",
"4937435", "Reuth\ bei\ Plauen",
"4935932", "Guttau",
"495775", "Diepenau",
"498725", "Wurmannsquick",
"4934362", "Mügeln\ bei\ Oschatz",
"498406", "Böhmfeld",
"4938876", "Roggendorf",
"4936257", "Luisenthal\ Thüringen",
"492234", "Frechen",
"498370", "Wiggensbach",
"496130", "Schwabenheim\ an\ der\ Selz",
"495237", "Augustdorf",
"49465", "Sylt",
"4936605", "Bad\ Köstritz",
"499401", "Neutraubling",
"497946", "Bretzfeld",
"497567", "Leutkirch\-Friesenhofen",
"498232", "Schwabmünchen",
"4938758", "Dömitz",
"4938207", "Stäbelow",
"4933239", "Gross\ Behnitz",
"496871", "Wadern",
"4935264", "Strehla",
"495247", "Harsewinkel",
"492753", "Erndtebrück",
"494674", "Ockholm",
"499295", "Töpen",
"497668", "Ihringen",
"495552", "Katlenburg",
"499762", "Saal\ an\ der\ Saale",
"494455", "Jade\-Schweiburg",
"4939457", "Benneckenstein\ Harz",
"498557", "Mauth",
"497936", "Schrozberg\-Bartenstein",
"492471", "Roetgen\ Eifel",
"499180", "Pyrbaum",
"498273", "Nordendorf",
"496726", "Lorch\ Rheingau",
"496405", "Laubach\ Hessen",
"4936601", "Hermsdorf\ Thüringen",
"499358", "Gössenheim",
"49851", "Passau",
"495223", "Bünde",
"499875", "Wolframs\-Eschenbach",
"497202", "Karlsbad",
"4933746", "Werbig\ bei\ Jüterbog",
"497163", "Ebersbach\ an\ der\ Fils",
"4935892", "Horka\ OL",
"497321", "Heidenheim\ an\ der\ Brenz",
"4933479", "Küstrin\-Kietz",
"496291", "Adelsheim",
"493909", "Klötze\ Altmark",
"4939362", "Grieben\ bei\ Tangerhütte",
"4937204", "Lichtenstein\ Sachsen",
"498153", "Wessling",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"495594", "Bovenden\-Reyershausen",
"4938721", "Ziegendorf",
"4934346", "Narsdorf",
"494276", "Borstel\ bei\ Sulingen",
"494239", "Dörverden\-Westen",
"49771", "Donaueschingen",
"493601", "Mühlhausen\ Thüringen",
"4934779", "Abberode",
"496269", "Gundelsheim\ Württemberg",
"494324", "Brokstedt",
"4934446", "Grosskorbetha",
"495358", "Bahrdorf\-Mackendorf",
"4939002", "Oebisfelde",
"4936739", "Rottenbach",
"498825", "Krün",
"496287", "Limbach\ Baden",
"494156", "Talkau",
"499223", "Rugendorf",
"495875", "Emmendorf",
"494903", "Wymeer",
"494249", "Bassum\-Nordwohlde",
"4938725", "Gross\ Godems",
"499552", "Burghaslach",
"4936254", "Friedrichswerth",
"495295", "Lichtenau\ Westfalen",
"494848", "Rantrum",
"4939085", "Zichtau",
"492563", "Stadtlohn",
"4939977", "Jördenstorf",
"497671", "Todtnau",
"496106", "Rodgau",
"4938331", "Rakow\ Vorpom",
"494838", "Tellingstedt",
"492331", "Hagen\ Westfalen",
"495401", "Georgsmarienhütte",
"492385", "Hamm\-Rhynern",
"496868", "Mettlach\-Tünsdorf",
"4934637", "Frankleben",
"4939393", "Werben\ Elbe",
"499775", "Schönau\ an\ der\ Brend",
"4939346", "Tucheim",
"4939454", "Elbingerode\ Harz",
"497145", "Markgröningen",
"494607", "Janneby",
"49661", "Fulda",
"496826", "Bexbach",
"4935267", "Diesbar\-Seusslitz",
"4939779", "Eggesin",
"493306", "Gransee",
"4938204", "Broderstorf",
"4933762", "Zeuthen",
"497135", "Brackenheim",
"497181", "Schorndorf\ Württemberg",
"494508", "Krummesse",
"4939320", "Schinne",
"492193", "Dabringhausen",
"494882", "Lunden",
"492426", "Nörvenich",
"497525", "Aulendorf",
"494403", "Bad\ Zwischenahn",
"4937207", "Hainichen\ Sachsen",
"497046", "Zaberfeld",
"496771", "St\ Goarshausen",
"4934493", "Gössnitz\ Thüringen",
"4933208", "Fahrland",
"4934977", "Quellendorf",
"496558", "Büdesheim\ Eifel",
"496453", "Gemünden\ Wohra",
"492636", "Burgbrohl",
"495901", "Fürstenau\ bei\ Bramsche",
"497376", "Langenenslingen",
"496657", "Hofbieber",
"498105", "Gilching",
"496394", "Bundenthal",
"495164", "Hodenhagen",
"493564", "Schwarze\ Pumpe",
"492646", "Königsfeld\ Eifel",
"497224", "Gernsbach",
"492597", "Senden\ Westfalen",
"492853", "Schermbeck",
"4936731", "Unterloquitz",
"4938370", "Kröslin",
"495706", "Porta\ Westfalica",
"495425", "Borgholzhausen",
"492064", "Dinslaken",
"494522", "Plön",
"497831", "Hausach",
"4937292", "Oederan",
"496203", "Ladenburg",
"494132", "Amelinghausen",
"496162", "Reinheim\ Odenwald",
"493435", "Oschatz",
"498654", "Freilassing",
"496586", "Beuren\ Hochwald",
"4939089", "Bismark\ Altmark",
"4938729", "Marnitz",
"497841", "Achern",
"497250", "Kraichtal",
"493445", "Naumburg\ Saale",
"4934221", "Schildau\ Gneisenaustadt",
"4934771", "Querfurt",
"494142", "Steinkirchen\ Kreis\ Stade",
"497664", "Freiburg\-Tiengen",
"4936425", "Isserstedt",
"499546", "Burgebrach",
"492509", "Nottuln\-Appelhülsen",
"4936735", "Probstzella",
"4938852", "Wittenburg",
"498801", "Seeshaupt",
"495645", "Borgentreich\-Borgholz",
"494173", "Wulfsen",
"497729", "Tennenbronn",
"499354", "Rieneck",
"499536", "Kirchlauter",
"495635", "Vöhl",
"495681", "Homberg\ Efze",
"499493", "Beratzhausen",
"499126", "Eckental",
"494253", "Asendorf\ Kreis\ Diepholz",
"4934775", "Wippra",
"4936421", "Camburg",
"4936642", "Harra",
"496021", "Aschaffenburg",
"494487", "Grossenkneten\-Huntlosen",
"495925", "Wietmarschen",
"4935691", "Bärenklau\ NL",
"494744", "Loxstedt",
"498121", "Markt\ Schwaben",
"495171", "Peine",
"493981", "Neustrelitz",
"493571", "Hoyerswerda",
"493935", "Tangerhütte",
"496449", "Ehringshausen\-Katzenfurt",
"492839", "Straelen\-Herongen",
"497353", "Schwendi",
"498585", "Grainet",
"498531", "Pocking",
"496476", "Mengerskirchen",
"495840", "Schnackenburg",
"495251", "Paderborn",
"494734", "Stadland\-Seefeld",
"496764", "Rheinböllen",
"494469", "Wangerooge",
"494683", "Oldsum",
"496439", "Holzappel",
"4939221", "Möckern\ bei\ Magdeburg",
"4939771", "Ueckermünde",
"498363", "Pfronten",
"498541", "Vilshofen\ Niederbayern",
"499467", "Michelsneukirchen",
"4935695", "Simmersdorf",
"4933836", "Butzow\ bei\ Brandenburg",
"494188", "Welle\ Nordheide",
"497052", "Bad\ Liebenzell",
"492248", "Hennef\-Uckerath",
"492721", "Lennestadt",
"496629", "Schenklengsfeld",
"498284", "Ziemetshausen",
"493362", "Erkner",
"498062", "Bruckmühl\ Mangfall",
"492238", "Pulheim",
"496592", "Daun",
"492296", "Reichshof\-Brüchermühle",
"4939225", "Altengrabow",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4939775", "Ahlbeck\ bei\ Torgelow",
"492652", "Mendig",
"495067", "Bockenem",
"4935329", "Dollenchen",
"497945", "Wüstenrot",
"497063", "Bad\ Wimpfen",
"494847", "Oster\-Ohrstedt",
"493494", "Wolfen",
"49531", "Braunschweig",
"499721", "Schweinfurt",
"4935246", "Ziegenhain\ Sachsen",
"499080", "Harburg\ Schwaben",
"499238", "Röslau",
"498053", "Bad\ Endorf",
"497935", "Schrozberg",
"497571", "Sigmaringen",
"494837", "Neuenkirchen\ Dithmarschen",
"496867", "Perl",
"499652", "Waidhaus",
"492663", "Westerburg\ Westerwald",
"494456", "Varel\-Altjührden",
"492993", "Marsberg\-Canstein",
"4939452", "Ilsenburg",
"499876", "Rohr\ Mittelfranken",
"497362", "Bopfingen",
"496406", "Lollar",
"496725", "Gau\-Algesheim",
"4933764", "Mittenwalde\ Mark",
"495357", "Grasleben",
"495101", "Pattensen",
"4938202", "Volkenshagen",
"493501", "Pirna",
"495964", "Lähden",
"4933394", "Blumberg\ Kreis\ Barnim",
"495694", "Diemelstadt",
"494823", "Wilster",
"497445", "Pfalzgrafenweiler",
"492697", "Blankenheim\-Ahrhütte",
"493994", "Malchin",
"492546", "Coesfeld\-Lette",
"4936252", "Tambach\-Dietharz",
"4935937", "Prischwitz",
"496242", "Osthofen",
"492354", "Meinerzhagen",
"493841", "Wismar",
"496557", "Hallschlag",
"496893", "Saarbrücken\-Ensheim",
"496658", "Poppenhausen\ Wasserkuppe",
"497435", "Albstadt\-Laufen",
"4934467", "Eckartsberga",
"495821", "Bad\ Bevensen",
"492536", "Münster\-Albachten",
"4933086", "Grieben\ Kreis\ Oberhavel",
"496232", "Speyer",
"494795", "Garlstedt",
"494103", "Wedel",
"4937326", "Frauenstein\ Sachsen",
"494262", "Visselhövede",
"492598", "Senden\-Ottmarsbocholt",
"494956", "Uplengen",
"49203", "Duisburg",
"493831", "Stralsund",
"4936923", "Treffurt",
"494608", "Handewitt",
"498291", "Zusmarshausen",
"497625", "Zell\ im\ Wiesental",
"4939999", "Tutow",
"498726", "Schönau\ Niederbayern",
"498405", "Stammham\ bei\ Ingolstadt",
"4939004", "Köckte\ bei\ Gardelegen",
"495464", "Alfhausen",
"499282", "Naila",
"49651", "Trier",
"495776", "Preussisch\ Ströhen",
"497265", "Angelbachtal",
"4933703", "Sperenberg",
"493525", "Riesa",
"499636", "Plössberg",
"4939030", "Brunau",
"497306", "Vöhringen\ Iller",
"495971", "Rheine",
"496462", "Gladenbach",
"495535", "Polle",
"494432", "Dötlingen\-Brettorf",
"4934956", "Zörbig",
"499646", "Freihung",
"499853", "Wilburgstetten",
"494442", "Lohne\ Oldenburg",
"496701", "Sprendlingen\ Rheinhessen",
"495545", "Hedemünden",
"492862", "Südlohn",
"4934785", "Sandersleben",
"494473", "Emstek",
"495026", "Steimbke",
"498379", "Waltenhofen\-Oberdorf",
"498039", "Rott\ am\ Inn",
"492775", "Driedorf",
"497564", "Bad\ Wurzach",
"498336", "Erkheim",
"498076", "Pfaffing",
"495329", "Schulenberg\ im\ Oberharz",
"494751", "Otterndorf",
"495234", "Horn\-Bad\ Meinberg",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"498554", "Schönberg\ Niederbayern",
"498346", "Pforzen",
"494622", "Taarstedt",
"4939831", "Feldberg",
"4934781", "Greifenhagen",
"495244", "Rietberg",
"499426", "Oberschneiding",
"499193", "Höchstadt\ an\ der\ Aisch",
"495753", "Auetal\-Bernsen",
"4938854", "Redefin",
"498421", "Eichstätt\ Bayern",
"499563", "Rödental",
"4936875", "Straufhain\-Streufdorf",
"492247", "Neunkirchen\-Seelscheid",
"499468", "Zell\ Oberpfalz",
"494187", "Holm\-Seppensen",
"492552", "Steinfurt\-Borghorst",
"499341", "Tauberbischofsheim",
"496256", "Lampertheim\-Hüttenfeld",
"496692", "Neustadt\ Hessen",
"4939956", "Neukalen",
"494932", "Norderney",
"495471", "Bohmte",
"492237", "Kerpen\ Rheinland\-Türnich",
"4938297", "Moitin",
"499071", "Dillingen\ an\ der\ Donau",
"499331", "Ochsenfurt",
"499385", "Kolitzheim",
"49371", "Chemnitz\ Sachsen",
"495068", "Elze\ Leine",
"4939995", "Nossendorf",
"4936644", "Hirschberg\ Saale",
"4936695", "Söllmnitz",
"497194", "Spiegelberg",
"496139", "Budenheim",
"4939268", "Egeln",
"494169", "Sauensiek",
"494942", "Südbrookmerland",
"4936871", "Bad\ Colberg\-Heldburg",
"494973", "Wittmund\-Burhafe",
"4937294", "Grünhainichen",
"496345", "Albersweiler",
"495805", "Oetzen",
"498641", "Grassau\ Kreis\ Traunstein",
"494488", "Westerstede",
"499167", "Oberscheinfeld",
"493671", "Saalfeld\ Saale",
"494365", "Heringsdorf\ Holstein",
"496381", "Kusel",
"498631", "Mühldorf\ am\ Inn",
"496335", "Trulben",
"498685", "Kirchanschöring",
"4936691", "Eisenberg\ Thüringen",
"4939991", "Daberkow",
"494206", "Stuhr\-Heiligenrode",
"499926", "Frauenau",
"492223", "Königswinter",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497854", "Kehl\-Goldscheuer",
"492358", "Meinerzhagen\-Valbert",
"494851", "Marne",
"494240", "Syke\-Heiligenfelde",
"498586", "Hauzenberg",
"4933054", "Liebenwalde",
"495926", "Engden",
"493998", "Demmin",
"497152", "Leonberg\ Württemberg",
"495167", "Walsrode\-Westenholz",
"494230", "Verden\-Walle",
"497272", "Rülzheim",
"4937606", "Lengenfeld\ Vogtland",
"499805", "Burgoberbach",
"497227", "Lichtenau\ Baden",
"493946", "Quedlinburg",
"492594", "Dülmen",
"496397", "Leimen\ Pfalz",
"496654", "Gersfeld\ Rhön",
"496475", "Weilmünster\-Wolfenhausen",
"498203", "Grossaitingen",
"495331", "Wolfenbüttel",
"492401", "Baesweiler",
"4939749", "Grambow\ bei\ Pasewalk",
"495071", "Schwarmstedt",
"494191", "Kaltenkirchen\ Holstein",
"493321", "Nauen\ Brandenburg",
"498021", "Waakirchen",
"494604", "Grossenwiehe",
"497243", "Ettlingen",
"495341", "Salzgitter",
"492295", "Ruppichteroth",
"492762", "Wenden\ Südsauerland",
"495468", "Bramsche\-Engter",
"495563", "Kreiensen",
"499471", "Burglengenfeld",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"497233", "Niefern\-Öschelbronn",
"498764", "Mauern\ Kreis\ Freising",
"4936647", "Saalburg\ Thüringen",
"495193", "Schneverdingen",
"495705", "Petershagen\-Windheim",
"495426", "Glandorf",
"499244", "Betzenstein",
"4935609", "Drachhausen",
"496541", "Traben\-Trarbach",
"494333", "Erfde",
"496363", "Niederkirchen",
"4938294", "Neubukow",
"497754", "Görwihl",
"496531", "Bernkastel\-Kues",
"499234", "Neusorg",
"496585", "Ralingen",
"494561", "Neustadt\ in\ Holstein",
"4936203", "Vieselbach",
"494343", "Laboe",
"498592", "Wegscheid\ Niederbayern",
"494327", "Grossenaspe",
"494372", "Westfehmarn",
"4933093", "Fürstenberg\ Havel",
"496062", "Erbach\ Odenwald",
"499545", "Buttenheim",
"495646", "Willebadessen",
"495853", "Neu\ Darchau",
"492164", "Jüchen\-Otzenrath",
"497340", "Neenstetten",
"4936336", "Klettenberg",
"498629", "Palling",
"49381", "Rostock",
"499971", "Cham",
"496284", "Mudau",
"499535", "Pfarrweisach",
"4937297", "Thum\ Sachsen",
"495636", "Lichtenfels\-Goddelsheim",
"4933965", "Herzsprung\ bei\ Wittstock",
"496825", "Illingen\ Saar",
"499776", "Mellrichstadt",
"497259", "Östringen\-Odenheim",
"497146", "Remseck\ am\ Neckar",
"499464", "Walderbach",
"495282", "Schieder\-Schwalenberg",
"495064", "Gross\ Düngen",
"499749", "Oberbach\ Unterfranken",
"492425", "Nideggen\-Embken",
"4939745", "Hetzdorf\ bei\ Strasburg",
"494723", "Cuxhaven\-Altenwalde",
"4935894", "Hähnichen",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498269", "Unteregg\ bei\ Mindelheim",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"497136", "Bad\ Friedrichshall",
"4939364", "Dolle",
"492392", "Werdohl",
"496789", "Heimbach\ Nahe",
"492635", "Rheinbrohl",
"492681", "Altenkirchen\ Westerwald",
"4933397", "Wandlitz",
"498868", "Schwabsoien",
"497045", "Oberderdingen",
"494747", "Beverstedt",
"497963", "Adelmannsfelden",
"494484", "Hude\-Wüsting",
"4933767", "Friedersdorf\ bei\ Berlin",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4935841", "Grossschönau\ Sachsen",
"4939741", "Jatznick",
"492645", "Vettelschoss",
"494737", "Stadland\-Schwei",
"497081", "Bad\ Wildbad",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"497720", "Schwenningen\ am\ Neckar",
"497375", "Obermarchtal",
"498106", "Vaterstetten",
"499101", "Langenzenn",
"499357", "Gräfendorf\ Bayern",
"492251", "Euskirchen",
"496430", "Hahnstätten",
"495849", "Waddeweitz",
"4934632", "Mücheln\ Geiseltal",
"4933969", "Stepenitz",
"494275", "Ehrenburg",
"4934464", "Freyburg\ Unstrut",
"499964", "Stallwang",
"492925", "Warstein\-Allagen",
"494155", "Büchen",
"4939972", "Walkendorf",
"49861", "Traunstein",
"496440", "Kölschhausen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"4935934", "Grossdubrau",
"492171", "Leverkusen\-Opladen",
"495839", "Wittingen\-Ohrdorf",
"4938736", "Goldberg",
"4934364", "Wermsdorf",
"4935601", "Peitz",
"498657", "Ramsau\ bei\ Berchtesgaden",
"493741", "Plauen",
"496105", "Mörfelden\-Walldorf",
"4933633", "Spreenhagen",
"499480", "Sünching",
"4938426", "Neuburg\-Steinhausen",
"495238", "Nieheim\-Himmighausen",
"497463", "Mühlheim\ an\ der\ Donau",
"4939007", "Tangeln",
"4936948", "Römhild",
"498394", "Lautrach",
"495652", "Bad\ Sooden\-Allendorf",
"497568", "Bad\ Wurzach\-Hauerz",
"497667", "Breisach\ am\ Rhein",
"49931", "Würzburg",
"496620", "Philippsthal\ Werra",
"493731", "Freiberg\ Sachsen",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4939753", "Strasburg",
"4938326", "Grimmen",
"4934741", "Frose",
"498771", "Ergoldsbach",
"495721", "Stadthagen",
"498453", "Reichertshofen\ Oberbayern",
"4935605", "Komptendorf",
"498558", "Hohenau\ Niederbayern",
"4936766", "Schalkau",
"498623", "Kirchweidach",
"4938759", "Tewswoos",
"4933238", "Senzke",
"4933921", "Zechlinerhütte",
"499337", "Gaukönigshofen",
"495673", "Immenhausen\ Hessen",
"4939243", "Nedlitz\ bei\ Zerbst",
"499077", "Bachhagel",
"495859", "Thomasburg",
"494525", "Ahrensbök",
"4939607", "Kotelow",
"495422", "Melle",
"497403", "Dunningen",
"496165", "Breuberg",
"499347", "Wittighausen",
"494135", "Kirchgellersen",
"494181", "Buchholz\ in\ der\ Nordheide",
"498427", "Wellheim",
"4938374", "Lassan\ bei\ Wolgast",
"492850", "Rees\-Haldern",
"492241", "Siegburg",
"498443", "Hohenwart\ Paar",
"494349", "Dänischenhagen",
"495632", "Willingen\ Upland",
"4933925", "Wustrau\-Altfriesack",
"498548", "Vilshofen\-Sandbach",
"499323", "Iphofen",
"498637", "Lohkirchen",
"496387", "Sankt\ Julian",
"4936072", "Weissenborn\-Lüderode",
"495258", "Salzkotten",
"493677", "Ilmenau\ Thüringen",
"492974", "Schmallenberg\-Fredeburg",
"492584", "Warendorf\-Milte",
"493622", "Waltershausen\ Thüringen",
"4936451", "Buttelstedt",
"493578", "Kamenz",
"494339", "Christiansholm",
"494224", "Gross\ Ippener",
"498433", "Königsmoos",
"4938234", "Born\ Darss",
"498538", "Pocking\-Hartkirchen",
"499904", "Lalling",
"495199", "Schneverdingen\-Heber",
"495642", "Warburg\-Scherfede",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"499161", "Neustadt\ an\ der\ Aisch",
"4933478", "Gross\ Neuendorf",
"496066", "Michelstadt\-Vielbrunn",
"4934296", "Groitzsch\ bei\ Pegau",
"49471", "Bremerhaven",
"496707", "Windesheim",
"497324", "Herbrechtingen",
"498166", "Allershausen\ Oberbayern",
"496294", "Krautheim\ Jagst",
"496028", "Sulzbach\ am\ Main",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4934243", "Bad\ Düben",
"4938301", "Putbus",
"4938482", "Warin",
"495922", "Bad\ Bentheim",
"495977", "Spelle",
"497903", "Mainhardt",
"4934607", "Wettin",
"497249", "Stutensee",
"497156", "Ditzingen",
"498808", "Pähl",
"498582", "Röhrnbach",
"498065", "Tuntenhausen\-Schönau",
"494671", "Bredstedt",
"496595", "Dockweiler",
"4936084", "Heuthen",
"492474", "Nideggen\-Schmidt",
"492655", "Weibern",
"4938305", "Gingst",
"497055", "Neuweiler\ Kreis\ Calw",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"494757", "Wanna",
"495183", "Lamspringe",
"493973", "Pasewalk",
"493583", "Zittau",
"499404", "Nittendorf",
"499220", "Kasendorf\-Azendorf",
"497838", "Nordrach",
"496874", "Wadern\-Nunkirchen",
"4939296", "Welsleben",
"498459", "Manching",
"498822", "Oberammergau",
"4933873", "Grosswudicke",
"494353", "Ascheffel",
"4934324", "Ostrau\ Sachsen",
"495827", "Unterlüss",
"495872", "Stoetze",
"497744", "Stühlingen",
"495908", "Wietmarschen\-Lohne",
"499174", "Hilpoltstein",
"494494", "Bösel\ Oldenburg",
"4938751", "Picher",
"493847", "Sternberg",
"499254", "Gefrees",
"4933929", "Gühlen\-Glienicke",
"496551", "Prüm",
"4934424", "Reuden\ bei\ Zeitz",
"497683", "Simonswald",
"492104", "Mettmann",
"492691", "Adenau",
"497734", "Gailingen",
"492961", "Brilon",
"496002", "Ober\-Mörlen",
"494501", "Kastorf\ Holstein",
"492382", "Ahlen\ Westfalen",
"495833", "Brome",
"4938796", "Viesecke",
"4939884", "Hassleben\ bei\ Prenzlau",
"495292", "Lichtenau\-Atteln",
"499555", "Schlüsselfeld\-Aschbach",
"4938755", "Eldena",
"495765", "Raddestorf",
"495656", "Waldkappel",
"496303", "Enkenbach\-Alsenborn",
"495843", "Wustrow\ Wendland",
"4934692", "Alsleben\ Saale",
"4937342", "Cranzahl",
"498704", "Altdorf\-Pfettrach",
"4936608", "Seelingstädt\ bei\ Gera",
"4936459", "Blankenhain\ Thüringen",
"4938466", "Jürgenshagen",
"496644", "Grebenhain",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"497132", "Neckarsulm",
"4939324", "Kläden\ bei\ Stendal",
"492338", "Breckerfeld",
"4933437", "Reichenberg\ bei\ Strausberg",
"4935953", "Burkau",
"494885", "Bergenhusen",
"496861", "Merzig",
"497577", "Veringenstadt",
"495503", "Nörten\-Hardenberg",
"4937438", "Bad\ Brambach",
"497522", "Wangen\ im\ Allgäu",
"4936848", "Wernshausen",
"494664", "Neukirchen\ bei\ Niebüll",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499727", "Schonungen\-Marktsteinach",
"496634", "Gemünden\ Felda",
"498384", "Röthenbach\ Allgäu",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"497142", "Bietigheim\-Bissingen",
"495286", "Ottenstein\ Niedersachsen",
"4938309", "Trent",
"492461", "Jülich",
"494841", "Husum\ Nordsee",
"4933337", "Altkünkendorf",
"496783", "Baumholder",
"4936701", "Lichte",
"496424", "Ebsdorfergrund",
"498102", "Höhenkirchen\-Siegertsbrunn",
"498263", "Breitenbrunn\ Schwaben",
"495351", "Helmstedt",
"499865", "Adelshofen\ Mittelfranken",
"497173", "Heubach",
"4935772", "Rietschen",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"497253", "Bad\ Schönborn",
"492824", "Kalkar",
"499733", "Münnerstadt",
"4933654", "Fünfeichen",
"493723", "Hohenstein\-Ernstthal",
"494266", "Brockel",
"496236", "Neuhofen\ Pfalz",
"4937366", "Rübenau",
"494952", "Rhauderfehn",
"495684", "Frielendorf",
"497328", "Königsbronn",
"495733", "Vlotho",
"492532", "Ostbevern",
"496298", "Möckmühl",
"494305", "Westensee",
"496024", "Schöllkrippen",
"496246", "Eich\ Rheinhessen",
"496159", "Messel",
"4933205", "Michendorf",
"495743", "Espelkamp\-Gestringen",
"4934327", "Waldheim\ Sachsen",
"492257", "Reckerscheid",
"499107", "Trautskirchen",
"499351", "Gemünden\ am\ Main",
"495865", "Gusborn",
"492542", "Gescher",
"4937755", "Schönheide\ Erzgebirge",
"499286", "Oberkotzau",
"492573", "Nordwalde",
"492983", "Winterberg\-Siedlinghausen",
"495772", "Espelkamp",
"494109", "Tangstedt\ Bz\ Hamburg",
"4936483", "Ziegenrück",
"497844", "Rheinau",
"49221", "Cologne",
"498722", "Gangkofen",
"497661", "Kirchzarten",
"493737", "Rochlitz",
"4939887", "Gerswalde",
"499090", "Rain\ Lech",
"497834", "Wolfach",
"499503", "Oberhaid\ Oberfranken",
"4933201", "Gross\ Glienicke",
"4936963", "Dorndorf\ Rhön",
"4935473", "Neu\ Lübbenau",
"496355", "Albisheim\ Pfrimm",
"498651", "Bad\ Reichenhall",
"499408", "Altenthann",
"499656", "Moosbach\ bei\ Vohenstrauss",
"499843", "Burgbernheim",
"499765", "Trappstadt",
"494452", "Zetel\-Neuenburg",
"4933334", "Greiffenberg",
"495555", "Moringen\-Fredelsloh",
"499292", "Konradsreuth",
"494829", "Wewelsfleth",
"4939427", "Ströbeck",
"498245", "Türkheim\ Wertach",
"499833", "Heidenheim\ Mittelfranken",
"4933434", "Herzfelde\ bei\ Strausberg",
"4939327", "Klietz",
"492724", "Finnentrop\-Serkenrode",
"4939088", "Letzlingen",
"497504", "Horgenzell",
"4938728", "Domsühl",
"498281", "Thannhausen\ Schwaben",
"4933657", "Steinsdorf\ Brandenburg",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"495254", "Paderborn\-Schloss\ Neuhaus",
"492802", "Alpen",
"494731", "Nordenham",
"492588", "Harsewinkel\-Greffen",
"496761", "Simmern\ Hunsrück",
"49355", "Cottbus",
"498544", "Eging\ am\ See",
"497366", "Abtsgmünd",
"494741", "Nordholz\ bei\ Bremerhaven",
"496402", "Hungen",
"498124", "Forstern\ Oberbayern",
"495174", "Lahstedt",
"493574", "Lauchhammer",
"493984", "Prenzlau",
"492687", "Horhausen\ Westerwald",
"498534", "Tettenweis",
"499908", "Schöfweg",
"499827", "Lichtenau\ Mittelfranken",
"499872", "Heilsbronn",
"492334", "Hagen\-Hohenlimburg",
"495404", "Westerkappeln",
"4938377", "Zinnowitz",
"499183", "Burgthann",
"494946", "Grossefehn\-Bagband",
"4939931", "Röbel\ Müritz",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"496648", "Bad\ Salzschlirf",
"498465", "Kipfenberg",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4939604", "Wildberg\ bei\ Altentreptow",
"496127", "Niedernhausen\ Taunus",
"496252", "Heppenheim\ Bergstrasse",
"496696", "Gilserberg",
"494936", "Grossheide",
"497674", "Todtmoos",
"494668", "Klanxbüll",
"4938783", "Dallmin",
"498388", "Hergensweiler",
"497455", "Dornhan",
"496638", "Schwalmtal\-Renzendorf",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"492556", "Metelen",
"4935698", "Hornow",
"496133", "Oppenheim",
"494202", "Achim\ bei\ Bremen",
"494163", "Horneburg\ Niederelbe",
"499922", "Zwiesel",
"499977", "Arnschwang",
"496523", "Holsthum",
"496428", "Stadtallendorf",
"4933209", "Caputh",
"492750", "Diedenshausen",
"4936742", "Uhlstädt",
"499569", "Sesslach",
"494321", "Neumünster",
"492828", "Emmerich\-Elten",
"499642", "Kemnath\ Stadt",
"497748", "Grafenhausen\ Hochschwarzwald",
"495904", "Lengerich\ Emsl",
"499199", "Kunreuth",
"492866", "Dorsten\-Rhade",
"499178", "Abenberg\ Mittelfranken",
"494446", "Bakum\ Kreis\ Vechta",
"498043", "Jachenau",
"496391", "Dahn",
"4934604", "Niemberg",
"495161", "Walsrode",
"493561", "Guben",
"497221", "Baden\-Baden",
"4935361", "Schlieben",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"497738", "Steisslingen",
"495323", "Clausthal\-Zellerfeld",
"496774", "Kaub",
"499632", "Waldsassen",
"496466", "Dautphetal\-Friedensdorf",
"494498", "Saterland\-Ramsloh",
"498033", "Oberaudorf",
"497955", "Wallhausen\ Württemberg",
"494479", "Molbergen\-Peheim",
"4936738", "Königsee",
"494857", "Barlt",
"498373", "Altusried",
"4936428", "Stadtroda",
"494626", "Treia",
"498342", "Marktoberdorf",
"499422", "Bogen\ Niederbayern",
"4935795", "Königsbrück",
"496050", "Biebergemünd",
"492603", "Bad\ Ems",
"497184", "Kaisersbach",
"499395", "Triefenstein",
"4935365", "Falkenberg\ Elster",
"495347", "Burgdorf\ bei\ Salzgitter",
"49481", "Heide\ Holstein",
"4935756", "Hosena",
"498708", "Weihmichl\-Unterneuhausen",
"4939856", "Beenz\ bei\ Prenzlau",
"4937382", "Geringswalde",
"496682", "Tann\ Rhön",
"498332", "Ottobeuren",
"493372", "Jüterbog",
"4936087", "Wüstheuterode",
"493327", "Werder\ Havel",
"498072", "Haag\ in\ Oberbayern",
"498027", "Dietramszell",
"495022", "Wietzen",
"499673", "Tiefenbach\ Oberpfalz",
"492407", "Herzogenrath\-Kohlscheid",
"495337", "Kissenbrück",
"497333", "Laichingen",
"492422", "Kreuzau",
"492859", "Wesel\-Bislich",
"499603", "Floss",
"498551", "Freyung",
"497073", "Ammerbuch",
"493302", "Hennigsdorf",
"495850", "Neetze",
"495241", "Gütersloh",
"492395", "Finnentrop\-Rönkhausen",
"4935383", "Elster\ Elbe",
"4935056", "Altenberg\ Sachsen",
"497343", "Buch\ bei\ Illertissen",
"4936373", "Buttstädt",
"497561", "Leutkirch\ im\ Allgäu",
"492673", "Ellenz\-Poltersdorf",
"499407", "Wenzenbach",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"494754", "Bülkau",
"495231", "Detmold",
"498303", "Waltenhofen",
"4933332", "Gartz\ Oder",
"4934206", "Rötha",
"494409", "Westerstede\-Ocholt",
"492642", "Remagen",
"497032", "Herrenberg",
"495190", "Soltau\-Emmingen",
"496297", "Ravenstein\ Baden",
"496704", "Langenlonsheim",
"494330", "Emkendorf",
"497327", "Dischingen",
"4933432", "Müncheberg",
"492632", "Andernach",
"497042", "Vaihingen\ an\ der\ Enz",
"495584", "Hattorf\ am\ Harz",
"494340", "Achterwehr",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"494152", "Geesthacht",
"492922", "Werl",
"492587", "Ennigerloh\-Westkirchen",
"492977", "Schmallenberg\-Bödefeld",
"4936042", "Tonna",
"498634", "Garching\ an\ der\ Alz",
"496384", "Konken",
"498783", "Rohr\ in\ Niederbayern",
"4935930", "Seitschen",
"497851", "Kehl",
"497240", "Pfinztal",
"4938391", "Altenkirchen\ Rügen",
"49365", "Gera",
"499907", "Zenting",
"499828", "Rügland",
"492688", "Kroppach",
"494272", "Siedenburg",
"498861", "Schongau",
"494243", "Twistringen",
"499074", "Höchstädt\ an\ der\ Donau",
"4939206", "Eichenbarleben",
"499334", "Giebelstadt",
"499229", "Mainleus",
"492183", "Rommerskirchen",
"494892", "Schenefeld\ Mittelholstein",
"4939723", "Krien",
"4938356", "Behrenhoff",
"4935823", "Ostritz",
"497191", "Backnang",
"494233", "Blender",
"498424", "Nassenfels",
"496102", "Neu\-Isenburg",
"496263", "Neckargerach",
"4938456", "Langhagen\ bei\ Güstrow",
"499344", "Gerchsheim",
"499556", "Geiselwind",
"495766", "Rehburg\-Loccum",
"495655", "Wanfried",
"495474", "Stemwede\-Dielingen",
"499802", "Ansbach\-Katterbach",
"497275", "Kandel",
"4933603", "Falkenhagen\ bei\ Seelow",
"499978", "Schönthal\ Oberpfalz",
"493504", "Dippoldiswalde",
"4933676", "Friedland\ bei\ Beeskow",
"496472", "Weilmünster",
"495961", "Haselünne",
"496427", "Cölbe\-Schönstadt",
"495691", "Bad\ Arolsen",
"4939037", "Pretzier",
"498165", "Neufahrn\ bei\ Freising",
"496623", "Rotenburg\ an\ der\ Fulda",
"4937384", "Wechselburg",
"495083", "Hohne\ bei\ Celle",
"498450", "Ingolstadt\-Zuchering",
"492827", "Goch\-Hassum",
"492872", "Rhede\ Westfalen",
"4939265", "Löderburg",
"492292", "Windeck\ Sieg",
"497574", "Gammertingen",
"494463", "Wangerland",
"498369", "Rückholz",
"4939998", "Loitz\ bei\ Demmin",
"492656", "Virneburg",
"492843", "Rheinberg",
"496433", "Hadamar",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"498066", "Bad\ Feilnbach",
"496128", "Taunusstein",
"493366", "Beeskow",
"496596", "Üdersdorf",
"496647", "Herbstein\-Stockhausen",
"495382", "Bad\ Gandersheim",
"492833", "Kerken",
"496443", "Ehringshausen\ Dill",
"493491", "Lutherstadt\ Wittenberg",
"497056", "Gechingen",
"494667", "Dagebüll",
"4936878", "Oberland",
"499724", "Stadtlauringen",
"4938223", "Saal\ Vorpom",
"498387", "Weiler\-Simmerberg",
"496637", "Feldatal",
"494146", "Stade\-Bützfleth",
"4934261", "Kühren\ bei\ Wurzen",
"4935975", "Hohnstein",
"4936465", "Oberndorf\ bei\ Apolda",
"499499", "Painten",
"499573", "Staffelstein\ Oberfranken",
"496582", "Freudenburg",
"495461", "Bramsche\ Hase",
"49921", "Bayreuth",
"4938827", "Kalkhorst",
"493328", "Teltow",
"496166", "Fischbachtal",
"4936077", "Grossbodungen",
"498028", "Fischbachau",
"494136", "Scharnebeck",
"498294", "Horgau",
"498707", "Adlkofen",
"494526", "Ascheberg\ Holstein",
"497723", "Furtwangen\ im\ Schwarzwald",
"494179", "Winsen\-Tönnhausen",
"495702", "Petershagen\-Lahde",
"492408", "Aachen\-Kornelimünster",
"4936744", "Remda",
"497484", "Simmersfeld",
"499122", "Schwabach",
"499177", "Heideck",
"495824", "Bad\ Bodenteich",
"4935971", "Sebnitz",
"4936461", "Bad\ Sulza",
"494963", "Dörpen",
"497747", "Berau",
"499532", "Maroldsweisach",
"4939602", "Kleeth",
"4933843", "Niemegk",
"493834", "Greifswald",
"496209", "Mörlenbach",
"493991", "Waren\ Müritz",
"493661", "Greiz",
"499542", "Schesslitz",
"492351", "Lüdenscheid",
"494858", "Sankt\ Margarethen\ Holstein",
"493844", "Schwaan",
"494497", "Barssel\-Harkebrügge",
"499257", "Zell\ Oberfranken",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"498547", "Osterhofen\-Gergweis",
"498252", "Schrobenhausen",
"495257", "Hövelhof",
"497084", "Schömberg\ bei\ Neuenbürg",
"492743", "Daaden",
"496150", "Weiterstadt",
"495542", "Witzenhausen",
"493969", "Siedenbollentin",
"492865", "Raesfeld",
"4936082", "Ershausen",
"498638", "Waldkraiburg",
"494445", "Visbek\ Kreis\ Vechta",
"498537", "Bad\ Füssing\-Aigen",
"499824", "Dietenhofen",
"4935451", "Dahme\ Brandenburg",
"493522", "Grossenhain\ Sachsen",
"495177", "Edemissen\-Abbensen",
"493987", "Templin",
"4939034", "Fleetmark",
"492684", "Puderbach\ Westerwald",
"497262", "Eppingen",
"492733", "Hilchenbach",
"494435", "Grossenkneten",
"4934926", "Pretzsch\ Elbe",
"494481", "Hatten\-Sandkrug",
"496465", "Breidenbach\ bei\ Biedenkopf",
"495532", "Stadtoldendorf",
"499396", "Urspringen\ bei\ Lohr",
"4936949", "Obermassfeld\-Grimmenthal",
"498143", "Inning\ am\ Ammersee",
"494625", "Jübek",
"499078", "Mertingen",
"4938484", "Ventschow",
"499338", "Röttingen\ Unterfranken",
"499099", "Kaisheim",
"495573", "Uslar\-Volpriehausen",
"498133", "Haimhausen\ Oberbayern",
"4935455", "Walddrehna",
"492772", "Herborn\ Hessen",
"49521", "Bielefeld",
"499461", "Roding",
"499348", "Werbach\-Gamburg",
"498466", "Denkendorf\ Oberbayern",
"4936640", "Remptendorf",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"499382", "Gerolzhofen",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"495724", "Obernkirchen",
"496373", "Schönenberg\-Kübelberg",
"496033", "Butzbach",
"494945", "Grossefehn\-Timmel",
"493683", "Schmalkalden",
"4936074", "Worbis",
"493744", "Auerbach\ Vogtland",
"4938824", "Mallentin",
"497456", "Haiterbach",
"492555", "Schöppingen",
"494758", "Nordleda",
"4938232", "Zingst\ Ostseebad",
"497837", "Oberharmersbach",
"4938850", "Gammelin",
"4936626", "Auma",
"494935", "Juist",
"4939926", "Grabowhöfe",
"496043", "Nidda",
"496695", "Jesberg",
"496027", "Stockstadt\ am\ Main",
"496332", "Zweibrücken",
"498682", "Laufen\ Salzach",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"494362", "Heiligenhafen",
"492174", "Burscheid\ Rheinland",
"499083", "Möttingen",
"499104", "Emskirchen",
"495483", "Lienen",
"495978", "Hörstel\-Dreierwalde",
"495802", "Wrestedt",
"492254", "Weilerswist",
"497823", "Seelbach\ Schutter",
"496342", "Schweigen\-Rechtenbach",
"498807", "Diessen\ am\ Ammersee",
"4938372", "Usedom",
"499961", "Mitterfels",
"496804", "Mandelbachtal",
"495344", "Lengede",
"497932", "Niederstetten\ Württemberg",
"4935608", "Gross\ Ossnig",
"498246", "Waal",
"499474", "Schmidmühlen",
"4935774", "Boxberg\ Sachsen",
"499655", "Tännesberg",
"499766", "Grosswenkheim",
"495556", "Lindau\ Harz",
"497942", "Neuenstein\ Württemberg",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4936945", "Henneberg",
"492404", "Alsdorf\ Rheinland",
"4936784", "Stützerbach",
"495074", "Rodewald",
"494194", "Sievershütten",
"498236", "Fischach",
"4933652", "Neuzelle",
"498024", "Holzkirchen",
"4939322", "Tangermünde",
"492591", "Lüdinghausen",
"499560", "Grub\ am\ Forst",
"493838", "Bergen\ auf\ Rügen",
"496651", "Rasdorf",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"495828", "Himbergen",
"497583", "Bad\ Schussenried",
"497973", "Obersontheim",
"495907", "Geeste",
"492759", "Bad\ Berleburg\-Aue",
"4936941", "Wasungen",
"494854", "Friedrichskoog",
"4934653", "Rottleberode",
"4939422", "Badersleben",
"497365", "Essingen\ Württemberg",
"496722", "Rüdesheim\ am\ Rhein",
"497432", "Albstadt\-Tailfingen",
"492323", "Herne",
"494265", "Fintel",
"496235", "Schifferstadt",
"499974", "Traitsching",
"4939882", "Gollin",
"494792", "Worpswede",
"496281", "Buchen\ Odenwald",
"495108", "Gehrden\ Han",
"497442", "Baiersbronn",
"492904", "Bestwig",
"496245", "Biblis",
"4937344", "Crottendorf\ Sachsen",
"499190", "Heroldsbach",
"492161", "Mönchengladbach",
"498402", "Münchsmünster",
"497751", "Waldshut",
"4934322", "Rosswein",
"496124", "Bad\ Schwalbach",
"4933733", "Stülpe",
"499285", "Kirchenlamitz",
"4939000", "Beetzendorf",
"496534", "Mülheim\ Mosel",
"499231", "Marktredwitz",
"494564", "Schashagen",
"4939748", "Viereck",
"497578", "Wald\ Hohenz",
"497473", "Mössingen",
"495407", "Wallenhorst",
"492337", "Hagen\-Dahl",
"4934422", "Osterfeld",
"498761", "Moosburg\ an\ der\ Isar",
"497622", "Schopfheim",
"496356", "Carlsberg\ Pfalz",
"495603", "Gudensberg",
"499728", "Wülfershausen\ Unterfranken",
"496059", "Jossgrund",
"499241", "Pegnitz",
"496544", "Rhaunen",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;