#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

static SV * _new(SV *class, HV *hash) {
	dTHX;
	if (SvTYPE(class) != SVt_PV) {
		char *name = HvNAME(SvSTASH(SvRV(class)));
		class = newSVpv(name, strlen(name));
	}
	return sv_bless(newRV_noinc((SV*)hash), gv_stashsv(class, 0));
}

char *substr(const char *input, size_t start, size_t len) {
	dTHX;
	char *ret = (char *)malloc(len - start + 1);
	memcpy(ret, input + start, len - start);
	ret[len - start] = '\0';
	return ret;
}

int find_last(const char *str, const char word) {
	dTHX;
	int lastIndex = -1, i = 0;
	for (i = 0; str[i] != '\0'; i++) {
		if (str[i] == word) {
			lastIndex = i;
		}
	}
	return lastIndex;
}

char *get_ex_method(const char *name) {
	dTHX;
	char *callr = HvNAME((HV*)CopSTASH(PL_curcop));
	STRLEN retlen = strlen(callr);
	size_t ex_len = strlen(name) + 2 + retlen + 1;
	char *ex_out = (char *)malloc(ex_len);
	if (!ex_out) croak("Out of memory in get_ex_method");
	snprintf(ex_out, ex_len, "%s::%s", callr, name);
	return ex_out;
}

char *get_caller(void) {
	dTHX;
	char *callr = HvNAME((HV*)CopSTASH(PL_curcop));
	return callr;
}

void get_class_and_method(SV *cv_name_sv, char **class_out, char **method_out) {
	dTHX;
	STRLEN len;
	char *full = SvPV(cv_name_sv, len);
	int idx = find_last(full, ':');
	if (idx == -1 || idx < 1) {
		*class_out = strdup("");
		*method_out = strdup(full);
		return;
	}
	int sep = idx;
	if (sep > 0 && full[sep-1] == ':') sep--;
	*class_out = substr(full, 0, sep);
	*method_out = substr(full, idx+1, len);
}

void register_attribute(CV *cv, char *name, SV *attr, XSUBADDR_t xsub_addr) {
	dTHX;
	SV *newcv = (SV *)CvXSUBANY(cv).any_ptr;
	SV *spec = (SV *)CvXSUBANY(newcv).any_ptr;

	if (!SvOK(attr) || !SvROK(attr)) {
		HV *n = newHV();
		hv_store(n, "name", 4, newSVpv(name, strlen(name)), 0);
		attr = newRV_noinc((SV*)n);
	} else {
		SV *rv = SvRV(attr);
		if (SvTYPE(rv) != SVt_PVHV || !hv_exists((HV*)rv, "isa", 3)) {
			HV *n = newHV();
			hv_store(n, "name", 4, newSVpv(name, strlen(name)), 0);
			hv_store(n, "isa", 3, newSVsv(attr), 0);
			attr = newRV_noinc((SV*)n);
		} else {
			hv_store((HV*)rv, "name", 4, newSVpv(name, strlen(name)), 0);
		}
	}

	HV *spec_hv = (HV*)SvRV(spec);
	hv_store(spec_hv, name, strlen(name), newSVsv(attr), 0);

	/* Track if any attributes need second pass (builder or trigger) */
	HV *attr_hv = (HV*)SvRV(attr);
	if (hv_exists(attr_hv, "builder", 7) || hv_exists(attr_hv, "trigger", 7)) {
		if (!hv_exists(spec_hv, "_needs_second_pass", 18)) {
			hv_store(spec_hv, "_needs_second_pass", 18, newSViv(1), 0);
		}
	}

	char *ex = get_ex_method(name);
	CV *new_attr_cv = newXS(ex, xsub_addr, __FILE__);
	SvREFCNT_inc(attr);
	CvXSUBANY(new_attr_cv).any_ptr = (void *)attr;
	free(ex);
}

static AV *get_avf(const char *fmt, ...) {
	dTHX;
	va_list ap;
	char buf[256];

	va_start(ap, fmt);
	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);

	return get_av(buf, GV_ADD);
}

static CV *get_cvf(const char *fmt, ...) {
	dTHX;
	va_list ap;
	char buf[256];

	va_start(ap, fmt);
	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);

	return get_cv(buf, GV_ADD);
}

static SV *normalise_attr(SV *attr) {
	dTHX;
	if (!SvOK(attr) || !SvROK(attr)) {
		HV *n = newHV();
		hv_store(n, "isa", 3, &PL_sv_undef, 0);
		attr = newRV_noinc((SV*)n);
	} else {
		SV *rv = SvRV(attr);
		if (SvTYPE(rv) != SVt_PVHV || !hv_exists((HV*)rv, "isa", 3)) {
			HV *n = newHV();
			hv_store(n, "isa", 3, newSVsv(attr), 0);
			attr = newRV_noinc((SV*)n);
		}
	}
	return attr;
}

MODULE = Meow  PACKAGE = Meow
PROTOTYPES: ENABLE

SV *
new(pkg, ...)
	SV *pkg
	CODE:
		SV *spec = (SV *)CvXSUBANY(cv).any_ptr;
		HV *args;
		int i;
		if (items > 2) {
			if ((items - 1) % 2 != 0) {
				croak("Odd number of elements in hash assignment");
			}
			args = newHV();
			for (i = 1; i < items; i += 2) {
				STRLEN retlen;
				char *key = SvPV(ST(i), retlen);
				SV *value = newSVsv(ST(i + 1));
				hv_store(args, key, retlen, value, 0);
			}
		} else {
			if (!SvOK(ST(1))) {
				args = newHV();
			} else if (!SvROK(ST(1)) || SvTYPE(SvRV(ST(1))) != SVt_PVHV) {
				croak("Not a hash assignment");
			} else {
				args = (HV*)SvRV(newSVsv(ST(1)));
			}
		}
		RETVAL = _new(newSVsv(ST(0)), args);
		HV *right = (HV*)SvRV(spec);
		HE *entry;
		/* First pass: apply defaults, coerce, and type checking */
		(void)hv_iterinit(right);
		while ((entry = hv_iternext(right))) {
			STRLEN retlen;
			char *key = SvPV(hv_iterkeysv(entry), retlen);
			/* Skip the metadata key */
			if (retlen == 18 && memcmp(key, "_needs_second_pass", 18) == 0) continue;

			SV **valp = hv_fetch(args, key, retlen, 0);
			SV *value = valp ? *valp : &PL_sv_undef;
			SV *spec_sv = hv_iterval(right, entry);

			if (SvROK(spec_sv) && SvTYPE(SvRV(spec_sv)) == SVt_PVHV) {
				HV *spec_hv = (HV*)SvRV(spec_sv);
				SV **default_svp, **coerce_svp, **isa_svp;

				/* Apply default if no value provided */
				if (!SvOK(value)) {
					default_svp = hv_fetch(spec_hv, "default", 7, 0);
					if (default_svp) {
						if (SvROK(*default_svp) && SvTYPE(SvRV(*default_svp)) == SVt_PVCV) {
							dSP;
							PUSHMARK(SP);
							XPUSHs(pkg);
							PUTBACK;
							call_sv(*default_svp, G_SCALAR);
							SPAGAIN;
							value = POPs;
							PUTBACK;
						} else {
							/* For simple values, just increment refcount instead of copy */
							value = *default_svp;
							SvREFCNT_inc(value);
						}
					}
				}

				/* Apply coerce if value exists */
				if (SvOK(value)) {
					coerce_svp = hv_fetch(spec_hv, "coerce", 6, 0);
					if (coerce_svp) {
						dSP;
						PUSHMARK(SP);
						XPUSHs(value);
						PUTBACK;
						call_sv(*coerce_svp, G_SCALAR);
						SPAGAIN;
						value = POPs;
						PUTBACK;
					}
				}

				/* Apply type check if value exists */
				if (SvOK(value)) {
					isa_svp = hv_fetch(spec_hv, "isa", 3, 0);
					if (isa_svp && SvOK(*isa_svp)) {
						dSP;
						PUSHMARK(SP);
						XPUSHs(value);
						PUTBACK;
						call_sv(*isa_svp, G_SCALAR);
						SPAGAIN;
						value = POPs;
						PUTBACK;
					}
				}

				SvREFCNT_inc(value);
			}
			hv_store(args, key, retlen, value, 0);
		}

		/* Second pass: apply builders and triggers (only if any attribute needs it) */
		if (hv_exists(right, "_needs_second_pass", 18)) {
			(void)hv_iterinit(right);
			while ((entry = hv_iternext(right))) {
				STRLEN retlen;
				char *key = SvPV(hv_iterkeysv(entry), retlen);
				/* Skip the metadata key */
				if (retlen == 18 && memcmp(key, "_needs_second_pass", 18) == 0) continue;

				SV **valp = hv_fetch(args, key, retlen, 0);
				SV *value = valp ? *valp : &PL_sv_undef;
				SV *spec_sv = hv_iterval(right, entry);
				HV *spec_hv = (HV*)SvRV(spec_sv);
				SV **builder_svp, **isa_svp, **trigger_svp;

				/* Apply builder if no value (builder needs $self and may access other attrs) */
				if (!SvOK(value)) {
					builder_svp = hv_fetch(spec_hv, "builder", 7, 0);
					if (builder_svp) {
						dSP;
						PUSHMARK(SP);
						XPUSHs(RETVAL);
						PUTBACK;
						call_sv(*builder_svp, G_SCALAR);
						SPAGAIN;
						value = POPs;
						PUTBACK;

						/* Type check builder result */
						if (SvOK(value)) {
							isa_svp = hv_fetch(spec_hv, "isa", 3, 0);
							if (isa_svp && SvOK(*isa_svp)) {
								dSP;
								PUSHMARK(SP);
								XPUSHs(value);
								PUTBACK;
								call_sv(*isa_svp, G_SCALAR);
								SPAGAIN;
								value = POPs;
								PUTBACK;
							}
						}
						hv_store(args, key, retlen, newSVsv(value), 0);
					}
				}

				/* Apply trigger if value exists */
				if (SvOK(value)) {
					trigger_svp = hv_fetch(spec_hv, "trigger", 7, 0);
					if (trigger_svp) {
						dSP;
						PUSHMARK(SP);
						XPUSHs(RETVAL);
						XPUSHs(value);
						PUTBACK;
						call_sv(*trigger_svp, G_SCALAR);
						SPAGAIN;
						POPs;
						PUTBACK;
					}
				}
			}
		}

	OUTPUT:
		RETVAL

SV *
rw_attribute(...)
	CODE:
		SV *spe = (SV *)CvXSUBANY(cv).any_ptr;
		HV *spec = (HV*)SvRV(spe);
		STRLEN retlen;
		SV **name_sv = hv_fetch(spec, "name", 4, 0);
		if (!name_sv) croak("No 'name' in spec");
		char *method = SvPV(*name_sv, retlen);
		STRLEN method_len = strlen(method);
		HV *self = (HV*)SvRV(ST(0));
		SV *val;

		if (items > 1) {
			SV **coerce_svp, **isa_svp, **trigger_svp;
			val = newSVsv(ST(1));

			coerce_svp = hv_fetch(spec, "coerce", 6, 0);
			if (coerce_svp) {
				dSP;
				PUSHMARK(SP);
				XPUSHs(val);
				PUTBACK;
				call_sv(*coerce_svp, G_SCALAR);
				SPAGAIN;
				SvREFCNT_dec(val);
				val = newSVsv(POPs);
				PUTBACK;
			}

			isa_svp = hv_fetch(spec, "isa", 3, 0);
			if (isa_svp && SvOK(*isa_svp)) {
				dSP;
				PUSHMARK(SP);
				XPUSHs(val);
				PUTBACK;
				call_sv(*isa_svp, G_SCALAR);
				SPAGAIN;
				SvREFCNT_dec(val);
				val = newSVsv(POPs);
				PUTBACK;
			}

			trigger_svp = hv_fetch(spec, "trigger", 7, 0);
			if (trigger_svp) {
				dSP;
				PUSHMARK(SP);
				XPUSHs(ST(0));
				XPUSHs(val);
				PUTBACK;
				call_sv(*trigger_svp, G_SCALAR);
				SPAGAIN;
				POPs;
				PUTBACK;
			}

			hv_store(self, method, method_len, newSVsv(val), 0);
			RETVAL = val;
		} else {
			SV **valp = hv_fetch(self, method, method_len, 0);
			if (valp) {
				RETVAL = *valp;
				SvREFCNT_inc(RETVAL);
			} else {
				RETVAL = &PL_sv_undef;
			}
		}
	OUTPUT:
		RETVAL

SV *
rw(name, attr)
	char *name
	SV *attr
	CODE:
		register_attribute(cv, name, attr, XS_Meow_rw_attribute);

		RETVAL = newSViv(1);
	OUTPUT:
		RETVAL

SV *
ro_attribute(...)
	CODE:
		if (items > 1) {
			croak("Read only attributes cannot be set");
		}
		SV *spe = (SV *)CvXSUBANY(cv).any_ptr;
		HV *spec = (HV*)SvRV(spe);
		SV **name_sv = hv_fetch(spec, "name", 4, 0);
		if (!name_sv) croak("No 'name' in spec");
		STRLEN method_len;
		char *method = SvPV(*name_sv, method_len);
		HV *self = (HV*)SvRV(ST(0));
		SV **valp = hv_fetch(self, method, method_len, 0);
		if (valp) {
			RETVAL = *valp;
			SvREFCNT_inc(RETVAL);
		} else {
			RETVAL = &PL_sv_undef;
		}
	OUTPUT:
		RETVAL

SV *
ro(name, ...)
	char *name
	CODE:
		SV *attr;
		if (items > 1) {
			attr = ST(1);
			SvREFCNT_inc(attr);
		} else {
			attr = &PL_sv_undef;
		}

		register_attribute(cv, name, attr, XS_Meow_ro_attribute);

		RETVAL = newSViv(1);
	OUTPUT:
		RETVAL

SV *
Default(...)
	CODE:
		SV *attr, *val;
		if (items > 1) {
			attr = ST(0);
			SvREFCNT_inc(attr);
			val = ST(1);
			SvREFCNT_inc(val);
		} else {
			attr = &PL_sv_undef;
			val = ST(0);
			SvREFCNT_inc(val);
		}
		attr = normalise_attr(attr);
		HV *spec = (HV*)SvRV(attr);
		hv_store(spec, "default", 7, val, 0);
		RETVAL = attr;
	OUTPUT:
		RETVAL

SV *
Coerce(...)
	CODE:
		SV *attr, *val;
		if (items > 1) {
			attr = ST(0);
			SvREFCNT_inc(attr);
			val = ST(1);
			SvREFCNT_inc(val);
		} else {
			attr = &PL_sv_undef;
			val = ST(0);
			SvREFCNT_inc(val);
		}
		if (!SvROK(val) || SvTYPE(SvRV(val)) != SVt_PVCV) {
			croak("Coerce requires a code reference as the second argument");
		}
		attr = normalise_attr(attr);
		HV *spec = (HV*)SvRV(attr);
		hv_store(spec, "coerce", 6, val, 0);
		SvREFCNT_inc(attr);
		RETVAL = attr;
	OUTPUT:
		RETVAL

SV *
Trigger(...)
	CODE:
		SV *attr, *val;
		if (items > 1) {
			attr = ST(0);
			SvREFCNT_inc(attr);
			val = ST(1);
			SvREFCNT_inc(val);
		} else {
			attr = &PL_sv_undef;
			val = ST(0);
			SvREFCNT_inc(val);
		}
		if (!SvROK(val) || SvTYPE(SvRV(val)) != SVt_PVCV) {
			croak("Trigger requires a code reference as the second argument");
		}
		attr = normalise_attr(attr);
		HV *spec = (HV*)SvRV(attr);
		hv_store(spec, "trigger", 7, val, 0);
		SvREFCNT_inc(attr);
		RETVAL = attr;
	OUTPUT:
		RETVAL

SV *
Builder(...)
	CODE:
		SV *attr, *val;
		if (items > 1) {
			attr = ST(0);
			SvREFCNT_inc(attr);
			val = ST(1);
			SvREFCNT_inc(val);
		} else {
			attr = &PL_sv_undef;
			val = ST(0);
			SvREFCNT_inc(val);
		}
		if (!SvROK(val) || SvTYPE(SvRV(val)) != SVt_PVCV) {
			croak("Builder requires a code reference as the second argument");
		}
		attr = normalise_attr(attr);
		HV *spec = (HV*)SvRV(attr);
		hv_store(spec, "builder", 7, val, 0);
		SvREFCNT_inc(attr);
		RETVAL = attr;
	OUTPUT:
		RETVAL

void
extends(...)
	CODE:
		dTHX;
		HV *stash = (HV*)CopSTASH(PL_curcop);
		const char *child = HvNAME(stash);
		int i;
		for (i = 0; i < items; i++) {
			char *parent = SvPV_nolen(ST(i));
			AV *isa = get_avf("%s::ISA", child);
			int found = 0;
			SV **svp;
			SSize_t j, len = isa ? av_len(isa) + 1 : 0;
			for (j = 0; j < len; j++) {
				svp = av_fetch(isa, j, 0);
				if (svp && SvPOK(*svp) && strcmp(SvPV_nolen(*svp), parent) == 0) {
					found = 1;
					break;
				}
			}
			if (!found) {
				av_push(isa, newSVpv(parent, 0));
			}

			CV *child_cv = get_cvf("%s::new", child);
			CV *parent_cv = get_cvf("%s::new", parent);

			if (!child_cv || !parent_cv)
				croak("Could not find new() for child or parent class");
			SV *child_spec = (SV *)CvXSUBANY(child_cv).any_ptr;
			SV *parent_spec = (SV *)CvXSUBANY(parent_cv).any_ptr;
			if (!child_spec || !parent_spec)
				croak("Missing spec in child or parent");
			HV *child_hv = (HV*)SvRV(child_spec);
			HV *parent_hv = (HV*)SvRV(parent_spec);
			HE *entry;
			hv_iterinit(parent_hv);
			while ((entry = hv_iternext(parent_hv))) {
				SV *keysv = hv_iterkeysv(entry);
				STRLEN klen;
				const char *key = SvPV(keysv, klen);
				if (!hv_exists(child_hv, key, klen)) {
					SV *val = newSVsv(hv_iterval(parent_hv, entry));
					hv_store(child_hv, key, klen, val, 0);
				}
			}
		}

void
import(pkg, ...)
	char *pkg
	CODE:
		char *callr = get_caller();
		const char *export[] = { "new", "rw", "ro", "extends", "Default", "Coerce", "Trigger", "Builder" };
		int i;
		CV *newcv = NULL;
		for (i = 0; i < 8; i++) {
			const char *ex = export[i];
			size_t name_len = strlen(callr) + 2 + strlen(ex) + 1;
			char *name = (char *)malloc(name_len);
			if (!name) croak("Out of memory in import");
			snprintf(name, name_len, "%s::%s", callr, ex);
			if (strcmp(ex, "new") == 0) {
				newcv = newXS(name, XS_Meow_new, __FILE__);
				SV *spec = newRV_noinc((SV*)newHV());
				CvXSUBANY(newcv).any_ptr = (void *)spec;
			} else if (strcmp(ex, "rw") == 0) {
				CV *rwcv = newXS(name, XS_Meow_rw, __FILE__);
				CvXSUBANY(rwcv).any_ptr = (void *)newcv;
			} else if (strcmp(ex, "ro") == 0) {
				CV *rwcv = newXS(name, XS_Meow_ro, __FILE__);
				CvXSUBANY(rwcv).any_ptr = (void *)newcv;
			} else if (strcmp(ex, "extends") == 0) {
				CV *extends_cv = newXS(name, XS_Meow_extends, __FILE__);
			} else if (strcmp(ex, "Default") == 0) {
				CV *default_cv = newXS(name, XS_Meow_Default, __FILE__);
			} else if (strcmp(ex, "Coerce") == 0){
				CV *coerce_cv = newXS(name, XS_Meow_Coerce, __FILE__);
			} else if (strcmp(ex, "Trigger") == 0) {
				CV *trigger_cv = newXS(name, XS_Meow_Trigger, __FILE__);
			} else if (strcmp(ex, "Builder") == 0) {
				CV *builder_cv = newXS(name, XS_Meow_Builder, __FILE__);
			}
		}

void
DESTROY(...)
	CODE:
		Safefree(ST(0));
