# vim: set ts=8 sts=2 sw=2 tw=100 et :
use strictures 2;
use stable 0.031 'postderef';
use experimental 'signatures';
no autovivification warn => qw(fetch store exists delete);
use if "$]" >= 5.022, experimental => 're_strict';
no if "$]" >= 5.031009, feature => 'indirect';
no if "$]" >= 5.033001, feature => 'multidimensional';
no if "$]" >= 5.033006, feature => 'bareword_filehandles';
no if "$]" >= 5.041009, feature => 'smartmatch';
no feature 'switch';
use open ':std', ':encoding(UTF-8)'; # force stdin, stdout, stderr into utf8

use lib 't/lib';
use Helper;
use Test::JSON::Schema::Acceptance 1.014;
use Mojo::File 'path';

foreach my $oas_version (map $_->basename, path('t/oas-vocabulary')->list({dir=>1})->each) {
  my $accepter = Test::JSON::Schema::Acceptance->new(
    verbose => 1,
    test_schemas => 0,  # some schemas are not valid, as we are testing error handling in traverse()
    specification => 'draft2020-12',
    test_dir => 't/oas-vocabulary/'.$oas_version,
  );
  $accepter->json_decoder->allow_bignum if Test::JSON::Schema::Acceptance->VERSION < '1.022';

  my $js = JSON::Schema::Modern->new(
    specification_version => 'draft2020-12',
    validate_formats => 1,
  );

  OpenAPI::Modern::Utilities::add_vocab_and_default_schemas($js, $oas_version);

  $accepter->acceptance(
    validate_data => sub ($schema, $instance_data) {
      my $result = $js->evaluate($instance_data, $schema);
      note 'result: ', $::encoder->encode($result);

      warn('evaluation generated an exception: '.$::encoder->encode($_))
        foreach
          grep +($_->{error} =~ /^EXCEPTION/),
            ($result->TO_JSON->{errors}//[])->@*;

      $result->valid;
    },
    @ARGV ? (tests => { file => \@ARGV }) : (),
  );

  path('t/results/oas-vocabulary-'.$oas_version.'.txt')->spew($accepter->results_text, 'UTF-8')
    if -d '.git' or $ENV{AUTHOR_TESTING} or $ENV{RELEASE_TESTING};
}

done_testing;
__END__
see t/results/oas-vocabulary.txt for test results
