use TestHelpers qw/ db read_data /;

=pod
Create the example how to organize tests correctly.

Crate sub to initialize DB with data required for test. It should be clear and easy.

Put 4 lines between big blocks. Mark each block with #####.
      No reason to put 5 empty lines. 5 vs 4 is hard to distinguish.

Put 4 lines between grouped tests which do similar checks. Mark this group with ####.

Put 3 lines between tests. Mark each test with ###.

Put 2 lines between checks related to the same test. Mark each check with ##.

Put 1 line between code lines which groupes actions. Eg. data calculation tooks two lines, but is
not related to the next expression also related to this test.

Just put together single lines. Use single # to crate comments.


Put 1 empty line between sections if they go one after another. Write:

	#### Section

	### Test group

Instead:

	#### Section
	### Test group


Put 1 empty line after big section: #### or #####:

	#### Big section

	... initizlization code



	### Test


TIP: Mark ## tests which depends on the state of the previous test

=cut


sub prepare_db_data {}

sub stub {}

my( $interpolated ) =  'This is iterpolated';


##### Section one

my( $got, $data, $req );


#### _select

#### _delete

### Delete by ID
my $id  =  7;
$req =  {
	Country => { id => $id, _action => 'delete' }
};
$got  =  A::FormData::process $req;
$data =  eval read_data 'country-empty-list';
is $got, $data, "Delete by ID";


## Fetch all   <<-- This is not a new test and belongs to the previous one. It still checks the
##                  integrity after the previous test.
$req =  {
	Country => {}
};
$got  =  A::FormData::process $req;
$data =  eval read_data 'section-with-expected-values';
is $got, $data, "Fetch all columns";




##### Section two

prepare_db_data();




#### Another group of tests: cool-feature

### Cool feature parsed



### Cool feature processed
# This is just comment


## Integrity check how it was processed. Eg. direct call to DB to check actual values.
# This is another comment




##### Finish

done_testing();

__DATA__
@@ section-with-expected-values
{
	comment => 'Hash is defined. We can eval it',
	value   => ">>$interpolated<<",
	text    => 'But actually we can put any text data here',
}
